<?php
/* add_ons_php */
$support_types = array(
    'input' => __( 'Text Field', 'homeradar-add-ons' ),
    'number' => __( 'Number', 'homeradar-add-ons' ),
    'select' => __( 'Select', 'homeradar-add-ons' ),
    'muti'      => __( 'Select Multiple', 'homeradar-add-ons' ),


    'checkbox' => __( 'Checkbox', 'homeradar-add-ons' ),
    'radio' => __( 'Radio', 'homeradar-add-ons' ),
    'switch' => __( 'Switch', 'homeradar-add-ons' ),
    
    'textarea' => __( 'Textarea', 'homeradar-add-ons' ),
    'editor' => __( 'Editor', 'homeradar-add-ons' ),
    'datetime' => __( 'Date Time Picker', 'homeradar-add-ons' ),
    'file' => _x( 'File Upload', 'Listing type', 'homeradar-add-ons' ),
    'raw_html' => _x( 'HTML Code', 'Listing type', 'homeradar-add-ons' ),
);
$compares = array(
    '=' => __( 'Listing value equal search value', 'homeradar-add-ons' ),
    '!=' => __( 'Listing value not equal search value', 'homeradar-add-ons' ),
    '>' => __( 'Listing value greater than search value', 'homeradar-add-ons' ),


    '>=' => __( 'Listing value greater than or equal search value', 'homeradar-add-ons' ),
    '<' => __( 'Listing value less than search value', 'homeradar-add-ons' ),
    '<=' => __( 'Listing value less than or equal search value', 'homeradar-add-ons' ),
    'LIKE' => __( 'LIKE', 'homeradar-add-ons' ),
    'NOT LIKE' => __( 'NOT LIKE', 'homeradar-add-ons' ),
    'IN' => __( 'IN', 'homeradar-add-ons' ),
    'NOT IN' => __( 'NOT IN', 'homeradar-add-ons' ),
    'BETWEEN' => __( 'BETWEEN', 'homeradar-add-ons' ),
    'NOT BETWEEN' => __( 'NOT BETWEEN', 'homeradar-add-ons' ),
);

$types = array(
    'CHAR' => __( 'CHAR', 'homeradar-add-ons' ),
    'NUMERIC' => __( 'NUMERIC', 'homeradar-add-ons' ),
    'DATE' => __( 'DATE', 'homeradar-add-ons' ),


    'DATETIME' => __( 'DATETIME', 'homeradar-add-ons' ),
    'DECIMAL' => __( 'DECIMAL', 'homeradar-add-ons' ),
    'TIME' => __( 'TIME', 'homeradar-add-ons' ),
);

if(!isset($index)) $index = false;
if(!isset($name)) $name = 'content_addfields';
if(!isset($field)) $field = array('field_type'=>'input','field_name'=>'field_name','field_label'=>'Field Label','compare'  => '=', 'ctype'=>'CHAR', 'forsearch'=>'yes');
?>
<div class="entry">
    <div class="entry-fields six-cols">
        <select class="custom-select" name="<?php echo $name; ?>[<?php echo $index === false ? '{{data.index}}':$index;?>][field_type]" required>
            <?php
            foreach ($support_types as $val => $lbl) {
                echo '<option value="'.$val.'" '.selected( $field['field_type'], $val, false ).'>'.$lbl.'</option>';
            }
            ?>
        </select>
        <input type="text" name="<?php echo $name; ?>[<?php echo $index === false ? '{{data.index}}':$index;?>][field_name]" placeholder="<?php esc_attr_e( 'Field Name',  'homeradar-add-ons' );?>" value="<?php echo isset($field['field_name'])? $field['field_name'] : '';?>" required>
        <input type="text" name="<?php echo $name; ?>[<?php echo $index === false ? '{{data.index}}':$index;?>][field_label]" placeholder="<?php esc_attr_e( 'Field Label',  'homeradar-add-ons' );?>" value="<?php echo isset($field['field_label'])? $field['field_label'] : '';?>">
        
        <div class="for-usersearch-checkbox">
            <input type="checkbox" name="<?php echo $name; ?>[<?php echo $index === false ? '{{data.index}}':$index;?>][forsearch]" value="yes" <?php echo isset($field['forsearch']) && $field['forsearch'] == 'yes' ? ' checked="checked"' : '';?>>
        </div>

        <select class="custom-select" name="<?php echo $name; ?>[<?php echo $index === false ? '{{data.index}}':$index;?>][compare]" required>
            <?php
            foreach ($compares as $val => $lbl) {
                echo '<option value="'.$val.'" '.selected( $field['compare'], $val, false ).'>'.$lbl.'</option>';
            }
            ?>
        </select>

        <select class="custom-select" name="<?php echo $name; ?>[<?php echo $index === false ? '{{data.index}}':$index;?>][ctype]" required>
            <?php
            foreach ($types as $val => $lbl) {
                echo '<option value="'.$val.'" '.selected( $field['ctype'], $val, false ).'>'.$lbl.'</option>';
            }
            ?>
        </select>
        
    </div>
        
    <button class="btn rmfield" type="button" ><span class="dashicons dashicons-trash"></span></button>
</div>
<!-- end entry -->

