<?php
/* add_ons_php */
if(!isset($photos)) $photos = array();
if(!isset($azp_attrs)) $azp_attrs = array();
$images_size = 'full';
if( !empty($azp_attrs['images_size']) ) $images_size = $azp_attrs['images_size'];
$slperview = 'auto';
if( !empty($azp_attrs['slperview']) ) $slperview = $azp_attrs['slperview'];
$slider_args = array();
if( $slperview == 'auto' ) 
    $slider_args['variableWidth'] = true;
elseif( !empty($slperview) )
    $slider_args['slidesToShow'] = $slperview;
?>
<!-- listing-carousel-wrap -->
<div class="list-single-carousel-wrap carousel-wrap listing-carousel-slides-<?php echo esc_attr( $slperview ); ?>" id="lhead_sec">
	<?php 
	if(!empty($photos)){ ?>
        <div class="fw-carousel single-carousel carousel fl-wrap full-height lightgallery" data-slides="<?php echo esc_attr( $slperview ); ?>" data-options='<?php echo json_encode($slider_args); ?>'>
            <?php
            foreach ($photos as $id ) {
                $image = get_post($id);
                if( !$image ) continue;
                $galCaptionID = uniqid('gal-cap');
            ?>
                <!-- slick-slide-item -->
                <div class="slick-slide-item">
                    <div class="box-item">
                        <?php echo wp_get_attachment_image( $id, $images_size ); ?>
                        <a href="<?php echo wp_get_attachment_url( $id );?>" class="gal-link popup-image" data-sub-htmlex="#<?php echo esc_attr( $galCaptionID );?>"><i class="fal fa-search"></i></a>
                        <?php 
                            
                        $image_title = $image->post_title;
                        $image_caption = $image->post_excerpt;
                        ?>
                        <div id="<?php echo esc_attr( $galCaptionID );?>" class="listing-caption dis-none">
                            <h3><?php echo esc_html( $image_title ); ?></h3>
                            <?php echo $image_caption; ?>
                        </div>
                        <div class="show-info dis-none">
                            <span><i class="fas fa-info"></i></span>
                            <div class="tooltip-info">
                                <h5><?php echo esc_html( $image_title ); ?></h5>
                                <?php echo $image_caption; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- slick-slide-item end -->
            <?php
            }
            ?>
        </div>
        <div class="crs-button-prev sw-btn"><i class="fal fa-angle-left"></i></div>
        <div class="crs-button-next sw-btn"><i class="fal fa-angle-right"></i></div>
	<?php 
	} ?>
</div>
<!-- listing-carousel-wrap end--> 