<?php
/* add_ons_php */
$listing_bookmarks = (array)get_user_meta( get_current_user_id(), ESB_META_PREFIX.'listing_bookmarks', true );
$listing_bookmarks = array_filter($listing_bookmarks);
$bmcount = count($listing_bookmarks);
if( $bmcount ){
    $post_args = array(
        'post_type'         => 'listing',
        'post__in'          => $listing_bookmarks,
        'posts_per_page'    => -1,
        'orderby'           => 'post__in',
        'post_status'       => 'publish'
    );
    $posts_query = new WP_Query($post_args);
    $bmcount = $posts_query->found_posts;
}

// compare 
$compared = Esb_Class_Compare::get_datas();
?>
<!--  cart-btn   -->
<div class="cart-btn  tolt show-header-modal" data-microtip-position="bottom"  data-tooltip="<?php echo esc_attr_x( 'Your Wishlist / Compare' , 'Header', 'homeradar-add-ons' ); ?>">
    <i class="fal fa-bell"></i>
    <span class="cart-btn_counter color-bg bmcounter-head"><?php echo $bmcount; ?></span>
</div>
<!--  cart-btn end -->

<!-- wishlist-wrap--> 
<div class="header-modal novis_wishlist tabs-act tabs-wrapper">
    <ul class="tabs-menu fl-wrap no-list-style">
        <li class="current"><a href="#tab-wish"><?php echo esc_html_x( 'Wishlist - ', 'Header', 'homeradar-add-ons' ); ?><span class="bmcounter-tab"><?php echo $bmcount; ?></span></a></li>
        <li><a href="#tab-compare"><?php echo esc_html_x( 'Compare - ', 'Header', 'homeradar-add-ons' ); ?><span class="cpcounter-tab"><?php echo count($compared); ?></span></a></li>
    </ul>
    <!--tabs -->                       
    <div class="tabs-container">
        <div class="tab">
            <!--tab -->
            <div id="tab-wish" class="tab-content first-tab">
                <!-- header-modal-container--> 
                <div class="header-modal-container scrollbar-inner fl-wrap" data-simplebar>
                    <!--widget-posts-->
                    <div class="widget-posts  fl-wrap">
                        <ul class="no-list-style wishlist-items-wrap">
                            
                            <?php
                            if( !empty($listing_bookmarks) && $posts_query->have_posts() ){
                                while ( $posts_query->have_posts() ) {
                                    $posts_query->the_post(); 
                                    homeradar_addons_get_template_part( 'templates-inner/bookmark', 'item' );
                                }
                            }else{
                                ?>
                                <li class="wishlist-item no-bookmark-wrap">
                                    <p><?php echo _e( 'You have no bookmark.', 'homeradar-add-ons' ); ?></p>
                                </li>
                            <?php
                            }

                            wp_reset_postdata();
                            
                            ?>
                        </ul>
                    </div>
                    <!-- widget-posts end-->
                </div>
                <!-- header-modal-container end--> 
                <div class="header-modal-top fl-wrap">
                    <div class="clear_wishlist color-bg clear-bookmark-btn"><i class="fal fa-trash-alt"></i><?php esc_html_e( 'Clear all', 'homeradar-add-ons' ); ?></div>
                </div>
            </div>
            <!--tab end -->
            <!--tab -->
            <div class="tab">
                <div id="tab-compare" class="tab-content">
                    <!-- header-modal-container--> 
                    <div class="header-modal-container scrollbar-inner fl-wrap" data-simplebar>
                        <!--widget-posts-->
                        <div class="widget-posts  fl-wrap">
                            <ul class="no-list-style compare-items-wrap">
                                <?php
                                $post_args = array(
                                    'post_type'         => 'listing',
                                    'post__in'          => $compared,
                                    'posts_per_page'    => -1,
                                    'orderby'           => 'post__in',
                                    'post_status'       => 'publish'
                                );
                                $query_posts = new WP_Query($post_args);
                                if( !empty($compared) && $query_posts->have_posts() ){
                                    while ( $query_posts->have_posts() ) {
                                        $query_posts->the_post(); 
                                        homeradar_addons_get_template_part( 'templates-inner/compare', 'item' );
                                    }
                                }else{
                                    ?>
                                    <li class="wishlist-item no-compare-item">
                                        <p><?php echo _e( 'You have no item to compare.', 'homeradar-add-ons' ); ?></p>
                                    </li>
                                <?php
                                }

                                wp_reset_postdata();
                                
                                ?>
                            </ul>
                        </div>
                        <!-- widget-posts end-->
                    </div>
                    <!-- header-modal-container end-->                                      
                    <div class="header-modal-top fl-wrap">
                        <a class="clear_wishlist color-bg" href="<?php echo get_permalink( esb_addons_get_wpml_option('compare_page') ); ?>"><i class="fal fa-random"></i><?php esc_html_e( 'Compare', 'homeradar-add-ons' ); ?></a>
                    </div>
                </div>
            </div>
            <!--tab end -->
        </div>
        <!--tabs end -->                            
    </div>
</div>
<!--wishlist-wrap end -->   