<?php
/* add_ons_php */
$rating = homeradar_addons_get_average_ratings(get_the_ID()); 
                        
?>
<div class="hero-listing-item">

    <h2><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h2>
    <div class="geodir-category-location fl-wrap flex-items-center">
        <?php 
        $address = get_post_meta( get_the_ID(), ESB_META_PREFIX.'address', true );
        $latitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'latitude', true );
        $longitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'longitude', true );
        // if($address != '' ):

        $address_url = 'javascript:void(0);';
        if( !empty($latitude) && !empty($longitude) ) $address_url = 'https://www.google.com/maps/search/?api=1&query='.esc_attr($latitude).','.esc_attr($longitude);
        ?>
        <?php if( $address != '' ): ?><a href="<?php echo $address_url;?>" target="_blank"><i class="fas fa-map-marker-alt"></i><?php echo esc_html($address); ?></a><?php endif; ?>
        <?php if( $rating != false ): ?>
            <div class="listing-rating card-popup-rainingvis" data-stars="<?php echo (int)homeradar_addons_get_option('rating_base');?>" data-rating="<?php echo $rating['sum']; ?>"><span class="re_stars-title"><?php echo homeradar_addons_rating_text($rating['sum']); ?></span></div>
        <?php endif; ?>
    </div>
    <div class="clearfix"></div>
    <div class="geodir-card-excerpt"><?php homeradar_addons_the_excerpt_max_charlength( homeradar_addons_get_option('excerpt_length','55') ); ?></div>
    <div class="clearfix"></div>
    <div class="flex-items-center">
        <a href="<?php the_permalink( ); ?>" class="btn color-bg float-btn"><?php _e( 'View Details', 'homeradar-add-ons' ); ?></a> 
        <?php
        $price_from = get_post_meta( get_the_ID(), '_price', true );
        if( !empty($price_from) ){
            ?><div class="list-single-header-price"><?php _ex( '<strong>Price:</strong>', 'Listing head', 'homeradar-add-ons' ); ?><?php echo homeradar_addons_get_price_string($price_from); ?></div><?php
        } ?>
    </div>
        
</div>