<?php
/* add_ons_php */

$login_redirect_page = esb_addons_get_wpml_option('login_redirect_page');
if($login_redirect_page != 'cth_current_page' && is_numeric($login_redirect_page) )
    $login_redirect_url = get_permalink( $login_redirect_page );
else 
    $login_redirect_url = homeradar_addons_get_current_url();
$reg_redirect_page = esb_addons_get_wpml_option('reg_redirect_page');
if($reg_redirect_page != 'cth_current_page' && is_numeric($reg_redirect_page) )
    $reg_redirect_url = get_permalink( $reg_redirect_page );
else 
    $reg_redirect_url = homeradar_addons_get_current_url();


?>
<!--register form -->
<div class="main-register-wrap ctb-modal-wrap ctb-modal" id="ctb-logreg-modal">
    <div class="reg-overlay"></div>
    <div class="main-register-holder tabs-act">
        <div class="main-register-wrapper modal_main fl-wrap dis-flex">
            <div class="main-register-header color-bg">
                <div class="main-register-logo fl-wrap">
                    <?php 
                    $logo = homeradar_addons_get_option('reg_logo');
                    if( !empty($logo['id']) ){
                        echo '<a class="custom-logo-link logo-text" href="'.esc_url( home_url('/' ) ).'">'.wp_get_attachment_image( $logo['id'], 'full' ).'</a>'; 
                    }elseif( has_custom_logo() ){
                        the_custom_logo(); 
                    }else echo '<a class="custom-logo-link logo-text" href="'.esc_url( home_url('/' ) ).'"><h2>'.get_bloginfo( 'name' ).'</h2></a>'; 
                    ?>
                </div>
                <?php 
                $logreg_form_before = homeradar_addons_get_option('logreg_form_before');
                if ( $logreg_form_before != '' ): ?>
                <div class="logreg-content-left">
                    <?php echo do_shortcode( $logreg_form_before ); ?>
                </div>
                <?php 
                endif; ?>
                <?php $bgimg = homeradar_addons_get_option('reg_bg'); ?>
                <div class="main-register-bg bg" data-bg="<?php if( !empty($bgimg) ) echo esc_url( homeradar_addons_get_attachment_thumb_link($bgimg['id'], 'bg-image') ); ?>">
                    <div class="mrb_pin"></div>
                    <div class="mrb_pin mrb_pin2"></div>
                </div>
                <div class="mrb_dec"></div>
                <div class="mrb_dec mrb_dec2"></div>
            </div>
            <div class="main-register tabs-wrapper">
                <div class="close-reg ctb-modal-close"><i class="fal fa-times"></i></div>
                <ul class="tabs-menu fl-wrap no-list-style">
                    <li class="current"><a href="#tab-login"><?php _e( '<i class="fal fa-sign-in-alt"></i> Login', 'homeradar-add-ons' ); ?></a></li>
                    <li><a href="#tab-register"><?php _e( '<i class="fal fa-user-plus"></i> Register', 'homeradar-add-ons' ); ?></a></li>
                </ul>

                <!--tabs -->                       
                <div class="tabs-container">
                    <div class="tab">
                        <!--tab -->
                        <div id="tab-login" class="tab-content first-tab">
                            <div class="custom-form">
                                <form method="post" id="homeradar-login">
                                    <div class="log-message"></div>
                                    <div class="hasIcon">
                                        <label for="user_login"><?php _e( 'Username or Email Address <span>*</span>', 'homeradar-add-ons' );?><span class="dec-icon"><i class="fal fa-user"></i></span></label>
                                        <input id="user_login" name="log" type="text" onClick="this.select()" value="" required>
                                    </div>
                                    <div class="hasIcon">
                                        <label for="user_pass"><?php _e( 'Password <span>*</span>', 'homeradar-add-ons' );?><span class="dec-icon"><i class="fal fa-key"></i></span></label>
                                        <input id="user_pass" name="pwd" type="password" onClick="this.select()" value="" required>
                                    </div>
                                    <?php homeradar_addons_display_recaptcha('loginCaptcha'); ?>

                                    <div class="clearfix"></div>
                                    <div class="flex-items-center jtf-space-between mb-20">
                                        <div class="filter-tags dis-flex">
                                            <input name="rememberme" id="rememberme" value="true" type="checkbox">
                                            <label for="rememberme"><?php _e('Remember me','homeradar-add-ons');?></label>
                                        </div>
                                        <div class="lost_password">
                                            <a class="lost-password" href="<?php echo wp_lostpassword_url( homeradar_addons_get_current_url() ); ?>"><?php _e('Lost Your Password?','homeradar-add-ons');?></a>
                                        </div>
                                    </div>

                                    <button type="submit" id="log-submit" class="log-submit-btn log_btn color-bg"><?php _e( 'Log In', 'homeradar-add-ons' );?></button>

                                    
                                        
                                    <?php
                                        // this prevent automated script for unwanted spam
                                        if ( function_exists( 'wp_nonce_field' ) ) 
                                            wp_nonce_field( 'homeradar-login', '_loginnonce' );
                                    ?>
                                    
                                    <input type="hidden" name="redirection" value="<?php echo esc_url($login_redirect_url); ?>" />
                                </form>
                            </div>
                        </div>
                        <!--tab end -->
                        <!--tab -->
                        <div class="tab">
                            <div id="tab-register" class="tab-content">
                                <div class="custom-form">
                                    <form method="post" class="main-register-form" id="homeradar-register">
                                        <div class="reg-message"></div>
        
                                        <?php if(homeradar_addons_get_option('register_password') != 'yes'): ?>
                                            <p><?php esc_html_e( 'Account details will be confirmed via email.', 'homeradar-add-ons' ); ?></p>
                                        <?php endif; ?>

                                        <?php 
                                        $login_pattern = homeradar_addons_get_option('login_pattern');
                                        $login_pat_desc = homeradar_addons_get_option('login_pat_desc');
                                        ?>
                                        <div class="hasIcon">
                                            <label for="reg_username"><?php _e( 'Username <span>*</span>', 'homeradar-add-ons' );?><span class="dec-icon"><i class="fal fa-user"></i></span></label>
                                            <input id="reg_username" name="username" type="text"  onClick="this.select()" value="" required 
                                                <?php if( !empty($login_pattern) ) echo 'pattern="'.esc_attr( $login_pattern ).'"'; ?>
                                                <?php if( !empty($login_pat_desc) ) echo 'title="'.esc_attr( $login_pat_desc ).'"'; ?>
                                            >
                                            <?php if( !empty($login_pat_desc) ) echo '<span class="input-pattern-desc">'.$login_pat_desc.'</span>'; ?>
                                        </div>

                                        <?php if(homeradar_addons_get_option('reg_firstname') == 'yes'): ?>
                                        <div class="hasIcon">
                                            <label for="reg_firstname"><?php _e( 'First Name <span>*</span>', 'homeradar-add-ons' );?><span class="dec-icon"><i class="fal fa-user"></i></span></label>
                                            <input id="reg_firstname" name="first_name" type="text"  onClick="this.select()" value="" required>
                                        </div>
                                        <?php endif; ?>

                                        <?php if(homeradar_addons_get_option('reg_lastname') == 'yes'): ?>
                                        <div class="hasIcon">
                                            <label for="reg_lastname"><?php _e( 'Last Name <span>*</span>', 'homeradar-add-ons' );?><span class="dec-icon"><i class="fal fa-user"></i></span></label>
                                            <input id="reg_lastname" name="last_name" type="text"  onClick="this.select()" value="" required>
                                        </div>
                                        <?php endif; ?>
                                        <?php 
                                        $email_pattern = homeradar_addons_get_option('email_pattern');
                                        $email_pat_desc = homeradar_addons_get_option('email_pat_desc'); ?>
                                        <div class="hasIcon">
                                            <label for="reg_email"><?php _e( 'Email Address <span>*</span>', 'homeradar-add-ons' );?><span class="dec-icon"><i class="fal fa-envelope"></i></span></label>
                                            <input id="reg_email" name="email" type="email"  onClick="this.select()" value="" required 
                                                <?php if( !empty($email_pattern) ) echo 'pattern="'.esc_attr( $email_pattern ).'"'; ?>
                                                <?php if( !empty($email_pat_desc) ) echo 'title="'.esc_attr( $email_pat_desc ).'"'; ?>
                                            >
                                            <?php if( !empty($email_pat_desc) ) echo '<span class="input-pattern-desc">'.$email_pat_desc.'</span>'; ?>
                                        </div>
                                        <?php if(homeradar_addons_get_option('register_password') == 'yes'): 
                                            $pwd_pattern = homeradar_addons_get_option('pwd_pattern');
                                            $pwd_pat_desc = homeradar_addons_get_option('pwd_pat_desc');
                                        ?>
                                        <div class="hasIcon">
                                            <label for="reg_password"><?php _e( 'Password <span>*</span>', 'homeradar-add-ons' );?><span class="dec-icon"><i class="fal fa-key"></i></span></label>
                                            <input id="reg_password" name="password" type="password" onClick="this.select()" value="" required
                                                autocomplete="off" 
                                                <?php if( !empty($pwd_pattern) ) echo 'pattern="'.esc_attr( $pwd_pattern ).'"'; ?>
                                                <?php if( !empty($pwd_pat_desc) ) echo 'title="'.esc_attr( $pwd_pat_desc ).'"'; ?>
                                            >
                                            <?php if( !empty($pwd_pat_desc) ) echo '<span class="input-pattern-desc">'.$pwd_pat_desc.'</span>'; ?>
                                        </div>
                                        <?php endif; ?>
                                        
                                        <?php if(homeradar_addons_get_option('register_role') == 'yes'): ?>
                                            <div class="switchbtn text-center reg-as-lauthor">
                                                <input type="checkbox" id="reg_lauthor" name="reg_lauthor" value="1" class="switchbtn-checkbox">
                                                <label class="switchbtn-label" for="reg_lauthor">
                                                    <?php _e( '<i class="fal fa-user-tie"></i><span>Register as author</span>', 'homeradar-add-ons' ); ?>
                                                </label>
                                            </div>
                                        <?php endif; ?>

                                        <div class="terms_wrap">
                                            <?php if(homeradar_addons_get_option('register_term_text') != ''): ?>
                                            <div class="filter-tags flex-items-center mb-10">
                                                <input id="accept_term" name="accept_term" value="1" type="checkbox" required="required">
                                                <label for="accept_term"><?php echo homeradar_addons_get_option('register_term_text');?></label>
                                            </div>
                                            <?php endif; ?>
                                            <?php if(homeradar_addons_get_option('register_consent_data_text') != ''): ?>
                                            <div class="filter-tags flex-items-center">
                                                <input id="consent_data" name="consent_data" value="1" type="checkbox" required="required">
                                                <label for="consent_data"><?php echo homeradar_addons_get_option('register_consent_data_text');?></label>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="clearfix"></div>

                                        <?php homeradar_addons_display_recaptcha('regCaptcha'); ?>
                                        
                                        <button type="submit" id="reg-submit" class="log-submit-btn log_btn color-bg"><?php _e( 'Register', 'homeradar-add-ons' );?></button>

                                        <?php
                                            // this prevent automated script for unwanted spam
                                            if ( function_exists( 'wp_nonce_field' ) ) 
                                                wp_nonce_field( 'homeradar-register', '_regnonce' );
                                        ?>

                                        <input type="hidden" name="redirection" value="<?php echo esc_url($reg_redirect_url); ?>" />

                                    </form>
                                </div>
                            </div>
                        </div>
                        <!--tab end -->
                    </div>
                    <!--tabs end -->
                    <?php 
                    $logreg_form_after = homeradar_addons_get_option('logreg_form_after');
                    if ( $logreg_form_after != '' ): 
                        _e( '<div class="log-separator fl-wrap"><span>or</span></div>', 'homeradar-add-ons' );
                    ?>
                    <div class="soc-log fl-wrap">
                        <?php echo do_shortcode( $logreg_form_after ); ?>
                    </div>
                    <?php 
                    endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!--register form end -->

<div class="ctb-modal-wrap ctb-modal" id="ctb-resetpsw-modal">
    <div class="ctb-modal-holder">
        <div class="ctb-modal-inner modal_main">
            <div class="ctb-modal-close"><i class="fal fa-times"></i></div>
            <div class="ctb-modal-title"><?php _e( 'Reset <span><strong>Password</strong></span>', 'homeradar-add-ons' );?></div>
            <div class="ctb-modal-content">
                
                <form class="reset-password-form custom-form" action="#" method="post">
                    <div class="hasIcon mb-20">
                        <label for="user_reset"><?php _e( 'Username or Email Address <span>*</span>', 'homeradar-add-ons' );?><span class="dec-icon"><i class="fal fa-user"></i></span></label>
                        <input id="user_reset" name="user_login" type="text"  value="" required>
                    </div>
                    <button type="submit" class="log_btn color-bg"><?php _e( 'Get New Password', 'homeradar-add-ons' );?></button>

                    <?php
                        // this prevent automated script for unwanted spam
                        if ( function_exists( 'wp_nonce_field' ) ) 
                            wp_nonce_field( 'homeradar-lostpsw', '_wpnonce' );
                    ?>
                </form>
            </div>
            <!-- end modal-content -->
        </div>
    </div>
</div>
<!-- end reset password modal --> 
