<?php
/* add_ons_php */
if( homeradar_addons_get_option('show_cats_nav','yes') !== 'yes' ) return;
if( !isset($exclass) ) $exclass = '';
if( !isset($tooltip_pos) ) $tooltip_pos = 'bottom';

$term_args = array(
    'taxonomy' => 'listing_cat',
    'hide_empty' => true,
    'orderby' => 'count',
    'order' => 'DESC',
    'number' => (int)homeradar_addons_get_option('cats_num'),
);
$term_args = apply_filters( 'cth_lcategories_tab_args', $term_args );
$listing_terms = get_terms( $term_args );
if ( ! empty( $listing_terms ) && ! is_wp_error( $listing_terms ) ){ 
    $search_cats = '';
    if(is_tax('listing_cat')){
        $search_cats = get_queried_object_id();
    }else{
        if(isset($_GET['lcats'])&&is_array($_GET['lcats'])){
            $search_cats = array_filter($_GET['lcats']);
            $search_cats = reset($search_cats);
        } 
    }
?>
<div class="categoties-column_container cat-list <?php echo $exclass; ?>">
    <ul>
        <?php
        foreach ($listing_terms as $cat) {
            $term_metas = homeradar_addons_custom_tax_metas($cat->term_id); 
            $act_cls = '';
            if( $cat->term_id == $search_cats ) $act_cls = 'act-category';
            ?>
            <li><a href="<?php echo homeradar_addons_get_term_link( $cat->term_id, 'listing_cat' ); ?>" class="<?php echo esc_attr( $act_cls );?> tolt"  data-microtip-position="<?php echo $tooltip_pos; ?>" data-tooltip="<?php echo esc_attr($cat->name); ?>">
                <?php 
                if( !empty($term_metas['icon']) ): ?><i class="<?php echo $term_metas['icon']; ?>"></i>
                <?php 
                else: 
                    echo $cat->name;
                endif; ?>
            </a></li>
        <?php
        } ?>
    </ul>
</div>
<?php
}