<?php
/* add_ons_php */

$current_user = wp_get_current_user();  
$user_role = homeradar_addons_get_user_role();

if( in_array($user_role, array('listing_author','seller','wcfm_vendor','shop_manager')) && ( $plan_id = Esb_Class_Membership::current_plan( get_current_user_id() ) ) != '' ){
    $plan_string = sprintf(__('<span>Tariff Plan: </span> <strong>%1$s</strong>', 'homeradar-add-ons'), get_the_title($plan_id));
    $plan_desc = sprintf(__('<p>You are on <a>%1$s</a>. Use link bellow to view details or upgrade.</p><a class="tfp-det-btn color2-bg" href="%2$s">Details</a>', 'homeradar-add-ons'), get_the_title($plan_id), get_permalink( esb_addons_get_wpml_option('packages_page') ) );
}else{
    $plan_string = sprintf(__('<span>Your are: </span> <strong>%1$s</strong>', 'homeradar-add-ons'), homeradar_addons_get_user_role_name());
    $plan_desc = sprintf(__('<p>You are <a>%1$s</a>. Order an membership plan to submit listings.</p><a class="tfp-det-btn color2-bg" href="%2$s">Membership Plans</a>', 'homeradar-add-ons'), homeradar_addons_get_user_role_name(), get_permalink( esb_addons_get_wpml_option('packages_page') ) );
}
 
?>
<div class="dashbard-menu-header">
    <div class="dashbard-menu-avatar fl-wrap">
        <?php 
            echo get_avatar($current_user->user_email,'80','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', $current_user->display_name );
        ?>
        <h4><?php echo sprintf(_x( 'Welcome , <span>%s</span>', 'Dashboard', 'homeradar-add-ons' ), $current_user->display_name); ?></h4>
    </div>
    <a href="<?php echo wp_logout_url(homeradar_addons_get_current_url()); ?>" class="log-out-btn tolt" data-microtip-position="bottom"  data-tooltip="<?php esc_attr_e( 'Log Out', 'homeradar-add-ons' ); ?>"><i class="far fa-power-off"></i></a>
</div>
<!--Tariff Plan menu-->
<div class="tfp-det-container">
    <div class="tfp-btn"><?php echo $plan_string; ?></div>
    <div class="tfp-det"><?php echo $plan_desc; ?></div>
</div>
<!--Tariff Plan menu end--> 