<?php
/* add_ons_php */


$current_user = wp_get_current_user(); 

Esb_Class_Message_CPT::delete_messages_count($current_user->ID);


if(is_front_page()) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
}                 

$post_args = array(
    'post_type'     => 'lmessage', 
    // 'author'        =>  0, 
    'orderby'       => 'date',
    'order'         => 'DESC',
    'paged'         => $paged,
    'post_status'   => 'publish',
    // 'posts_per_page' => -1, // no limit
    
    'meta_query' => array(
        // show listing author bookings
        // 'relation' => 'OR',
        array(
            'key'       => ESB_META_PREFIX.'to_user_id',
            'value'     => $current_user->ID,
            // 'compare' => 'IN',
            'type'      => 'NUMERIC'
        ),
        // show user bookings
        // array(
        //     'relation' => 'AND',
        //     array(
        //         'key'     => ESB_META_PREFIX.'lmsg_email',
        //         'value'   => $current_user->user_email,
        //     ),
        //     array(
        //         'key'     => ESB_META_PREFIX.'lmsg_status',
        //         'value'   => 'canceled',
        //         'compare' => '!='
        //     )  
        // ),
        
    ),
    
);
if(isset($_GET['id']) && $_GET['id'] > 0){
    $post_args['meta_query'] = array(
        array(
            'key'       => ESB_META_PREFIX.'first_msg',
            'value'     => $_GET['id'],
            'type'      => 'NUMERIC'
        )
    );
}

// The Query
$posts_query = new WP_Query( $post_args );

?>

<div class="dashboard-content-wrapper dashboard-content-messages">
    <div class="dashboard-content-inner">
        
        <div class="dashboard-message-grid">

            
            <div class="dasboard-widget-box fl-wrap">

                <div class="messages-grid-inner cthiso-isotope-wrapper dashboard-items-grid">
                    <div class="cthiso-flex cthiso-big-pad cthiso-two-cols mb-20">
                    
                    <?php 
                    if($posts_query->have_posts()) :
                        while($posts_query->have_posts()) : $posts_query->the_post(); 
                            $lmsg_email = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_email', true );
                            $lmsg_phone = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_phone', true );
                            $lmsg_name = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_name', true );

                            $from_user = get_post_meta( get_the_ID(), ESB_META_PREFIX.'from_user_id', true );
                            $first_msg_meta = get_post_meta( get_the_ID(), ESB_META_PREFIX.'first_msg', true );
                            $lmsg_status = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_status', true );
                            $listing_id             = get_post_meta( get_the_ID(), ESB_META_PREFIX.'listing_id', true );
                        ?>
                        <div class="cthiso-item">
                            <div id="message-<?php the_ID(); ?>" <?php post_class('dashboard-message-item bookings-item'); ?>>


                                <div class="bookings-item-header fl-wrap lms-item-header">
                                    <?php echo get_avatar($lmsg_email,'80','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', $lmsg_name ); ?>
                                    <h4><?php the_title(); ?></h4>
                                    
                                    <span class="booking-list-new new-bookmark green-bg lmsg-<?php echo $lmsg_status;?>"><?php echo Esb_Class_Message_CPT::status_text( $lmsg_status ); ?></span>
                                </div>
                                <div class="bookings-item-content fl-wrap">
                                    <ul class="no-list-style">
                                        <?php 
                                        if( !empty($first_msg_meta) ): 
                                            $first_msg_url = add_query_arg('id', $first_msg_meta, Esb_Class_Dashboard::screen_url('messages') );
                                        ?>
                                        <li class="bkdt-item bk-mlisting">
                                            <span class="bkdt-title ms-mreply-to"><?php _e( 'Reply to: ', 'homeradar-add-ons' ); ?></span>  
                                            <span><a class="msg-reply-to-link" href="<?php echo esc_url( $first_msg_url );?>"><?php echo get_the_title( $first_msg_meta ); ?></a></span>
                                        </li>
                                        <?php 
                                        endif; ?>

                                        <?php if ( !empty($lmsg_name) ): ?>
                                        <li class="bkdt-item bk-cname"><span class="bkdt-title"><?php esc_html_e( 'Name: ', 'homeradar-add-ons' ); ?></span><span><?php echo esc_html($lmsg_name); ?></span></li>
                                        <?php endif ?>
                                        <?php if ( !empty($lmsg_phone) ): ?>
                                        <li class="bkdt-item bk-cphone"><span class="bkdt-title"><?php esc_html_e( 'Phone: ', 'homeradar-add-ons' ); ?></span><span><a href="tel:<?php echo esc_attr($lmsg_phone); ?>"><?php echo esc_html($lmsg_phone); ?></a></span></li>
                                        <?php endif ?>
                                        <?php if ( !empty($lmsg_email) ): ?>
                                        <li class="bkdt-item bk-cphone"><span class="bkdt-title"><?php esc_html_e( 'Email: ', 'homeradar-add-ons' ); ?></span><span><a href="mailto:<?php echo esc_attr($lmsg_email); ?>"><?php echo esc_html($lmsg_email); ?></a></span></li>
                                        <?php endif ?>

                                        <?php 
                                        if( !empty($listing_id) ): ?>
                                        <li class="bkdt-item bk-mlisting">
                                            <span class="bkdt-title ms-mlisting"><?php _e( 'For listing :', 'homeradar-add-ons' ); ?></span>   
                                            <span><a href="<?php echo get_permalink( $listing_id ); ?>" target="_blank"><?php echo get_the_title( $listing_id ); ?></a></span>
                                        </li>
                                        <?php endif; ?>
                                        <?php 
                                        $msgCheckin = get_post_meta( get_the_ID(), ESB_META_PREFIX.'checkin', true );
                                        if( !empty($msgCheckin) ): ?>
                                        <li class="bkdt-item bk-mlisting">
                                            <span class="bkdt-title ms-mdate"><?php _e( 'Date :', 'homeradar-add-ons' ); ?></span>   
                                            <span><a href="javascript:void(0);" target="_top"><?php echo esc_html($msgCheckin); ?></a></span>
                                        </li>
                                        <?php endif; ?>
                                        <?php 
                                        $msgTime = get_post_meta( get_the_ID(), ESB_META_PREFIX.'time', true );
                                        if( !empty($msgTime) ): ?>
                                        <li class="bkdt-item bk-mtime">
                                            <span class="bkdt-title ms-mlisting"><?php _e( 'Time :', 'homeradar-add-ons' ); ?></span>   
                                            <span><a href="javascript:void(0);" target="_top"><?php echo esc_html($msgTime); ?></a></span>
                                        </li>
                                        <?php endif; ?>

                                       
                                    </ul>
                                    
                                    <?php echo wp_kses_post( get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_message', true ) ); ?>
                                </div>
                                
                                <div class="bookings-item-footer fl-wrap flex-items-center jtf-space-between">
                                    
                                    <span class="message-date"><?php the_time(get_option('date_format'));?></span>
                                    <ul class="no-list-style dis-flex">
                                        <?php 
                                        if( !empty($from_user) ): 
                                            $first_msg = $first_msg_meta != '' ? $first_msg_meta : get_the_ID();
                                        ?><li><a href="#" class="green-bg tolt reply-lauthor_msg" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Reply', 'homeradar-add-ons' ); ?>" data-id="<?php echo $from_user;?>" data-replyto="<?php echo get_the_ID();?>" data-firstmsg="<?php echo esc_attr($first_msg);?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><i class="far fa-envelope"></i></a></li>
                                        <?php endif; ?>
                                        <?php
                                        if(get_current_user_id() == get_post_meta( get_the_ID(), ESB_META_PREFIX.'to_user_id', true ) ): 
                                        ?><li><a href="#" class="del-bg tolt del-lauthor_msg" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Delete', 'homeradar-add-ons' ); ?>" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><i class="far fa-trash"></i></a></li><?php endif; ?>
                                    </ul>
                                </div>


                            </div>
                            <!-- dashboard-list end--> 
                        </div>
                    <?php 
                        endwhile; 
                        echo homeradar_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
                    
                        /* Restore original Post Data 
                         * NB: Because we are using new WP_Query we aren't stomping on the 
                         * original $wp_query and it does not need to be reset with 
                         * wp_reset_query(). We just need to set the post data back up with
                         * wp_reset_postdata().
                         */
                        wp_reset_postdata();
                    else:
                    ?> 
                    <div id="message-no" class="dashboard-card-none dashboard-message-item fullw">
                        <div class="dashboard-card-content">
                            <?php _e( '<p>You have no message yet!</p>', 'homeradar-add-ons' ); ?>
                        </div>
                    </div>
                    <?php
                    endif; ?> 

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>