<?php
/* add_ons_php */
// don't show on customer dashboard

homeradar_addons_reset_user_notification_type('listing_publish');

$current_user = wp_get_current_user();    

if(is_front_page()) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
}                 

$args = array(
    'post_type'     =>  'listing', 
    'author'        =>  $current_user->ID, 
    'orderby'       =>  'date',
    'order'         =>  'DESC',
    'paged'         => $paged,
    // 'posts_per_page' => -1 // no limit

    'post_status'   => array( 'publish', 'pending', 'draft', 'future' ),
);

// The Query
$posts_query = new WP_Query( $args );

?>
<div class="dashboard-content-wrapper dashboard-content-listings">
    <div class="dashboard-content-inner">
        
        <div class="dasboard-opt sl-opt fl-wrap dis-flex jtf-space-between">
            <!-- <div class="dashboard-search-listing">
                <input type="text" onclick="this.select()" placeholder="Search" value="">
                <button type="submit"><i class="far fa-search"></i></button>
            </div> -->
            <?php if( Esb_Class_Membership::is_author()  ): ?>
                <a href="<?php echo homeradar_addons_add_listing_url(); ?>" class="gradient-bg dashboard-addnew_btn"><?php _e( 'Add New', 'homeradar-add-ons' ); ?><i class="fal fa-plus"></i></a>   
            <?php endif; ?>
            
            <!-- price-opt-->
            <!-- <div class="price-opt">
                <span class="price-opt-title">Sort   by:</span>
                <div class="listsearch-input-item">
                    <select data-placeholder="Lastes" class="chosen-select no-search-select" >
                        <option>Lastes</option>
                        <option>Oldes</option>
                        <option>Average rating</option>
                        <option>Name: A-Z</option>
                        <option>Name: Z-A</option>
                    </select>
                </div>
            </div> -->
            <!-- price-opt end-->
        </div>
        <div class="clearfix"></div>
        
        <div class="dashboard-listings-grid cthiso-isotope-wrapper dashboard-items-grid">
            
            <?php 
            if($posts_query->have_posts()) : ?>
            <div class="cthiso-flex cthiso-big-pad cthiso-two-cols mb-20">
            <?php
                while($posts_query->have_posts()) : $posts_query->the_post(); 
                    $address = get_post_meta( get_the_ID(), ESB_META_PREFIX.'address', true );
                    $latitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'latitude', true );
                    $longitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'longitude', true );
                    $direction = 'javascript:void(0);';
                    if( !empty($latitude) && !empty($longitude) ) $direction = "https://www.google.com/maps/search/?api=1&query=$latitude,$longitude";
                ?>
                <div class="cthiso-item">
                    <div id="listing-<?php the_ID(); ?>" <?php post_class('dashboard-listings-item dis-flex'); ?>>
                        <?php
                        if(has_post_thumbnail( )){ ?>
                        <div class="dashboard-listings-item_img">
                            <div class="bg-wrap">
                                <div class="bg" data-bg="<?php echo get_the_post_thumbnail_url(null, 'listing-featured'); ?>"></div>
                            </div>
                            <div class="overlay"></div>
                            <a href="<?php the_permalink( ); ?>" class="color-bg"><?php _ex( 'View', 'Dashboard listings', 'homeradar-add-ons' ); ?></a>
                        </div>
                        <?php } ?>
                        <div class="dashboard-listings-item_content">
                            <h4><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h4>
                            <?php 
                            if( !empty($address) ): ?>
                            <div class="geodir-category-location">
                                <a href="<?php echo $direction; ?>"><i class="fas fa-map-marker-alt"></i> <span><?php echo $address; ?></span></a>
                            </div>
                            <?php 
                            endif; ?>
                            <div class="clearfix"></div>
                            <?php 
                            
                            $rating = homeradar_addons_get_average_ratings(get_the_ID());    ?>
                            <?php if( $rating != false ): ?>
                                <div class="listing-rating card-popup-rainingvis tolt" data-stars="<?php echo (int)homeradar_addons_get_option('rating_base');?>" data-rating="<?php echo $rating['sum']; ?>" data-microtip-position="right" data-tooltip="<?php echo homeradar_addons_rating_text($rating['sum']); ?>"></div>
                            <?php 
                            endif; ?>  
                            <div class="dashboard-listings-item_opt dis-flex jtf-space-between">
                                <span class="viewed-counter"><i class="fas fa-eye"></i><?php echo sprintf(_x( ' Viewed - %s', 'Dashboard listings', 'homeradar-add-ons' ), Esb_Class_LStats::get_stats(get_the_ID()) ); ?></span>
                                <ul class="no-list-style dis-flex">
                                    <li>
                                        <a href="#" class="set-lfeatured<?php if( get_post_meta( get_the_ID(), ESB_META_PREFIX.'featured', true ) == '1' ) echo ' lfeatured' ;?>" data-id="<?php echo get_the_ID();?>"><span class="lfeatured-loading"><i class="fa fa-spinner fa-pulse"></i></span><span class="as-lfeatured"><?php esc_html_e( 'Set as featured', 'homeradar-add-ons' );?></span><span class="lfeatured"><?php esc_html_e( 'Featured', 'homeradar-add-ons' );?></span></a>
                                    </li>
                                    <li><a href="<?php echo esc_url( homeradar_addons_get_edit_listing_url( ) );?>" class="tolt" data-microtip-position="top-left"  data-tooltip="<?php echo esc_attr_x( 'Edit', 'Dashboard listings', 'homeradar-add-ons' ); ?>"><i class="far fa-edit"></i></a></li>
                                    <li><a href="#" class="tolt" data-microtip-position="top-left"  data-tooltip="<?php echo esc_attr_x( 'Disable', 'Dashboard listings', 'homeradar-add-ons' ); ?>"><i class="far fa-signal-alt-slash"></i></a></li>
                                    <li><a href="#" class="tolt del-listing"  data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>" data-microtip-position="top-left"  data-tooltip="<?php echo esc_attr_x( 'Delete', 'Dashboard listings', 'homeradar-add-ons' ); ?>"><i class="far fa-trash-alt"></i></a></li>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                </div>
                <!-- dashboard-list end--> 
            <?php 
                endwhile; 
                ?>
            </div>
            <?php
                echo homeradar_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
            
                /* Restore original Post Data 
                 * NB: Because we are using new WP_Query we aren't stomping on the 
                 * original $wp_query and it does not need to be reset with 
                 * wp_reset_query(). We just need to set the post data back up with
                 * wp_reset_postdata().
                 */
                wp_reset_postdata();
            else:
            ?> 
            <div id="listing-no" class="dashboard-card-none dashboard-listing-item">
                <div class="dashboard-card-content">
                    <?php _e( '<p>You have no listing yet!</p>', 'homeradar-add-ons' ); ?>
                </div>
            </div>
            <?php
            endif; ?> 
        
        </div>
    </div>
</div>
