<?php
/* add_ons_php */

$current_user = wp_get_current_user();  

$views_count = 0;
// $bookmarks_count = 0;
$comments_count = 0;
$bookings_count = 0;
$post_args = array(
    'post_type'         => 'listing',
    'author'            => $current_user->ID,
    'posts_per_page'    => -1,
    'post_status'       => array('publish','pending','future','private'), // 'publish',
    'fields'            => 'ids'
);
$posts_get = get_posts( $post_args );
foreach ( $posts_get as $pid ) {
    if( homeradar_addons_get_option('db_hide_lviews') != 'yes' ) $views_count += Esb_Class_LStats::get_stats( $pid );
    // $bookmarks_count += Esb_Class_Listing_CPT::get_bookmark_count( $pid );
    if( homeradar_addons_get_option('db_hide_lreviews') != 'yes' ) $comments_count += get_comments_number( $pid );
    if( homeradar_addons_get_option('db_hide_lbookings') != 'yes' ) $bookings_count += count( get_posts(
        array(
            'post_type'         => 'lbooking',
            'posts_per_page'    => -1,
            'post_status'       => 'publish',
            'fields'            => 'ids',
            // 'meta_key'          => ESB_META_PREFIX .'listing_id',
            // 'meta_value_num'    => $pid,

            'meta_query' => array(
                // 'relation' => 'OR',
                array(
                    'key'     => ESB_META_PREFIX .'listing_id',
                    'value'   => $pid,
                    'type'      => 'NUMERIC',
                ),
                array(
                    'key' => ESB_META_PREFIX .'lb_status',
                    'value'   => array( 'canceled', 'refunded', 'failed' ),
                    'compare' => 'NOT IN',
                ),
            ),

        )
    ) );

    // $reviews = homeradar_addons_get_average_ratings($listing_ID);
    // if($reviews) $reviews_count += $reviews['count'];
}


$notifications = Esb_Class_Dashboard::get_notifications( $current_user->ID );
// $notifications = json_decode(json_encode($notifications),true);

?>
<div class="dashboard-content-wrapper dashboard-content-dashboard">
    <div class="dashboard-content-inner">

        <?php 
        if( homeradar_addons_get_option('show_stats', 'yes') == 'yes' ): 
            $countCol = array(
                'llistings'        => '',
                'lviews'        => '',
                'lreviews'      => '',
                'lbookings'     => '',
            );
            if( homeradar_addons_get_option('db_hide_lviews') == 'yes' ) unset( $countCol['lviews'] );
            if( homeradar_addons_get_option('db_hide_lreviews') == 'yes' ) unset( $countCol['lreviews'] );
            if( homeradar_addons_get_option('db_hide_lbookings') == 'yes' ) unset( $countCol['lbookings'] );

            $countCol = count( $countCol );
        ?>
        
        <!-- list-single-facts -->
        <div class="dashboard-facts fl-wrap">
            <div class="row">
                <?php if( homeradar_addons_get_option('db_hide_lviews') != 'yes' ): ?>
                <div class="lstats-lviews db-facts-item col-md-<?php echo 12/$countCol;?>">
                    <div class="dashboard-stats fl-wrap">
                        <i class="fal fa-map-marked"></i>
                        <h4><?php _e( 'Active Listings', 'homeradar-add-ons' ); ?></h4>
                        <div class="dashboard-stats-count"><?php echo count_user_posts( null, 'listing', true ); ?></div>
                    </div>

                    
                </div>
                <?php endif; ?>
                <?php if( homeradar_addons_get_option('db_hide_lviews') != 'yes' ): ?>
                <div class="lstats-lviews db-facts-item col-md-<?php echo 12/$countCol;?>">
                    <div class="dashboard-stats fl-wrap">
                        <i class="fal fa-chart-bar"></i>
                        <h4><?php _e( 'Listing Views', 'homeradar-add-ons' ); ?></h4>
                        <div class="dashboard-stats-count"><?php echo $views_count; ?>
                            <!-- <span>(<strong>+356</strong> this week)</span> -->
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if( homeradar_addons_get_option('db_hide_lreviews') != 'yes' ): ?>
                <div class="lstats-lreviews db-facts-item col-md-<?php echo 12/$countCol;?>">
                    <div class="dashboard-stats fl-wrap">
                        <i class="fal fa-comments-alt"></i>
                        <h4><?php _e( 'Total Reviews', 'homeradar-add-ons' ); ?></h4>
                        <div class="dashboard-stats-count"><?php echo $comments_count; ?>
                            <!-- <span>(<strong>+12</strong> this week)</span> -->
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if( homeradar_addons_get_option('db_hide_lbookings') != 'yes' ): ?>
                <div class="lstats-lbookings db-facts-item col-md-<?php echo 12/$countCol;?>">
                    <div class="dashboard-stats fl-wrap">
                        <i class="fal fa-envelope-open-dollar"></i>
                        <h4><?php _e( 'Bookings ', 'homeradar-add-ons' ); ?></h4>
                        <div class="dashboard-stats-count"><?php echo $bookings_count; ?>
                            <!-- <span>(<strong>+234</strong> this week)</span> -->
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <!-- list-single-facts end -->
        <?php endif; ?>

        
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-8">

                <?php 
                $substatus = Esb_Class_Membership::subscription_status(); 
                if( !empty($substatus) ): ?>
                <div class="dashboard-list-box fl-wrap dashboard-substatus">
                    <div class="notification-list-item notification success-notif">
                        <div class="notification-list-inner">
                            <div class="notification-list-text">
                                <div class="notification-msg"><?php echo $substatus; ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <div class="dashboard-widget-title fl-wrap"><?php _ex( 'Your Statistic', 'Dashboard', 'homeradar-add-ons' ); ?></div>
                <?php 
                if( homeradar_addons_get_option('show_chart', 'yes') == 'yes' ): ?>
                <div class="dasboard-content fl-wrap">
                    <!-- chart-wra-->
                    <div class="chart-wrap-wraper fl-wrap">
                        <div id="dashboard-chart"></div>
                    </div>
                    <!--chart-wrap end-->
                </div>
                <?php endif; ?>
                <?php do_action( 'cth_front_dashboard_dashboard'); ?>
                <div class="dashboard-widget-title fl-wrap">
                    <h3><?php _e( 'Recent Activities', 'homeradar-add-ons' ); ?></h3>
                </div>
                <!-- dashboard-list-box-->
                <div class="dashboard-list-box  fl-wrap">
                    <?php 
                    if( !empty($notifications) ):
                    $npages = array_pop($notifications);
                    foreach ($notifications as $key => $noti) {
                    ?>  
                    <div class="notification-list-item dis-flex jtf-space-between">
                        <div class="notification-list-inner dis-flex jtf-space-between">
                            <div class="notification-list-text">
                                <div class="notification-msg"><?php echo  $noti->message ; ?></div>
                            </div>
                            <div class="notification-list-time"><i class="fal fa-calendar-week"></i><?php echo $noti->time ; ?></div>
                        </div>
                        <span class="notification-list-remove delete-notification" data-notification="<?php echo $noti->id ; ?>"><i class="fal fa-times"></i></span>
                    </div>
                    <!-- dashboard-list end-->    
                    <?php 
                    } ?>

                    <?php else: ?> 
                    <div class="notification-list-item">
                        <div class="notification-list-inner">
                            <div class="notification-list-text">
                                <div class="notification-msg"><?php _e( 'You have no activity.', 'homeradar-add-ons' ); ?></div>
                            </div>
                        </div>
                    </div>
                    <!-- dashboard-list end-->  
                    <?php endif; ?> 

                    
                </div>
                <!-- dashboard-list-box end-->
                
            </div>
            <div class="col-md-4">
                <?php 
                $post_args = array(
                    'post_type'     => 'lmessage', 
                    'orderby'       => 'date',
                    'order'         => 'DESC',
                    'post_status'   => 'publish',
                    'posts_per_page' => 5, // no limit
                    
                    'meta_query' => array(
                        // show listing author bookings
                        // 'relation' => 'OR',
                        array(
                            'key'       => ESB_META_PREFIX.'to_user_id',
                            'value'     => $current_user->ID,
                            // 'compare' => 'IN',
                            'type'      => 'NUMERIC'
                        ),
                        // show user bookings
                        // array(
                        //     'relation' => 'AND',
                        //     array(
                        //         'key'     => ESB_META_PREFIX.'lmsg_email',
                        //         'value'   => $current_user->user_email,
                        //     ),
                        //     array(
                        //         'key'     => ESB_META_PREFIX.'lmsg_status',
                        //         'value'   => 'canceled',
                        //         'compare' => '!='
                        //     )  
                        // ),
                        
                    ),
                    
                );
                // The Query
                $posts_query = new WP_Query( $post_args );
                if($posts_query->have_posts()) :
                ?>
                <!--box-widget-->
                <div class="dasboard-widget fl-wrap">
                    <div class="dasboard-widget-title fl-wrap">
                        <h5><i class="fas fa-comment-alt"></i><?php _e( 'Last Messages', 'homeradar-add-ons' ); ?></h5>
                    </div>
                    <div class="chat-contacts fl-wrap">
                        <?php 
                        while($posts_query->have_posts()) : $posts_query->the_post();  
                            $lmsg_email = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_email', true );
                            // $lmsg_phone = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_phone', true );
                            $lmsg_name = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_name', true );

                            // $from_user = get_post_meta( get_the_ID(), ESB_META_PREFIX.'from_user_id', true );
                            // $first_msg_meta = get_post_meta( get_the_ID(), ESB_META_PREFIX.'first_msg', true );
                            // $lmsg_status = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_status', true );
                            // $listing_id             = get_post_meta( get_the_ID(), ESB_META_PREFIX.'listing_id', true );
                        ?>
                        <!-- chat-contacts-item-->
                        <a class="chat-contacts-item" href="javascript:void(0);">
                            <div class="dashboard-message-avatar">
                                <?php echo get_avatar($lmsg_email,'80','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', $lmsg_name ); ?>
                                <!-- <div class="message-counter">2</div> -->
                            </div>
                            <div class="chat-contacts-item-text">
                                <h4><?php echo esc_html( $lmsg_name ); ?></h4>
                                <span><?php the_time(get_option('date_format'));?></span>
                                <div class="msg-message"><?php echo wp_kses_post( get_post_meta( get_the_ID(), ESB_META_PREFIX.'lmsg_message', true ) ); ?></div>
                            </div>
                        </a>
                        <!-- chat-contacts-item -->
                        <?php 
                        endwhile; ?> 
                    </div>
                </div>
                <!--box-widget end -->  
                <?php endif; 
                wp_reset_postdata();?>                            
                   
                <?php 
                if(is_active_sidebar('main-db-sidebar')){
                    dynamic_sidebar('main-db-sidebar');
                } ?>                           
            </div>
        </div>


    </div>
</div>
