<?php
/* add_ons_php */
global $post;

$listing_bookmarks = get_user_meta( get_current_user_id(), ESB_META_PREFIX.'listing_bookmarks', true );

homeradar_addons_reset_user_notification_type('bookmarked');
?>
<div class="dashboard-content-wrapper dashboard-content-bookmarks">
    <div class="dashboard-content-inner">
        
        
        <div class="dashboard-listings-grid cthiso-isotope-wrapper dashboard-items-grid">
            <div class="cthiso-flex cthiso-big-pad cthiso-two-cols mb-20">
        <?php 
        if(!empty($listing_bookmarks) && is_array($listing_bookmarks)){
            foreach ($listing_bookmarks as $lid) {
                if( !get_post($lid) ) continue;
                $post = get_post($lid);
                setup_postdata( $post );
                $address = get_post_meta( get_the_ID(), ESB_META_PREFIX.'address', true );
                $latitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'latitude', true );
                $longitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'longitude', true );
                $direction = 'javascript:void(0);';
                if( !empty($latitude) && !empty($longitude) ) $direction = "https://www.google.com/maps/search/?api=1&query=$latitude,$longitude";
                ?>
                <div class="cthiso-item">
                    <div class="dashboard-listings-item dis-flex">
                        <?php
                        if(has_post_thumbnail( )){ ?>
                        <div class="dashboard-listings-item_img">
                            <div class="bg-wrap">
                                <div class="bg" data-bg="<?php echo get_the_post_thumbnail_url(null, 'listing-featured'); ?>"></div>
                            </div>
                            <div class="overlay"></div>
                            <a href="<?php the_permalink( ); ?>" class="color-bg"><?php _ex( 'View', 'Dashboard listings', 'homeradar-add-ons' ); ?></a>
                        </div>
                        <?php } ?>
                        <div class="dashboard-listings-item_content">
                            <h4><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h4>
                            <?php 
                            if( !empty($address) ): ?>
                            <div class="geodir-category-location">
                                <a href="<?php echo $direction; ?>"><i class="fas fa-map-marker-alt"></i> <span><?php echo $address; ?></span></a>
                            </div>
                            <?php 
                            endif; ?>
                            <div class="clearfix"></div>
                            <?php 
                            
                            $rating = homeradar_addons_get_average_ratings(get_the_ID());    ?>
                            <?php if( $rating != false ): ?>
                                <div class="listing-rating card-popup-rainingvis tolt" data-stars="<?php echo (int)homeradar_addons_get_option('rating_base');?>" data-rating="<?php echo $rating['sum']; ?>" data-microtip-position="right" data-tooltip="<?php echo homeradar_addons_rating_text($rating['sum']); ?>"></div>
                            <?php 
                            endif; ?>  
                            <?php 
                            $cats = get_the_terms(get_the_ID(), 'listing_cat');
                            if ( $cats && ! is_wp_error( $cats ) ){ ?>
                                <div class="widget-posts-descr-link mt-10">
                                    <?php 
                                    foreach( $cats as $key => $cat){
                                        
                                        echo sprintf( '<a href="%1$s" class="widget-post-cat">%2$s</a> ',
                                            homeradar_addons_get_term_link( $cat->term_id, 'listing_cat' ),
                                            esc_html( $cat->name )
                                        );
                                    }
                                    ?>
                                </div>
                            <?php }  ?>
                            <div class="dashboard-listings-item_opt dis-flex jtf-space-between">
                                <span class="viewed-counter"><i class="fas fa-eye"></i><?php echo sprintf(_x( ' Viewed - %s', 'Dashboard listings', 'homeradar-add-ons' ), Esb_Class_LStats::get_stats(get_the_ID()) ); ?></span>
                                <ul class="no-list-style dis-flex">
                                    
                                    <li><a href="#" class="tolt delete-bookmark-btn"  data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>" data-microtip-position="top-left"  data-tooltip="<?php echo esc_attr_x( 'Delete', 'Dashboard listings', 'homeradar-add-ons' ); ?>"><i class="far fa-trash-alt"></i></a></li>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                </div>
                <!-- dashboard-list end--> 
                <?php
                wp_reset_postdata();
            }
        }else{
            ?>
            <div class="col-md-12">
                <div id="listing-no" class="dashboard-card-none dashboard-listing-item">
                    <div class="dashboard-card-content">
                        <?php _e( '<p>You have no bookmark.</p>', 'homeradar-add-ons' ); ?>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>
        </div><!-- end row -->
        </div>
    </div>
</div>

    