<?php
/* add_ons_php */
$current_user = wp_get_current_user(); 
update_user_meta( $current_user->ID, ESB_META_PREFIX . 'bookings_count', 0 );
if(is_front_page()) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
} 
$bk_show_status = (array)homeradar_addons_get_option('bk_show_status');
$bk_show_status = array_filter($bk_show_status);
$bktype_query = array(
                    'key'     => ESB_META_PREFIX.'bk_form_type',
                    'value'   => 'inquiry',
                    'compare'   => '!=',
                );
$meta_queries = array();
// author bookings
if( Esb_Class_Membership::is_author() && !isset($_GET['mybks'])  ){
    // author listings
    $au_listings = get_posts( array(
        'fields'                => 'ids',
        'post_type'             =>  'listing', 
        'author'                =>  $current_user->ID, 
        'orderby'               =>  'date',
        'order'                 =>  'DESC',
        'post_status'           => 'publish',
        'posts_per_page'        => -1, // no limit 
    ) );
    $au_listing_ids = array();
    foreach ( $au_listings as $post_ID ) {
       $au_listing_ids[] = $post_ID;
    } 
    if(!empty($au_listing_ids))  {
        $meta_queries = array(
            'relation' => 'AND',
            array(
                'key'       => ESB_META_PREFIX.'listing_id',
                'value'     => $au_listing_ids,
                'compare'   => 'IN',
                'type'      => 'NUMERIC',
            )

        ); 
        if( homeradar_addons_get_option('separate_inquiries') == 'yes' ){
            $meta_queries[] = $bktype_query;
        }
        if( !empty($bk_show_status) ){
            $meta_queries[] = array(
                        'key'     => ESB_META_PREFIX.'lb_status',
                        'value'   => $bk_show_status,
                        'compare' => 'IN'
                    );
        }
    }
        
}else{
    $meta_queries = array(
        'relation' => 'AND',
        array(
            'relation' => 'OR',
            array(
                'key'     => ESB_META_PREFIX.'lb_email',
                'value'   => $current_user->user_email,
            ),
            array(
                'key'     => ESB_META_PREFIX.'user_id',
                'value'   => $current_user->ID,
            ),
        ),

    ); 
    if( homeradar_addons_get_option('separate_inquiries') == 'yes' ){
        $meta_queries[] = $bktype_query;
    }
    if( !empty($bk_show_status) ){
        $meta_queries[] = array(
                    'key'     => ESB_META_PREFIX.'lb_status',
                    'value'   => $bk_show_status,
                    'compare' => 'IN'
                );
    }
}

$args = array(
    'post_type'     =>  'lbooking', 
    // 'author'        =>  0, 
    'orderby'       =>  'date',
    'order'         =>  'DESC',
    'paged'         => $paged,
    'post_status'   => 'publish',
    // 'posts_per_page' => -1, // no limit
    // 'posts_per_page' => 1,
    // 'meta_query' => $meta_queries
    
);
if( !empty($meta_queries) ) $args['meta_query'] = $meta_queries;
// The Query
$posts_query = new WP_Query( $args );
?>
<div class="dashboard-content-wrapper dashboard-content-bookings">
    <div class="dashboard-content-inner">
        
       

        <?php 
        if( Esb_Class_Membership::is_author() ){
            if( !isset($_GET['mybks']) ){
                $url = add_query_arg('mybks', '', Esb_Class_Dashboard::screen_url('bookings') );  
                $btntext = esc_html_x( 'My Bookings', 'Front-end dashboard', 'homeradar-add-ons' );
            }else{
                $url = Esb_Class_Dashboard::screen_url('bookings');  
                $btntext = esc_html_x( 'Listing Bookings', 'Front-end dashboard', 'homeradar-add-ons' );
            }
                
            ?>
            <div class="bkreports-btn-wrap mb-20">
                <a href="<?php echo esc_url( $url ); ?>" class="bkmybks-btn btn btn-noicon color2-bg"><?php echo $btntext; ?></a>
            </div>
            <?php
        }
        ?>
        
        <div class="dashboard-bookings-grid">

            <div class="dasboard-widget-title fl-wrap dis-flex jtf-space-between">
                <h5><i class="fal fa-comments-alt"></i><?php _e( 'Last Bookings', 'homeradar-add-ons' ); ?> <!-- <span> ( +3 New ) </span> --></h5>
                <!-- <a href="#" class="mark-all-read  tolt" data-microtip-position="bottom" data-tooltip="<?php echo esc_attr( 'Mark all as read','dfsdfds'); ?>"><i class="far fa-comment-alt-check"></i> </a> -->
            </div>
            <div class="dasboard-widget-box fl-wrap">
                <!-- <div class="dasboard-opt fl-wrap">
                    
                    <div class="price-opt">
                        <span class="price-opt-title">Sort   by:</span>
                        <div class="listsearch-input-item">
                            <select data-placeholder="Lastes" class="chosen-select no-search-select" >
                                <option>Lastes</option>
                                <option>Oldes</option>
                            </select>
                        </div>
                    </div>
                    
                </div>
                <div class="clearfix"></div> -->
            

            <div class="bookings-grid-inner cthiso-isotope-wrapper dashboard-items-grid">
            <?php 
            if( !empty($meta_queries) && $posts_query->have_posts() ) :?>
            
                <div class="cthiso-flex cthiso-big-pad cthiso-two-cols mb-20">
                <?php
                while($posts_query->have_posts()) : $posts_query->the_post(); 
                    $listing_id = get_post_meta( get_the_ID(), ESB_META_PREFIX.'listing_id', true );
                    $listing_author_id = get_post_field('post_author', $listing_id);
                    // $booking = get_post( get_post_meta( get_the_ID(), ESB_META_PREFIX.'booking_id', true ) );
                    // $lb_email = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lb_email', true );
                    // $lb_phone = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lb_phone', true );

                    $lb_name = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lb_name', true );
                    $lb_email = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lb_email', true );
                    $lb_phone = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lb_phone', true );
                    $lb_user = 0;

                    $user_obj   = get_userdata( get_post_meta( get_the_ID(), ESB_META_PREFIX . 'user_id', true) );
                    if( $user_obj ){
                        $lb_user = $user_obj->ID;
                        if( empty($lb_name) ) $lb_name = $user_obj->display_name;
                        
                        if( empty($lb_email) ) $lb_email = $user_obj->user_email;
                        if( empty($lb_phone) ) $lb_phone = get_user_meta( $user_obj->ID, ESB_META_PREFIX.'phone', true);
                    }
                    $nights   = get_post_meta( get_the_ID(), ESB_META_PREFIX.'nights', true );
                    
                    //$person = (int)$lb_adults + (int)$lb_children;
                    $payment_method = get_post_meta( get_the_ID(), ESB_META_PREFIX.'payment_method', true );
                    $lb_quantity = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lb_quantity', true );
                    $qty = get_post_meta( get_the_ID(), ESB_META_PREFIX.'qty', true );
                    $date_event = get_post_meta( get_the_ID(), ESB_META_PREFIX.'date_event', true );
                    
                    // $listing_id =  get_post_meta( get_the_ID(), ESB_META_PREFIX.'listing_id', true );
                    $services = get_post_meta($listing_id, ESB_META_PREFIX.'lservices', true);
                    $value_serv = array();
                    if( is_array($services) && !empty($services) ) {
                        $value_key_ser  = array();
                        $addservices = get_post_meta( get_the_ID(), ESB_META_PREFIX.'addservices', true );
                        if(  is_array($addservices) && !empty($addservices) ){
                            foreach ($addservices  as $key => $item_serv) {
                                // var_dump($item_serv);
                                $value_key_ser[]  = array_search($item_serv,array_column($services,  'service_id'));
                            }
                            foreach ($value_key_ser as $key => $value) {
                                 $value_serv[] = $services[$value];
                            }
                        } 
                    };
                    $bkcoupon = get_post_meta( get_the_ID(), ESB_META_PREFIX.'bkcoupon', true ); 

                    $lb_status = get_post_meta( get_the_ID(), ESB_META_PREFIX.'lb_status', true );

                    $price = get_post_meta( get_the_ID(), ESB_META_PREFIX.'price', true );
                    $children_price = get_post_meta( get_the_ID(), ESB_META_PREFIX.'children_price', true );
                    $infant_price = get_post_meta( get_the_ID(), ESB_META_PREFIX.'infant_price', true );

                    $billingDetails = Esb_Class_User::billingDetails($lb_user);

                    // listing phones
                    $lphone = get_post_meta( $listing_id, ESB_META_PREFIX.'phone', true );
                    $lwhatsapp = get_post_meta( $listing_id, ESB_META_PREFIX.'whatsapp', true );
                    


                ?>
                <div class="cthiso-item">
                    <div id="booking-<?php the_ID(); ?>" <?php post_class('dashboard-booking-item bookings-item'); ?>>

                        <div class="bookings-item-header fl-wrap">
                            <?php echo get_the_post_thumbnail( $listing_id, 'post-thumbnail'); ?>
                            <h4><?php echo sprintf(_x( 'For %s', 'Booking for', 'homeradar-add-ons' ), '<a href="'.esc_url( get_permalink( $listing_id ) ).'" target="_blank">'.get_the_title( $listing_id ).'</a>'); ?></h4>
                            
                            <?php if( $lb_status == 'pending'){ ?>
                                <span class="booking-list-new green-bg new-bookmark"><?php _e( 'New', 'homeradar-add-ons' ); ?></span>
                            <?php }elseif( $lb_status == 'completed'){ ?>
                                <span class="booking-list-new green-bg new-bookmark"><?php _e( 'Approved', 'homeradar-add-ons' ); ?></span>
                            <?php }elseif( $lb_status == 'canceled'){ ?>
                                <span class="booking-list-new cancel-bg new-bookmark"><?php _e( 'Canceled', 'homeradar-add-ons' ); ?></span>
                            <?php }elseif( $lb_status == 'refunded'){ ?>
                                <span class="booking-list-new cancel-bg new-bookmark"><?php _e( 'Refunded', 'homeradar-add-ons' ); ?></span>
                            <?php } ?>
                        </div>
                        <div class="bookings-item-content fl-wrap">
                            <ul class="no-list-style">
                                <?php if ( !empty($lb_name) ): ?>
                                <li class="bkdt-item bk-cname"><span class="bkdt-title"><?php esc_html_e( 'Name: ', 'homeradar-add-ons' ); ?></span><span><?php echo esc_html($lb_name); ?></span></li>
                                <?php endif ?>
                                <?php if ( !empty($lb_phone) ): ?>
                                <li class="bkdt-item bk-cphone"><span class="bkdt-title"><?php esc_html_e( 'Phone: ', 'homeradar-add-ons' ); ?></span><span><a href="tel:<?php echo esc_attr($lb_phone); ?>"><?php echo esc_html($lb_phone); ?></a></span></li>
                                <?php endif ?>
                                <?php if ( !empty($lb_email) ): ?>
                                <li class="bkdt-item bk-cphone"><span class="bkdt-title"><?php esc_html_e( 'Email: ', 'homeradar-add-ons' ); ?></span><span><a href="mailto:<?php echo esc_attr($lb_email); ?>"><?php echo esc_html($lb_email); ?></a></span></li>
                                <?php endif ?>
                               
                            </ul>
                            <?php echo wp_kses_post( get_post_meta( get_the_ID(), ESB_META_PREFIX.'lb_add_info', true ) ); ?>
                            
                            
                            <!-- <div class="booking-list-contr"><?php if( $current_user->ID == $listing_author_id && $lb_status != 'refunded' ): ?>
                            <?php 
                            if( $lb_status == 'completed' ): ?>
                            <a href="javascript:void(0);" class="green-bg tolt" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Approved', 'homeradar-add-ons' ); ?>"><i class="fal fa-check"></i></a>
                            <?php elseif( $lb_status != 'canceled' ): ?>
                            <a href="#" class="green-bg tolt approve-booking" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Approve', 'homeradar-add-ons' ); ?>" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><i class="fal fa-check"></i></a>
                            <?php endif; ?>
                            <?php if( $lb_status != 'canceled' && ( $lb_status != 'completed' || 'yes' == homeradar_addons_get_option('booking_approved_cancel') ) ): ?>
                            <a href="#" class="cancel-bg tolt cancel-booking" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Cancel', 'homeradar-add-ons' ); ?>" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><i class="fal fa-ban"></i></a>
                            <?php endif; ?>
                            <?php if( homeradar_addons_get_option('booking_author_delete') == 'yes' ): ?>
                                <a href="#" class="del-bg tolt del-booking" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Delete', 'homeradar-add-ons' ); ?>" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><i class="far fa-trash"></i></a>
                            <?php endif; ?><?php elseif( $lb_status != 'canceled' && $lb_status != 'refunded' && ( $lb_status != 'completed' || 'yes' == homeradar_addons_get_option('booking_approved_cancel_customer') ) ): // for booked user ?><a href="#" class="cancel-bg tolt cancel-booking" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Cancel', 'homeradar-add-ons' ); ?>" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><i class="fal fa-ban"></i></a><?php endif; ?></div>
 -->
                        
                        </div>
                        
                        <div class="bookings-item-footer fl-wrap flex-items-center jtf-space-between">
                            <?php 
                            $singleUrl = add_query_arg('bkid', get_the_ID(), Esb_Class_Dashboard::screen_url('bookings') );   ?>
                            <a href="<?php echo esc_url( $singleUrl ); ?>" class="btn-link"><?php esc_html_e( 'View Details', 'homeradar-add-ons' ); ?></a>
                            <!-- <span class="message-date"><?php the_time(get_option('date_format'));?></span> -->
                            <ul class="no-list-style dis-flex">
                                <!-- <?php if ( !empty($lb_email) ): ?><li><a href="mailto:<?php echo esc_attr($lb_email); ?>" class="tolt" data-microtip-position="top-left"  data-tooltip="<?php esc_attr_e( 'Write', 'homeradar-add-ons' ); ?>"><i class="far fa-envelope"></i></a></li><?php endif ?>
                                <?php if ( !empty($lb_phone) ): ?><li><a href="tel:<?php echo esc_attr($lb_phone); ?>" class="tolt" data-microtip-position="top-left"  data-tooltip="<?php esc_attr_e( 'Call', 'homeradar-add-ons' ); ?>"><i class="far fa-phone"></i></a></li><?php endif ?>
                                 -->
                                <?php if( $lb_status != 'canceled' && $lb_status != 'completed' && $lb_status != 'refunded' ): ?>
                                    <li><a href="#" class="tolt approve-booking" data-microtip-position="top-left"  data-tooltip="<?php esc_attr_e( 'Approve', 'homeradar-add-ons' ); ?>" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><i class="far fa-check"></i></a></li>
                                <?php endif ?>

                                <?php if( Esb_Class_Membership::is_author() && homeradar_addons_get_option('booking_author_delete') == 'yes' ): ?>
                                    <li><a href="#" class="tolt del-booking" data-microtip-position="top-left"  data-tooltip="<?php esc_attr_e( 'Delete', 'homeradar-add-ons' ); ?>" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><i class="far fa-trash"></i></a></li>
                                <?php endif ?>
                                <?php if( $lb_status != 'canceled' && $lb_status != 'refunded' && ( $lb_status != 'completed' || 'yes' == homeradar_addons_get_option('booking_approved_cancel_customer') ) ): ?>
                                    <li><a href="#" class="tolt cancel-booking" data-microtip-position="top-left"  data-tooltip="<?php esc_attr_e( 'Cancel', 'homeradar-add-ons' ); ?>" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><i class="far fa-ban"></i></a></li>
                                <?php endif ?>
                                
                                <!-- <li><a href="#" class="tolt" data-microtip-position="top-left"  data-tooltip="<?php esc_attr_e( 'Delete', 'homeradar-add-ons' ); ?>"><i class="far fa-trash"></i></a></li> -->
                            </ul>
                        </div>


                        
                        
                            
                    </div>
                    <!-- dashboard-list end--> 
                </div><!-- cthiso-item -->
            <?php 
                endwhile; ?>
                </div><!-- cthiso-flex -->
            
            <?php
                echo homeradar_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
            
                /* Restore original Post Data 
                 * NB: Because we are using new WP_Query we aren't stomping on the 
                 * original $wp_query and it does not need to be reset with 
                 * wp_reset_query(). We just need to set the post data back up with
                 * wp_reset_postdata().
                 */
                wp_reset_postdata();
            else:
            ?> 
            <div id="booking-no" class="dashboard-card-none dashboard-booking-item">
                <div class="dashboard-card-content">
                    <?php _e( '<p>You have no booking yet!</p>', 'homeradar-add-ons' ); ?>
                </div>
            </div>
            <?php
            endif; ?> 
                </div><!-- bookings-grid-inner -->
            </div><!-- dasboard-widget-box -->

        </div>
    </div>
</div>

