<?php
/* add_ons_php */
// don't show on customer dashboard
$current_user = wp_get_current_user();    

if(is_front_page()) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
} 


$post_args = array(
    'post_type'         => 'lagent',
    'paged'             => $paged,
    // 'posts_per_page'=> $settings['posts_per_page'],
    // 'orderby'=> $settings['order_by'],
    // 'order'=> $settings['order'],

    'post_status'       => 'publish',
    'author'            => $current_user->ID,
);
// The Query
$posts_query = new WP_Query( $post_args );

?>
<div class="dashboard-content-wrapper dashboard-content-listings">
    <div class="dashboard-content-inner">
        
        <div class="dasboard-opt sl-opt fl-wrap dis-flex jtf-space-between">
            <!-- <div class="dashboard-search-listing">
                <input type="text" onclick="this.select()" placeholder="Search" value="">
                <button type="submit"><i class="far fa-search"></i></button>
            </div> -->
            <?php // found_posts ?>
            <?php if( Esb_Class_Membership::is_author() && Esb_Class_Membership::agents_limit() &&  Esb_Class_Membership::agents_limit() > $posts_query->found_posts ): ?>
            <div class="add-agent-wrap pos-relative popup-form-wrap ml-auto">
                <a href="#" class="gradient-bg dashboard-addnew_btn show-popup-form"><?php _e( 'Add New', 'homeradar-add-ons' ); ?><i class="fal fa-plus"></i></a>   
                <div class="popup-form">
                    <form method="post" enctype="multipart/form-data" class="cthajax-form" data-action="agent_add">
                        <div class="mtbox-fields-wrap dis-flex flx-wrap row">
                            <div class="mtbox-field submit-field-12 hasIcon">
                                <label for="agent-title" class="lbl-block"><?php _e( 'Title', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-user"></i></span></label>
                                <input type="text" class="input-text full-w" name="title" id="agent-title" value="" required="required">
                            </div>
                            <div class="mtbox-field submit-field-12 hasIcon">
                                <label for="agent-email" class="lbl-block"><?php _e( 'Email Address', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="far fa-envelope"></i></span></label>
                                <input type="email" class="input-text full-w" name="email" id="agent-email" value="" required="required">
                            </div>
                            <div class="mtbox-field submit-field-12 hasIcon">
                                <label for="agent-url" class="lbl-block"><?php _e( 'Agent Link', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fal fa-link"></i></span></label>
                                <input type="text" class="input-text full-w" name="website" id="agent-url" value="" required="required">
                            </div>
                        </div>
                        <div class="cthajax-error mb-20"></div>
                        <button class="btn float-btn color-bg fw-btn cthajax-submit" type="submit"><?php  esc_html_e( 'Submit', 'homeradar-add-ons' ); ?></button>
                    </form>
                    
                </div>
            </div>
                
            <?php endif; ?>
            
            <!-- price-opt-->
            <!-- <div class="price-opt">
                <span class="price-opt-title">Sort   by:</span>
                <div class="listsearch-input-item">
                    <select data-placeholder="Lastes" class="chosen-select no-search-select" >
                        <option>Lastes</option>
                        <option>Oldes</option>
                        <option>Average rating</option>
                        <option>Name: A-Z</option>
                        <option>Name: Z-A</option>
                    </select>
                </div>
            </div> -->
            <!-- price-opt end-->
        </div>
        <div class="clearfix"></div>
        
        <div class="dashboard-agents-grid cthiso-isotope-wrapper dashboard-items-grid">
            
            <?php 
            if($posts_query->have_posts()) : ?>
            <div class="cthiso-flex cthiso-big-pad cthiso-three-cols mb-20">
            <?php
                while($posts_query->have_posts()) : $posts_query->the_post(); 
                    
                ?>
                <div class="cthiso-item cthajax-item-wrap">
                    <?php homeradar_addons_get_template_part( 'template-parts/dashboard/agent', false ); ?>
                </div>
                <!-- dashboard-list end--> 
            <?php 
                endwhile; 
                ?>
            </div>
            <?php
                echo homeradar_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
            
                /* Restore original Post Data 
                 * NB: Because we are using new WP_Query we aren't stomping on the 
                 * original $wp_query and it does not need to be reset with 
                 * wp_reset_query(). We just need to set the post data back up with
                 * wp_reset_postdata().
                 */
                wp_reset_postdata();
            else:
            ?> 
            <div id="agents-no" class="dashboard-card-none dashboard-agent-item">
                <div class="dashboard-card-content">
                    <?php _e( '<p>You have no agent yet!</p>', 'homeradar-add-ons' ); ?>
                </div>
            </div>
            <?php
            endif; ?> 
        
        </div>
    </div>
</div>
