<?php
/* add_ons_php */
$url = add_query_arg('agent', get_the_ID(), Esb_Class_Dashboard::screen_url('agents') );  
?>
<article class="geodir-category-listing fl-wrap">
    <div class="geodir-category-img fl-wrap  agent_card">
        <?php if(has_post_thumbnail()): ?>
            <a href="<?php the_permalink( ); ?>" class="geodir-category-img_item"><?php the_post_thumbnail( 'full' ); ?></a>
        <?php endif; ?>
        <?php 
        $rating = get_post_meta( get_the_ID(), ESB_META_PREFIX.'rating_average', true ); 
        if( !empty($rating) ) :
            $rating_base = (int)homeradar_addons_get_option('rating_base'); 
            if(empty($rating_base)) $rating_base = 5;
        ?>
        <div class="listing-rating card-popup-rainingvis" data-rating="<?php echo $rating; ?>" data-stars="<?php echo $rating_base; ?>"><span class="re_stars-title review-text"><?php echo homeradar_addons_rating_text($rating); ?></span></div>
        <?php 
        endif; ?>
    </div>
    <div class="geodir-category-content fl-wrap">
        <?php 
        if( get_post_meta( get_the_ID(), ESB_META_PREFIX.'verified', true ) == 'yes' ): ?>
            <div class="card-verified tolt" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-user-check"></i></div>
        <?php else:  ?>
            <div class="card-verified cv_not tolt" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Not Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-minus-octagon"></i></div>
        <?php endif; ?>
        <div class="agent_card-title fl-wrap">
            <h4 class="agent-title"><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h4>
            <?php 
            $agency = get_post_meta( get_the_ID(), ESB_META_PREFIX.'agency', true ); 
            ?>
            <?php if( !empty($agency) ): ?><h5 class="agent-agency"><a href="<?php echo get_the_permalink( $agency ); ?>"><?php echo get_the_title( $agency ); ?></a></h5><?php endif; ?>

        </div>
        <div class="agent-card-facts fl-wrap">
            <ul class="no-list-style dis-flex">
                <li><?php esc_html_e( 'Viewed', 'homeradar-add-ons' ); ?><span class="viewed-counter"><?php echo homeradar_addons_get_post_views(get_the_ID()); ?></span></li>
                <?php $comments = get_comments_number(); ?>
                <li><?php esc_html_e( 'Reviews', 'homeradar-add-ons' ); ?><span class="bookmark-counter"><?php echo $comments; ?></span></li>
                <?php 
                $post_args = array(
                    'post_type'         => 'listing',
                    'posts_per_page'    => -1,
                    'post_status'       => 'publish',
                    'meta_query' => array(
                        array(
                            'key'     => ESB_META_PREFIX.'lagent',
                            'value'   => get_the_ID(),
                        ),
                    ),
                );
                $lpostsCount = count(get_posts( $post_args ));
                ?>
                <li><?php esc_html_e( 'Listings', 'homeradar-add-ons' ); ?><span class="bookmark-counter"><?php echo $lpostsCount; ?></span></li>
            </ul>
        </div>
        <div class="geodir-category-footer fl-wrap">
            <a href="<?php echo esc_url( $url ); ?>" class="btn float-btn color-bg small-btn"><?php _e( 'Edit', 'homeradar-add-ons' ); ?></a>
            <a href="#" class="tolt ftr-btn cthajax-inline" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Delete', 'homeradar-add-ons' ); ?>" 
                data-action="agent_delete" data-id="<?php echo get_the_ID();?>" 
                data-confirm="<?php echo esc_attr( sprintf( __( "Are you sure want to delete %s agent and its data?\nThe agent is permanently deleted.", 'homeradar-add-ons' ), get_the_title() ) ); ?>"
                ><i class="fal fa-trash"></i></a>
        </div>
    </div>
</article>
