<?php
/* add_ons_php */
// don't show on customer dashboard
$current_user = wp_get_current_user();    
if(!isset($agent)) $agent = 0;
$generalFields = Esb_Class_Agent_CPT::general_fields();
?>
<div class="dashboard-content-wrapper dashboard-content-listings">
    <div class="dashboard-content-inner">
        
        <div class="dashboard-agent-edit">
            
            <form method="post" enctype="multipart/form-data" class="cthajax-form" data-action="agent_submit">

                <div class="dasboard-widget-title fl-wrap mt-30">
                    <h5><i class="fas fa-info"></i><?php _e( 'Basic Informations', 'homeradar-add-ons' ); ?></h5>
                </div>
                <div class="dasboard-widget-box">
                    <div class="mtbox-fields-wrap dis-flex flx-wrap row">
                        <div class="mtbox-field submit-field-4 hasIcon">
                            <label for="agent-title" class="lbl-block"><?php _e( 'Title', 'homeradar-add-ons' ); ?><span class="dec-icon"><i class="fas fa-user"></i></span></label>
                            <input type="text" class="input-text full-w" name="title" id="agent-title" value="<?php echo get_the_title( $agent );?>" required="required">
                        </div>
                    </div>
                    <div class="mtbox-fields-wrap dis-flex flx-wrap row">
                        <div class="mtbox-field submit-field-6">
                            <label class="lbl-block"><?php _e( 'Avatar', 'homeradar-add-ons' ); ?></label>
                            <?php
                            $thumbnail = get_post_thumbnail_id($agent);
                            ?>
                            <div class="edit-profile-photo fl-wrap upload-photo-js-wrap">
                                <div class="profile-photo-wrap"><?php
                                if ($thumbnail != '') {
                                    echo wp_get_attachment_image($thumbnail);
                                }
                                ?></div>
                                <div class="change-photo-btn">
                                    <div class="photoUpload">
                                        <span><i class="fal fa-image"></i><?php _e('Upload Photo', 'homeradar-add-ons');?></span>
                                        <?php
                                        if (current_user_can('upload_files')) {

                                            homeradar_addons_get_template_part('template-parts/images-select', false, array('is_single' => true, 'name' => 'thumbnail', 'datas' => array($thumbnail)));
                                        } else {?>
                                            <input type="file" class="upload cth-avatar-upload" name="thumbnail_upload">
                                        <?php
                                        }?>
                                    </div>
                                </div>
                                <a href="#" class="del-user-photo" data-name="thumbnail"><i class="fal fa-times"></i></a>
                            </div>
                        </div>
                        <div class="mtbox-field submit-field-6">
                            <label class="lbl-block"><?php _e( 'Cover Image', 'homeradar-add-ons' ); ?></label>
                            <?php
                            $coverImage = get_post_meta($agent, ESB_META_PREFIX . 'coverImage', true);
                            $img_id = '';
                            if( !empty($coverImage['id']) ) $img_id = $coverImage['id'];
                            ?>
                            <div class="edit-profile-photo fl-wrap upload-photo-js-wrap">
                                <div class="profile-photo-wrap"><?php
                                if ($img_id != '') {
                                    echo wp_get_attachment_image($img_id);
                                } ?></div>
                                <div class="change-photo-btn">
                                    <div class="photoUpload">
                                        <span><i class="fal fa-image"></i><?php _e('Upload Photo', 'homeradar-add-ons');?></span>
                                        <?php
                                        if (current_user_can('upload_files')) {

                                            homeradar_addons_get_template_part('template-parts/images-select', false, array('is_single' => true, 'name' => 'coverImage', 'datas' => array($img_id)));
                                        } else {?>
                                            <input type="file" class="upload cth-avatar-upload" name="coverImage_upload">
                                        <?php
                                        }?>
                                    </div>
                                </div>
                                <a href="#" class="del-user-photo" data-name="coverImage"><i class="fal fa-times"></i></a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="dasboard-widget-title fl-wrap mt-30">
                    <h5><i class="fas fa-list"></i><?php _e( 'Details', 'homeradar-add-ons' ); ?></h5>
                </div>
                <div class="dasboard-widget-box">
                    <div class="mtbox-fields-wrap dis-flex flx-wrap row">
                        <div class="mtbox-field submit-field-12">
                            <label for="description" class="lbl-block"><?php _e( 'Description', 'homeradar-add-ons' ); ?></label>
                            <?php 
                            $editor_args = array(
                                'textarea_rows'     => 10,
                                'textarea_name'     => 'description',
                                'teeny'             => true,
                                'quicktags'         => true
                            );
                            wp_editor( apply_filters('the_content', get_post_field('post_content', $agent) ), 'description', $editor_args );
                            ?>
                        </div>
                        <?php
                        foreach ($generalFields as $field) {
                            $id = uniqid('mtfield');
                            $hasIcon = !empty($field['icon']);
                            ?>
                            <div class="mtbox-field submit-field-6<?php if($hasIcon) echo ' hasIcon'; ?>">
                                <label for="<?php echo $id; ?>" class="lbl-block"><?php echo $field['label']; ?><?php if( $hasIcon): ?><span class="dec-icon"><i class="<?php echo esc_attr($field['icon']); ?>"></i></span><?php endif; ?></label>
                                <input type="text" class="input-text full-w" name="<?php echo $field['name']; ?>" id="<?php echo $id; ?>" value="<?php echo get_post_meta( $agent, ESB_META_PREFIX.$field['name'], true );?>">
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>

                <div class="dasboard-widget-title fl-wrap mt-30">
                    <h5><i class="fas fa-share-alt"></i><?php _e( 'Socials', 'homeradar-add-ons' ); ?></h5>
                </div>
                <div class="dasboard-widget-box">
                    <div class="mtbox-fields-wrap dis-flex flx-wrap row">
                        <?php
                        $socials = homeradar_addons_get_socials_list();
                        foreach ($socials as $val => $lbl) {
                            ?>
                            <div class="mtbox-field submit-field-6 hasIcon">
                                <label for="<?php echo $val; ?>" class="lbl-block"><?php echo sprintf( __( '%s URL', 'homeradar-add-ons' ), $lbl ); ?><span class="dec-icon"><i class="fab fa-<?php echo esc_attr($val); ?>"></i></span></label>
                                <input type="text" class="input-text full-w" name="<?php echo $val; ?>" id="<?php echo $val; ?>" value="<?php echo get_post_meta( $agent, ESB_META_PREFIX.$val, true );?>">
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="cthajax-error mb-20"></div>
                    <div class="flex-items-center mt-10">
                        <button class="btn float-btn color-bg cthajax-submit" type="submit"><?php  esc_html_e( 'Save', 'homeradar-add-ons' ); ?></button>
                        <a href="<?php echo Esb_Class_Dashboard::screen_url('agents'); ?>" class="btn-link ml-20"><?php esc_html_e( 'Cancel', 'homeradar-add-ons' ); ?></a>
                    </div>
                </div>

            
                <input type="hidden" name="post_id" value="<?php echo $agent; ?>">

            </form>

        
        </div>

    </div>
</div>
