<?php
/* add_ons_php */
	
?>
<!--  agent card item -->
<article class="geodir-category-listing fl-wrap">
    <div class="geodir-category-img fl-wrap  agent_card">
        <a href="<?php the_permalink( ); ?>" class="geodir-category-img_item">
            <?php if(has_post_thumbnail()): ?>
                <?php the_post_thumbnail( 'full' ); ?>
            <?php endif; ?>
            <ul class="list-single-opt_header_cat no-list-style">
                <li><span class="cat-opt color-bg">
                    <?php
                    $lcount = count_user_posts( get_the_author_meta('ID') , "listing" , true );
                    echo sprintf(_nx( '%d Listing', '%d Listings', $lcount, 'Agent card', 'homeradar-add-ons' ), $lcount ) ?>
                </span></li>
            </ul>
            

        </a>
        <div class="agent-card-social fl-wrap">
            <ul class="no-list-style">
                <?php 
                $socials = homeradar_addons_get_socials_list();
                foreach ($socials as $val => $lbl) {
                    $url = get_post_meta( get_the_ID(), ESB_META_PREFIX.$val, true );
                    if( !empty($url) ): ?>
                        <li><a href="<?php echo esc_url( $url ); ?>" target="_blank"><i class="fab fa-<?php echo esc_attr($val) ?>"></i></a></li>
                    <?php
                    endif;
                } 
                ?>
            </ul>
        </div>
        <?php 
        $rating = get_post_meta( get_the_ID(), ESB_META_PREFIX.'rating_average', true ); 
        if( !empty($rating) ) :
            $rating_base = (int)homeradar_addons_get_option('rating_base'); 
            if(empty($rating_base)) $rating_base = 5;
        ?>
        <div class="listing-rating card-popup-rainingvis" data-rating="<?php echo $rating; ?>" data-stars="<?php echo $rating_base; ?>"><span class="re_stars-title review-text"><?php echo homeradar_addons_rating_text($rating); ?></span></div>
        <?php 
        endif; ?>
    </div>
    <div class="geodir-category-content fl-wrap">
        <?php 
        if( get_post_meta( get_the_ID(), ESB_META_PREFIX.'verified', true ) == 'yes' ): ?>
            <div class="card-verified tolt" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-user-check"></i></div>
        <?php else:  ?>
            <div class="card-verified cv_not tolt" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Not Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-minus-octagon"></i></div>
        <?php endif; ?>
        <div class="agent_card-title fl-wrap">
            <h4 class="agent-title"><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h4>
            <?php 
            $agency = get_post_meta( get_the_ID(), ESB_META_PREFIX.'agency', true ); 
            $company = get_post_meta( get_the_ID(), ESB_META_PREFIX.'company', true ); 
            $position = get_post_meta( get_the_ID(), ESB_META_PREFIX.'position', true ); 
            ?>
            <?php if( !empty($agency) ): ?><h5 class="agent-agency"><a href="<?php echo get_the_permalink( $agency ); ?>"><?php echo get_the_title( $agency ); ?></a></h5><?php endif; ?>
            <?php if( !empty($company) || !empty($position) ): ?><h5 class="agent-agency agent-job-comp"><a href="javascript:void(0);"><?php echo sprintf( _x( '%1$s at %2$s', 'Agent Job', 'homeradar-add-ons' ), $position, $company ); ?></a></h5><?php endif; ?>
        </div>
        <?php the_excerpt(); ?>
        <div class="geodir-category-footer fl-wrap">
            <a href="<?php the_permalink( ); ?>" class="btn float-btn color-bg small-btn"><?php _e( 'View Profile', 'homeradar-add-ons' ); ?></a>
            <?php 
            $email = get_post_meta( get_the_ID(), ESB_META_PREFIX.'email', true );
            $phone = get_post_meta( get_the_ID(), ESB_META_PREFIX.'phone', true );
            ?>
            <?php if( !empty($email) ): ?><a href="mailto:<?php echo esc_attr( $email ) ;?>" class="tolt ftr-btn" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Write Message', 'homeradar-add-ons' ); ?>"><i class="fal fa-envelope"></i></a><?php endif; ?>
            <?php if( !empty($phone) ): ?><a href="tel:<?php echo esc_attr( $phone );?>" class="tolt ftr-btn" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Call Now', 'homeradar-add-ons' ); ?>"><i class="fal fa-phone"></i></a><?php endif; ?>
        </div>
    </div>
</article>
<!--  agent card item end -->