<?php
/* add_ons_php */
	
?>
<!--  agency card item -->
<article class="geodir-category-listing fl-wrap">
    <div class="geodir-category-img fl-wrap">
        <?php if(has_post_thumbnail()): ?>
            <a href="<?php the_permalink( ); ?>" class="geodir-category-img_item">
            <?php the_post_thumbnail( 'full' ); ?>
            </a>
        <?php endif; ?>
    </div>
    <div class="geodir-category-content fl-wrap">
        <?php 
        if( get_post_meta( get_the_ID(), ESB_META_PREFIX.'verified', true ) == 'yes' ): ?>
            <div class="card-verified tolt" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-user-check"></i></div>
        <?php else:  ?>
            <div class="card-verified cv_not tolt" data-microtip-position="left" data-tooltip="<?php esc_attr_e( 'Not Verified', 'homeradar-add-ons' ); ?>"><i class="fal fa-minus-octagon"></i></div>
        <?php endif; ?>
        <div class="agent_card-title fl-wrap">
            <h4><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h4>
            <?php 
            $address = get_post_meta( get_the_ID(), ESB_META_PREFIX.'address', true );
            $latitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'latitude', true );
            $longitude = get_post_meta( get_the_ID(), ESB_META_PREFIX.'longitude', true );

            $address_url = 'javascript:void(0);';
            if( $longitude != '' && $latitude != '' ) $address_url = 'https://www.google.com/maps/search/?api=1&query='.esc_attr($latitude).','.esc_attr($longitude);
            ?>
            <div class="geodir-category-location fl-wrap flex-items-center">
                <?php if( $address != '' ): ?><a class="agency-address" href="<?php echo $address_url; ?>"><i class="fas fa-map-marker-alt"></i><?php echo esc_html( $address ); ?></a><?php endif; ?>
                <?php 
                $rating = get_post_meta( get_the_ID(), ESB_META_PREFIX.'rating_average', true ); 
                if( !empty($rating) ) :
                    $rating_base = (int)homeradar_addons_get_option('rating_base'); 
                    if(empty($rating_base)) $rating_base = 5;
                ?>
                <div class="listing-rating card-popup-rainingvis" data-rating="<?php echo $rating; ?>" data-stars="<?php echo $rating_base; ?>"><span class="re_stars-title review-text"><?php echo homeradar_addons_rating_text($rating); ?></span></div>
                <?php 
                endif; ?>
            </div>
        </div>
        <?php the_excerpt(); ?>
        <?php $comments = get_comments_number(); ?>
        <div class="small-facts fl-wrap">
            <ul class="no-list-style flex-items-center">
                <li><i class="fal fa-home"></i> <span><?php
                    $lcount = count_user_posts( get_the_author_meta('ID') , "listing" , true );
                    echo sprintf(_nx( '<strong>%d</strong>Listing', '<strong>%d</strong>Listings', $lcount, 'Agent card', 'homeradar-add-ons' ), $lcount ) ?></span></li>
                <li><i class="fal fa-users-class"></i> <span><strong>25</strong>Agents</span></li>
                <li><i class="fal fa-comment-alt"></i> <span><?php echo sprintf(_nx( '<strong>%d</strong> Review', '<strong>%d</strong> Reviews', $comments, 'Comment count', 'homeradar-add-ons' ), $comments ); ?></span></li>
            </ul>
        </div>
        <div class="geodir-category-footer fl-wrap">
            <a href="<?php the_permalink( ); ?>" class="btn float-btn color-bg small-btn"><?php _e( 'View Details', 'homeradar-add-ons' ); ?></a>
            <?php 
            $email = get_post_meta( get_the_ID(), ESB_META_PREFIX.'email', true );
            $phone = get_post_meta( get_the_ID(), ESB_META_PREFIX.'phone', true );
            ?>
            <?php if( !empty($email) ): ?><a href="mailto:<?php echo esc_attr( $email ) ;?>" class="tolt ftr-btn" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Write Message', 'homeradar-add-ons' ); ?>"><i class="fal fa-envelope"></i></a><?php endif; ?>
            <?php if( !empty($phone) ): ?><a href="tel:<?php echo esc_attr( $phone );?>" class="tolt ftr-btn" data-microtip-position="top-left" data-tooltip="<?php esc_attr_e( 'Call Now', 'homeradar-add-ons' ); ?>"><i class="fal fa-phone"></i></a><?php endif; ?>


        </div>
    </div>
</article>

<!--  agency card item end -->
