<?php
/* add_ons_php */

class Esb_Class_CTHTesti_CPT extends Esb_Class_CPT {
    protected $name = 'cth_testimonial';

    public function register(){

        $labels = array( 
            'name' => __( 'Testimonial', 'homeradar-add-ons' ),
            'singular_name' => __( 'Testimonial', 'homeradar-add-ons' ),
            'add_new' => __( 'Add New Testimonial', 'homeradar-add-ons' ),
            'add_new_item' => __( 'Add New Testimonial', 'homeradar-add-ons' ),
            'edit_item' => __( 'Edit Testimonial', 'homeradar-add-ons' ),
            'new_item' => __( 'New Testimonial', 'homeradar-add-ons' ),
            'view_item' => __( 'View Testimonial', 'homeradar-add-ons' ),
            'search_items' => __( 'Search Testimonials', 'homeradar-add-ons' ),
            'not_found' => __( 'No Testimonials found', 'homeradar-add-ons' ),
            'not_found_in_trash' => __( 'No Testimonials found in Trash', 'homeradar-add-ons' ),
            'parent_item_colon' => __( 'Parent Testimonial:', 'homeradar-add-ons' ),
            'menu_name' => __( 'Testimonials', 'homeradar-add-ons' ),
        );

        $args = array( 
            'labels' => $labels,
            'hierarchical' => true,
            'description' => __( 'List Testimonials', 'homeradar-add-ons' ),
            'supports' => array( 'title', 'editor', 'thumbnail'/*,'comments', 'post-formats'*/),
            'public' => false,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_position' => 25,
            'menu_icon' => 'dashicons-format-chat', 
            'show_in_nav_menus' => false,
            'publicly_queryable' => true,
            'exclude_from_search' => true,
            'has_archive' => false,
            'query_var' => true,
            'can_export' => true,
            'rewrite' => true,
            'capability_type' => 'post'
        );
        register_post_type( $this->name, $args );
    }
    protected function set_meta_columns(){
        $this->has_columns = true;
    }
    public function meta_columns_head($columns){
        $columns['_thumbnail'] = __( 'Thumbnail', 'homeradar-add-ons' );
        $columns['_rating'] = __( 'Rating', 'homeradar-add-ons' );
        $columns['_id'] = __( 'ID', 'homeradar-add-ons' );
        return $columns;
    }
    public function meta_columns_content($column_name, $post_ID){
        if ($column_name == '_id') {
            echo $post_ID;
        }
        if ($column_name == '_thumbnail') {
            echo get_the_post_thumbnail( $post_ID, 'thumbnail', array('style'=>'width:100px;height:auto;') );
        }
        if ($column_name == '_rating') {
            $rated = get_post_meta($post_ID, ESB_META_PREFIX.'testim_rate', true );
            if($rated != '' && $rated != 'no'){
                $ratedval = floatval($rated);
                echo '<ul class="star-rating">';
                for ($i=1; $i <= 5; $i++) { 
                    if($i <= $ratedval){
                        echo '<li><i class="testimfa testimfa-star"></i></li>';
                    }else{
                        if($i - 0.5 == $ratedval){
                            echo '<li><i class="testimfa testimfa-star-half"></i></li>';
                        }
                    }
                    
                }
                echo '</ul>';
            }else{
                esc_html_e('Not Rated','homeradar-add-ons' );
            }
        }
    }

}

new Esb_Class_CTHTesti_CPT();
