<?php
/* add_ons_php */

class Esb_Class_Agent_CPT extends Esb_Class_CPT {
    protected $name = 'lagent';

    protected $permalinks = array();
    protected function init(){
        $this->permalinks = get_option( 'cthpermalinks', array() );
        parent::init();

        add_action( 'init', array($this, 'taxonomies'), 0 ); 

        add_filter('single_template', array($this, 'single_template'));

        $logged_in_ajax_actions = array(
            'homeradar_addons_agent_submit',
            'homeradar_addons_agent_add',
            'homeradar_addons_agent_delete',
        );
        foreach ($logged_in_ajax_actions as $action) {
            $funname = str_replace('homeradar_addons_', '', $action);   
            add_action('wp_ajax_'.$action, array( $this, $funname ));
        } 

        do_action( $this->name.'_cpt_init_after' );
    }

    public function single_template($tmpl){
        global $post;

        if ($post->post_type == 'lagent') {
            $tmpl = homeradar_addons_get_template_part('templates/single', 'agent', null, false);
        }
        return $tmpl;
    }

    public function register(){
        $slug = !empty($this->permalinks['cthagent_slug']) ? $this->permalinks['cthagent_slug'] : 'agent';
        $labels = array( 
            'name' => __( 'Agent', 'homeradar-add-ons' ),
            'singular_name' => __( 'Agent', 'homeradar-add-ons' ), 
            'add_new' => __( 'Add New Agent', 'homeradar-add-ons' ),
            'add_new_item' => __( 'Add New Agent', 'homeradar-add-ons' ),
            'edit_item' => __( 'Edit Agent', 'homeradar-add-ons' ),
            'new_item' => __( 'New Agent', 'homeradar-add-ons' ),
            'view_item' => __( 'View Agent', 'homeradar-add-ons' ),
            'search_items' => __( 'Search Agents', 'homeradar-add-ons' ),
            'not_found' => __( 'No Agents found', 'homeradar-add-ons' ),
            'not_found_in_trash' => __( 'No Agents found in Trash', 'homeradar-add-ons' ),
            'parent_item_colon' => __( 'Parent Agent:', 'homeradar-add-ons' ), 
            'menu_name' => __( 'Agents', 'homeradar-add-ons' ),
        );

        $args = array( 
            'labels' => $labels,
            'hierarchical' => false,
            'description' => __( 'Agents', 'homeradar-add-ons' ),
            'supports' => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments', 'author'), // 'title', 'editor',  'author', 'thumbnail','comments','excerpt'
            'taxonomies' => array('agent_cat','agent_city'),
            'public' => true,
            'show_ui' => true,
            'show_in_menu' => true,//default from show_ui
            'menu_position' => 25,
            'menu_icon' => 'dashicons-id',
            'show_in_nav_menus' => true,
            // 'publicly_queryable' => false,
            'exclude_from_search' => true,
            'has_archive' => false,
            'query_var' => true,
            'can_export' => true,
            'rewrite' => array( 'slug' => $slug ),
            'capability_type' => 'post'
        );
        register_post_type( $this->name, $args );
    }
    public function taxonomies(){
        
        $labels = array(
            'name' => __( 'Categories', 'homeradar-add-ons' ),
            'singular_name' => __( 'Category', 'homeradar-add-ons' ),
            'search_items' =>  __( 'Search Categories','homeradar-add-ons' ),
            'all_items' => __( 'All Categories','homeradar-add-ons' ),
            'parent_item' => __( 'Parent Category','homeradar-add-ons' ),
            'parent_item_colon' => __( 'Parent Category:','homeradar-add-ons' ),
            'edit_item' => __( 'Edit Category','homeradar-add-ons' ), 
            'update_item' => __( 'Update Category','homeradar-add-ons' ),
            'add_new_item' => __( 'Add New Category','homeradar-add-ons' ),
            'new_item_name' => __( 'New Category Name','homeradar-add-ons' ),
            'menu_name' => __( 'Categories','homeradar-add-ons' ),
        );     
        // Now register the taxonomy
        register_taxonomy('agent_cat',array('lagent'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            // 'show_in_menu'  => false,
            'show_in_nav_menus'=> false,
            'show_admin_column' => true,
            'show_tagcloud'     => false,
            'query_var' => false,
            'rewrite' => array( 'slug' => __( 'agent_cat', 'homeradar-add-ons' ) ),
            // https://codex.wordpress.org/Roles_and_Capabilities
            // 'capabilities' => array(
            //     'manage_terms' => 'manage_categories',
            //     'edit_terms' => 'manage_categories',
            //     'delete_terms' => 'manage_categories',
            //     'assign_terms' => 'edit_posts'
            // ),

        ));
        $labels = array(
            'name' => __( 'Cities', 'homeradar-add-ons' ),
            'singular_name' => __( 'City', 'homeradar-add-ons' ),
            'search_items' =>  __( 'Search Cities','homeradar-add-ons' ),
            'all_items' => __( 'All Cities','homeradar-add-ons' ),
            'parent_item' => __( 'Parent City','homeradar-add-ons' ),
            'parent_item_colon' => __( 'Parent City:','homeradar-add-ons' ),
            'edit_item' => __( 'Edit City','homeradar-add-ons' ), 
            'update_item' => __( 'Update City','homeradar-add-ons' ),
            'add_new_item' => __( 'Add New City','homeradar-add-ons' ),
            'new_item_name' => __( 'New City Name','homeradar-add-ons' ),
            'menu_name' => __( 'Cities','homeradar-add-ons' ),
        );     
        // Now register the taxonomy
        register_taxonomy('agent_city',array('lagent'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            // 'show_in_menu'  => false,
            'show_in_nav_menus'=> false,
            'show_admin_column' => true,
            'show_tagcloud'     => false,
            'query_var' => false,
            'rewrite' => array( 'slug' => __( 'agent_city', 'homeradar-add-ons' ) ),

        ));
    }
    protected function set_meta_columns(){
        $this->has_columns = true;
    }
    public function meta_columns_head($columns){
        unset($columns['date']);
        
        $columns['_price']          = __('Price','homeradar-add-ons');
        $columns['_address']       = __('Address','homeradar-add-ons');
        $columns['_thumbnail']      = __('Thumbnail','homeradar-add-ons');
        $columns['_id']             = __('ID','homeradar-add-ons');
        return $columns;
    }
    public function meta_columns_content($column_name, $post_ID){
        if ($column_name == '_price') {
            echo '<strong>'.homeradar_addons_get_price_formated( get_post_meta( $post_ID, '_price', true ) ).'</strong>';
        }
        if ($column_name == '_id') {
            echo '<strong>'.$post_ID.'</strong>';
        }
        if ($column_name == '_address') {
            echo '<strong>'.get_post_meta( $post_ID, ESB_META_PREFIX.'address', true ).'</strong>';
        }
        if ($column_name == '_thumbnail') {
            echo get_the_post_thumbnail( $post_ID, 'thumbnail', array('style'=>'width:100px;height:auto;') );
        }
    }

    protected function set_meta_boxes(){
        $dfBoxes = array(
            'details'       => array(
                'title'         => __( 'Agent Details', 'homeradar-add-ons' ),
                'context'       => 'normal', // normal - side - advanced
                'priority'       => 'high', // default - high - core - low
                'callback_args'       => array(),
            ),
            'verified'       => array(
                'title'         => _x( 'Verified', 'Agent', 'homeradar-add-ons' ),
                'context'       => 'side', // normal - side - advanced
                'priority'       => 'high', // default - high - core - low
                'callback_args'       => array(),
            )
        );
        $addiBoxes = (array)apply_filters( 'cth_cpt_lagent_meta_boxes', array() );

        $this->meta_boxes = array_merge($addiBoxes, $dfBoxes);
    }

    public function lagent_verified_callback($post, $args){
        $verified = get_post_meta( $post->ID, ESB_META_PREFIX.'verified', true );
        ?>
        <label for="agverified" class="selectit"><input type="checkbox" id="agverified" name="verified" value="yes" <?php checked( $verified, 'yes', true ); ?>><?php _ex( 'Is this Agent verified?', 'Agent', 'homeradar-add-ons' ); ?></label>                   
        <?php   
    }

    public static function general_fields(){
        $fields = [
            [
                'name'              => 'email',
                'type'              => 'text',
                'label'             => __( 'Email Address', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
            [
                'name'              => 'company',
                'type'              => 'text',
                'label'             => __( 'Company Name', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
            [
                'name'              => 'position',
                'type'              => 'text',
                'label'             => __( 'Job Position', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
            [
                'name'              => 'phone',
                'type'              => 'text',
                'label'             => __( 'Mobile Number', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
            [
                'name'              => 'office_number',
                'type'              => 'text',
                'label'             => __( 'Office Number', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
            [
                'name'              => 'fax_number',
                'type'              => 'text',
                'label'             => __( 'Fax Number', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
            [
                'name'              => 'whatsapp_number',
                'type'              => 'text',
                'label'             => __( 'WhatsApp Number', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
            [
                'name'              => 'skype',
                'type'              => 'text',
                'label'             => __( 'Skype Account', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
            [
                'name'              => 'address',
                'type'              => 'text',
                'label'             => __( 'Address', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
            [
                'name'              => 'website',
                'type'              => 'text',
                'label'             => __( 'Website', 'homeradar-add-ons' ),
                'icon'              => 'fas fa-user',
            ],
        ];

        return $fields;
    } 

    public function lagent_details_callback($post, $args){
        wp_nonce_field( 'cth-cpt-fields', '_cth_cpt_nonce' );
        $generalFields = $this->general_fields();
        ?>
        <div id="agent-details-tabs" class="cthmetabox-tabs dis-flex">

            <div class="tabs-wrapper">
                <a class="tab-item tab-item-active" href="javascript:void(0);"><?php _e( 'General', 'homeradar-add-ons' ); ?></a>
                <a class="tab-item" href="javascript:void(0);"><?php _e( 'Socials', 'homeradar-add-ons' ); ?></a>
            </div>

            <div class="tabs-content-wrapper">
                <?php include_once( 'mttabs/agent-general.php' ); ?>
                <?php include_once( 'mttabs/socials.php' ); ?>
            </div>

            

        </div>

                    
        <?php 

    }

    public function save_meta_vals($post_id, $post){
        if(isset($_POST['areas'])){
            $new_val = sanitize_text_field( $_POST['areas'] ) ;
            $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.'areas', true );
            if($new_val !== $origin_val){
                update_post_meta( $post_id, ESB_META_PREFIX.'areas', $new_val );
            }
            
        }

        

        if(isset($_POST['specialties'])){
            $new_val = sanitize_text_field( $_POST['specialties'] ) ;
            $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.'specialties', true );
            if($new_val !== $origin_val){
                update_post_meta( $post_id, ESB_META_PREFIX.'specialties', $new_val );
            }
            
        }

        $generalFields = $this->general_fields();
        foreach ($generalFields as $field) {
            if(isset($_POST[$field['name']])){
                $new_val = sanitize_text_field( $_POST[$field['name']] ) ;
                $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.$field['name'], true );
                if($new_val !== $origin_val){
                    update_post_meta( $post_id, ESB_META_PREFIX.$field['name'], $new_val );
                }
                
            }
        }

        $socials = homeradar_addons_get_socials_list();
        foreach ($socials as $val => $lbl) {
            if(isset($_POST[$val])){
                $new_val = sanitize_text_field( $_POST[$val] ) ;
                $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.$val, true );
                if($new_val !== $origin_val){
                    update_post_meta( $post_id, ESB_META_PREFIX.$val, $new_val );
                }
                
            }
        }
    }

    public function save_post($post_id, $post, $update){
        if(!$this->can_save($post_id)) return;

        if(isset($_POST['verified'])){
            update_post_meta( $post_id, ESB_META_PREFIX.'verified',  'yes' );
        }else{
            update_post_meta( $post_id, ESB_META_PREFIX.'verified',  'no' );
        }

        if(isset($_POST['coverImage'])){
            update_post_meta( $post_id, ESB_META_PREFIX.'coverImage', $_POST['coverImage'] );
        }

        

        if(isset($_POST['agency'])){
            update_post_meta( $post_id, ESB_META_PREFIX.'agency', $_POST['agency'] );
        }

        $this->save_meta_vals($post_id, $post);

        // if(isset($_POST['areas'])){
        //     $new_val = sanitize_text_field( $_POST['areas'] ) ;
        //     $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.'areas', true );
        //     if($new_val !== $origin_val){
        //         update_post_meta( $post_id, ESB_META_PREFIX.'areas', $new_val );
        //     }
            
        // }

        

        // if(isset($_POST['specialties'])){
        //     $new_val = sanitize_text_field( $_POST['specialties'] ) ;
        //     $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.'specialties', true );
        //     if($new_val !== $origin_val){
        //         update_post_meta( $post_id, ESB_META_PREFIX.'specialties', $new_val );
        //     }
            
        // }

        // $generalFields = $this->general_fields();
        // foreach ($generalFields as $field) {
        //     if(isset($_POST[$field['name']])){
        //         $new_val = sanitize_text_field( $_POST[$field['name']] ) ;
        //         $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.$field['name'], true );
        //         if($new_val !== $origin_val){
        //             update_post_meta( $post_id, ESB_META_PREFIX.$field['name'], $new_val );
        //         }
                
        //     }
        // }

        // $socials = homeradar_addons_get_socials_list();
        // foreach ($socials as $val => $lbl) {
        //     if(isset($_POST[$val])){
        //         $new_val = sanitize_text_field( $_POST[$val] ) ;
        //         $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.$val, true );
        //         if($new_val !== $origin_val){
        //             update_post_meta( $post_id, ESB_META_PREFIX.$val, $new_val );
        //         }
                
        //     }
        // }

        
        // new settings
        do_action( 'cth_cpt_lagent_save_meta_boxes', $post_id, $post, $update );
    }

    public function agent_add(){
        $json = array(
            'success'       => false,
            'data'          => array(
                'POST'          =>$_POST,
            ),
            'debug'         => false,
        );
        Esb_Class_Ajax_Handler::verify_nonce('homeradar-add-ons');
        $listing_data = array();
        // $listing_data['ID'] = $edit_listing_id; // set ID to update
        $listing_data['post_title'] = isset($_POST['title'])? esc_html($_POST['title']) : 'Agent title';
        $listing_data['post_content'] = isset($_POST['description'])? wp_kses_post($_POST['description']) : '';
        $listing_data['post_status'] = 'publish';
        $listing_data['post_type'] = 'lagent';
        if( isset($_POST['disable_comment']) && !empty($_POST['disable_comment']) ){
            $listing_data['comment_status'] = 'closed'; //'open'; // closed
        }else{
            $listing_data['comment_status'] = get_option('default_comment_status');
        }
        $listing_id = wp_insert_post($listing_data ,true );
        if (!is_wp_error($listing_id)) {
            $json['success'] = true;
            $json['data']['message'] = __( 'The agent has been successfully added.', 'homeradar-add-ons' );

            $this->save_meta_vals($listing_id, null);

            $json['data']['redirect_url'] = add_query_arg('agent', $listing_id, Esb_Class_Dashboard::screen_url('agents') );

        }else{
            $json['data']['error'] = $listing_id->get_error_message();
        }

        wp_send_json( $json );
    }

    public function agent_submit(){
        $json = array(
            'success'       => false,
            'data'          => array(
                'POST'          =>$_POST,
            ),
            'debug'         => false,
        );

        Esb_Class_Ajax_Handler::verify_nonce('homeradar-add-ons');
        $user_id = get_current_user_id();
        $listing_data = array();
        $edit_listing_id = isset($_POST['post_id'])? $_POST['post_id'] : 0;
        if(is_numeric($edit_listing_id) && (int)$edit_listing_id > 0){
            $old_listing_post = get_post( $edit_listing_id );
            if($old_listing_post){
                $is_editing = true;
                if( ! user_can( $user_id, 'edit_post' , $edit_listing_id ) ){
                    $json['data']['error'] = __( "You don't have permission to edit this agent.", 'homeradar-add-ons' ) ;
                    wp_send_json( $json );
                }
                // don't update post author
                $listing_data['post_author'] = $old_listing_post->post_author;
                $listing_data['post_status'] = $old_listing_post->post_status;
                $listing_data['post_date'] = $old_listing_post->post_date;
            }
        }
        $listing_data['ID'] = $edit_listing_id; // set ID to update
        $listing_data['post_title'] = isset($_POST['title'])? esc_html($_POST['title']) : 'Agent title';

        // $listing_data['post_author'] = 2;
        if(isset($_POST['post_excerpt'])) $listing_data['post_excerpt'] = wp_kses_post($_POST['post_excerpt']);
        $listing_data['post_content'] = isset($_POST['description'])? wp_kses_post($_POST['description']) : '';
        //$listing_data['post_author'] = '0';// default 0 for no author assigned
        $listing_data['post_status'] = 'publish';
        $listing_data['post_type'] = 'lagent';

        if( isset($_POST['disable_comment']) && !empty($_POST['disable_comment']) ){
            $listing_data['comment_status'] = 'closed'; //'open'; // closed
        }else{
            $listing_data['comment_status'] = get_option('default_comment_status');
        }
        
        $listing_id = wp_insert_post($listing_data ,true );
        if (!is_wp_error($listing_id)) {
            $json['success'] = true;
            $json['data']['message'] = sprintf(__( 'The agent has been successfully updated. %s', 'homeradar-add-ons' ), '<a href="'.Esb_Class_Dashboard::screen_url('agents').'">'.__( 'Agents List', 'homeradar-add-ons' ).'</a>' );

            $this->save_meta_vals($listing_id, null);

            // image
            if( isset($_POST[ 'thumbnail' ]) ){
                $featured = $_POST['thumbnail'];
                if(is_array($featured) && count($featured)){
                    $featured = reset($featured);
                }
                // delete old image
                $old_thumbnail_id = get_post_thumbnail_id($listing_id);
                if( homeradar_addons_get_option('submit_remove_deleted_imgs') == 'yes' && $featured != $old_thumbnail_id ){
                    wp_delete_attachment( $old_thumbnail_id, true );
                }
                set_post_thumbnail( $listing_id, $featured ); 
            }
            $custom_avatar_upload = homeradar_addons_handle_image_multiple_upload('thumbnail_upload');
            if(!empty($custom_avatar_upload)){
                reset($custom_avatar_upload);
                set_post_thumbnail( $listing_id, key($custom_avatar_upload) ); 
            } 
            if( isset($_POST[ 'coverImage' ]) ){
                $images = '';
                if(is_array($_POST[ 'coverImage' ]) && count($_POST[ 'coverImage' ])){
                    $imgid = reset($_POST[ 'coverImage' ]);
                    $images = array(
                        'id'        => $imgid,
                        'url'       => wp_get_attachment_url( $imgid ),
                    );
                }
                update_post_meta( $listing_id, ESB_META_PREFIX.'coverImage', $images );
            }
            $custom_avatar_upload = homeradar_addons_handle_image_multiple_upload('coverImage_upload');
            if(!empty($custom_avatar_upload)){
                reset($custom_avatar_upload);
                $imgid = key($custom_avatar_upload);
                update_post_meta( $listing_id, ESB_META_PREFIX.'coverImage', array(
                        'id'        => $imgid,
                        'url'       => wp_get_attachment_url( $imgid ),
                    ) );
            } 

        }else{
            $json['data']['error'] = $listing_id->get_error_message();
        }

        wp_send_json( $json );

    }
    public function agent_delete(){
        $json = array(
            'success' => false,
            'data' => array(
                'POST'=>$_POST,
            ),
            'debug' => false
        );
        
        Esb_Class_Dashboard::verify_nonce('homeradar-add-ons');
        $pid = $_POST['id'];
        if(is_numeric($pid) && (int)$pid > 0){
            $author_id = get_post_field('post_author', $pid);
            if( get_current_user_id() != $author_id ){
                $json['data']['error'] = __( "You don't have permission to delete this agent", 'homeradar-add-ons' );
                $json['data']['user'] = get_current_user_id();
                $json['data']['author'] = $author_id;
                wp_send_json($json );
            }
            $deleted_post = wp_delete_post( $pid, true );
            if($deleted_post){
                $json['data']['deleted_booking'] = $deleted_post;
                $json['success'] = true;
            }else{
                $json['data']['error'] = esc_html__( 'Delete agent failure', 'homeradar-add-ons' ) ;
            } 
        }else{
            $json['data']['error'] = esc_html__( 'The agent id is incorrect.', 'homeradar-add-ons' ) ;
        }

        wp_send_json($json );
    }

}

new Esb_Class_Agent_CPT();
