<?php
/* add_ons_php */

class Esb_Class_Agency_CPT extends Esb_Class_CPT {
    protected $name = 'lagency';
    protected $permalinks = array();
    protected function init(){
        $this->permalinks = get_option( 'cthpermalinks', array() );
        parent::init();

        add_action( 'init', array($this, 'taxonomies'), 0 ); 

        add_filter('single_template', array($this, 'single_template')); 

        do_action( $this->name.'_cpt_init_after' );
    }

    public function single_template($tmpl){
        global $post;

        if ($post->post_type == 'lagency') {
            $tmpl = homeradar_addons_get_template_part('templates/single', 'agency', null, false);
        }
        return $tmpl;
    }

    public function register(){
        $slug = !empty($this->permalinks['cthagency_slug']) ? $this->permalinks['cthagency_slug'] : 'agency';
        $labels = array( 
            'name' => __( 'Agency', 'homeradar-add-ons' ),
            'singular_name' => __( 'Agency', 'homeradar-add-ons' ), 
            'add_new' => __( 'Add New Agency', 'homeradar-add-ons' ),
            'add_new_item' => __( 'Add New Agency', 'homeradar-add-ons' ),
            'edit_item' => __( 'Edit Agency', 'homeradar-add-ons' ),
            'new_item' => __( 'New Agency', 'homeradar-add-ons' ),
            'view_item' => __( 'View Agency', 'homeradar-add-ons' ),
            'search_items' => __( 'Search Agencies', 'homeradar-add-ons' ),
            'not_found' => __( 'No Agencies found', 'homeradar-add-ons' ),
            'not_found_in_trash' => __( 'No Agencies found in Trash', 'homeradar-add-ons' ),
            'parent_item_colon' => __( 'Parent Agency:', 'homeradar-add-ons' ), 
            'menu_name' => __( 'Agencies', 'homeradar-add-ons' ),
        );

        $args = array( 
            'labels' => $labels,
            'hierarchical' => false,
            'description' => __( 'Agencies', 'homeradar-add-ons' ),
            'supports' => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments', 'author'),
            'taxonomies' => array('agency_cat','agency_city'),
            'public' => true,
            'show_ui' => true,
            'show_in_menu' => true,//default from show_ui
            'menu_position' => 25,
            'menu_icon' => 'dashicons-groups',
            'show_in_nav_menus' => true,
            // 'publicly_queryable' => false,
            'exclude_from_search' => true,
            'has_archive' => false,
            'query_var' => true,
            'can_export' => true,
            'rewrite' => array( 'slug' => $slug ),
            'capability_type' => 'post'
        );
        register_post_type( $this->name, $args );
    }
    public function taxonomies(){
        
        $labels = array(
            'name' => __( 'Categories', 'homeradar-add-ons' ),
            'singular_name' => __( 'Category', 'homeradar-add-ons' ),
            'search_items' =>  __( 'Search Categories','homeradar-add-ons' ),
            'all_items' => __( 'All Categories','homeradar-add-ons' ),
            'parent_item' => __( 'Parent Category','homeradar-add-ons' ),
            'parent_item_colon' => __( 'Parent Category:','homeradar-add-ons' ),
            'edit_item' => __( 'Edit Category','homeradar-add-ons' ), 
            'update_item' => __( 'Update Category','homeradar-add-ons' ),
            'add_new_item' => __( 'Add New Category','homeradar-add-ons' ),
            'new_item_name' => __( 'New Category Name','homeradar-add-ons' ),
            'menu_name' => __( 'Categories','homeradar-add-ons' ),
        );     
        // Now register the taxonomy
        register_taxonomy('agency_cat',array('lagency'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            // 'show_in_menu'  => false,
            'show_in_nav_menus'=> false,
            'show_admin_column' => true,
            'show_tagcloud'     => false,
            'query_var' => false,
            'rewrite' => array( 'slug' => __( 'agency_cat', 'homeradar-add-ons' ) ),
            // https://codex.wordpress.org/Roles_and_Capabilities
            // 'capabilities' => array(
            //     'manage_terms' => 'manage_categories',
            //     'edit_terms' => 'manage_categories',
            //     'delete_terms' => 'manage_categories',
            //     'assign_terms' => 'edit_posts'
            // ),

        ));
        $labels = array(
            'name' => __( 'Cities', 'homeradar-add-ons' ),
            'singular_name' => __( 'City', 'homeradar-add-ons' ),
            'search_items' =>  __( 'Search Cities','homeradar-add-ons' ),
            'all_items' => __( 'All Cities','homeradar-add-ons' ),
            'parent_item' => __( 'Parent City','homeradar-add-ons' ),
            'parent_item_colon' => __( 'Parent City:','homeradar-add-ons' ),
            'edit_item' => __( 'Edit City','homeradar-add-ons' ), 
            'update_item' => __( 'Update City','homeradar-add-ons' ),
            'add_new_item' => __( 'Add New City','homeradar-add-ons' ),
            'new_item_name' => __( 'New City Name','homeradar-add-ons' ),
            'menu_name' => __( 'Cities','homeradar-add-ons' ),
        );     
        // Now register the taxonomy
        register_taxonomy('agency_city',array('lagency'), array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            // 'show_in_menu'  => false,
            'show_in_nav_menus'=> false,
            'show_admin_column' => true,
            'show_tagcloud'     => false,
            'query_var' => false,
            'rewrite' => array( 'slug' => __( 'agency_city', 'homeradar-add-ons' ) ),

        ));
    }

    protected function set_meta_columns(){
        $this->has_columns = true;
    }
    public function meta_columns_head($columns){
        unset($columns['date']);
        
        $columns['_price']          = __('Price','homeradar-add-ons');
        $columns['_pm_count']       = __('Subscribers Count','homeradar-add-ons');
        $columns['_thumbnail']      = __('Thumbnail','homeradar-add-ons');
        $columns['_id']             = __('ID','homeradar-add-ons');
        return $columns;
    }
    public function meta_columns_content($column_name, $post_ID){
        if ($column_name == '_price') {
            echo '<strong>'.homeradar_addons_get_price_formated( get_post_meta( $post_ID, '_price', true ) ).'</strong>';
        }
        if ($column_name == '_id') {
            echo '<strong>'.$post_ID.'</strong>';
        }
        if ($column_name == '_pm_count') {
            echo '<strong>'.get_post_meta( $post_ID, ESB_META_PREFIX.'pm_count', true ).'</strong>';
        }
        if ($column_name == '_thumbnail') {
            echo get_the_post_thumbnail( $post_ID, 'thumbnail', array('style'=>'width:100px;height:auto;') );
        }
    }

    protected function set_meta_boxes(){
        $dfBoxes = array(
            'details'       => array(
                'title'         => __( 'Agency Details', 'homeradar-add-ons' ),
                'context'       => 'normal', // normal - side - advanced
                'priority'       => 'core', // default - high - core - low
                'callback_args'       => array(),
            ),
            'verified'       => array(
                'title'         => _x( 'Verified', 'Agency', 'homeradar-add-ons' ),
                'context'       => 'side', // normal - side - advanced
                'priority'       => 'high', // default - high - core - low
                'callback_args'       => array(),
            )
        );
        $addiBoxes = (array)apply_filters( 'cth_cpt_lagency_meta_boxes', array() );

        $this->meta_boxes = array_merge($addiBoxes, $dfBoxes);
    }

    public function lagency_verified_callback($post, $args){
        $verified = get_post_meta( $post->ID, ESB_META_PREFIX.'verified', true );
        ?>
        <label for="agverified" class="selectit"><input type="checkbox" id="agverified" name="verified" value="yes" <?php checked( $verified, 'yes', true ); ?>><?php _ex( 'Is this Agency verified?', 'Agency', 'homeradar-add-ons' ); ?></label>                   
        <?php   
    }

    public static function general_fields(){
        $fields = [
            [
                'name'              => 'email',
                'type'              => 'text',
                'label'             => __( 'Email Address', 'homeradar-add-ons' ),
            ],
            // [
            //     'name'              => 'company',
            //     'type'              => 'text',
            //     'label'             => __( 'Company Name', 'homeradar-add-ons' ),
            // ],
            [
                'name'              => 'phone',
                'type'              => 'text',
                'label'             => __( 'Mobile Number', 'homeradar-add-ons' ),
            ],
            [
                'name'              => 'office_number',
                'type'              => 'text',
                'label'             => __( 'Office Number', 'homeradar-add-ons' ),
            ],
            [
                'name'              => 'fax_number',
                'type'              => 'text',
                'label'             => __( 'Fax Number', 'homeradar-add-ons' ),
            ],
            [
                'name'              => 'whatsapp_number',
                'type'              => 'text',
                'label'             => __( 'WhatsApp Number', 'homeradar-add-ons' ),
            ],
            [
                'name'              => 'skype',
                'type'              => 'text',
                'label'             => __( 'Skype Account', 'homeradar-add-ons' ),
            ],
            [
                'name'              => 'address',
                'type'              => 'text',
                'label'             => __( 'Address', 'homeradar-add-ons' ),
            ],
            [
                'name'              => 'latitude',
                'type'              => 'text',
                'label'             => __( 'Latitude', 'homeradar-add-ons' ),
            ],
            [
                'name'              => 'longitude',
                'type'              => 'text',
                'label'             => __( 'Longitude', 'homeradar-add-ons' ),
            ],
            [
                'name'              => 'website',
                'type'              => 'text',
                'label'             => __( 'Website', 'homeradar-add-ons' ),
            ],
        ];

        return $fields;
    } 

    public function lagency_details_callback($post, $args){
        wp_nonce_field( 'cth-cpt-fields', '_cth_cpt_nonce' );
        $generalFields = $this->general_fields();
        ?>
        <div id="agent-details-tabs" class="cthmetabox-tabs dis-flex">

            <div class="tabs-wrapper">
                <a class="tab-item tab-item-active" href="javascript:void(0);"><?php _e( 'General', 'homeradar-add-ons' ); ?></a>
                <a class="tab-item" href="javascript:void(0);"><?php _e( 'Socials', 'homeradar-add-ons' ); ?></a>
            </div>

            <div class="tabs-content-wrapper">
                <?php include_once( 'mttabs/agency-general.php' ); ?>
                <?php include_once( 'mttabs/socials.php' ); ?>
            </div>

            

        </div>

                    
        <?php 

    }

    public function save_post($post_id, $post, $update){
        if(!$this->can_save($post_id)) return;

        if(isset($_POST['verified'])){
            update_post_meta( $post_id, ESB_META_PREFIX.'verified',  'yes' );
        }else{
            update_post_meta( $post_id, ESB_META_PREFIX.'verified',  'no' );
        }

        if(isset($_POST['areas'])){
            $new_val = sanitize_text_field( $_POST['areas'] ) ;
            $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.'areas', true );
            if($new_val !== $origin_val){
                update_post_meta( $post_id, ESB_META_PREFIX.'areas', $new_val );
            }
            
        }


        $generalFields = $this->general_fields();
        foreach ($generalFields as $field) {
            if(isset($_POST[$field['name']])){
                $new_val = sanitize_text_field( $_POST[$field['name']] ) ;
                $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.$field['name'], true );
                if($new_val !== $origin_val){
                    update_post_meta( $post_id, ESB_META_PREFIX.$field['name'], $new_val );
                }
                
            }
        }

        $socials = homeradar_addons_get_socials_list();
        foreach ($socials as $val => $lbl) {
            if(isset($_POST[$val])){
                $new_val = sanitize_text_field( $_POST[$val] ) ;
                $origin_val = get_post_meta( $post_id, ESB_META_PREFIX.$val, true );
                if($new_val !== $origin_val){
                    update_post_meta( $post_id, ESB_META_PREFIX.$val, $new_val );
                }
                
            }
        }

        // new settings
        do_action( 'cth_cpt_lagency_save_meta_boxes', $post_id, $post, $update );
    }

    

}

new Esb_Class_Agency_CPT();
