<?php 
/* add_ons_php */

function homeradar_addons_options_get_search(){
    return array(
            array(
                "type" => "section",
                'id' => 'search_category_opts',
                "title" => __( 'Category Options', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'search_cat_level',
                "title" => __('Category Level', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> '0',
                    'options'=> array(
                        '0' => esc_html__('1 Level', 'homeradar-add-ons'), 
                        '1' => esc_html__('2 Level', 'homeradar-add-ons'), 
                        '2' => esc_html__('3 Level', 'homeradar-add-ons'), 
                        '3' => esc_html__('4 Level', 'homeradar-add-ons'), 
                        '4' => esc_html__('5 Level', 'homeradar-add-ons'), 
                    ),
                ),
                'desc' => esc_html__("Max category level display on search form.", 'homeradar-add-ons'), 
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'search_load_subcat',
                'args'=> array(
                    'default' => 'yes',
                    'value' => 'yes',
                ),
                "title" => __('Load Sub-Cat', 'homeradar-add-ons'),
                'desc' => esc_html__("Load sub categories for filter.", 'homeradar-add-ons'), 

            ),

            

            array(
                "type" => "section",
                'id' => 'search_taxonomy_opts',
                "title" => __( 'Taxonomy Options', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'search_include_cat',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Include Category', 'homeradar-add-ons'),
                'desc' => esc_html__("Include listing category for search value", 'homeradar-add-ons'), 

            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'search_include_tag',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Include Tag', 'homeradar-add-ons'),
                'desc' => esc_html__("Include listing tag for search value", 'homeradar-add-ons'), 

            ),

            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'search_tax_relation',
                "title" => __('Taxonomy Relation', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'AND',
                    'options'=> array(
                        'AND' => esc_html__('AND', 'homeradar-add-ons'), 
                        'OR' => esc_html__('OR', 'homeradar-add-ons'), 
                        
                    ),
                ),
                'desc' => esc_html__("The logical relationship between each inner taxonomy.", 'homeradar-add-ons'), 
            ),

            array(
                "type" => "section",
                'id' => 'search_distance_opts',
                "title" => __( 'Distance Options', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "number",
                'id' => 'distance_min',
                "title" => __('Distance Search Min (kilometer)', 'homeradar-add-ons'),
                'args' => array(
                    'default'  => '2',
                    'min'  => '0',
                    'max'  => '40000',
                    'step'  => '1',
                ),
                // 'desc'  => __('Timezone offset value from UTC', 'homeradar-add-ons'),
            ),
            array(
                "type" => "field",
                "field_type" => "number",
                'id' => 'distance_max',
                "title" => __('Distance Search Max (kilometer)', 'homeradar-add-ons'),
                'args' => array(
                    'default'  => '20',
                    'min'  => '1',
                    'max'  => '40000',
                    'step'  => '1',
                ),
                // 'desc'  => __('Timezone offset value from UTC', 'homeradar-add-ons'),
            ),
            array(
                "type" => "field",
                "field_type" => "number",
                'id' => 'distance_df',
                "title" => __('Distance Search Default (kilometer)', 'homeradar-add-ons'),
                'args' => array(
                    'default'  => '10',
                    'min'  => '1',
                    'max'  => '40000',
                    'step'  => '1',
                ),
                // 'desc'  => __('Timezone offset value from UTC', 'homeradar-add-ons'),
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox", 
                'id' => 'distance_miles',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Use miles instead', 'homeradar-add-ons'),  
                'desc'  => __( 'You also need translate km text to miles', 'homeradar-add-ons' ),
            ),



            array(
                "type" => "section",
                'id' => 'search_filter_opts',
                "title" => __( 'Filter Options', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'filter_hide_string',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Hide Filter String', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'filter_hide_loc',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Hide Location', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'filter_hide_cat',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Hide Category', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'filter_hide_address',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Hide Address', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'filter_hide_event_date',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Hide Event Date', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'filter_hide_event_time',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Hide Event Time', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'filter_hide_open_now',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Hide Open Now', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'filter_hide_price_range',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Hide Price Range', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'filter_hide_sortby',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Hide Sort By', 'homeradar-add-ons'),
                'desc' => '', 

            ),

            array(
                "type" => "field",
                "field_type" => "lfeatures",
                'id' => 'filter_features',
                'args'=> array(
                    'default' => array(),
                    // 'hide_empty'    => true, // default is true
                ),
                "title" => __('Features', 'homeradar-add-ons'),
                'desc' => '', 

            ),

            array(
                "type" => "field",
                "field_type" => "cth_tags",
                'id' => 'filter_ltags',
                'args'=> array(
                    'default' => array(),
                    'hide_empty'    => true,
                ),
                "title" => __('Tags Filter', 'homeradar-add-ons'),
                'desc' => '', 

            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'show_cats_nav',
                'args'=> array(
                    'default' => 'yes',
                    'value' => 'yes',
                ),
                "title" => _x('Show Categories Nav', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
                'desc' => '', 

            ),

            array(
                "type" => "field",
                "field_type" => "number",
                'id' => 'cats_num',
                "title" => __('Number of categories on the nav', 'homeradar-add-ons'),
                'args' => array(
                    'default'  => '5',
                    'min'  => '0',
                    'max'  => '100',
                    'step'  => '1',
                ),
                'desc'  => __('Set to 0 to show all', 'homeradar-add-ons'),
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'use_ltype_search',
                'args'=> array(
                    'default' => 'yes',
                    'value' => 'yes',
                ),
                "title" => _x('Allow search by listing type?', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
                'desc' => _x('For Hero and Header search forms', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'use_ltype_filter',
                'args'=> array(
                    'default' => 'yes',
                    'value' => 'yes',
                ),
                "title" => _x('Allow filter by listing type?', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
                'desc' => _x('For search results form', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'fevent_exact',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => _x('Filter events by exact date', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
                // 'desc' => _x('For search results form', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'fevent_calendar',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => _x('Filter event date from calendar also?', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
                // 'desc' => _x('For search results form', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'hide_cat_features',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => _x('Do not load features on selecting category?', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
                // 'desc' => _x('For search results form', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'inout_rooms_only',
                'args'=> array(
                    'default' => 'yes',
                    'value' => 'yes',
                ),
                "title" => __('Checkin/Checkout search for rooms only?', 'homeradar-add-ons'),
                'desc' => esc_html__("By enabling this option, the check-in/checkout search will only show listings with rooms", 'homeradar-add-ons'), 

            ),

    );
}
