<?php 
/* add_ons_php */

function homeradar_addons_options_get_listings(){
    return array(

            array(
                "type" => "section",
                'id' => 'listings_archive_sec',
                "title" => __( 'Archive Layout', 'homeradar-add-ons' ),
                'desc' => __("For listing search, category, location, feature pages.", 'homeradar-add-ons'), 
            ),

            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'llayout',
                "title" => __('Layout', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'column-map-filter',
                    'options'=> array(
                        'column-map' => esc_html__('Column Map', 'homeradar-add-ons'), 
                        'column-map-filter' => esc_html__('Column Map/Top-Filter', 'homeradar-add-ons'), 
                        'full-map' => esc_html__('Fullwidth Map', 'homeradar-add-ons'), 
                        'full-map-filter' => esc_html__('Fullwidth Map/Side-Filter', 'homeradar-add-ons'), 
                        'no-map' => esc_html__('Without Map', 'homeradar-add-ons'), 
                        'no-map-filter' => esc_html__('Without Map/Side-Filter', 'homeradar-add-ons'), 
                    ),
                ),
                'desc' => esc_html__("Select listings page layout", 'homeradar-add-ons'), 
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'show_lheader',
                'args'=> array(
                    'default' => 'yes',
                    'value' => 'yes',
                ),
                "title" => esc_html__('Show Header', 'homeradar-add-ons'),
                'desc' => __('For <strong>Without Map</strong> layouts only', 'homeradar-add-ons'),

            ),
            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'lheader_title',
                "title" => __('Listings head title', 'homeradar-add-ons'),
                'desc' => __('For <strong>Without Map</strong> layouts only', 'homeradar-add-ons'),
                'args' => array(
                    'default' => 'Our Listings',
                )
            ),
            array(
                "type" => "field",
                "field_type" => "textarea",
                'id' => 'lheader_intro',
                "title" => __('Listings head info', 'homeradar-add-ons'),
                'desc' => __('For <strong>Without Map</strong> layouts only', 'homeradar-add-ons'),
                'args' => array(
                    'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut nec tincidunt arcu, sit amet fermentum sem.',
                )
            ),
            
            array(
                "type" => "field",
                "field_type" => "image",
                'id' => 'lheader_bg',
                "title" => __('Header Background', 'homeradar-add-ons'),
                'desc' => __('For <strong>Without Map</strong> layouts only', 'homeradar-add-ons'),
            ),


            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'map_pos',
                "title" => __('Map Position', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'right',
                    'options'=> array(
                        'top' => esc_html__('Top', 'homeradar-add-ons'), 
                        'left' => esc_html__('Left', 'homeradar-add-ons'), 
                        'right' => esc_html__('Right', 'homeradar-add-ons'), 
                        'hide' => esc_html__('Hide', 'homeradar-add-ons'), 
                    ),
                ),
                'desc' => esc_html__("Select Google Map position", 'homeradar-add-ons'), 
            ),

            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'filter_pos',
                "title" => __('Filter Position', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'top',
                    'options'=> array(
                        'top' => esc_html__('Top', 'homeradar-add-ons'), 
                        'left' => esc_html__('Left', 'homeradar-add-ons'), 
                        'right' => esc_html__('Right', 'homeradar-add-ons'), 
                        'left_col' => esc_html__('Column Left', 'homeradar-add-ons'), 
                    ),
                ),
                'desc' => esc_html__("Select Listing Filter position", 'homeradar-add-ons'), 
            ),

            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'columns_grid',
                "title" => __('Columns Grid', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'two',
                    'options'=> array(
                        'one' => esc_html__('One Column', 'homeradar-add-ons'), 
                        'two' => esc_html__('Two Columns', 'homeradar-add-ons'), 
                        'three' => esc_html__('Three Columns', 'homeradar-add-ons'), 
                        'four' => esc_html__('Four Columns', 'homeradar-add-ons'), 
                        'five' => esc_html__('Five Columns', 'homeradar-add-ons'), 
                        'six' => esc_html__('Six Columns', 'homeradar-add-ons'), 
                    ),
                ),
                'desc' => '', 
            ),


            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'listings_grid_layout',
                "title" => __('Default Layout', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'grid',
                    'options'=> array(
                        'grid' => esc_html__('Grid View', 'homeradar-add-ons'), 
                        'list' => esc_html__('List View', 'homeradar-add-ons'), 
                        
                    ),
                ),
                'desc' => '', 
            ),

            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'listings_orderby',
                "title" => __('Order Listings by', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'date',
                    'options'=> homeradar_addons_get_post_orderby(),
                ),
                'desc' => '', 
            ),
            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'listings_order',
                "title" => __('Sort Order', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'DESC',
                    'options'=> array(
                        'ASC' => __( 'Ascending order - (1, 2, 3; a, b, c)', 'homeradar-add-ons' ),
                        'DESC' => __( 'Descending order - (3, 2, 1; c, b, a)', 'homeradar-add-ons' ),
                    ),
                ),
                'desc' => '', 
            ),

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'listings_count',
                "title" => __('Listings per page', 'homeradar-add-ons'),
                'desc'  => __( 'Number of listings to show on a page (-1 for all)', 'homeradar-add-ons' ),
                'args' => array(
                    'default' => '6',
                )
            ),

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'excerpt_length',
                "title" => __('Excerpt Characters Length', 'homeradar-add-ons'),
                'desc'  => '',
                'args' => array(
                    'default' => '55',
                )
            ),

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'address_length',
                "title" => __('Address Characters Length', 'homeradar-add-ons'),
                'desc'  => '',
                'args' => array(
                    'default' => '45',
                )
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'hide_past_events',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => esc_html__('Hide past event listings', 'homeradar-add-ons'),
                'desc' => '', 

            ),

            // array(
            //     "type" => "field",
            //     "field_type" => "checkbox",
            //     'id' => 'listing_event_date',
            //     'args'=> array(
            //         'default' => 'yes',
            //         'value' => 'yes',
            //     ),
            //     "title" => esc_html__('Show Event Date', 'homeradar-add-ons'),
            //     'desc' => '', 

            // ),

            // array(
            //     "type" => "field",
            //     "field_type" => "checkbox",
            //     'id' => 'grid_wkhour',
            //     'args'=> array(
            //         'default' => 'yes',
            //         'value' => 'yes',
            //     ),
            //     "title" => esc_html__('Show Status', 'homeradar-add-ons'),
            //     'desc' => '', 

            // ),

            // array(
            //     "type" => "field",
            //     "field_type" => "checkbox",
            //     'id' => 'grid_price',
            //     'args'=> array(
            //         'default' => 'yes',
            //         'value' => 'yes',
            //     ),
            //     "title" => esc_html__('Show Price', 'homeradar-add-ons'),
            //     'desc' => '', 

            // ),

            // array(
            //     "type" => "field",
            //     "field_type" => "checkbox",
            //     'id' => 'grid_price_range',
            //     'args'=> array(
            //         'default' => 'yes',
            //         'value' => 'yes',
            //     ),
            //     "title" => esc_html__('Show Price Range', 'homeradar-add-ons'),
            //     'desc' => '', 

            // ),

            // array(
            //     "type" => "field",
            //     "field_type" => "checkbox",
            //     'id' => 'grid_viewed_count',
            //     'args'=> array(
            //         'default' => 'yes',
            //         'value' => 'yes',
            //     ),
            //     "title" => esc_html__('Show Viewed Count', 'homeradar-add-ons'),
            //     'desc' => '', 

            // ),

            

            

            array(
                "type" => "section",
                'id' => 'listings_search_sec',
                "title" => __( 'Listing Search Page', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "textarea",
                'id' => 'search_infor_before',
                "title" => __('Information Before', 'homeradar-add-ons'),
                'desc'  => '',
                'args' => array(
                    'default' => '',
                )
            ),
            array(
                "type" => "field",
                "field_type" => "textarea",
                'id' => 'search_infor_after',
                "title" => __('Information After', 'homeradar-add-ons'),
                'desc'  => '',
                'args' => array(
                    'default' => '',
                )
            ),

            array(
                "type" => "section",
                'id' => 'author_page_sidebars',
                "title" => _x( 'Author page', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'lauthor_archive_for',
                "title" => _x('Use listing author layout for?', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> array('administrator','listing_author','author'),
                    'options'=> homeradar_addons_get_author_roles(true),
                    'multiple' => true,
                    'use-select2' => true
                ),
                // 'desc' => esc_html__("The page redirect to after submit/edit listing", 'homeradar-add-ons'), 
            ),

            

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'author_show_posts',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => _x('Show Author Posts', 'HomeRadar Add-Ons option', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            


            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'author_hide_about',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => esc_html_x('Hide About Author widget', 'HomeRadar Add-Ons option', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'author_hide_contacts',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => esc_html_x('Hide User Contacts widget', 'HomeRadar Add-Ons option', 'homeradar-add-ons'),
                'desc' => '', 

            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'author_hide_form',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => esc_html_x('Hide Contact Form widget', 'HomeRadar Add-Ons option', 'homeradar-add-ons'),
                'desc' => '', 

            ),

            array(
                "type" => "section",
                'id' => 'ical_sync_sec',
                "title" => _x( 'iCal Synchronization Scheduler', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'ical_sync_enable',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => esc_html_x('Enable iCal Synchronization', 'HomeRadar Add-Ons option', 'homeradar-add-ons'),
                'desc' => 'You site will run a cron job every interval value bellow to sync dates from external iCal added to listing/rooms. Then mark the dates as unavailable for booking.', 

            ),

            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'ical_sync_interval',
                "title" => esc_html_x('Interval', 'HomeRadar Add-Ons option', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> '30',
                    'options'=> array(
                        "5" => _x( '5 minutes', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        "10" => _x( '10 minutes', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        // "15" => _x( '15 minutes', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        "20" => _x( '20 minutes', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        // "25" => _x( '25 minutes', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        "30" => _x( '30 minutes', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        "60" => _x( 'One hour', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        "120" => _x( 'Two hours', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        "720" => _x( 'Twice daily', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        "1440" => _x( 'Daily', 'HomeRadar Add-Ons', 'homeradar-add-ons' ),
                        
                        
                    ),
                ),
                'desc' => '', 
            ),

            array(
                "type" => "field",
                "field_type" => "info",
                'id' => 'ical_sync_infos',
                "title" => esc_html_x('NOTE', 'HomeRadar Add-Ons option', 'homeradar-add-ons'),
                'desc'  => __( 'You need to uncheck the Enable iCal Synchronization option to change Interval value. Save changes then enable it again.', 'homeradar-add-ons' ),
            ),

    );
}
