<?php 
/* add_ons_php */

function homeradar_addons_options_get_general(){
    return array(
            array(
                "type" => "section",
                'id' => 'general_design_opts',
                "title" => __( 'General Options', 'homeradar-add-ons' ),
            ),
            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'disable_bubble',
                'args'=> array(
                    'default' => 'no',
                    'value' => 'yes',
                ),
                "title" => __('Disable Bubble Animation', 'homeradar-add-ons'),
                'desc'  => '',
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'week_starts_monday',
                'args'=> array(
                    'default' => 'yes',
                    'value' => 'yes',
                ),
                "title" => _x('Weeks starts on Monday?', 'HomeRadar Add-Ons', 'homeradar-add-ons'),
                'desc'  => '',
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'use_clock_24h',
                'args'=> array(
                    'default' => 'yes',
                    'value' => 'yes',
                ),
                "title" => __('Use 24-hour format', 'homeradar-add-ons'),
                'desc'  => '',
            ),
            
            
            
            array(
                "type" => "section",
                'id' => 'general_section_5',
                "title" => __( 'Currency Options', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'currency',
                "title" => __('Currency', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'USD',
                    'options'=> homeradar_addons_get_currency_array(),
                    'class'     => 'base_currency_select'
                )
            ),

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'currency_symbol',
                'args' => array(
                    'default'  => '$',
                ),
                "title" => __('Symbol', 'homeradar-add-ons'),
                // 'desc'  => __('General', 'homeradar-add-ons'),
            ),


            array(
                "type" => "field",
                "field_type" => "select",
                'id' => 'currency_pos',
                "title" => __('Currency position', 'homeradar-add-ons'),
                'args'=> array(
                    'default'=> 'left_space',
                    'options'=> array(
                        'left' => __( 'Left', 'homeradar-add-ons' ),
                        'left_space' => __( 'Left with space', 'homeradar-add-ons' ),
                        'right' => __( 'Right', 'homeradar-add-ons' ),
                        'right_space' => __( 'Right with space', 'homeradar-add-ons' ),
                    ),
                )
            ),
            

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'thousand_sep',
                'args' => array(
                    'default'  => ',',
                ),
                "title" => __('Thousand separator', 'homeradar-add-ons'),
                // 'desc'  => __('General', 'homeradar-add-ons'),
            ),

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'decimal_sep',
                'args' => array(
                    'default'  => '.',
                ),
                "title" => __('Decimal separator', 'homeradar-add-ons'),
                // 'desc'  => __('General', 'homeradar-add-ons'),
            ),

            array(
                "type" => "field",
                "field_type" => "number",
                'id' => 'decimals',
                "title" => __('Number of decimals', 'homeradar-add-ons'),
                'args' => array(
                    'default'  => '2',
                    'min'  => '0',
                    'max'  => '14',
                    'step'  => '1',
                ),
                // 'desc'  => __('Timezone offset value from UTC', 'homeradar-add-ons'),
            ),

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'curr_convert_api',
                'args' => array(
                    'default'  => '39dd0de7891d0b93c9d0',
                ),
                "title" => __('currencyconverterapi.com api key', 'homeradar-add-ons'),
                'desc'  => __('Enter your api key here then click to Save button at the bottom before using currency converter button bellow', 'homeradar-add-ons'),
            ),

            array(
                "type" => "field",
                "field_type" => "checkbox",
                'id' => 'curr_convert_free',
                'args'=> array(
                    'default' => 'yes',
                    'value' => 'yes',
                ),
                "title" => __('Is free currencyconverterapi.com api key?', 'homeradar-add-ons'),
                'desc'  => '',
            ),

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'area_unit',
                'args' => array(
                    'default'  => 'ft2',
                ),
                "title" => __('Area Unit', 'homeradar-add-ons'),
                'desc'  => '',
            ),

            array(
                "type" => "section",
                'id' => 'general_section_51',
                "title" => __( 'Multiple Currencies', 'homeradar-add-ons' ),
            ),

            // homeradar_addons_get_option('currencies')

            array(
                "type" => "field",
                "field_type" => "currencies",
                'id' => 'currencies',
                'args' => array(
                    'default'  => '',
                    'load_tmpl' => true
                ),
                "title" => __('Currencies', 'homeradar-add-ons'),
                'desc'  => __('Available currencies for front-end show.', 'homeradar-add-ons'),
            ),

            array(
                "type" => "section",
                'id' => 'general_tax_sec',
                "title" => __( 'Taxes', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'vat_tax',
                "title" => __('VAT Tax', 'homeradar-add-ons'),
                'desc'  => __( 'VAT tax percent. Default: 10%', 'homeradar-add-ons' ),
                'args' => array(
                    'default' => '10',
                )
            ),

            array(
                "type" => "field",
                "field_type" => "text",
                'id' => 'service_fee',
                "title" => __('Service Fees (percent)', 'homeradar-add-ons'),
                'desc'  => '',
                'args' => array(
                    'default' => '5',
                )
            ),

            
            array(
                "type" => "section",
                'id' => 'general_section_6',
                "title" => __( 'Listing Pages - Important', 'homeradar-add-ons' ),
            ),

            array(
                "type" => "field",
                "field_type" => "page_select",
                'id' => 'submit_page',
                "title" => __('Submit Listing Page', 'homeradar-add-ons'),
                'desc'  => __('The page will be used to display listing submission. The page content should contain <b>[listing_submit_page]</b> shortcode', 'homeradar-add-ons'),
                'args' => array(
                    'default_title' => "Submit Listing",
                )
            ),

            array(
                "type" => "field",
                "field_type" => "page_select",
                'id' => 'edit_page',
                "title" => __('Edit Listing Page', 'homeradar-add-ons'),
                'desc'  => __('The page will be used to edit listing. The page content should contain <b>[listing_edit_page]</b> shortcode', 'homeradar-add-ons'),
                'args' => array(
                    'default_title' => "Edit Listing",
                )
            ),

            array(
                "type" => "field",
                "field_type" => "page_select",
                'id' => 'dashboard_page',
                "title" => __('Listing Author Dashboard Page', 'homeradar-add-ons'),
                'desc'  => __('The page will be used for listing author dashboard. The page content should contain <b>[listing_dashboard_page]</b> shortcode', 'homeradar-add-ons'),
                'args' => array(
                    'default_title' => "Dashboard",
                )
            ),

            // array(
            //     "type" => "field",
            //     "field_type" => "page_select",
            //     'id' => 'payment_page',
            //     "title" => __('Listing Payment Page', 'homeradar-add-ons'),
            //     'desc'  => __('The page will be used for listing/booking checkout', 'homeradar-add-ons'),
            //     'args' => array(
            //         'default_title' => "Listing Payment",
            //     )
            // ),

            array(
                "type" => "field",
                "field_type" => "page_select",
                'id' => 'checkout_page',
                "title" => __('Listing Checkout Page', 'homeradar-add-ons'),
                'desc'  => __('The page will be used for Membership/Listing checkout. The page content should contain <b>[listing_checkout_page]</b> shortcode', 'homeradar-add-ons'),
                'args' => array(
                    'default_title' => "Listing Checkout",
                )
            ),

            array(
                "type" => "field",
                "field_type" => "page_select",
                'id' => 'checkout_success_page',
                "title" => __('Free membership success', 'homeradar-add-ons'),
                'desc'  => __('The page user will be redirected to when click to free membership plan.', 'homeradar-add-ons'),
                'args' => array(
                    'default'   => 'none',
                    'default_title' => "Checkout Success",
                    'options' => array(
                        array(
                            'none',
                            __( 'Front Page', 'homeradar-add-ons' ),
                        ),
                    )
                )
            ),

            array(
                "type" => "field",
                "field_type" => "page_select",
                'id' => 'compare_page',
                "title" => __('Compare Listings Page', 'homeradar-add-ons'),
                'desc'  => __('The page will be used to compare listings. The page content should contain <b>[listing_compare_page]</b> shortcode', 'homeradar-add-ons'),
                'args' => array(
                    'default_title' => "Compare",
                )
            ),
            array(
                "type" => "field",
                "field_type" => "page_select",
                'id' => 'agencies_page',
                "title" => __('Agencies List Page', 'homeradar-add-ons'),
                'desc'  => __('The page will be used to display list of agencies. The page template must be <b>Agencies List</b>', 'homeradar-add-ons'),
                'args' => array(
                    'default_title' => "Agencies List",
                )
            ),
            array(
                "type" => "field",
                "field_type" => "page_select",
                'id' => 'agents_page',
                "title" => __('Agents List Page', 'homeradar-add-ons'),
                'desc'  => __('The page will be used to display list of agents. The page template must be <b>Agents List</b>', 'homeradar-add-ons'),
                'args' => array(
                    'default_title' => "Agents List",
                )
            ),
    );
}
