<?php
/* add_ons_php */

defined('ABSPATH') || exit;

class Esb_Class_Frontend_Scripts
{

    private static $plugin_url;

    public static function init()
    {
        self::$plugin_url = plugin_dir_url(ESB_PLUGIN_FILE);
        // hide admin bar front-end

        add_action('wp_enqueue_scripts', array(get_called_class(), 'enqueue_scripts'));
        // withdrawal
        // earning - user meta
    }
    private static function enqueue_react_libraries()
    {
        wp_enqueue_script('react', self::$plugin_url . "assets/js/react.production.min.js", array(), null, true);
        wp_enqueue_script('react-dom', self::$plugin_url . "assets/js/react-dom.production.min.js", array(), null, true);
        wp_enqueue_script('react-router-dom', self::$plugin_url . "assets/js/react-router-dom.min.js", array(), null, true);
        // wp_enqueue_script('redux', self::$plugin_url . "assets/js/redux.min.js", array(), null, true);
        // wp_enqueue_script('react-redux', self::$plugin_url . "assets/js/react-redux.min.js", array(), null, true);
        // wp_enqueue_script('redux-thunk', self::$plugin_url . "assets/js/redux-thunk.min.js", array(), null, true);
        // wp_enqueue_script('qs', self::$plugin_url . "assets/js/qs.js", array(), null, true);
        // wp_enqueue_script('axios', self::$plugin_url . "assets/js/axios.min.js", array(), null, true);

        // for submit page only
        // wp_enqueue_script('Sortable', self::$plugin_url . "assets/js/Sortable.min.js", array(), null, true);
        // wp_enqueue_script('react-sortable', self::$plugin_url . "assets/js/react-sortable.min.js", array(), null, true);
    }
    private static function enqueue_redux_libraries()
    {
        
        wp_enqueue_script('redux', self::$plugin_url . "assets/js/redux.min.js", array(), null, true);
        wp_enqueue_script('react-redux', self::$plugin_url . "assets/js/react-redux.min.js", array(), null, true);
        wp_enqueue_script('redux-thunk', self::$plugin_url . "assets/js/redux-thunk.min.js", array(), null, true);
        wp_enqueue_script('qs', self::$plugin_url . "assets/js/qs.js", array(), null, true);
        wp_enqueue_script('axios', self::$plugin_url . "assets/js/axios.min.js", array(), null, true);

    }
    public static function enqueue_scripts()
    {
        global $wp_query;
        // global $post;
        wp_enqueue_style('mb-YTPlayer', self::$plugin_url . "assets/vendors/jquery.mb.YTPlayer/jquery.mb.YTPlayer.min.css", false);
        // wp_enqueue_style( 'daterangepicker-css', self::$plugin_url ."assets/css/daterangepicker.css", array(  ), null );
        // wp_enqueue_style('select2', self::$plugin_url . "assets/css/select2.min.css", false);
        // wp_enqueue_style( 'jscrollpane' , self::$plugin_url ."assets/css/jquery.jscrollpane.css", false );
        if ( is_page(esb_addons_get_wpml_option('dashboard_page')) || is_page(esb_addons_get_wpml_option('submit_page')) || is_page(esb_addons_get_wpml_option('edit_page')) ) {
            wp_enqueue_style('homeradar-addons-dashboard', self::$plugin_url . "assets/css/homeradar-dashboard.min.css", false);
            wp_style_add_data( 'homeradar-addons-dashboard', 'rtl', 'replace' );
        }
        wp_enqueue_style('homeradar-addons', self::$plugin_url . "assets/css/homeradar-add-ons.min.css", false);
        wp_style_add_data( 'homeradar-addons', 'rtl', 'replace' );
        
        if (homeradar_addons_get_option('azp_css_external') == 'yes') {
            $upload     = wp_upload_dir();
            $upload_url = $upload['baseurl'];
            wp_enqueue_style('listing_types', $upload_url . "/azp/css/listing_types.css", false);
        } else {
            $azp_csses = Esb_Class_Listing_Type_CPT::get_azp_css();
            wp_add_inline_style('homeradar-addons', $azp_csses);
        }

        wp_enqueue_script('homeradar-addons-plugins', self::$plugin_url . "assets/js/plugins.js", array(), null, true);
        // wp_enqueue_script( 'backbone.marionette', $this->plugin_url ."assets/js/backbone.marionette.min.js" , array('jquery','backbone','underscore'), null , true );
        // wp_enqueue_script( 'jquery.selectbox', $this->plugin_url ."assets/js/jquery.selectbox.min.js" , array(), null , true );
        // wp_enqueue_script("moment-js", self::$plugin_url . "assets/js/moment.min.js", array(), null, true);
        // wp_enqueue_script("daterangepicker-js", self::$plugin_url ."assets/js/daterangepicker.js" , array(), null , true);
        // wp_enqueue_script('select2', self::$plugin_url . "assets/js/select2.min.js", array('jquery'), null, true);
        // wp_enqueue_script('mousewheel', self::$plugin_url . "assets/js/jquery.mousewheel.js", array(), null, true);
        // wp_enqueue_script( 'jscrollpane', self::$plugin_url ."assets/js/jquery.jscrollpane.min.js" , array(), null , true );
        $map_provider = homeradar_addons_get_option('map_provider');
        $gmap_api_key        = homeradar_addons_get_option('gmap_api_key');
        $google_map_language = homeradar_addons_get_option('google_map_language') ? '&language=' . homeradar_addons_get_option('google_map_language') : '';


        if (homeradar_addons_must_enqueue_media()) {
            wp_enqueue_media();
        }

        // wp_enqueue_script('chart.js', self::$plugin_url . "assets/js/Chart.js", array(), null, true);
        // https://make.wordpress.org/core/2018/11/09/new-javascript-i18n-support-in-wordpress/
        wp_enqueue_script('homeradar-addons', self::$plugin_url . "assets/js/homeradar-add-ons.min.js", array( 'underscore', 'masonry', 'jquery-ui-sortable'), null, true);

        // AIzaSyChCXNJOoVajjJ1KvF3g0kq63yb5KQLPMA

        // wp_enqueue_script( 'homeradar-app', self::$plugin_url ."assets/js/homeradar-app.js" , array('backbone.marionette','jquery.selectbox','homeradar-gmap'), null , true );

        $gmap_marker    = homeradar_addons_get_option('gmap_marker');
        $curr_user_data = array(
            'id'           => 0,
            'display_name' => '',
            'avatar'       => '',
            'can_upload'   => false,

            'role'         => false,
            'is_author'    => false,
        );

        if (is_user_logged_in()) {
            $current_user   = wp_get_current_user();
            $curr_user_data = array(
                'id'           => $current_user->ID,
                'display_name' => $current_user->display_name,
                'avatar'       => get_avatar($current_user->user_email, '150', 'https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $current_user->display_name),

                'can_upload'   => current_user_can('upload_files'),
                'role'         => homeradar_addons_get_user_role(),
                'is_author'    => Esb_Class_Membership::is_author(),
                // 'is_author'         => true,
            );
        }
        $checkout_page_id = esb_addons_get_wpml_option('checkout_page');
        $_homeradar_add_ons = array(
            'url'                  => esc_url(admin_url('admin-ajax.php')),
            'nonce'                => wp_create_nonce('homeradar-add-ons'),
            'posted_on'            => __('Posted on ', 'homeradar-add-ons'),
            'reply'                => __('Reply', 'homeradar-add-ons'),
            'retweet'              => __('Retweet', 'homeradar-add-ons'),
            'favorite'             => __('Favorite', 'homeradar-add-ons'),
            'pl_w'                 => __('Please wait...', 'homeradar-add-ons'),
            'like'                 => esc_html__('Like', 'homeradar-add-ons'),
            'unlike'               => esc_html__('Unlike', 'homeradar-add-ons'),
            
            'use_dfmarker'         => homeradar_addons_get_option('use_dfmarker') == 'yes' ? true : false,
            'hide_mkprice'         => homeradar_addons_get_option('hide_mkprice') == 'yes' ? true : false,
            'marker'               => !empty( $gmap_marker['id'] )? wp_get_attachment_url($gmap_marker['id']) : ESB_DIR_URL . "assets/images/marker.png",
            'center_lat'           => floatval(homeradar_addons_get_option('gmap_default_lat')),
            'center_lng'           => floatval(homeradar_addons_get_option('gmap_default_long')),
            'map_zoom'             => homeradar_addons_get_option('gmap_default_zoom'),
            'socials'              => homeradar_addons_get_socials_list(),
            'gmap_type'            => homeradar_addons_get_option('gmap_type'),
            'login_delay'          => homeradar_addons_get_option('login_delay'),
            // 'files'                => homeradar_addons_cont_fiels_select(),
            // 'features'             => homeradar_addons_get_listing_features(),
            'listing_type_opts'    => Esb_Class_Membership::author_listing_types(),
            'chatbox_message'      => homeradar_addons_get_option('chatbox_message'),
            // 'submit_timezone_hide' => homeradar_addons_get_option('submit_timezone_hide'),
            // 'working_days'         => Esb_Class_Date::week_days(),
            // 'working_hours'        => Esb_Class_Date::wkhours_select(),
            // 'timezones'            => homeradar_addons_generate_timezone_list(),
            // 'timezone'             => get_option('timezone_string', 'Europe/London'),
            'post_id'              => get_queried_object_id(),
            'ckot_url'             => esc_url(get_permalink($checkout_page_id)),

            'location_type'        => homeradar_addons_get_option('listing_location_result_type'),
            'autocomplete_result_type' => homeradar_addons_get_option('autocomplete_result_type', 'none'),
            'address_format'       => array_filter(explode(",", homeradar_addons_get_option('listing_address_format'))),
            'country_restrictions' => homeradar_addons_get_option('country_restrictions'),

            'place_lng'            => homeradar_addons_get_option('google_map_language') ? homeradar_addons_get_option('google_map_language') : '',

            'disable_bubble'       => homeradar_addons_get_option('disable_bubble', 'no'),

            // 'filter_subcats'    => homeradar_addons_get_option('search_load_subcat'),

            'lb_approved'          => __('Approved', 'homeradar-add-ons'),

            'lb_24h'               => homeradar_addons_get_option('booking_clock_24h') == 'yes' ? true : false,
            'td_color'             => homeradar_addons_get_option('time_picker_color'),
            'lb_delay'             => homeradar_addons_get_option('add_cart_delay'),
            'md_limit'             => homeradar_addons_get_option('submit_media_limit'),
            'md_limit_msg'         => sprintf(__('Max upload files is %s', 'homeradar-add-ons'), homeradar_addons_get_option('submit_media_limit')),
            'md_limit_size'        => homeradar_addons_get_option('submit_media_limit_size'),
            'md_limit_size_msg'    => sprintf(__('Max upload file size is %s MB', 'homeradar-add-ons'), homeradar_addons_get_option('submit_media_limit_size')),

            'search'               => __('Search...', 'homeradar-add-ons'),

            'gcaptcha'             => (homeradar_addons_get_option('enable_g_recaptcah') == 'yes' && homeradar_addons_get_option('g_recaptcha_site_key') != '') ? true : false,
            'gcaptcha_key'         => homeradar_addons_get_option('g_recaptcha_site_key'),
            'location_show_state'  => homeradar_addons_get_option('location_show_state'),
            'weather_unit'          => homeradar_addons_get_option('weather_unit', 'metric'),
            'weather_strings'      => array(
                'days'      => array(
                    _x('Sunday', 'weather widget', 'homeradar-add-ons'),
                    _x('Monday', 'weather widget', 'homeradar-add-ons'),
                    _x('Tuesday', 'weather widget', 'homeradar-add-ons'),
                    _x('Wednesday', 'weather widget', 'homeradar-add-ons'),
                    _x('Thursday', 'weather widget', 'homeradar-add-ons'),
                    _x('Friday', 'weather widget', 'homeradar-add-ons'),
                    _x('Saturday', 'weather widget', 'homeradar-add-ons'),
                ),
                'min'       => _x('Min', 'weather widget', 'homeradar-add-ons'),
                'max'       => _x('Max', 'weather widget', 'homeradar-add-ons'),
                'direction' => array(
                    _x('N', 'wind direction', 'homeradar-add-ons'),
                    _x('NNE', 'wind direction', 'homeradar-add-ons'),
                    _x('NE', 'wind direction', 'homeradar-add-ons'),
                    _x('ENE', 'wind direction', 'homeradar-add-ons'),
                    _x('E', 'wind direction', 'homeradar-add-ons'),
                    _x('ESE', 'wind direction', 'homeradar-add-ons'),
                    _x('SE', 'wind direction', 'homeradar-add-ons'),
                    _x('SSE', 'wind direction', 'homeradar-add-ons'),
                    _x('S', 'wind direction', 'homeradar-add-ons'),
                    _x('SSW', 'wind direction', 'homeradar-add-ons'),
                    _x('SW', 'wind direction', 'homeradar-add-ons'),
                    _x('WSW', 'wind direction', 'homeradar-add-ons'),
                    _x('W', 'wind direction', 'homeradar-add-ons'),
                    _x('WNW', 'wind direction', 'homeradar-add-ons'),
                    _x('NW', 'wind direction', 'homeradar-add-ons'),
                    _x('NNW', 'wind direction', 'homeradar-add-ons'),
                ),
            ),
            'i18n'                 => array(
                'share_on'              => __('Share this on {SOCIAL}', 'homeradar-add-ons'),
                'del-listing'           => __("Are you sure want to delete {{listing_title}} listing and its data?\nThe listing is permanently deleted.", 'homeradar-add-ons'),
                'cancel-booking'        => __("Are you sure want to cancel {{booking_title}} booking?", 'homeradar-add-ons'),
                'approve-booking'       => __("Are you sure want to approve {{booking_title}} booking?", 'homeradar-add-ons'),
                'del-booking'           => __("Are you sure want to delete {{booking_title}} booking and its data?\nThe booking is permanently deleted.", 'homeradar-add-ons'),
                'del-message'           => __("Are you sure want to cancel {{message_title}} message?", 'homeradar-add-ons'),
                'chats_h3'              => __('Inbox', 'homeradar-add-ons'),
                'chat_fr_owner'         => __('Chat With Owner', 'homeradar-add-ons'),
                'chat_fr_login'         => __('Login to chat', 'homeradar-add-ons'),
                'chat_fr_cwith'         => __('Chat with ', 'homeradar-add-ons'),
                'chat_fr_conver'        => __('Conversations', 'homeradar-add-ons'),
                'change_pas_h3'         => __(' Change Password', 'homeradar-add-ons'),
                'change_pas_lb_CP'      => __('Current Password', 'homeradar-add-ons'),
                'change_pas_lb_NP'      => __('New Password', 'homeradar-add-ons'),
                'change_pas_lb_CNP'     => __('Confirm New Password', 'homeradar-add-ons'),

                'inner_chat_op_W'       => __('Week', 'homeradar-add-ons'),
                'inner_chat_op_M'       => __('Month', 'homeradar-add-ons'),
                'inner_chat_op_Y'       => __('Year', 'homeradar-add-ons'),

                'inner_listing_li_E'    => __('Edit ', 'homeradar-add-ons'),
                'inner_listing_li_D'    => __('Delete ', 'homeradar-add-ons'),

                'author_review_h3'      => __('Reviews for your listings', 'homeradar-add-ons'),

                'likebtn'               => __('Like Button', 'homeradar-add-ons'),
                'welcome'               => __('Welcome', 'homeradar-add-ons'),
                'listings'              => __('Listings', 'homeradar-add-ons'),
                'bookings'              => __('Bookings', 'homeradar-add-ons'),
                'reviews'               => __('Reviews', 'homeradar-add-ons'),
                'log_out'               => __('Log Out ', 'homeradar-add-ons'),
                'add_hour'              => __('Add Hour', 'homeradar-add-ons'),
                // 'timezone'              => __('Timezone', 'homeradar-add-ons'),

                'book_dates'            => __('Dates', 'homeradar-add-ons'),
                'book_services'         => __('Extra Services', 'homeradar-add-ons'),
                'book_ad'               => __('ADULTS', 'homeradar-add-ons'),
                'book_chi'              => __('CHILDREN', 'homeradar-add-ons'),
                'book_avr'              => __('Available Rooms', 'homeradar-add-ons'),
                'book_ts'               => __('Total Cost', 'homeradar-add-ons'),
                'book_chev'             => __('Check availability', 'homeradar-add-ons'),
                'book_bn'               => __('Book Now', 'homeradar-add-ons'),
                'checkout_can'          => __('Cancel', 'homeradar-add-ons'),
                'checkout_app'          => __('Apply', 'homeradar-add-ons'),
                'roomsl_avai'           => __('Available:', 'homeradar-add-ons'),
                'roomsl_maxg'           => __('Max Guests: ', 'homeradar-add-ons'),
                'roomsl_quan'           => __('Quantity', 'homeradar-add-ons'),

                'btn_save'              => __('Save Change', 'homeradar-add-ons'),
                'btn_save_c'            => __('Save Changes', 'homeradar-add-ons'),
                'btn_close'             => __('Close me', 'homeradar-add-ons'),
                'btn_send'              => __('Send Listing', 'homeradar-add-ons'),

                'btn_add_F'             => __('Add Fact', 'homeradar-add-ons'),
                'fact_title'            => __('Fact Title', 'homeradar-add-ons'),
                'fact_number'           => __('Fact Number', 'homeradar-add-ons'),
                'fact_icon'             => __('Fact Icon', 'homeradar-add-ons'),
                'location_country'      => __('Country', 'homeradar-add-ons'),
                'location_state'        => __('State', 'homeradar-add-ons'),
                'location_city'         => __('City', 'homeradar-add-ons'),

                'faq_title'             => __('Question', 'homeradar-add-ons'),
                'faq_content'           => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'homeradar-add-ons'),
                'btn_add_Faq'           => __('Add FAQ', 'homeradar-add-ons'),

                'btn_add_S'             => __('Add Social', 'homeradar-add-ons'),
                'btn_add_R'             => __('Add Room', 'homeradar-add-ons'),
                'btn_add_N'             => __('Add New', 'homeradar-add-ons'),

                'image_upload'          => __(' Click here to upload', 'homeradar-add-ons'),

                'btn_send'              => __('Send', 'homeradar-add-ons'),

                'th_mount'              => __('Amount', 'homeradar-add-ons'),
                'th_method'             => __('Method', 'homeradar-add-ons'),
                'th_to'                 => __('To', 'homeradar-add-ons'),
                'th_date'               => __('Date Submitted', 'homeradar-add-ons'),
                'th_status'             => __('Status', 'homeradar-add-ons'),
                'calendar_dis_number'   => __('Select the number of months displayed.', 'homeradar-add-ons'),
                'calendar_number_one'   => __('One Months', 'homeradar-add-ons'),
                'calendar_number_two'   => __('Two Months', 'homeradar-add-ons'),
                'calendar_number_three' => __('Three Months', 'homeradar-add-ons'),
                'calendar_number_four'  => __('Four Months', 'homeradar-add-ons'),
                'calendar_number_five'  => __('Five Months', 'homeradar-add-ons'),
                'calendar_number_six'   => __('Six Months', 'homeradar-add-ons'),
                'calendar_number_seven' => __('Seven Months', 'homeradar-add-ons'),
                'coupon_code'           => __('Coupon code', 'homeradar-add-ons'),
                'coupon_discount'       => __('Discount type', 'homeradar-add-ons'),
                'coupon_percentage'     => __('Percentage discount', 'homeradar-add-ons'),
                'coupon_fix_cart'       => __('Fixed cart discount', 'homeradar-add-ons'),
                'coupon_desc'           => __('Description', 'homeradar-add-ons'),
                'coupon_show'           => __('Display content in widget banner?', 'homeradar-add-ons'),
                'coupon_amount'         => __('Discount amount', 'homeradar-add-ons'),
                'coupon_qtt'            => __('Coupon quantity', 'homeradar-add-ons'),
                'coupon_expiry'         => __('Coupon expiry date', 'homeradar-add-ons'),
                'coupon_format'         => __('Format:YY-mm-dd HH:ii:ss', 'homeradar-add-ons'),

                'bt_coupon'             => __('Add Coupon', 'homeradar-add-ons'),
                'bt_services'           => __('Add Service', 'homeradar-add-ons'),
                'services_name'         => __('Service Name', 'homeradar-add-ons'),
                'services_desc'         => __('Description', 'homeradar-add-ons'),
                'services_price'        => __('Service Price', 'homeradar-add-ons'),
                'bt_member'             => __('Add Member', 'homeradar-add-ons'),
                'member_name'           => __('Name: ', 'homeradar-add-ons'),
                'member_job'            => __('Job or Position: ', 'homeradar-add-ons'),
                'member_desc'           => __('Description', 'homeradar-add-ons'),
                'member_img'            => __('Image', 'homeradar-add-ons'),
                'memeber_social'        => __('Socials', 'homeradar-add-ons'),
                'member_url'            => __('Website', 'homeradar-add-ons'),

                'days'                  => cth_get_week_days(),
                'months'                => array(
                    _x('{YEAR} January', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} February', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} March', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} April', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} May', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} June', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} July', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} August', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} September', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} October', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} November', 'calendar', 'homeradar-add-ons'),
                    _x('{YEAR} December', 'calendar', 'homeradar-add-ons'),
                ),
                // earnings
                'earnings_title'        => __('Your Earnings', 'homeradar-add-ons'),
                'th_date_'              => __('Date', 'homeradar-add-ons'),
                'th_total_'             => __('Total', 'homeradar-add-ons'),
                'th_fee_'               => __('Author Fee', 'homeradar-add-ons'),
                'th_earning_'           => __('Earning', 'homeradar-add-ons'),
                'th_order_'             => __('Order', 'homeradar-add-ons'),
                'go_back'               => __('Go back', 'homeradar-add-ons'),
                'no_earning'            => __('You have no earning.', 'homeradar-add-ons'),
                'th_vat_ser'            => __( 'VAT - Services', 'homeradar-add-ons' ),
                
                'cancel'                => __('Cancel', 'homeradar-add-ons'),
                'submit'                => __('Submit', 'homeradar-add-ons'),

                'ltype_title'           => _x('Listing type', 'Listing type', 'homeradar-add-ons'),
                'ltype_desc'            => _x('Listing type description', 'Listing type', 'homeradar-add-ons'),
                'wkh_enter'             => _x('Enter Hours', 'Working hour', 'homeradar-add-ons'),
                'wkh_open'              => _x('Open all day', 'Working hour', 'homeradar-add-ons'),
                'wkh_close'             => _x('Close all day', 'Working hour', 'homeradar-add-ons'),
                'calen_lock'            => _x('Lock this month', 'Calendar', 'homeradar-add-ons'),
                'calen_unlock'          => _x('Unlock this month', 'Calendar', 'homeradar-add-ons'),

                'smwdtitle'             => __('Submit a withdrawal request', 'homeradar-add-ons'),
                'wdfunds'               => __('Withdraw funds', 'homeradar-add-ons'),
                'goearnings'            => __('View Earnings', 'homeradar-add-ons'),

                'chat_type_msg'         => __('Type Message', 'homeradar-add-ons'),

                'save'                  => __('Save', 'homeradar-add-ons'),
                'cal_event_start'       => __('Event start time: ', 'homeradar-add-ons'),
                'cal_event_end'         => __('Event end date: ', 'homeradar-add-ons'),
                'cal_opts'              => __('Options', 'homeradar-add-ons'),

                'wth_payments'          => __('PayPal / Stripe Email', 'homeradar-add-ons'),
                'wth_amount'            => __('Amount ', 'homeradar-add-ons'),
                'wth_plh_email'         => __('email@gmail.com', 'homeradar-add-ons'),
                'wth_acount_balance'    => __('Account Balance', 'homeradar-add-ons'),
                'wth_will_process'      => __('Your request will be processed on {DATE}', 'homeradar-add-ons'),
                'wth_no_request'        => __('You have no withdrawal request', 'homeradar-add-ons'),
                'wth_min_str'        => _x('The minimum withdrawal amount is {amount}','Dashboard', 'homeradar-add-ons'),
                'wth_max_str'        => _x('The maximum withdrawal amount is {amount}','Dashboard', 'homeradar-add-ons'),
                'wth_bank_iban'        => _x('IBAN','Withdrawal - Bank transfer', 'homeradar-add-ons'),
                'wth_bank_account'        => _x('ACOUNT','Withdrawal - Bank transfer', 'homeradar-add-ons'),
                'wth_bank_name'        => _x('NAME','Withdrawal - Bank transfer', 'homeradar-add-ons'),
                'wth_bank_bname'        => _x('Bank Name','Withdrawal - Bank transfer', 'homeradar-add-ons'),
                'wth_enter_email'        => _x('Please enter a correct email address.','Withdrawal - Bank transfer', 'homeradar-add-ons'),
                
                'bt_slots'              => __('Add Time Slot', 'homeradar-add-ons'),
                'slot_time'             => __('Time', 'homeradar-add-ons'),
                'slot_guests'           => __('Guests', 'homeradar-add-ons'),
                'slot_available'        => __('Available slots', 'homeradar-add-ons'),

                'no_ltype'              => __('There is no listing type. Please contact to site owner for more details.', 'homeradar-add-ons'),
                'ltype_select_guide'    => __('Click to change listing type', 'homeradar-add-ons'),

                'bt_add_menu'           => __('Add Menu', 'homeradar-add-ons'),
                'menu_name'             => __('Menu Name', 'homeradar-add-ons'),
                'menu_cats'             => __('Menu Types (comma separated)', 'homeradar-add-ons'),
                'menu_desc'             => __('Menu Description', 'homeradar-add-ons'),
                'menu_price'            => __('Menu Price', 'homeradar-add-ons'),
                'menu_url'              => __('Menu Link', 'homeradar-add-ons'),
                'menu_photos'           => __('Menu Photos', 'homeradar-add-ons'),


                'headm_iframe'          => _x('iFrame Source', 'Submit page', 'homeradar-add-ons'),
                'headm_mp4'             => _x('MP4 Video', 'Submit page', 'homeradar-add-ons'),
                'headm_youtube'         => _x('Youtube Video ID', 'Submit page', 'homeradar-add-ons'),
                'headm_vimeo'           => _x('Vimeo Video ID', 'Submit page', 'homeradar-add-ons'),
                'headm_bgimg'           => _x('Background Image', 'Submit page', 'homeradar-add-ons'),
                'preview_btn'           => __('Preview', 'homeradar-add-ons'),
                'add_listing'           => __('Add Listing', 'homeradar-add-ons'),
                'edit_listing'           => __('Edit Listing', 'homeradar-add-ons'),

                'add_room'              => __('Add Room', 'homeradar-add-ons'),
                'edit_room'             => __('Edit Room', 'homeradar-add-ons'),
                'nights'                 => __('Nights', 'homeradar-add-ons'),
                'slots_add'             => __( 'Add Slot', 'homeradar-add-ons' ),
                'slots_guests'             => __( 'Max Guests', 'homeradar-add-ons' ),
                'slots_start'             => __( 'Start time', 'homeradar-add-ons' ),
                'slots_end'             => __( 'End time', 'homeradar-add-ons' ),
                'slots_price'             => __( 'Price', 'homeradar-add-ons' ),

                'raselect_placeholder'             => __( 'Select', 'homeradar-add-ons' ),
                'raselect_nooptions'             => __( 'No options', 'homeradar-add-ons' ),

                'cal_bulkedit'             => __( 'Bulk Edit', 'homeradar-add-ons' ),
                'save_bulkedit'            => __( 'Save', 'homeradar-add-ons' ),
                'cancel_bulkedit'            => __( 'Cancel', 'homeradar-add-ons' ),

                'adults'                => __('Adults', 'homeradar-add-ons'),
                'children'              => __('Children', 'homeradar-add-ons'),

                'AM'                            => _x( 'AM', 'Time picker AM', 'homeradar-add-ons' ),
                'PM'                            => _x( 'PM', 'Time picker PM', 'homeradar-add-ons' ),
                'evt_start'                            => _x( 'Start', 'Submit page', 'homeradar-add-ons' ),
                'evt_end'                            => _x( 'End', 'Submit page', 'homeradar-add-ons' ),

                // 'tslots'                            => _x( 'Time Slots', 'Time Slot', 'homeradar-add-ons' ),
                'no_slots'                            => _x( 'There is no available slot. Select another date.', 'Time Slot', 'homeradar-add-ons' ),
                'slots_avai'                            => _x( '{slots} slots available', 'Time Slot', 'homeradar-add-ons' ),
                // tickets
                'no_tickets'                          => _x( 'There is no available tickets. Select another date.', 'Booking form', 'homeradar-add-ons' ),
                'tickets_required'                    => _x( 'You need select a ticket', 'Booking form', 'homeradar-add-ons' ),
                'no_rooms'                            => _x( 'There is no room available in the selected period. Please select another period then click on Check availability button', 'Booking form', 'homeradar-add-ons' ),
                'no_rooms_init'                       => _x( 'Click on Check availability button to see available rooms', 'Booking form', 'homeradar-add-ons' ),
                'cal_clear_past'                      => _x( 'Clear old dates', 'Booking form', 'homeradar-add-ons' ),
                'field_required'                      => _x( '{SMFNAME} field is required. Please enter it value.', 'Submit listing', 'homeradar-add-ons' ),

                'floor_title'               => _x('Plan Title', 'Submit page', 'homeradar-add-ons'),
                'floor_size'                => _x('Plan Size', 'Submit page', 'homeradar-add-ons'),
                'floor_desc'                => _x('Plan Description', 'Submit page', 'homeradar-add-ons'),
                'floor_images'              => _x('Images', 'Submit page', 'homeradar-add-ons'),

                'header_bgimage'                    => _x('Background Image', 'Submit page', 'homeradar-add-ons'),
                'header_bgvideo'                    => _x('Background Video', 'Submit page', 'homeradar-add-ons'),
                'header_bgslider'                   => _x('Images Slider', 'Submit page', 'homeradar-add-ons'),
                'header_bgslideshow'                => _x('Background Slidshow', 'Submit page', 'homeradar-add-ons'),
                'header_map'                        => _x('Map', 'Submit page', 'homeradar-add-ons'),
                'header_streetview'                 => _x('Street View', 'Submit page', 'homeradar-add-ons'),
                'header_iframe'                     => _x('Embed iFrame', 'Submit page', 'homeradar-add-ons'),
                'header_choose'                     => _x('Select a type', 'Submit page', 'homeradar-add-ons'),
            ),

            'distance_df'          => homeradar_addons_get_option('distance_df'),
            'curr_user'            => $curr_user_data,

            

            'currency'             => homeradar_addons_get_currency_attrs(),
            'base_currency'        => homeradar_addons_get_base_currency(),

            

            // 'wpeditor'                      => homeradar_addons_get_wp_editor(),

            'wpml'                          => apply_filters( 'wpml_current_language', null ),

            'unfill_address'             => homeradar_addons_get_option('unfill_address'),
            'unfill_state'             => homeradar_addons_get_option('unfill_state'),
            'unfill_city'             => homeradar_addons_get_option('unfill_city'),
            'js_decimals'             => (int)homeradar_addons_get_option('decimals'),
            'map_provider'              => $map_provider,
            'mbtoken'                   => homeradar_addons_get_option('mapbox_token'),
            'week_starts_monday'                => homeradar_addons_get_option('week_starts_monday'),
            'withdrawal_date'                => (int)homeradar_addons_get_option('withdrawal_date'),
            'single_map_init'               => homeradar_addons_get_option('single_map_init', 'no'),
            'hide_cat_features'               => homeradar_addons_get_option('hide_cat_features', 'no'),
            'compare_max'                       => homeradar_addons_get_option('compare_max', '4'),
            'tag_dis_comma'                     => is_rtl() ? 'yes': 'no',
        );

        if( homeradar_addons_cookie_accepted() ){
            if( $map_provider == 'mapbox' ){
                wp_enqueue_style('mapbox-gl', "https://api.mapbox.com/mapbox-gl-js/v2.2.0/mapbox-gl.css", false);
                wp_enqueue_style('mapbox-gl-geocoder', "https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.7.0/mapbox-gl-geocoder.css", false);

                wp_enqueue_script('mapbox-gl', "https://api.mapbox.com/mapbox-gl-js/v2.2.0/mapbox-gl.js", array(), null, true);
                wp_enqueue_script('mapbox-gl-geocoder', "https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.7.0/mapbox-gl-geocoder.min.js", array(), null, true);
                
                // https://docs.mapbox.com/help/how-mapbox-works/geocoding/
                // https://docs.mapbox.com/mapbox-gl-js/example/mapbox-gl-geocoder
                wp_enqueue_script('es6-promise', "https://cdn.jsdelivr.net/npm/es6-promise@4/dist/es6-promise.min.js", array(), null, true);
                wp_enqueue_script('es6-promise-auto', "https://cdn.jsdelivr.net/npm/es6-promise@4/dist/es6-promise.auto.min.js", array(), null, true);

                wp_enqueue_script('homeradar-mapbox', self::$plugin_url . "assets/js/mapbox-map.js", array('homeradar-addons','mapbox-gl'), null, true);

            }else if( $map_provider == 'googlemap' ){
                wp_enqueue_script("googleapis", "https://maps.googleapis.com/maps/api/js?key=$gmap_api_key&libraries=places$google_map_language", array(), false, true);
                wp_enqueue_script('infobox', self::$plugin_url . "assets/js/infobox.js", array('googleapis'), null, true);
                wp_enqueue_script('markerclusterer', self::$plugin_url . "assets/js/markerclusterer.min.js", array('googleapis'), null, true);
                wp_enqueue_script('oms', self::$plugin_url . "assets/js/oms.min.js", array(), null, true);

                wp_enqueue_script('homeradar-gmap', self::$plugin_url . "assets/js/google-map.js", array('homeradar-addons','googleapis'), null, true);
            }else {
                wp_enqueue_style('openlayers', self::$plugin_url . "assets/css/ol.css", false);
                wp_enqueue_script('openlayers', self::$plugin_url . "assets/js/ol.js", array(), null, true);
                wp_enqueue_script('homeradar-osm', self::$plugin_url . "assets/js/osm-map.js", array('homeradar-addons','openlayers'), null, true);

            }
        }
            
        // if(is_singular('listing')){
        //     $_homeradar_add_ons['slid'] =
        // }
        if (homeradar_addons_must_enqueue_editor()) {
            wp_enqueue_editor();
        }

        self::enqueue_react_libraries();
        self::enqueue_redux_libraries();

        
        wp_enqueue_script('homeradar-react-app', self::$plugin_url . "assets/js/homeradar-react-app.min.js", array('homeradar-addons'), null, true);
        
        if( is_singular( 'listing' ) ){
            wp_enqueue_script('homeradar-single', self::$plugin_url . "assets/js/homeradar-single.min.js", array('homeradar-addons'), null, true);
            wp_enqueue_script('addevent', 'https://addevent.com/libs/atc/1.6.1/atc.min.js#cthasync#cthdefer', array(), null, true);


        }
        if( homeradar_addons_get_option('admin_chat') == 'yes' && homeradar_addons_get_option('show_fchat') == 'yes' ){
            wp_enqueue_script('homeradar-chat-app', self::$plugin_url . "assets/js/homeradar-chat-app.min.js", array('homeradar-addons'), null, true);
        }
        
        wp_localize_script('homeradar-addons', '_homeradar_add_ons', $_homeradar_add_ons);

        $_homeradar_dashboard = array(
            
            'i18n' => array(
                'inner_chat_op_W'    => __('Week', 'homeradar-add-ons'),
                'inner_chat_op_M'    => __('Month', 'homeradar-add-ons'),
                'inner_chat_op_Y'    => __('Year', 'homeradar-add-ons'),
                'chart_alltime'      => __('All time', 'homeradar-add-ons'),
                'chart_views_lbl'    => __('Listing Views', 'homeradar-add-ons'),
                'chart_earnings_lbl' => __('Earnings', 'homeradar-add-ons'),
                'chart_bookings_lbl' => __('Bookings', 'homeradar-add-ons'),

                'withdrawals'           => __( 'Withdrawals', 'homeradar-add-ons' ),
                'wth_notes'           => __( 'Additional Infos', 'homeradar-add-ons' ),

            ),

            'chart_hide_views'               => homeradar_addons_get_option('chart_hide_views') == 'yes' ? true : false,
            'chart_hide_earning'               => homeradar_addons_get_option('chart_hide_earning') == 'yes' ? true : false,
            'chart_hide_booking'               => homeradar_addons_get_option('chart_hide_booking') == 'yes' ? true : false,
            // nonce for rest api - Cookie Authentication
            // 'nonce' => wp_create_nonce( 'wp_rest' ),

            'payment'              => homeradar_addons_get_payments(),
            'withdrawal_min'        => (float)homeradar_addons_get_option('withdrawal_min'),

        );

        // for submit page
        if ( is_page(esb_addons_get_wpml_option('submit_page')) || is_page(esb_addons_get_wpml_option('edit_page')) ) {

            $_homeradar_submit = array(
                'submit_timezone_hide' => homeradar_addons_get_option('submit_timezone_hide'),
                'timezones'            => homeradar_addons_generate_timezone_list(),
                'timezone'             => get_option('timezone_string', 'Europe/London'),
                'working_days'         => Esb_Class_Date::week_days(),
                'working_hours'        => Esb_Class_Date::wkhours_select(),

                'features'             => homeradar_addons_get_listing_features(),
                
                'i18n'                 => array(
                    'timezone'              => __('Timezone', 'homeradar-add-ons'),
                ),
            );
            wp_enqueue_script('Sortable', self::$plugin_url . "assets/js/Sortable.min.js", array(), null, true);
            wp_enqueue_script('react-sortable', self::$plugin_url . "assets/js/react-sortable.min.js", array(), null, true);

            wp_enqueue_script('homeradar-submit', self::$plugin_url . "assets/js/homeradar-submit.min.js", array('homeradar-addons'), null, true);
            wp_localize_script('homeradar-submit', '_homeradar_submit', $_homeradar_submit);
        }


        


        

        wp_localize_script('homeradar-addons', '_homeradar_dashboard', $_homeradar_dashboard);

        // for dashboard page
        if ( is_page(esb_addons_get_wpml_option('dashboard_page')) ) {
            wp_enqueue_script('chart.js', self::$plugin_url . "assets/js/Chart.js", array(), null, true);
            wp_enqueue_script('homeradar-dashboard', self::$plugin_url . "assets/js/homeradar-dashboard.min.js", array('homeradar-addons'), null, true);
            // edit product
            $dashboard = get_query_var('dashboard');
            if( $dashboard == 'products' && !empty($_GET['edit']) ){
                wp_enqueue_script('homeradar-woo', self::$plugin_url . "assets/js/woo-product.js", array('homeradar-addons'), null, true);
            }
        }

        // if (function_exists('wp_set_script_translations')) {
        //     wp_set_script_translations('homeradar-addons', 'homeradar-add-ons');
        // }

        // if (function_exists('wp_set_script_translations')) {
        //     wp_set_script_translations('homeradar-react-app', 'homeradar-add-ons');
        // }

        // google reCAPTCHA - v2
        $withcaptcha = false;
        if ( false == Esb_Class_User::custom_log_reg() && homeradar_addons_get_option('enable_g_recaptcah') == 'yes' && homeradar_addons_get_option('g_recaptcha_site_key') != '' ) {
            wp_enqueue_script( 'google-recaptcha', "https://www.google.com/recaptcha/api.js?render=".homeradar_addons_get_option('g_recaptcha_site_key'), array('homeradar-addons'), null, true);
            // wp_enqueue_script( 'google-recaptcha', "https://www.google.com/recaptcha/api.js", array('homeradar-addons'), null, true);
            $withcaptcha = true;
        }

        // login modal script
        if( false == is_user_logged_in() ){
            if( $withcaptcha ){
                wp_enqueue_script('homeradar-logreg', self::$plugin_url . "assets/js/logreg-captcha.min.js", array('homeradar-addons', 'google-recaptcha'), null, true);
            }else{
                wp_enqueue_script('homeradar-logreg', self::$plugin_url . "assets/js/logreg.min.js", array('homeradar-addons'), null, true);
            }
        }

        // for Stripe payment
        if (is_page(esb_addons_get_wpml_option('checkout_page'))) {
            $pmdeps = (array)apply_filters( 'cth_payments_deps', array('jquery') );
            wp_enqueue_script('add-ons-payments', self::$plugin_url . "assets/js/payments.min.js", $pmdeps, null, true);
            $stripe_logo               = homeradar_addons_get_option('stripe_logo');
            $_homeradar_add_ons_payments = array(
                'site_title'      => get_bloginfo('name'),
                // 'site_desc'         => get_bloginfo('description'),
                'logo'            => $stripe_logo['url'],
                'publishable_key' => homeradar_addons_get_option('payments_test_mode') == 'yes' ? homeradar_addons_get_option('payments_stripe_test_public') : homeradar_addons_get_option('payments_stripe_live_public'),
                'currency_code'   => homeradar_addons_get_currency(),

                'one_time_text'   => __('Pay for {{plan}} plan', 'homeradar-add-ons'),
                'recurring_text'  => __('Subscription for {{plan}} plan', 'homeradar-add-ons'),
                'use_email'       => homeradar_addons_get_option('payments_stripe_use_email') == 'yes' ? true : false,

                // 'url'           => esc_url(admin_url( 'admin-ajax.php' ) ),
                // 'nonce'         => wp_create_nonce( 'homeradar-add-ons' ),

            );
            wp_localize_script('add-ons-payments', '_homeradar_add_ons_payments', $_homeradar_add_ons_payments);
        }
    }
}
Esb_Class_Frontend_Scripts::init();
