<?php
/* add_ons_php */

defined('ABSPATH') || exit;

// require_once ESB_ABSPATH . 'includes/class-cart-session.php';  

class Esb_Class_Compare
{
    private static $_instance;
    protected $_cookie_expiration;
    public static $datas = array();
    public function __construct()
    {
        $this->_cookie_expiration = date_i18n('U') + intval( apply_filters( 'esb_cart_expiration', 60 * 60 * 48 ) ); // 48 hours
        $this->init();
    }
    public static function getInstance() {
        if ( ! ( self::$_instance instanceof self ) ) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
    private function init(){
        add_action( 'wp_loaded', array($this, 'get_cookie') );
        // add_action( 'wp_loaded', array($this, 'parse_cart_details'), 20 );
        add_shortcode( 'listing_compare_page', array($this, 'shortcode') );
    }
    public function get_cookie(){
        if(isset($_COOKIE["cth-lcompare"])){
            $cookie_data = stripslashes($_COOKIE['cth-lcompare']);
            $datas = json_decode($cookie_data, true);
            if($datas != null) self::$datas = $datas; 
        }
    }
    public static function get_datas(){
        $datas = array();
        foreach (self::$datas as $com) {
            if( !empty($com['id']) ) $datas[] = $com['id'];
        }
        return $datas;
    }
    public static function is_added($id){
        $added = false;
        if( !empty($id) && in_array($id, self::get_datas()) ){
            $added = true;
        }
        return $added;
    }
    public function shortcode($atts, $content = ''){
        $compared = $this->get_datas();
        ob_start();
        ?>
        <!-- section -->
        <section class="gray-bg small-padding ">
            <div class="container">
                <?php 
                if( !empty($compared) && count($compared) >= 2 ): ?>
                <div class="compare-container fl-wrap">
                    
                    <div class="compare-counter"><?php echo sprintf(_nx( '<span>%d</span> Option', '<span>%d</span> Options', count($compared), 'Compare Options', 'homeradar-add-ons' ), count($compared) ); ?></div>
                    <div class="compare-header">
                        <?php homeradar_addons_get_template_part( 'templates-inner/compare', 'label' ); ?>
                    </div>
                    <?php 
                    $slider_args = array(
                        // 'simulateTouch'     => false,
                        'infinite'          => false,
                        'dots'              => false,
                        'arrows'            => false,
                        'variableWidth'     => true,
                    );
                    $breakpoints = array();
                    $slidesPerView = array();
                    $responsive = explode( ",", trim( '1920:4,768:2' ) );
                    if( !empty($responsive) ){
                        foreach ($responsive as $breakpoint) {
                            $breakpoint = explode( ":", trim($breakpoint) );
                            if( count($breakpoint) === 2 ){
                                $breakpoints[] = array( 'breakpoint' => intval($breakpoint[0]), 'settings' => array( 'slidesToShow'=>intval($breakpoint[1]) ) );
                                $slidesPerView[] = intval($breakpoint[1]);
                            }
                        }
                    }
                    if( !empty($breakpoints) ){
                        usort($breakpoints, function($a, $b) {
                            return $b['breakpoint'] - $a['breakpoint'];
                        });
                        $slider_args['slidesToShow'] = max($slidesPerView);
                        $slider_args['responsive'] = $breakpoints;
                    }
                    $slider_args['autoplay'] = false;
                    $slider_args['centerMode'] = false;
                    ?>
                    <div class="single-carousel carousel compare-slider" data-options='<?php echo json_encode($slider_args); ?>'>
                        <?php 

                        $post_args = array(
                            'post_type'         => 'listing',
                            'post__in'          => $compared,
                            'posts_per_page'    => -1,
                            'orderby'           => 'post__in',
                            'post_status'       => 'publish'
                        );
                        $query_posts = new WP_Query($post_args);
                        if( !empty($compared) && $query_posts->have_posts() ){
                            while ( $query_posts->have_posts() ) {
                                $query_posts->the_post(); 
                                homeradar_addons_get_template_part( 'templates-inner/compare', 'slide' );
                            }
                        }

                        wp_reset_postdata();
                        ?>
                    </div>
                    
                </div>
                <?php else: ?>
                    <div class="compare-message"><?php _e( 'You need to select at least two listings to compare.', 'homeradar-add-ons' ); ?></div>
                <?php endif; ?>
            </div>
        </section>
        <!-- section end-->
        <?php
        $output = ob_get_clean();

        return $output;
    }
}

Esb_Class_Compare::getInstance();


