<?php 
/* add_ons_php */

defined( 'ABSPATH' ) || exit; 
class Esb_Class_Ajax{ 

    public static function init(){ 
        $logged_in_ajax_actions = array(
            'lagent_get',
        );
        foreach ($logged_in_ajax_actions as $action) {
            $funname = str_replace('homeradar_addons_', '', $action);
            add_action('wp_ajax_'.$action, array( __CLASS__, $funname ));
        }
    }
    public static function verify_nonce($action_name = '', $datas = array() ){
        if (!isset($_REQUEST['_wpnonce']) || $action_name == '' || ! wp_verify_nonce( $_REQUEST['_wpnonce'], $action_name ) ){
            $result = array(
                'success'   => false,
                'error'     => esc_html__( 'Security checked!, Cheatn huh?', 'homeradar-add-ons' ),
                'data'      => array(
                    'error'     => esc_html__( 'Security checked!, Cheatn huh?', 'homeradar-add-ons' ),
                ),
            );

            if( !empty($datas) && is_array($datas) ){
                $result = array_merge($result, $datas);
            }

            wp_send_json( $result );
        }

    }

    public static function lagent_get(){
        $json = array(
            'success'   => false,
            'data'      => array(
                'POST'      => $_POST,
            ),
            // 'posts' => array(),
            // 'pagi' => array(),
            'debug'     => false,

        );

        // wp_send_json( $json );
        
        self::verify_nonce('homeradar-add-ons');

        $json['terms'] = get_posts( 
        array(
                    'post_type'         => 'lagent',
                    'posts_per_page'    => -1,
                    'post_status'       => 'publish',
                    'author'            => get_current_user_id(),
                    
                    'orderby' => 'date',
                    'order' => 'DESC'
                ) 
         );
        wp_send_json( $json );
    }

    


}
Esb_Class_Ajax::init();
