<?php
/* add_ons_php */

defined('ABSPATH') || exit;

class Esb_Class_Admin_Scripts
{

    private static $plugin_url;

    public static function init()
    {
        self::$plugin_url = plugin_dir_url(ESB_PLUGIN_FILE);

        add_action('admin_footer', array(get_called_class(), 'price_templates'));

        add_action('admin_enqueue_scripts', array(get_called_class(), 'enqueue_scripts'));
    }
    public static function price_templates()
    {
        ?>
        <script type="text/template" id="tmpl-content-addwidget">
            <?php homeradar_addons_get_template_part('templates-inner/add-widget');?>
        </script>
        <script type="text/template" id="tmpl-content-addwidgetfield">
            <?php homeradar_addons_get_template_part('templates-inner/add-widgetfield');?>
        </script>
        <script type="text/template" id="tmpl-currency">
            <?php homeradar_addons_get_template_part('templates-inner/add-currency');?>
        </script>
        <?php
// edit listing templates
        homeradar_addons_get_template_part('shortcodes/tmpls');
        // socials template
        homeradar_addons_get_template_part('shortcodes/tmpls-dashboard');
    }
    private static function enqueue_react_libraries()
    {
        wp_enqueue_script('react', self::$plugin_url . "assets/js/react.production.min.js", array(), null, true);
        wp_enqueue_script('react-dom', self::$plugin_url . "assets/js/react-dom.production.min.js", array(), null, true);
        wp_enqueue_script('react-router-dom', self::$plugin_url . "assets/js/react-router-dom.min.js", array(), null, true);
        wp_enqueue_script('redux', self::$plugin_url . "assets/js/redux.min.js", array(), null, true);
        wp_enqueue_script('react-redux', self::$plugin_url . "assets/js/react-redux.min.js", array(), null, true);
        wp_enqueue_script('redux-thunk', self::$plugin_url . "assets/js/redux-thunk.min.js", array(), null, true);
        wp_enqueue_script('qs', self::$plugin_url . "assets/js/qs.js", array(), null, true);
        wp_enqueue_script('axios', self::$plugin_url . "assets/js/axios.min.js", array(), null, true);
        wp_enqueue_script('Sortable', self::$plugin_url . "assets/js/Sortable.min.js", array(), null, true);
        wp_enqueue_script('react-sortable', self::$plugin_url . "assets/js/react-sortable.min.js", array(), null, true);
        wp_enqueue_script('jquery-scrolltofixed', self::$plugin_url . "assets/js/jquery-scrolltofixed-min.js", array(), null, true);

    }

    public static function enqueue_scripts($hook)
    {
        wp_enqueue_media();
        wp_enqueue_style('wp-color-picker');
        wp_enqueue_script('wp-color-picker');

        wp_enqueue_style('fontawesome-pro', self::$plugin_url . "assets/vendors/fontawesome-pro/css/all.min.css", false);
        wp_enqueue_style('select2', self::$plugin_url . 'assets/css/select2.min.css');
        wp_enqueue_style('homeradar-add-ons', self::$plugin_url . 'assets/css/admin.css');

        wp_enqueue_style('datetimepicker.jquery', self::$plugin_url . 'assets/admin/datetimepicker/jquery.datetimepicker.min.css');
        $map_provider = homeradar_addons_get_option('map_provider');
        $gmap_api_key = homeradar_addons_get_option('gmap_api_key');

        if( $map_provider == 'mapbox' ){
            wp_enqueue_style('mapbox-gl', "https://api.mapbox.com/mapbox-gl-js/v2.2.0/mapbox-gl.css", false);
            wp_enqueue_style('mapbox-gl-geocoder', "https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.7.0/mapbox-gl-geocoder.css", false);

            wp_enqueue_script('mapbox-gl', "https://api.mapbox.com/mapbox-gl-js/v2.2.0/mapbox-gl.js", array(), null, true);
            wp_enqueue_script('mapbox-gl-geocoder', "https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-geocoder/v4.7.0/mapbox-gl-geocoder.min.js", array(), null, true);
            // https://docs.mapbox.com/help/how-mapbox-works/geocoding/
            // https://docs.mapbox.com/mapbox-gl-js/example/mapbox-gl-geocoder
            wp_enqueue_script('es6-promise', "https://cdn.jsdelivr.net/npm/es6-promise@4/dist/es6-promise.min.js", array(), null, true);
            wp_enqueue_script('es6-promise-auto', "https://cdn.jsdelivr.net/npm/es6-promise@4/dist/es6-promise.auto.min.js", array(), null, true);

        }else if( $map_provider == 'googlemap' ){
            wp_enqueue_script("googleapis", "https://maps.googleapis.com/maps/api/js?key=$gmap_api_key&libraries=places", array(), false, true);
        }else {
            wp_enqueue_script('openlayers', self::$plugin_url . "assets/js/ol.js", array(), null, true);
        }


        wp_enqueue_script('select2', self::$plugin_url . 'assets/js/select2.min.js', array('jquery'), null, true);
        wp_enqueue_script('datetimepicker.jquery', self::$plugin_url . 'assets/admin/datetimepicker/jquery.datetimepicker.full.min.js', array('jquery'), null, true);

        wp_enqueue_script('homeradar-addons-admin', self::$plugin_url . 'assets/js/addons-admin.min.js', array('jquery', 'jquery-ui-sortable', 'select2', 'wp-i18n'), null, true);
        $curr_user_data = array(
            'id'           => 0,
            'display_name' => '',
            'avatar'       => '',
            'can_upload'   => false,
        );

        if (is_user_logged_in()) {
            $current_user   = wp_get_current_user();
            $curr_user_data = array(
                'id'           => $current_user->ID,
                'display_name' => $current_user->display_name,
                'avatar'       => get_avatar($current_user->user_email, '150', 'https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $current_user->display_name),

                'can_upload'   => current_user_can('upload_files'),
            );
        }
        $gmap_marker            = homeradar_addons_get_option('gmap_marker');
        $_homeradar_add_ons_admin = array(
            'center_lat' => floatval(homeradar_addons_get_option('gmap_default_lat')),
            'center_lng' => floatval(homeradar_addons_get_option('gmap_default_long')),
            'map_zoom'   => homeradar_addons_get_option('gmap_default_zoom'),
            'marker'     => $gmap_marker['url'] ? $gmap_marker['url'] : ESB_DIR_URL . "assets/images/marker.png",
            
        );
        wp_localize_script('homeradar-addons-admin', '_homeradar_add_ons_admin', $_homeradar_add_ons_admin);
        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('homeradar-addons-admin', 'homeradar-add-ons');
        }

        $screen = get_current_screen();
        if ($screen->base == 'post' && ($screen->post_type == 'listing_type' || $screen->post_type == 'listing' || $screen->post_type == 'lrooms' || $screen->post_type == 'product')) {
            wp_enqueue_editor();
            self::enqueue_react_libraries();
            $_homeradar_add_ons_adminapp = array(
                'i18n'         => array(
                    'profile'                   => __('Profile', 'homeradar-add-ons'),

                    'tab_general'               => __('General', 'homeradar-add-ons'),
                    'tab_fields'                => __('Fields', 'homeradar-add-ons'),
                    'tab_single'                => __('Single', 'homeradar-add-ons'),
                    'tab_cards'                 => __('Cards', 'homeradar-add-ons'),
                    'tab_filter'                => __('Filter', 'homeradar-add-ons'),
                    'tab_advanced'              => __('Advanced', 'homeradar-add-ons'),
                    'tab_advanced_schema'       => __('Schema Markup', 'homeradar-add-ons'),
                    'tab_advanced_settings'     => __('Settings', 'homeradar-add-ons'),
                    
                    'nav_title_L'               => __('Listing', 'homeradar-add-ons'),
                    'nav_title_R'               => __('Child Product', 'homeradar-add-ons'),
                    'nav_title_FB'              => __('Form Booking', 'homeradar-add-ons'),
                    'nav_title_Ra'              => __('Rating', 'homeradar-add-ons'),
                    'nav_title_Fi_L'            => __('Filter Listing', 'homeradar-add-ons'),
                    'nav_title_Fi_HS'           => __('Filter Hero Section', 'homeradar-add-ons'),
                    'nav_title_Fi_H'            => __('Filter Header', 'homeradar-add-ons'),

                    // Comp - inners - AddForm
                    'opt_val_choose'            => __('Chose...', 'homeradar-add-ons'),
                    'opt_val_input'             => __('Input', 'homeradar-add-ons'),
                    'opt_val_check'             => __('Checkbox', 'homeradar-add-ons'),
                    'opt_val_text'              => __('Textarea', 'homeradar-add-ons'),
                    'opt_val_Wysiwyg'           => __('Wysiwyg Editor', 'homeradar-add-ons'),
                    'opt_val_select'            => __('Select', 'homeradar-add-ons'),
                    'opt_val_radio'             => __('Radio', 'homeradar-add-ons'),
                    'opt_val_switch'            => __('Switch', 'homeradar-add-ons'),
                    'opt_val_img'               => __('Image', 'homeradar-add-ons'),
                    'opt_val_muti'              => __('Multiple select', 'homeradar-add-ons'),
                    'opt_val_number'            => __('Number', 'homeradar-add-ons'),

                    'opt_val_img'               => __('Image', 'homeradar-add-ons'),
                    // 'opt_val_img'               => __('Image', 'homeradar-add-ons'),
                    // 'opt_val_img'               => __('Image', 'homeradar-add-ons'),
                    // 'opt_val_img'               => __('Image', 'homeradar-add-ons'),
                    // 'opt_val_img'               => __('Image', 'homeradar-add-ons'),
                    // 'opt_val_img'               => __('Image', 'homeradar-add-ons'),

                    'lable_loca_Fi_SorG'        => __('Is Single Image', 'homeradar-add-ons'),
                    'lable_loca_Fi_C'           => __('Preview Columns', 'homeradar-add-ons'),
                    'label_image_limit'         => __( 'Limit', 'homeradar-add-ons' ),
                    // 'opt_val_N'        => __( 'None',  'homeradar-add-ons' ),
                    'opt_val_Y'                 => __('Yes', 'homeradar-add-ons'),
                    'opt_val_N'                 => __('No', 'homeradar-add-ons'),

                    // Comp - general
                    'label_title_icon'          => __('Icon', 'homeradar-add-ons'),
                    'label_title_singular_name' => __('Singular name (e.g.Business)', 'homeradar-add-ons'),
                    'label_title_plural_name'   => __('Plural name (e.g.Business)', 'homeradar-add-ons'),
                    'label_title_child_ptype'   => __('Choose custom post type for child products', 'homeradar-add-ons'),
                    // Label, H2, Span title
                    'title'                     => __('This is listing type General tab', 'homeradar-add-ons'),
                    'lable_title_S'             => __('Select Type', 'homeradar-add-ons'),
                    'lable_title_A'             => __('Add Listing Room', 'homeradar-add-ons'),
                    'lable_title_A_Fi'          => __('Add Field Rating', 'homeradar-add-ons'),

                    'lable_loca_T'              => __('TOP', 'homeradar-add-ons'),
                    'lable_loca_R'              => __('RIGHT', 'homeradar-add-ons'),
                    'lable_loca_B'              => __('BOTTOM', 'homeradar-add-ons'),
                    'lable_loca_L'              => __('LEFT', 'homeradar-add-ons'),

                    'lable_title_O'             => __('Option value', 'homeradar-add-ons'),

                    'lable_title_Fi_ID'         => __('Field ID', 'homeradar-add-ons'),
                    'lable_title_Fi_T'          => __('Field Title', 'homeradar-add-ons'),
                    'lable_title_Fi_N'          => __('Field Name', 'homeradar-add-ons'),
                    'lable_title_Fi_L'          => __('Field Label', 'homeradar-add-ons'),
                    'lable_title_Fi_I'          => __('Field Icon', 'homeradar-add-ons'),
                    'lable_title_Fi_D'          => __('Field Description', 'homeradar-add-ons'),
                    'lable_title_Fi_de'         => __('Default Value', 'homeradar-add-ons'),
                    'lable_title_Fi_ra_sy'      => __('Field Rating System', 'homeradar-add-ons'),
                    'lable_title_Fi_V'          => __('Field Value', 'homeradar-add-ons'),
                    'lable_title_Fi_Df_V'       => __('Default Value', 'homeradar-add-ons'),
                    'lable_title_Fi_W'          => __('Field Width', 'homeradar-add-ons'),
                    'lable_title_Fi_C'          => __('Field column', 'homeradar-add-ons'),
                    'lable_title_Fi_SorG'       => __('Field single or Gallery', 'homeradar-add-ons'),
                    'lable_title_Fi_Re'         => __('Required', 'homeradar-add-ons'),
                    'lable_title_Fi_admin'      => __('Show Dashboard Admin', 'homeradar-add-ons'),
                    'lable_title_Fi_dec_op'     => __('Hidden Description', 'homeradar-add-ons'),

                    'lable_title_TT'            => __('Title Text', 'homeradar-add-ons'),
                    'lable_title_TD'            => __('Title Description', 'homeradar-add-ons'),
                    'label_resmenu_limit'       => _x('Menus Limit', 'Listing Fields', 'homeradar-add-ons'),



                    'span_title_C'              => __(' Click here or drop files to upload', 'homeradar-add-ons'),
                    'span_title_Cl'             => __(' Click here to upload', 'homeradar-add-ons'),
                    'span_title_P'              => __('PX', 'homeradar-add-ons'),
                    'span_title_E'              => __('EM', 'homeradar-add-ons'),
                    'span_title_R'              => __('REM', 'homeradar-add-ons'),
                    'span_title_S'              => __(' Select images', 'homeradar-add-ons'),
                    'span_title'                => __('%', 'homeradar-add-ons'),

                    // Button
                    'btn_s'                     => __('Save', 'homeradar-add-ons'),
                    'btn_save'                  => __('Save Change', 'homeradar-add-ons'),
                    'btn_add_Fi'                => __('Add Field ', 'homeradar-add-ons'),
                    'btn_add_F'                 => __('Add Facts  ', 'homeradar-add-ons'),
                    'btn_add_R'                 => __('Add Room', 'homeradar-add-ons'),
                    'btn_add_S'                 => __('Add Social', 'homeradar-add-ons'),
                    'btn_add_O'                 => __('Add Option', 'homeradar-add-ons'),
                    'btn_link_V'                => __('Link values', 'homeradar-add-ons'),

                    'validate_error'            => __('was used by another field. Please try with other value.', 'homeradar-add-ons'),
                    'max_room'                  => __('Max Rooms', 'homeradar-add-ons'),
                    'template_erro'             => __('Template name must not be empty.', 'homeradar-add-ons'),
                    'template_save'             => __('Saved Page Templates', 'homeradar-add-ons'),
                    'template_append'           => __('Append previosly saved template to the current layout', 'homeradar-add-ons'),

                    'opt_lbl'                   => __('Label', 'homeradar-add-ons'),
                    'opt_val'                   => __('Value', 'homeradar-add-ons'),

                    'schema_name'               => __('Schema Name', 'homeradar-add-ons'),
                    'schema_value'              => __('Schema Value', 'homeradar-add-ons'),
                    'schema_use_listing'        => __('Use listing info', 'homeradar-add-ons'),
                    'room_add_text'             => __('Add Room text', 'homeradar-add-ons'),
                    'add_ticket_btn'           => __('Add button text', 'homeradar-add-ons'),
                    'ticket_name_title'           => __('Name field title', 'homeradar-add-ons'),
                    'ticket_price_title'           => __('Price field title', 'homeradar-add-ons'),
                    'ticket_desc_title'           => __('Description field title', 'homeradar-add-ons'),
                    'ticket_available_title'           => __('Available field title', 'homeradar-add-ons'),
                    'add_text_field_lbl'           => __('Add New Text', 'homeradar-add-ons'),


                ),
                // azp elements
                'azp_elements' => AZPElements::getEles(),
                'schema'       => homeradar_addons_schema_listing_metas(),
            );
            wp_enqueue_script('homeradar-react-adminapp', self::$plugin_url . "assets/js/homeradar-react-adminapp.min.js", array('underscore', 'homeradar-addons-admin'), null, true);
            wp_localize_script('homeradar-react-adminapp', '_homeradar_add_ons_adminapp', $_homeradar_add_ons_adminapp);
            //======================
            $listing_type_opts   = array();
            $listing_types_posts = get_posts(array(
                'post_type'      => 'listing_type',
                'posts_per_page' => -1,
                'post_status'    => 'publish',
                'fields'         => 'ids',

                // 'suppress_filters'  => false,
            ));
            if ($listing_types_posts) {
                foreach ($listing_types_posts as $ltid) {
                    $listing_type_opts[] = array(
                        'ID'          => $ltid,
                        'title'       => get_the_title($ltid),
                        'icon'        => '',
                        'description' => '',
                    );
                }
            }
            $room_type_opts = array(
                array(
                    'ID'    => '0',
                    'title' => __('Select a listing', 'homeradar-add-ons'),
                ),
            );
            $room_types_posts = get_posts(array(
                'post_type'      => 'listing',
                'posts_per_page' => -1,
                'post_status'    => 'publish',
                'fields'         => 'ids',

                // 'suppress_filters'  => false,
            ));
            if ($room_types_posts) {
                foreach ($room_types_posts as $ltid) {
                    $room_type_opts[] = array(
                        'ID'          => $ltid,
                        'title'       => get_the_title($ltid),
                        'icon'        => '',
                        'description' => '',
                    );
                }
            }
            $type_child_nth = array(array(
                'none' => 'None',
            ));
            // $room_pt          = get_post_type_object('lrooms');
            $type_child_nth[] = array(
                'lrooms' => __( 'Hotel Room', 'homeradar-add-ons' ), // $room_pt->labels->singular_name,
            );
            if (post_type_exists('product')) {
                // $product_pt       = get_post_type_object('product');
                $type_child_nth[] = array(
                    'product' => __( 'WooCommerce Product', 'homeradar-add-ons' ),  // $product_pt->labels->singular_name,
                );
            }
            $child_ptype = '';
            $child_pty   = get_post_meta(get_queried_object_id(), ESB_META_PREFIX . 'general_field_meta', true);
            if (!empty($child_pty) && $child_pty != '') {
                $child_ptype = $child_pty;
            }
            $gmap_marker      = homeradar_addons_get_option('gmap_marker');
            $_homeradar_add_ons = array(
                'url'                  => esc_url(admin_url('admin-ajax.php')),
                'nonce'                => wp_create_nonce('homeradar-add-ons'),
                // 'listing_types'                 => $listing_type_ids,
                'listing_type_opts'    => $listing_type_opts,
                'room_type_opts'       => $room_type_opts,
                'id_post'              => get_the_ID(),
                'curr_user'            => $curr_user_data,
                'socials'              => homeradar_addons_get_socials_list(),
                'marker'               => $gmap_marker['url'] ? $gmap_marker['url'] : self::$plugin_url . "assets/images/marker2.png",
                'center_lat'           => floatval(homeradar_addons_get_option('gmap_default_lat')),
                'center_lng'           => floatval(homeradar_addons_get_option('gmap_default_long')),
                'map_zoom'             => homeradar_addons_get_option('gmap_default_zoom'),
                
                // 'files'                => homeradar_addons_cont_fiels_select(),
                // 'features'             => homeradar_addons_get_listing_features(),
                'cats'                 => homeradar_addons_get_listing_cats(),
                'locs'                 => homeradar_addons_get_listing_locs(),
                'gmap_type'            => homeradar_addons_get_option('gmap_type'),
                // 'submit_timezone_hide' => homeradar_addons_get_option('submit_timezone_hide'),
                // 'working_days'         => Esb_Class_Date::week_days(),
                // 'working_hours'        => Esb_Class_Date::wkhours_select(),
                // 'timezones'            => homeradar_addons_generate_timezone_list(),
                // 'timezone'             => get_option('timezone_string', 'Europe/London'),
                'child_pt_title'       => $type_child_nth,
                'child_ptype'          => $child_ptype,
                'i18n'                 => array(
                    'btn_add_F'             => __('Add Fact', 'homeradar-add-ons'),
                    'fact_title'            => __('Fact Title', 'homeradar-add-ons'),
                    'fact_number'           => __('Fact Number', 'homeradar-add-ons'),
                    'fact_icon'             => __('Fact Icon', 'homeradar-add-ons'),
                    'slect_rtype'           => __('Select a listing', 'homeradar-add-ons'),

                    'faq_title'             => __('Question', 'homeradar-add-ons'),
                    'faq_content'           => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'homeradar-add-ons'),
                    'btn_add_Faq'           => __('Add FAQ', 'homeradar-add-ons'),
                    'btn_save'              => __('Save Change', 'homeradar-add-ons'),
                    
                    'btn_add_R'             => __('Add Room', 'homeradar-add-ons'),
                    'btn_add_Ame'           => __('Add Amenitie', 'homeradar-add-ons'),
                    'add_hour'              => __('Add Hour', 'homeradar-add-ons'),
                    // 'timezone'              => __('Timezone', 'homeradar-add-ons'),
                    'image_upload'          => __(' Click here to upload', 'homeradar-add-ons'),
                    // 'select_images'  => __( 'Select Images',  'homeradar-add-ons' ),
                    // 'select'  => __( 'Select',  'homeradar-add-ons' ),
                    
                    'btn_add_S'             => __('Add Social', 'homeradar-add-ons'),
                    'btn_add_N'             => __('Add New', 'homeradar-add-ons'),
                    'btn_save_c'            => __('Save Changes', 'homeradar-add-ons'),
                    'btn_close'             => __('Close me', 'homeradar-add-ons'),
                    'btn_send'              => __('Send Listing', 'homeradar-add-ons'),
                    'calendar_dis_number'   => __('Select the number of months displayed.', 'homeradar-add-ons'),
                    'calendar_number_one'   => __('One Months', 'homeradar-add-ons'),
                    'calendar_number_two'   => __('Two Months', 'homeradar-add-ons'),
                    'calendar_number_three' => __('Three Months', 'homeradar-add-ons'),
                    'calendar_number_four'  => __('Four Months', 'homeradar-add-ons'),
                    'calendar_number_five'  => __('Five Months', 'homeradar-add-ons'),
                    'calendar_number_six'   => __('Six Months', 'homeradar-add-ons'),
                    'calendar_number_seven' => __('Seven Months', 'homeradar-add-ons'),

                    'coupon_code'           => __('Coupon code', 'homeradar-add-ons'),
                    'coupon_discount'       => __('Discount type', 'homeradar-add-ons'),
                    'coupon_percentage'     => __('Percentage discount', 'homeradar-add-ons'),
                    'coupon_fix_cart'       => __('Fixed cart discount', 'homeradar-add-ons'),
                    'coupon_desc'           => __('Description', 'homeradar-add-ons'),
                    'coupon_show'           => __('Display content in widget banner?', 'homeradar-add-ons'),
                    'coupon_amount'         => __('Discount amount', 'homeradar-add-ons'),
                    'coupon_qtt'            => __('Coupon quantity', 'homeradar-add-ons'),
                    'coupon_expiry'         => __('Coupon expiry date', 'homeradar-add-ons'),
                    'coupon_format'         => __('Format:YY-mm-dd HH:ii:ss', 'homeradar-add-ons'),

                    'bt_coupon'             => __('Add Coupon', 'homeradar-add-ons'),
                    'bt_services'           => __('Add Service', 'homeradar-add-ons'),
                    'services_name'         => __('Service Name', 'homeradar-add-ons'),
                    'services_desc'         => __('Description', 'homeradar-add-ons'),
                    'services_price'        => __('Service Price', 'homeradar-add-ons'),
                    'bt_member'             => __('Add Member', 'homeradar-add-ons'),
                    'member_name'           => __('Name: ', 'homeradar-add-ons'),
                    'member_job'            => __('Job or Position: ', 'homeradar-add-ons'),
                    'member_desc'           => __('Description', 'homeradar-add-ons'),
                    'member_img'            => __('Image', 'homeradar-add-ons'),
                    'memeber_social'        => __('Socials', 'homeradar-add-ons'),
                    'member_url'            => __('Website', 'homeradar-add-ons'),

                    'days'                  => cth_get_week_days(),
                    'months'                => array(
                        _x('{YEAR} January', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} February', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} March', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} April', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} May', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} June', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} July', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} August', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} September', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} October', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} November', 'calendar', 'homeradar-add-ons'),
                        _x('{YEAR} December', 'calendar', 'homeradar-add-ons'),
                    ),
                    'ltype_title'           => _x('Listing type', 'Listing type', 'homeradar-add-ons'),
                    'ltype_desc'            => _x('Listing type description', 'Listing type', 'homeradar-add-ons'),
                    'wkh_enter'             => _x('Enter Hours', 'Working hour', 'homeradar-add-ons'),
                    'wkh_open'              => _x('Open all day', 'Working hour', 'homeradar-add-ons'),
                    'wkh_close'             => _x('Close all day', 'Working hour', 'homeradar-add-ons'),
                    'calen_lock'            => _x('Lock this month', 'Calendar', 'homeradar-add-ons'),
                    'calen_unlock'          => _x('Unlock this month', 'Calendar', 'homeradar-add-ons'),

                    'cancel'                => __('Cancel', 'homeradar-add-ons'),
                    'submit'                => __('Submit', 'homeradar-add-ons'),

                    'save'                  => __('Save', 'homeradar-add-ons'),
                    'cal_event_start'       => __('Event start time: ', 'homeradar-add-ons'),
                    'cal_event_end'         => __('Event end date: ', 'homeradar-add-ons'),
                    'cal_opts'              => __('Options', 'homeradar-add-ons'),

                    'bt_slots'              => __('Add Time Slot', 'homeradar-add-ons'),
                    'slot_time'             => __('Time', 'homeradar-add-ons'),
                    'slot_guests'           => __('Guests', 'homeradar-add-ons'),
                    'slot_available'        => __('Available slots', 'homeradar-add-ons'),
                    'ltype_select_guide'    => __('Click to change listing type', 'homeradar-add-ons'),

                    'bt_add_menu'    => __('Add Menu', 'homeradar-add-ons'),
                    'menu_name'    => __('Menu Name', 'homeradar-add-ons'),
                    'menu_cats'    => __('Menu Types (comma separated)', 'homeradar-add-ons'),
                    'menu_desc'    => __('Menu Description', 'homeradar-add-ons'),
                    'menu_price'    => __('Menu Price', 'homeradar-add-ons'),
                    'menu_url'    => __('Menu Link', 'homeradar-add-ons'),
                    'menu_photos'    => __('Menu Photos', 'homeradar-add-ons'),

                    'headm_iframe'          => _x('iFrame Source', 'Submit page', 'homeradar-add-ons'),
                    'headm_mp4'    => __('MP4 Video', 'homeradar-add-ons'),
                    'headm_youtube'    => __('Youtube Video ID', 'homeradar-add-ons'),
                    'headm_vimeo'    => __('Vimeo Video ID', 'homeradar-add-ons'),
                    'headm_bgimg'    => __('Background Image', 'homeradar-add-ons'),
                    'preview_btn'           => __('Preview', 'homeradar-add-ons'),
                    'slots_add'             => __( 'Add Slot', 'homeradar-add-ons' ),
                    'slots_guests'             => __( 'Max Guests', 'homeradar-add-ons' ),
                    'slots_start'             => __( 'Start time', 'homeradar-add-ons' ),
                    'slots_end'             => __( 'End time', 'homeradar-add-ons' ),
                    'slots_price'             => __( 'Price', 'homeradar-add-ons' ),

                    'raselect_placeholder'             => __( 'Select', 'homeradar-add-ons' ),
                    'raselect_nooptions'             => __( 'No options', 'homeradar-add-ons' ),
                    
                    'cal_bulkedit'             => __( 'Bulk Edit', 'homeradar-add-ons' ),
                    'save_bulkedit'            => __( 'Save', 'homeradar-add-ons' ),
                    'cancel_bulkedit'            => __( 'Cancel', 'homeradar-add-ons' ),
                    'AM'                            => _x( 'AM', 'Time picker AM', 'homeradar-add-ons' ),
                    'PM'                            => _x( 'PM', 'Time picker PM', 'homeradar-add-ons' ),
                    'evt_start'                            => _x( 'Start', 'Submit page', 'homeradar-add-ons' ),
                    'evt_end'                            => _x( 'End', 'Submit page', 'homeradar-add-ons' ),
                    'cal_clear_past'                      => _x( 'Clear old dates', 'Booking form', 'homeradar-add-ons' ),

                    'floor_title'               => _x('Plan Title', 'Submit page', 'homeradar-add-ons'),
                    'floor_size'                => _x('Plan Size', 'Submit page', 'homeradar-add-ons'),
                    'floor_desc'                => _x('Plan Description', 'Submit page', 'homeradar-add-ons'),
                    'floor_images'              => _x('Images', 'Submit page', 'homeradar-add-ons'),

                    'header_bgimage'                    => _x('Background Image', 'Submit page', 'homeradar-add-ons'),
                    'header_bgvideo'                    => _x('Background Video', 'Submit page', 'homeradar-add-ons'),
                    'header_bgslider'                   => _x('Images Slider', 'Submit page', 'homeradar-add-ons'),
                    'header_bgslideshow'                => _x('Background Slidshow', 'Submit page', 'homeradar-add-ons'),
                    'header_map'                        => _x('Map', 'Submit page', 'homeradar-add-ons'),
                    'header_streetview'                 => _x('Street View', 'Submit page', 'homeradar-add-ons'),
                    'header_iframe'                     => _x('Embed iFrame', 'Submit page', 'homeradar-add-ons'),
                    'header_choose'                     => _x('Select a type', 'Submit page', 'homeradar-add-ons'),
                
                ),
                'currency'             => homeradar_addons_get_currency_attrs(),
                'base_currency'        => homeradar_addons_get_base_currency(),
                'wpml'                          => apply_filters( 'wpml_current_language', null ),

                'unfill_address'             => homeradar_addons_get_option('unfill_address'),
                'unfill_state'             => homeradar_addons_get_option('unfill_state'),
                'unfill_city'             => homeradar_addons_get_option('unfill_city'),
                'woocats'                   => homeradar_addons_get_woo_cats(),

                'map_provider'              => $map_provider,
                'mbtoken'                   => homeradar_addons_get_option('mapbox_token'),
                'autocomplete_result_type' => homeradar_addons_get_option('autocomplete_result_type', 'none'),
                'week_starts_monday'                => homeradar_addons_get_option('week_starts_monday'),
                'tag_dis_comma'                     => is_rtl() ? 'yes': 'no',
            );

            wp_localize_script('homeradar-react-adminapp', '_homeradar_add_ons', $_homeradar_add_ons);



            // for submit listing
            $_homeradar_submit = array(
                'submit_timezone_hide' => homeradar_addons_get_option('submit_timezone_hide'),
                'timezones'            => homeradar_addons_generate_timezone_list(),
                'timezone'             => get_option('timezone_string', 'Europe/London'),
                'working_days'         => Esb_Class_Date::week_days(),
                'working_hours'        => Esb_Class_Date::wkhours_select(),

                'features'             => homeradar_addons_get_listing_features(),
                
                'i18n'                 => array(
                    'timezone'              => __('Timezone', 'homeradar-add-ons'),
                ),
            );
            wp_localize_script('homeradar-react-adminapp', '_homeradar_submit', $_homeradar_submit);
            //========================

            if (function_exists('wp_set_script_translations')) {
                wp_set_script_translations('homeradar-react-adminapp', 'homeradar-add-ons');
            }

        }

        // if ($hook != 'settings_page_homeradar-addons') {
        //     return;
        // }

        // wp_enqueue_script('homeradar_addons_image', ESB_DIR_URL . 'inc/assets/upload_file.js', array('jquery'), null, true);
        // wp_enqueue_style( 'custom_wp_admin_css', plugins_url('admin-style.css', __FILE__) );
        // wp_enqueue_script('select2', ESB_DIR_URL . 'assets/js/select2.min.js', array('jquery'), null, true);
        // wp_enqueue_script('homeradar-add-ons-options', ESB_DIR_URL . 'assets/js/addons-options.js', array('select2'), null, true);
    }
}

Esb_Class_Admin_Scripts::init();