<?php 
/* add_ons_php */

function homeradar_addons_azp_elements(){ 
	$elements = array();


    $elements['azp_row'] = array(
        'name'                  => __('Row','homeradar-add-ons'), 
        'category'              => __("structure",'homeradar-add-ons'), 
        'desc'                  => __('Create Row/Column layout grid','homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/row.png',

        'hasownchild'=>'yes',
        'childtypename'=>'AzuraColumn',
        'childname'=>'Column',
        'showStyleTab'=> true,
        'showTypographyTab'=> true,
        'showAnimationTab'=> true,
        'attrs' => array (
            
            array(
                'type'                  => 'text',
                'param_name'            => 'section_title',
                'label'                 => __('Section Title','homeradar-add-ons'), 
                'desc'                  => '',
                'default'               => '',
                
            ),
            array(
                'type'                  => 'textarea',
                'param_name'            => 'content',
                'label'                 => __('Section Introtext (Can be use with html tags.)','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'title_align',
                'label'                 => __('Section Title Alignment','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'setleft',
                'value'                 => array(   
                    'setleft'                       => __('Left', 'homeradar-add-ons'),
                    'setcenter'                     => __('Center', 'homeradar-add-ons'),
                    'setright'                      => __('Right', 'homeradar-add-ons'),                                                                              
                ),
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'fullwidth',
                'label'                 => __('Content width','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '0',
                'value'                 => array(   
                    '1'                     => __('Fluid width', 'homeradar-add-ons'),
                    '0'                     => __('Fixed width', 'homeradar-add-ons'),                                                                             
                ),
            ),

            array(
                'type'                  => 'select',
                'param_name'            => 'sec_width',
                'label'                 => __('Section Width','homeradar-add-ons'),
                'desc'                  => __("Use Default for template content width" ,'homeradar-add-ons'),
                'default'               => 'default',
                'value'                 => array(   
                    'default'                       => __('Default', 'homeradar-add-ons'),
                    'fullscreen'                        => __('Fullscreen width', 'homeradar-add-ons'),                                                                           
                ),
            ),

            array(
                'type'                  => 'switch',
                'param_name'            => 'is_fullheight',
                'label'                 => __('Is Fullscreen height','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '0',
                'value'                 => array(   
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),                                                                              
                ),
            ),

            array(
                'type'                  => 'switch',
                'param_name'            => 'equal_height',
                'label'                 => __('Equal height','homeradar-add-ons'),
                'desc'                  => __("Set this option to Yes if you want to set columns equal height." ,'homeradar-add-ons'),
                'default'               => '0',
                'value'                 => array(   
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),                                                                             
                ),
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'equal_height',
                'label'                 => __('Equal height','homeradar-add-ons'),
                'desc'                  => __("Set this option to Yes if you want to set columns equal height." ,'homeradar-add-ons'),
                'default'               => '0',
                'value'                 => array(   
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),                                                                             
                ),
            ),

            array(
                'type'                  => 'switch',
                'param_name'            => 'use_parallax',
                'label'                 => __('Use Parallax','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '0',
                'value'                 => array(   
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),                                                                               
                ),
            ),

            array(
                'type'                  => 'image',
                'param_name'            => 'parallax_image',
                'label'                 => __('Parallax Image','homeradar-add-ons'),
                'desc'                  => __("If no image is selected, parallax will use background image from Style tab.", 'homeradar-add-ons'),
                'default'               =>'',
                "depends_on"         => array(   
                    'element'   => 'use_parallax',  
                    'value'                 => array('1'),                                                                                
                    'has_value' => false,                                                                                
                ),
            ),

            array(
                'type'                  => 'text',
                'param_name'            => 'parallax_value',
                'label'                 => __('Parallax Value','homeradar-add-ons'),
                'desc'                  => __("Pixel number. Which we are telling the browser is to move Parallax Image down every time we scroll down 100% of the viewport height and move Parallax Image up every time we scroll up 100% of the viewport height. Ex: 300 or -300 for reverse direction." ,'homeradar-add-ons'),
                'default'               => '300',
                'rgba'          => true,
                "depends_on"         => array(   
                    'element'   => 'use_parallax',  
                    'value'                 => array('1'),                                                                                
                    'has_value' => false,                                                                                
                ),
            ),

            array(
                'type'                  => 'color',
                'param_name'            => 'overlay_color',
                'label'                 => __('Overlay Color','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'rgba'          => true,
                "depends_on"         => array(   
                    'element'   => 'use_parallax',  
                    'value'                 => array('1'),                                                                                
                    'has_value' => false,                                                                                
                ),
            ),
            
            array(
                'type'                  => 'select',
                'param_name'            => 'column_gap',
                'label'                 => __('Columns gap','homeradar-add-ons'),
                'desc'                  => __("Gap between columns." ,'homeradar-add-ons'),
                'default'               => '15',
                'value'                 => array(   
                    '0'                     => __('0px', 'homeradar-add-ons'),
                    '1'                     => __('1px', 'homeradar-add-ons'),
                    '2'                     => __('2px', 'homeradar-add-ons'),
                    '3'                     => __('3px', 'homeradar-add-ons'),
                    '4'                     => __('4px', 'homeradar-add-ons'),
                    '5'                     => __('5px', 'homeradar-add-ons'),
                    '10'                        => __('10px', 'homeradar-add-ons'),
                    '15'                        => __('15px', 'homeradar-add-ons'),
                    '20'                        => __('20px', 'homeradar-add-ons'),
                    '25'                        => __('25px', 'homeradar-add-ons'),
                    '30'                        => __('30px', 'homeradar-add-ons'),
                    '35'                        => __('35px', 'homeradar-add-ons'),
                    '40'                        => __('40px', 'homeradar-add-ons'),
                    '45'                        => __('45px', 'homeradar-add-ons'),
                    '50'                        => __('50px', 'homeradar-add-ons'),                                                                           
                ),
            ),

            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Section ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => '',
            ),

            array(
                'type'                  => 'colslayout', // this type for row element only
                'param_name'            => 'cols_layout',
                'label'                 => __('Columns Layout','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '100',
                'value'                 => array(   
                    '100'                     => __('100', 'homeradar-add-ons'),
                    '50,50'                   => __('50-50', 'homeradar-add-ons'),
                    '33,66'                   => __('33-66', 'homeradar-add-ons'),
                    '66,33'                   => __('66-33', 'homeradar-add-ons'),                                                                       
                    '33,33,33'                => __('33-33-33', 'homeradar-add-ons'),                                                                       
                    '25,25,25,25'             => __('25-25-25-25', 'homeradar-add-ons'),                                                                       
                    '20,20,20,20,20'          => __('20-20-20-20-20', 'homeradar-add-ons'),                                                                       
                ),
            ),

        )
    );

    $elements['azp_rowinner'] = array(
        'name'                  => __('Row Inner','homeradar-add-ons'),
        'desc'                  => __('Create Row/Column layout grid in parent column element','homeradar-add-ons'),
        'category'              => __("structure",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/row.png',
        'hasownchild'=>'yes',
        'childtypename'=>'AzuraColumnInner',
        'childname'=>'Column Inner',
        'showStyleTab'=> true,
        'showTypographyTab'=> true,
        'showAnimationTab'=> true,
        'attrs' => array (
            array(
                'type'                  => 'select',
                'param_name'            => 'column_gap',
                'label'                 => __('Columns gap','homeradar-add-ons'),
                'desc'                  => __("Gap between columns." ,'homeradar-add-ons'),
                'default'               => '15',
                'value'                 => array(   
                    '0'                     => __('0px', 'homeradar-add-ons'),
                    '1'                     => __('1px', 'homeradar-add-ons'),
                    '2'                     => __('2px', 'homeradar-add-ons'),
                    '3'                     => __('3px', 'homeradar-add-ons'),
                    '4'                     => __('4px', 'homeradar-add-ons'),
                    '5'                     => __('5px', 'homeradar-add-ons'),
                    '10'                        => __('10px', 'homeradar-add-ons'),
                    '15'                        => __('15px', 'homeradar-add-ons'),
                    '20'                        => __('20px', 'homeradar-add-ons'),
                    '25'                        => __('25px', 'homeradar-add-ons'),
                    '30'                        => __('30px', 'homeradar-add-ons'),
                    '35'                        => __('35px', 'homeradar-add-ons'),
                    '40'                        => __('40px', 'homeradar-add-ons'),
                    '45'                        => __('45px', 'homeradar-add-ons'),
                    '50'                        => __('50px', 'homeradar-add-ons'),                                                                             
                ),
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'equal_height',
                'label'                 => __('Equal height','homeradar-add-ons'),
                'desc'                  => __("Set this option to Yes if you want to set columns equal height." ,'homeradar-add-ons'),
                'default'               => '0',
                'value'                 => array(   
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),                                                                             
                ),
            ),
            
            
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Row ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => '',
            ),

            array(
                'type'                  => 'colslayout', // this type for row element only
                'param_name'            => 'cols_layout',
                'label'                 => __('Columns Layout','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '100',
                'value'                 => array(   
                    '100'                     => __('100', 'homeradar-add-ons'),
                    '50,50'                   => __('50-50', 'homeradar-add-ons'),
                    '33,66'                   => __('33-66', 'homeradar-add-ons'),
                    '66,33'                   => __('66-33', 'homeradar-add-ons'),                                                                       
                    '33,33,33'                => __('33-33-33', 'homeradar-add-ons'),                                                                       
                    '25,25,25,25'             => __('25-25-25-25', 'homeradar-add-ons'),                                                                       
                    '20,20,20,20,20'          => __('20-20-20-20-20', 'homeradar-add-ons'),                                                                       
                ),
            ),
            
        )
    );

	$elements['azp_column'] = array(
        'name'                          =>__( 'Column', 'homeradar-add-ons' ),
        'category'                      => __("forrow",'homeradar-add-ons'),
        'icon'                          => ESB_DIR_URL .'assets/azp-eles-icon/row.png',
        'showStyleTab'=> true,
        'showTypographyTab'=> true,
        'showAnimationTab'=> true,
        // 'showResponsiveTab'=> true,
        'attrs' => array (

            array(
                'type'                  =>'width',
                'param_name'            =>'azp_rwid',
                'label'                 =>__( 'Column Width (%)', 'homeradar-add-ons' ),
                'desc'                  => "",
                'default'               => ''
            ),

            // array(
            //     'type'                  =>'checkbox',
            //     'param_name'            =>'test_checkbox',
            //     'label'                 =>__( 'Test Checkbox', 'homeradar-add-ons' ),
            //     'desc'                  => "" ,
            //     'value'                  => 'yes' ,
            //     'unchecked'                  => 'no' ,
            //     'default'               => 'yes'
            // ),

            // array(
            //     'type'                  =>'radio',
            //     'param_name'            =>'test_radio',
            //     'label'                 =>__( 'Test Radio', 'homeradar-add-ons' ),
            //     'value'                  => array(
            //         'no'                    => __( 'No', 'homeradar-add-ons' ),
            //         'yes'                    => __( 'Yes', 'homeradar-add-ons' ),
            //         'test'                    => __( 'Test', 'homeradar-add-ons' ),
            //     ),
            //     'desc'                  => "" ,
            //     'default'               => 'yes'
            // ),

            array(
                'type'					=>'text',
                'param_name'			=>'el_id',
                'label'					=>__( 'ID', 'homeradar-add-ons' ),
                'desc' 					=> "" ,
                'default'				=>''
            ),
            
            array(
                'type'					=>'text',
                'param_name'			=>'el_class',
                'label'					=> __( 'Extra Class', 'homeradar-add-ons' ),
                'desc' 					=> __( 'Use this field to add a class name and then refer to it in your CSS.', 'homeradar-add-ons' ) ,
                'default' 				=>''
            ),
            
        )
    );

    $elements['azp_columninner'] = array(
        'name'                  => __('Column Inner','homeradar-add-ons'),
        'category'              => __("forrowinner",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/row.png',
        'showStyleTab'=> true,
        'showTypographyTab'=> true,
        'showAnimationTab'=> true,
        // 'showResponsiveTab'=> true,
        'attrs' => array (
            array(
                'type'                  =>'width',
                'param_name'            =>'azp_rwid',
                'label'                 =>__( 'Column Width (%)', 'homeradar-add-ons' ),
                'desc'                  => "",
                'default'               => ''
            ),

            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => ''
            ),
            
        )
    );

    $elements['azp_container'] = array(
        'name'                  => __('Container','homeradar-add-ons'),
        'desc'                  => __('Create wrapper in parent column element','homeradar-add-ons'),
        'category'              => __("structure",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/container.png',
        'open_settings_on_create'=>true,
        'showStyleTab'=> true,
        'showTypographyTab'=> true,
        'showAnimationTab'=> true,
        'attrs' => array (
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => ''
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'wraptag',
                'label'                 => __('Wrapper Tag','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'div',
                'value'                 => array(
                    'div'                       => __('div', 'homeradar-add-ons'),
                    'section'                       => __('section', 'homeradar-add-ons'),
                    'article'                       => __('article', 'homeradar-add-ons'),
                    'aside'                     => __('aside', 'homeradar-add-ons'),
                    'ul'                        => __('ul', 'homeradar-add-ons'),
                )
            ),
            
        )
    );

    $elements['azp_text'] = array(
        'name'                  => __('Text Block','homeradar-add-ons'),
        'desc'                  => __('A block of text with WYSIWYG editor','homeradar-add-ons'),
        'category'              => __("content",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/text-block.png',
        'open_settings_on_create'=>true,
        'showStyleTab'=> true,
        'showTypographyTab'=> true,
        'showAnimationTab'=> true,
        'attrs' => array (
            // array(
            //     'type'                  => 'icon',
            //     'param_name'            => 'el_icon',
            //     'show_in_admin'         => true,
            //     'label'                 => __('Icon Selector','homeradar-add-ons'),
            //     'desc'                  => '',
            //     'default'               => ''
            // ),

            // array(
            //     'type'                  => 'repeater',
            //     'param_name'            => 'el_repeater',
            //     'show_in_admin'         => true,
            //     'label'                 => __('Repeater Field','homeradar-add-ons'),
            //     'desc'                  => '',
            //     'title_field'           => 'rp_text',
            //     'fields'                => array(
            //         array(
            //             'type'                  => 'text',
            //             'param_name'            => 'rp_text',
            //             'show_in_admin'         => true,
            //             'label'                 => __('Repeater Field Text','homeradar-add-ons'),
            //             'desc'                  => '',
            //             'default'               => ''
            //         ),
            //         array(
            //             'type'                  => 'textarea',
            //             'param_name'            => 'rp_textarea',
            //             'show_in_admin'         => true,
            //             'label'                 => __('Repeater Field Textarea','homeradar-add-ons'),
            //             'desc'                  => '',
            //             'default'               => ''
            //         ),
            //         array(
            //             'type'                  => 'image',
            //             'param_name'            => 'rp_img',
            //             'show_in_admin'         => true,
            //             'label'                 => __('Repeater Field Image','homeradar-add-ons'),
            //             'desc'                  => '',
            //             'default'               => ''
            //         ),
            //     ),
            //     'default'               => array(
            //         // array('rp_text'=>'rp_text','rp_textarea'=>'rp_textarea') -> Objects are not valid as a React child (found: object with keys {rp_text, rp_textarea}).
            //     )
            // ),

            array(
                'type'                  => 'editor',
                
                'param_name'            => 'content',
                'label'                 => __('Content','homeradar-add-ons'),
                'show_in_admin'         => true,
                'desc'                  => __("Text Content (Can be used with HTML tags)" ,'homeradar-add-ons'),
                'default'               => '<h3>Back End Page Builder</h3><p>Build a responsive website and manage your content easily with super fast back-end builder. No programming knowledge required – create stunning and beautiful pages with drag and drop builder.</p>',
                'iscontent'             =>'yes'
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'show_in_admin'         => true,
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'show_in_admin'         => true,
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => ''
            ),
            
        )
    );

    $elements['azp_image'] = array(
        'name'                  => __('Single Image','homeradar-add-ons'),
        'desc'                  => __('','homeradar-add-ons'),
        'category'              => __("content",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/image.png',
        'open_settings_on_create'=>true,
        'showStyleTab'=>true,
        'showAnimationTab'=>true,
        'attrs' => array (
            array(
                'type'                  => 'images',
                'param_name'            => 'image_url',
                'label'                 => __('Image Source','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'show_in_admin'         => true,
            ),
            // array(
            //     'type'                  => 'text',
            //     'param_name'            => 'alttext',
            //     'label'                 => __('Alt Text','homeradar-add-ons'),
            //     'desc'                  => '',
            //     'default'               => '',
            // ),
            array(
                'type'                  => 'select',
                'param_name'            => 'image_style',
                'label'                 => __("Image Style",'homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'default',
                'value'                 => array(
                    'default'                       => __('Default', 'homeradar-add-ons'),
                    'circle'                        => __('Circle', 'homeradar-add-ons'),
                    'thumbnail'                     => __('Thumbnail', 'homeradar-add-ons'),
                    // 'withcontent'                        => __('Thumbnail with content', 'default'),
                )
                
            ),
            // array(
            //     'type'                  => 'select',
            //     'param_name'            => 'click_action',
            //     'label'                 => __("Click action",'homeradar-add-ons'),
            //     'desc'                  => __("Select action for user click." ,'homeradar-add-ons'),
            //     'default'               => 'none',
            //     'value'                 => array(
            //         'none'                      => __('None', 'homeradar-add-ons'),
            //         'lightbox'                      => __('Open popup', 'homeradar-add-ons'),
            //         'modal'                     => __('Open modal', 'homeradar-add-ons'),
            //         'link'                      => __('Open link', 'homeradar-add-ons'),
            //     )
                
            // ),
            // array(
            //     'type'                  => 'text',
            //     'param_name'            => 'modal_id',
            //     'label'                 => __('Modal ID','homeradar-add-ons'),
            //     'desc'                  => __("Enter your modal ID here to open it." ,'homeradar-add-ons'),
            //     'default'               => '',
            //     'depends_on' => array(
            //         'element' => 'click_action',
            //         'value'                 => array('modal'),
            //         'has_value' => false,
            //     ),
            // ),
            // array(
            //     'type'                  => 'image',
            //     'param_name'            => 'large_image',
            //     'label'                 => __('Popup image or video','homeradar-add-ons'),
            //     'desc'                  => __("Large Image or Youtube, Vimeo, Soundcloud link for light box. Leave empty to use default." ,'homeradar-add-ons'),
            //     'default'               => '',
            //     'depends_on'=> array(
            //         'element'=> 'click_action',
            //         'value'                 => array('lightbox'),
            //         'has_value' => false,
            //     ),
            // ),
            array(
                'type'                  => 'text',
                'param_name'            => 'video_link',
                'label'                 => __('Video url','homeradar-add-ons'),
                'desc'                  => 'EX:https://www.youtube.com/watch?v=d9Q3vKl40Y8',
                'default'               => '',
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'name_video_link',
                'label'                 => __('Describes the video path.','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'Promo Video',
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'image_link',
                'label'                 => __('Image Link','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '#',
                'depends_on'=> array(
                    'element'=> 'click_action',
                    'value'                 => array('link'),
                    'has_value' => false,
                ),
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'link_target',
                'label'                 => __("Open link in",'homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '_blank',
                'value'                 => array(
                    '_blank'                        => __('New tab', 'homeradar-add-ons'),
                    '_self'                     => __('Current tab', 'homeradar-add-ons'),
                ),
                'depends_on'=> array(
                    'element'=> 'click_action',
                    'value'                 => array('link'),
                    'has_value' => false,
                ),
                
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => '',
                
            ),

            
        )
    );
    
    $elements['azp_accordion'] = array(
        'name'                  => __('Accordion','homeradar-add-ons'),
        'desc'                  => __('','homeradar-add-ons'),
        'category'              => __("content",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/accordion.png',
        'open_settings_on_create'=>true,
        'showStyleTab'=>true,
        'showAnimationTab'=>true,
        'attrs' => array (
             array(
                'type'                  => 'repeater',
                'param_name'            => 'contents_order',
                'show_in_admin'         => true,
                'label'                 => __('Accordion Items','homeradar-add-ons'),
                'desc'                  => '',
                'title_field'           => 'rp_text',
                'fields'                => array(
                    array(
                        'type'                  => 'text',
                        'param_name'            => 'title',
                        'show_in_admin'         => true,
                        'label'                 => __('Title','homeradar-add-ons'),
                        'desc'                  => '',
                        'default'               => 'Accordion #1'
                    ),
                    array(
                        'type'                  => 'textarea',
                        'param_name'            => 'content',
                        'show_in_admin'         => true,
                        'label'                 => __('Content','homeradar-add-ons'),
                        'desc'                  => '',
                        'default'               => 'I am item content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.'
                    ),
                    // array(
                    //     'type'                  => 'icon',
                    //     'param_name'            => 'icon',
                    //     'show_in_admin'         => true,
                    //     'label'                 => __('Icon','homeradar-add-ons'),
                    //     'desc'                  => '',
                    //     'default'               => ''
                    // ),
                    // array(
                    //     'type'                  => 'icon',
                    //     'param_name'            => 'active_icon',
                    //     'show_in_admin'         => true,
                    //     'label'                 => __('Active Icon','homeradar-add-ons'),
                    //     'desc'                  => '',
                    //     'default'               => ''
                    // ),
                ),
                'default'               => array(
                )
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => '',
                
            ),

            
        )
    );
    $elements['azp_gallery'] = array(
        'name'                  => __('Image Gallery','homeradar-add-ons'),
        'desc'                  => __('','homeradar-add-ons'),
        'category'              => __("content",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/gallery.png',
        'open_settings_on_create'=>true,
        'showStyleTab'=>true,
        'showAnimationTab'=>true,
        'attrs' => array (
            array(
                'type'                  => 'images',
                'param_name'            => 'image_url',
                'label'                 => __('Image Source','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'show_in_admin'         => true,
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'image_size',
                 'show_in_admin'         => true,
                'label'                 => __("Image Size",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => 'thumbnail',
                'value'=> array(
                    'thumbnail'                  => __('Thumbnail - 150 x 150', 'homeradar-add-ons'),
                    'medium'                     => __('Medium - 300 x 300', 'homeradar-add-ons'),
                    'medium_large'               => __('Medium Large - 768 x 0', 'homeradar-add-ons'),
                    'large'                      => __('large', 'homeradar-add-ons'),
                    'full'                       => __('Full', 'homeradar-add-ons'),
                )
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'grid_cols',
                'show_in_admin'         => true,
                'label'                 => __("Columns",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => 'three',
                'value'                 => array(
                    'one'                     => __('One Column', 'homeradar-add-ons'),
                    'two'                     => __('Two Column', 'homeradar-add-ons'),
                    'three'                     => __('Three Columns', 'homeradar-add-ons'),
                    'four'                     => __('Four Columns', 'homeradar-add-ons'),
                    'five'                     => __('Five Columns', 'homeradar-add-ons'),
                    'six'                     => __('Six Columns', 'homeradar-add-ons'),
                    'seven'                     => __('Seven Columns', 'homeradar-add-ons'),
                    'eight'                     => __('Eight Columns', 'homeradar-add-ons'),
                    'nine'                     => __('Nine Columns', 'homeradar-add-ons'),
                    'ten'                     => __('Ten Columns', 'homeradar-add-ons'),
                )
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'items_width',
                'label'                 => __('Items Width','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'Defined location width. Available values are x1(default),x2(x2 width),x3(x3 width), and separated by comma. Ex: x1,x1,x2,x1,x1,x1'
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'space',
                'show_in_admin'         => true,
                'label'                 => __("Space",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => 'big',
                'value'                 => array(
                    'big'                     => __('Big', 'homeradar-add-ons'),
                    'medium'                     => __('Medium', 'homeradar-add-ons'),
                    'small'                     => __('Small', 'homeradar-add-ons'),
                    'extrasmall'                     => __('Extra small', 'homeradar-add-ons'),
                    'no'                     => __('None', 'homeradar-add-ons'),
                )
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => '',
                
            ),

            
        )
    );

    $elements['azp_carousel'] = array(
        'name'                  => __('Image Carousel','homeradar-add-ons'),
        'desc'                  => __('','homeradar-add-ons'),
        'category'              => __("content",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/image-carousel.png',
        'open_settings_on_create'=>true,
        'showStyleTab'=>true,
        'showAnimationTab'=>true,
        'attrs' => array (
            array(
                'type'                  => 'images',
                'param_name'            => 'image_url',
                'show_in_admin'         => true,
                'label'                 => __('Image Source','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'show_in_admin'         => true,
            ),
            array(
                'type'                  => 'textarea',
                'param_name'            => 'link',
                'label'                 => __('link','homeradar-add-ons'),
                'desc'                  => 'Enter links for each (Note: divide links with | or linebreaks (Enter) and no spaces).',
                'default'               => '#|#|#|#|#|#'
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'target',
                'show_in_admin'         => true,
                'label'                 => __("Target",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => '_blank',
                'value'=> array(
                    '_blank'                  => __('Opens Image link in new window', 'homeradar-add-ons'),
                    '_self'                     => __('Opens Image link in the same window', 'homeradar-add-ons'),
                )
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'thumbnail_size',
                 'show_in_admin'         => true,
                'label'                 => __("Image Size",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => 'thumbnail',
                'value'=> array(
                    'thumbnail'                  => __('Thumbnail - 150 x 150', 'homeradar-add-ons'),
                    'medium'                     => __('Medium - 300 x 300', 'homeradar-add-ons'),
                    'medium_large'               => __('Medium Large - 768 x 0', 'homeradar-add-ons'),
                    'large'                      => __('large', 'homeradar-add-ons'),
                    'full'                       => __('Full', 'homeradar-add-ons'),
                )
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'spacing',
                'show_in_admin'         => true,
                'label'                 => __("Spacing",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => '10',
                'value'                 => array(
                    '0'                     => __('None', 'homeradar-add-ons'),
                    '1'                     => __('1px', 'homeradar-add-ons'),
                    '2'                     => __('2px', 'homeradar-add-ons'),
                    '3'                     => __('3px', 'homeradar-add-ons'),
                    '4'                     => __('4px', 'homeradar-add-ons'),
                    '5'                     => __('5px', 'homeradar-add-ons'),
                    '10'                     => __('10px', 'homeradar-add-ons'),
                    '15'                     => __('15px', 'homeradar-add-ons'),
                    '20'                     => __('20px', 'homeradar-add-ons'),
                    '25'                     => __('25px', 'homeradar-add-ons'),
                    '30'                     => __('30px', 'homeradar-add-ons'),
                )
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'responsive',
                'label'                 => __('responsive','homeradar-add-ons'),
                'desc'                  => 'The format is: screen-size:number-items-display,larger-screen-size:number-items-display. Ex: 320:2,768:2,992:4,1200:5',
                'default'               => '320:2,768:2,992:2,1200:3'
            ),
             array(
                'type'                  => 'text',
                'param_name'            => 'speed',
                'label'                 => __('Speed','homeradar-add-ons'),
                'desc'                  => 'Duration of transition between slides (in ms). Default: 1300',
                'default'               => '1300'
            ),
            // array(
            //     'type'                  => 'switch',
            //     'param_name'            => 'show_title',
            //     'show_in_admin'         => true,
            //     'label'                 => __('Show Title/Caption','homeradar-add-ons'),
            //     'desc'                  => '',
            //     'default'               => 'yes',
            //     'value'                 => array(   
            //         'yes'          => __('Show', 'homeradar-add-ons'), 
            //         'no'            => __('Hidden', 'homeradar-add-ons'), 
            //      ),
            // ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'autoplay',
                'show_in_admin'         => true,
                'label'                 => __('Auto Play','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'no',
                'value'                 => array(   
                    'yes'          => __('Yes', 'homeradar-add-ons'), 
                    'no'            => __('No', 'homeradar-add-ons'), 
                 ),
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'loop',
                'show_in_admin'         => true,
                'label'                 => __('Loop','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'yes',
                'value'                 => array(   
                    'yes'          => __('Yes', 'homeradar-add-ons'), 
                    'no'            => __('No', 'homeradar-add-ons'), 
                 ),
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'show_navigation',
                'show_in_admin'         => true,
                'label'                 => __('Show Navigation','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'yes',
                'value'                 => array(   
                    'yes'          => __('Yes', 'homeradar-add-ons'), 
                    'no'            => __('No', 'homeradar-add-ons'), 
                 ),
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'show_dots',
                'show_in_admin'         => true,
                'label'                 => __('Show Dots','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'yes',
                'value'                 => array(   
                    'yes'          => __('Yes', 'homeradar-add-ons'), 
                    'no'            => __('No', 'homeradar-add-ons'), 
                 ),
            ),
            //  array(
            //     'type'                  => 'select',
            //     'param_name'            => 'wow_type',
            //     'show_in_admin'         => true,
            //     'label'                 => __('Reveal Animations When You Scroll','homeradar-add-ons'),
            //     'desc'                  => '',
            //     'default'               => 'yes',
            //     'value'                 => array(   
            //         ''                      => __('None', 'homeradar-add-ons'), 
            //         'bounceIn'              => __('BounceIn', 'homeradar-add-ons'), 
            //         'bounceInDown'          => __('BounceInDown', 'homeradar-add-ons'), 
            //         'bounceInLeft'          => __('bounceInLeft', 'homeradar-add-ons'),
            //         'bounceInRight'         => __('bounceInRight', 'homeradar-add-ons'), 
            //         'fadeIn'                => __('fadeIn', 'homeradar-add-ons'),
            //         'fadeInUp'              => __('fadeInUp', 'homeradar-add-ons'), 
            //         'fadeInDown'            => __('fadeInDown', 'homeradar-add-ons'),

            //      ),
            // ),
            // array(
            //     'type'                  => 'text',
            //     'param_name'            => 'ani_time',
            //     'label'                 => __('Animations time','homeradar-add-ons'),
            //     'desc'                  => '',
            //     'default'               => '1.0'
            // ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => '',
                
            ),  
        )
    );
    $elements['azp_button'] = array(
        'name'                  => __('Button','homeradar-add-ons'),
        'desc'                  => __('','homeradar-add-ons'),
        'category'              => __("content",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/button.png',
        'open_settings_on_create'=>true,
        'showStyleTab'=>true,
        'showAnimationTab'=>true,
        'attrs' => array (
            array(
                'type'                  => 'text',
                'param_name'            => 'name',
                'show_in_admin'         => true,
                'label'                 => __('Text','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'Text on the button'
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'shape',
                'show_in_admin'         => true,
                'label'                 => __("Shape",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => 'square',
                'value'                 => array(
                    'rounded'                     => __('rounded', 'homeradar-add-ons'),
                    'square'                     => __('Square', 'homeradar-add-ons'),
                )
            ),
            array(
                'type'                  => 'icon',
                'param_name'            => 'icon',
                'show_in_admin'         => true,
                'label'                 => __('Icon','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'color',
                'show_in_admin'         => true,
                'label'                 => __("Color",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => 'default',
                'value'                 => array(
                    'default'                     => __('Color Theme', 'homeradar-add-ons'),
                    'primary'                     => __('Classic Blue', 'homeradar-add-ons'),
                    'success'                     => __('Classic Green', 'homeradar-add-ons'),
                    'warning'                     => __('Classic Orange', 'homeradar-add-ons'),
                    'white'                     => __('white', 'homeradar-add-ons'),
                    // 'black'                     => __('Clack', 'homeradar-add-ons'), 
                )
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'size',
                'show_in_admin'         => true,
                'label'                 => __("Size",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => 'md',
                'value'                 => array(
                    'xs'                     => __('Mini', 'homeradar-add-ons'),
                    'sm'                     => __('Small', 'homeradar-add-ons'),
                    'md'                     => __('Normal', 'homeradar-add-ons'),
                    'lg'                     => __('Large', 'homeradar-add-ons'),
                    'xl'                     => __('Extra Large', 'homeradar-add-ons'),
                )
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'align',
                 'show_in_admin'         => true,
                'label'                 => __("Icon alignment",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => 'left',
                'value'                 => array(
                    'left'                     => __('Left', 'homeradar-add-ons'),
                    'center'                     => __('Center', 'homeradar-add-ons'),
                    'right'                     => __('Right', 'homeradar-add-ons'),
                )
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'link',
                'show_in_admin'         => true,
                'label'                 => __('URL (Link)','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '#'
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => '',
                
            ),     
        )
    );
    $elements['azp_contact_form'] = array(
        'name'                  => __(' Contact Form 7','homeradar-add-ons'),
        'desc'                  => __('','homeradar-add-ons'),
        'category'              => __("content",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/contactform.png',
        'open_settings_on_create'=>true,
        'showStyleTab'=>true,
        'showAnimationTab'=>true,
        'attrs' => array (
            array(
                'type'                  => 'select',
                'param_name'            => 'f_id',
                 'show_in_admin'         => true,
                'label'                 => __("Select a form",'homeradar-add-ons'),
                'desc'                  => __("" ,'homeradar-add-ons'),
                'default'               => '',
                'value'                 => homeradar_addons_get_contact_form7_forms(),
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'f_title',
                 'show_in_admin'         => true,
                'label'                 => __('Form Title','homeradar-add-ons'),
                'desc'                  => __('(Optional) Title to search if no ID selected or cannot find by ID.','homeradar-add-ons'),
                'default'               => ''
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => '',
                
            ),  
        )
    );
    $elements['raw_html'] = array(
        'name'                  => __('Raw HTML','homeradar-add-ons'),
        'desc'                  => '',
        'category'              => __("content",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/raw-html.png',
        'open_settings_on_create'=>true,
        'showStyleTab'          => true,
        'showTypographyTab'     => false,
        'showAnimationTab'      => true,
        'attrs' => array (
            
            array(
                'type'                  => 'raw_html',
                'param_name'            => 'content',
                'label'                 => __('Content','homeradar-add-ons'),
                'show_in_admin'         => false,
                'desc'                  => __("HTML/JS Code" ,'homeradar-add-ons'),
                'default'               => '',
                'iscontent'             => 'yes'
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'show_in_admin'         => true,
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'show_in_admin'         => true,
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => ''
            ),
            
        )
    );
    $elements['azp_cus_field'] = array(
        'name'                  => __('Custom Field','homeradar-add-ons'),
        'desc'                  => __('','homeradar-add-ons'),
        'category'              => __("Listings Get Field",'homeradar-add-ons'),
        'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/icon.png',
        'open_settings_on_create'=>true,
        'showStyleTab'=>true,
        'showAnimationTab'=>true,
        'attrs' => array (
            array(
                'type'                  => 'text',
                'param_name'            => 'field_title',
                'show_in_admin'         => true,
                'label'                 => __('Listing Field Title','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'repeater',
                'param_name'            => 'cus_field',
                // 'show_in_admin'         => true,
                'label'                 => __('Custom Field','homeradar-add-ons'),
                'desc'                  => '',
                'title_field'           => 'rp_text',
                'fields'                => array(
                    array(
                        'type'                  => 'text',
                        'param_name'            => 'f_title',
                        'label'                 => __('Field Title','homeradar-add-ons'),
                        'desc'                  => '',
                        'default'               => ''
                    ),
                    array(
                        'type'                  => 'text',
                        'param_name'            => 'f_name',
                        'label'                 => __('Field Name','homeradar-add-ons'),
                        'desc'                  => '',
                        'default'               => ''
                    ),
                    array(
                        'type'                  => 'text',
                        'param_name'            => 'f_class',
                        'show_in_admin'         => true,
                        'label'                 => __('Field Class','homeradar-add-ons'),
                        'desc'                  => '',
                        'default'               => ''
                    ),
                    array(
                        'type'                  => 'select',
                        'param_name'            => 'f_type',
                        'show_in_admin'         => true,
                        'label'                 => __("Type",'homeradar-add-ons'),
                        'desc'                  => __("" ,'homeradar-add-ons'),
                        'default'               => 'default',
                        'value'                 => array(
                            'image'                     => __('Single image', 'homeradar-add-ons'),
                            'default'                     => __('Default', 'homeradar-add-ons'),
                            'list'                     => __('List', 'homeradar-add-ons'),
                            'gallery'                     => __('Gallery', 'homeradar-add-ons'),
                            'currency'                     => __('Currency', 'homeradar-add-ons'),
                        )
                    ),
                    array(
                        'type'                  => 'select',
                        'param_name'            => 'f_wid',
                        'label'                 => __('Width','homeradar-add-ons'),
                        'desc'                  => '',
                        'default'               => 'cus-wid-12',
                        'value'                 => array( 
                            ''                              => __('None', 'homeradar-add-ons'),  
                            'cus-wid-1'                      => __('1 Column - 1/12', 'homeradar-add-ons'),
                            'cus-wid-2'                      => __('2 Columns - 1/6', 'homeradar-add-ons'),
                            'cus-wid-3'                      => __('3 Columns - 1/4', 'homeradar-add-ons'),
                            'cus-wid-4'                      => __('4 Columns - 1/3', 'homeradar-add-ons'),
                            'cus-wid-5'                      => __('5 Columns - 5/12', 'homeradar-add-ons'),
                            'cus-wid-6'                      => __('6 Columns - 1/2', 'homeradar-add-ons'),
                            'cus-wid-7'                      => __('7 Columns - 7/12', 'homeradar-add-ons'),
                            'cus-wid-8'                      => __('8 Columns - 2/3', 'homeradar-add-ons'),
                            'cus-wid-9'                      => __('9 Columns - 1/4', 'homeradar-add-ons'),
                            'cus-wid-10'                     => __('10 Columns - 5/6', 'homeradar-add-ons'),
                            'cus-wid-11'                     => __('11 Columns - 11/12', 'homeradar-add-ons'),
                            'cus-wid-12'                     => __('12 Columns - 1/1', 'homeradar-add-ons'),
                        ),
                    ),
                ),
                'default'               => urlencode(json_encode(array(
                    array(
                        'f_title'   =>  'Title',
                        'f_name'    =>  'field_name',
                        'f_type'    =>  'default',
                        'f_class'   =>  '',
                        'f_wid'     =>  'cus-wid-1',
                    ),

                ))),
            ),
            array(
                'type'          => 'switch',
                'param_name'    => 'use_sec_style',
                // 'show_in_admin' => true,
                'label'         => _x('Use section style', 'Listing type', 'homeradar-add-ons'),
                // 'desc'                  => '',
                'default'       => 'no',
                'value'         => array(
                    'yes' => _x('Yes', 'Yes/No option', 'homeradar-add-ons'),
                    'no'  => _x('No', 'Yes/No option', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_id',
                'label'                 => __('Element ID','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'text',
                'param_name'            => 'el_class',
                'label'                 => __('Extra Class','homeradar-add-ons'),
                'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
                'default'               => '',
                
            ),

            
        )
    );
    // $elements['azp_cus_field_bk'] = array(
    //     'name'                  => __('Custom Field','homeradar-add-ons'),
    //     'desc'                  => __('','homeradar-add-ons'),
    //     'category'              => __("Customs Get Field",'homeradar-add-ons'),
    //     'icon'                  => ESB_DIR_URL .'assets/azp-eles-icon/icon.png',
    //     'open_settings_on_create'=>true,
    //     'showStyleTab'=>true,
    //     'showAnimationTab'=>true,
    //     'attrs' => array (
    //         array(
    //             'type'                  => 'text',
    //             'param_name'            => 'f_title',
    //             'show_in_admin'         => true,
    //             'label'                 => __('Field Title','homeradar-add-ons'),
    //             'desc'                  => '',
    //             'default'               => ''
    //         ),
    //         array(
    //             'type'                  => 'text',
    //             'param_name'            => 'f_name',
    //             'show_in_admin'         => true,
    //             'label'                 => __('Field Name','homeradar-add-ons'),
    //             'desc'                  => '',
    //             'default'               => ''
    //         ),
    //         // array(
    //         //     'type'                  => 'text',
    //         //     'param_name'            => 'f_class',
    //         //     'show_in_admin'         => true,
    //         //     'label'                 => __('Field Class','homeradar-add-ons'),
    //         //     'desc'                  => '',
    //         //     'default'               => ''
    //         // ),
    //         array(
    //             'type'                  => 'select',
    //             'param_name'            => 'f_type',
    //             'show_in_admin'         => true,
    //             'label'                 => __("Type",'homeradar-add-ons'),
    //             'desc'                  => __("" ,'homeradar-add-ons'),
    //             'default'               => 'input',
    //             'value'                 => array(
    //                 'input'                    => __('Input', 'homeradar-add-ons'),
    //                 'textarea'                  => __('Textarea', 'homeradar-add-ons'),
    //                 'select'                     => __('Select', 'homeradar-add-ons'),
    //                 'checkbox'                  => __('Checkbox', 'homeradar-add-ons'),
    //             )
    //         ),
    //         // array(
    //         //     'type'                  => 'select',
    //         //     'param_name'            => 'f_wid',
    //         //     'show_in_admin'         => true,
    //         //     'label'                 => __('Width','homeradar-add-ons'),
    //         //     'desc'                  => '',
    //         //     'default'               => 'col-md-12',
    //         //     'value'                 => array( 
    //         //         ''                              => __('None', 'homeradar-add-ons'),  
    //         //         'col-md-1'                      => __('1 Column - 1/12', 'homeradar-add-ons'),
    //         //         'col-md-2'                      => __('2 Columns - 1/6', 'homeradar-add-ons'),
    //         //         'col-md-3'                      => __('3 Columns - 1/4', 'homeradar-add-ons'),
    //         //         'col-md-4'                      => __('4 Columns - 1/3', 'homeradar-add-ons'),
    //         //         'col-md-5'                      => __('5 Columns - 5/12', 'homeradar-add-ons'),
    //         //         'col-md-6'                      => __('6 Columns - 1/2', 'homeradar-add-ons'),
    //         //         'col-md-7'                      => __('7 Columns - 7/12', 'homeradar-add-ons'),
    //         //         'col-md-8'                      => __('8 Columns - 2/3', 'homeradar-add-ons'),
    //         //         'col-md-9'                      => __('9 Columns - 1/4', 'homeradar-add-ons'),
    //         //         'col-md-10'                     => __('10 Columns - 5/6', 'homeradar-add-ons'),
    //         //         'col-md-11'                     => __('11 Columns - 11/12', 'homeradar-add-ons'),
    //         //         'col-md-12'                     => __('12 Columns - 1/1', 'homeradar-add-ons'),
    //         //     ),
    //         // ),
    //         array(
    //             'type'                  => 'text',
    //             'param_name'            => 'el_id',
    //             'label'                 => __('Element ID','homeradar-add-ons'),
    //             'desc'                  => '',
    //             'default'               => ''
    //         ),
    //         array(
    //             'type'                  => 'text',
    //             'param_name'            => 'el_class',
    //             'label'                 => __('Extra Class','homeradar-add-ons'),
    //             'desc'                  => __("Use this field to add a class name and then refer to it in your CSS." ,'homeradar-add-ons'),
    //             'default'               => '',
                
    //         ),

            
    //     )
    // );


    $new_elements = apply_filters( 'azp_register_elements', $elements );
    if(is_array($new_elements)) $elements = array_merge($elements, $new_elements);

    /* For Styles - Animations and Responsive tabs */

    $elements['AZPStyleOptions'] = array(
        'attrs' => array (
            array(
                'type'                  =>'dimension',
                'param_name'            =>'azp_margin',
                'label'                 => __( 'Margin', 'homeradar-add-ons' ),
                'desc'                  => "" ,
                'default'               => '',
                'em_unit'               => false,
                // 'per_unit'              => false,
                // 'rem_unit'              => false,
            ),

            array(
                'type'                  =>'dimension',
                'param_name'            =>'azp_padding',
                'label'                 => __( 'Padding', 'homeradar-add-ons' ),
                'desc'                  => "" ,
                'default'               => ''
            ),
            array(
                'type'                  =>'dimension',
                'param_name'            =>'azp_border_width',
                'label'                 => __( 'Border Width', 'homeradar-add-ons' ),
                'desc'                  => "" ,
                'default'               => '',
                'em_unit'               => false,
            ),

            

            array(
                'type'                  => 'color',
                'param_name'            => 'azp_bd_color',
                'label'                 => __( 'Border Color', 'homeradar-add-ons' ),
                'desc'                  => "" ,
                'default'               => '',
                //'rgba'                => true
            ),

            array(
                'type'                  => 'select',
                'param_name'            => 'azp_bd_style',
                'label'                 => __( 'Border Style', 'homeradar-add-ons' ),
                'desc'                  => "" ,
                'default'               => '',
                "value"                 => array(   
                    ''                      => __( 'Default', 'homeradar-add-ons' ),
                    'solid'                 => __( 'Solid', 'homeradar-add-ons' ),
                    'dotted'                => __( 'Dotted', 'homeradar-add-ons' ),
                    'dashed'                => __( 'Dashed', 'homeradar-add-ons' ),
                    'none'                  => __( 'None', 'homeradar-add-ons' ),
                    'hidden'                => __( 'Hidden', 'homeradar-add-ons' ),
                    'double'                => __( 'Double', 'homeradar-add-ons' ),
                    'groove'                => __( 'Groove', 'homeradar-add-ons' ),
                    'ridge'                 => __( 'Ridge', 'homeradar-add-ons' ),
                    'inset'                 => __( 'Inset', 'homeradar-add-ons' ),
                    'outset'                => __( 'Outset', 'homeradar-add-ons' ),
                    'initial'               => __( 'Initial', 'homeradar-add-ons' ),
                    'inherit'               => __( 'Inherit', 'homeradar-add-ons' ),
                ),
            ),


            array(
                'type'                  => 'color',
                'param_name'            => 'azp_bg_color',
                'label'                 => __('Background Color','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'image',
                'param_name'            => 'azp_bg_image',
                'label'                 => __('Background Image','homeradar-add-ons'),
                'fieldclass'            => 'input-small',
                'desc'                  => '',
                'default'               => ''
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'azp_bg_repeat',
                'label'                 => __('Background Repeat','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array(   
                    ''                     => __('Default - Repeat', 'homeradar-add-ons'),
                    'repeat-x'             => __('Repeat X', 'homeradar-add-ons'),
                    'repeat-y'             => __('Repeat Y', 'homeradar-add-ons'),
                    'no-repeat'            => __('No Repeat', 'homeradar-add-ons'),    

                ),
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'azp_bg_attachment',
                'label'                 => __('Background Attachment','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array(   
                    ''                     => __('Default - Scroll', 'homeradar-add-ons'),
                    'fixed'                => __('Fixed', 'homeradar-add-ons'),
                    'local'                => __('Local', 'homeradar-add-ons'),
                    'initial'              => __( 'Initial', 'homeradar-add-ons' ),
                    'inherit'              => __( 'Inherit', 'homeradar-add-ons' ),
                ),
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'azp_bg_size',
                'label'                 => __('Background Size','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array(   
                    ''                     => __('Default - Auto', 'homeradar-add-ons'),
                    'cover'                => __('Cover', 'homeradar-add-ons'),
                    'contain'              => __('Contain', 'homeradar-add-ons'),  

                ),
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'azp_bg_position',
                'label'                 => __('Background Position','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array(   
                    ''                     => __('Default', 'homeradar-add-ons'),
                    'left top'             => __('Left - Top', 'homeradar-add-ons'),
                    'left center'          => __('Left - Center', 'homeradar-add-ons'),
                    'left bottom'          => __('Left - Bottom', 'homeradar-add-ons'),
                    'right top'            => __('Right - Top', 'homeradar-add-ons'),
                    'right center'         => __('Right - Center', 'homeradar-add-ons'),
                    'right bottom'         => __('Right - Bottom', 'homeradar-add-ons'),
                    'center top'           => __('Center - Top', 'homeradar-add-ons'),
                    'center center'        => __('Center - Center', 'homeradar-add-ons'),
                    'center bottom'        => __('Center - Bottom', 'homeradar-add-ons'),
                ),
            ),
            // array(
            //     'type'                  => 'textarea',
            //     'param_name'            => 'additional_style',
            //     'label'                 => __('Additional Inline Style','homeradar-add-ons'),
            //     'fieldclass'            => 'ele-inline-css',
            //     'desc'                  => '',
            //     'default'               => ''
            // ),
            
        )
    );

    
    // $elements['AZPTypoOptions'] = array(
    //     'attrs' => array (
    //         array(
    //             'type'                  => 'switch',
    //             'param_name'            => 'typo_tempfont',
    //             'label'                 => __('Use template font?','homeradar-add-ons'),
    //             'desc'                  => __("Use default template font instead of custom Google font." ,'homeradar-add-ons'),
    //             'default'               => '1',
    //             'value'                 => array(
    //                 '1'                     => __('Yes', 'homeradar-add-ons'),
    //                 '0'                     => __('No', 'homeradar-add-ons'),
    //             ),
    //         ),

    //         array(
    //             'type'                  => 'googlefonts',
    //             'param_name'            => 'typo_googlefont',
    //             'label'                 => __('Google Font','homeradar-add-ons'),
    //             'desc'                  => '',
    //             'default'               => 'Roboto:regular',
    //             'depends_on'            => array(
    //                 'element'               =>'typo_tempfont',
    //                 'value'                 => array('0'),
    //                 'has_value'             => false
    //             ),
                
    //         ),
    //         array(
    //             'type'                  => 'text',
    //             'param_name'            => 'typo_fontsize',
    //             'label'                 => __('Font Size','homeradar-add-ons'),
    //             'desc'                  => __("Unit included. Ex: 14px",'homeradar-add-ons'),
    //             'default'               => ''
    //         ),
    //         array(
    //             'type'                  => 'text',
    //             'param_name'            => 'typo_lheight',
    //             'label'                 => __('Line Height','homeradar-add-ons'),
    //             'desc'                  => __("Unit included: 28px or 1 for 'Font Size' value" ,'homeradar-add-ons'),
    //             'default'               => '',
                
    //         ),
    //         array(
    //             'type'                  => 'color',
    //             'param_name'            => 'typo_textcolor',
    //             'label'                 => __('Text Color','homeradar-add-ons'),
    //             'desc'                  => '',
    //             'default'               => ''
    //         ),
    //         array(
    //             'type'                  => 'select',
    //             'param_name'            => 'typo_textalign',
    //             'label'                 => __('Text Align','homeradar-add-ons'),
    //             'desc'                  => '',
    //             'default'               => '',
    //             'value'                 => array(
    //                 ''                     => __('Template Default', 'homeradar-add-ons'),
    //                 'left'                     => __('Left', 'homeradar-add-ons'),
    //                 'right'                        => __('Right', 'homeradar-add-ons'),
    //                 'center'                       => __('Center', 'homeradar-add-ons'),
    //                 'justify'                       => __('Justify', 'homeradar-add-ons'),
    //             ),
                
    //         ),

    //         array(
    //             'type'                  => 'select',
    //             'param_name'            => 'typo_texttransform',
    //             'label'                 => __('Text Transformation','homeradar-add-ons'),
    //             'desc'                  => '',
    //             'default'               => '',
    //             'value'                 => array(
    //                 ''                     => __('Template Default', 'homeradar-add-ons'),
    //                 'uppercase'                        => __('Uppercase', 'homeradar-add-ons'),
    //                 'lowercase'                        => __('Lowercase', 'homeradar-add-ons'),
    //                 'capitalize'                       => __('Capitalize', 'homeradar-add-ons'),
    //             ),
                
    //         ),
            


            
    //         array(
    //             'type'                  => 'text',
    //             'param_name'            => 'typo_letterspacing',
    //             'label'                 => __('Letter Spacing','homeradar-add-ons'),
    //             'desc'                  => __("Unit included. Ex: 3px" ,'homeradar-add-ons'),
    //             'default'               => '',
                
    //         ),
            
    //         array(
    //             'type'                  => 'text',
    //             'param_name'            => 'typo_textindent',
    //             'label'                 => __('Text Indentation','homeradar-add-ons'),
    //             'desc'                  => __("Specify the indentation of the first line of a text. Unit included. Ex: 50px" ,'homeradar-add-ons'),
    //             'default'               => '',
                
    //         ),



            
    //     )
    // );

    
    //new animation from version 3
    $elements['AZPAnimationOptions'] = array(
        'attrs' => array (
            array(
                'type'                  => 'switch',
                'param_name'            => 'animation',
                'label'                 => __('Use Animation','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '0',
                'value'                 => array(   
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),                                                                               
                ),
            ),
            

            array(
                'type'                  => 'animation',
                'param_name'            => 'animationtype',
                'label'                 => __('Animation Type','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'fadeIn',
                'value'                 => array(   
                    'bounce'                        => __('bounce', 'homeradar-add-ons'),
                    'flash'                     => __('flash', 'homeradar-add-ons'),
                    'pulse'                     => __('pulse', 'homeradar-add-ons'),
                    'rubberBand'                        => __('rubberBand', 'homeradar-add-ons'),
                    'shake'                     => __('shake', 'homeradar-add-ons'),
                    'headShake'                     => __('headShake', 'homeradar-add-ons'),
                    'swing'                     => __('swing', 'homeradar-add-ons'),
                    'tada'                      => __('tada', 'homeradar-add-ons'),
                    'jello'                     => __('jello', 'homeradar-add-ons'),
                    'bounceIn'                      => __('bounceIn', 'homeradar-add-ons'),
                    'bounceInDown'                      => __('bounceInDown', 'homeradar-add-ons'),
                    'bounceInLeft'                      => __('bounceInLeft', 'homeradar-add-ons'),
                    'bounceInRight'                     => __('bounceInRight', 'homeradar-add-ons'),
                    'bounceInUp'                        => __('bounceInUp', 'homeradar-add-ons'),
                    // 'bounceOut'                      => __('bounceOut', 'default'),
                    // 'bounceOutDown'                      => __('bounceOutDown', 'default'),
                    // 'bounceOutLeft'                      => __('bounceOutLeft', 'default'),
                    // 'bounceOutRight'                     => __('bounceOutRight', 'default'),
                    // 'bounceOutUp'                        => __('bounceOutUp', 'default'),
                    'fadeIn'                        => __('fadeIn', 'homeradar-add-ons'),
                    'fadeInDown'                        => __('fadeInDown', 'homeradar-add-ons'),
                    'fadeInDownBig'                     => __('fadeInDownBig', 'homeradar-add-ons'),
                    'fadeInLeft'                        => __('fadeInLeft', 'homeradar-add-ons'),
                    'fadeInLeftBig'                     => __('fadeInLeftBig', 'homeradar-add-ons'),
                    'fadeInRight'                       => __('fadeInRight', 'homeradar-add-ons'),
                    'fadeInRightBig'                        => __('fadeInRightBig', 'homeradar-add-ons'),
                    'fadeInUp'                      => __('fadeInUp', 'homeradar-add-ons'),
                    'fadeInUpBig'                       => __('fadeInUpBig', 'homeradar-add-ons'),
                    // 'fadeOut'                        => __('fadeOut', 'default'),
                    // 'fadeOutDown'                        => __('fadeOutDown', 'default'),
                    // 'fadeOutDownBig'                     => __('fadeOutDownBig', 'default'),
                    // 'fadeOutLeft'                        => __('fadeOutLeft', 'default'),
                    // 'fadeOutLeftBig'                     => __('fadeOutLeftBig', 'default'),
                    // 'fadeOutRight'                       => __('fadeOutRight', 'default'),
                    // 'fadeOutRightBig'                        => __('fadeOutRightBig', 'default'),
                    // 'fadeOutUp'                      => __('fadeOutUp', 'default'),
                    // 'fadeOutUpBig'                       => __('fadeOutUpBig', 'default'),
                    'flipInX'                       => __('flipInX', 'homeradar-add-ons'),
                    'flipInY'                       => __('flipInY', 'homeradar-add-ons'),
                    // 'flipOutX'                       => __('flipOutX', 'default'),
                    // 'flipOutY'                       => __('flipOutY', 'default'),
                    'lightSpeedIn'                      => __('lightSpeedIn', 'homeradar-add-ons'),
                    //'lightSpeedOut'                       => __('lightSpeedOut', 'default'),
                    'rotateIn'                      => __('rotateIn', 'homeradar-add-ons'),
                    'rotateInDownLeft'                      => __('rotateInDownLeft', 'homeradar-add-ons'),
                    'rotateInDownRight'                     => __('rotateInDownRight', 'homeradar-add-ons'),
                    'rotateInUpLeft'                        => __('rotateInUpLeft', 'homeradar-add-ons'),
                    'rotateInUpRight'                       => __('rotateInUpRight', 'homeradar-add-ons'),
                    // 'rotateOut'                      => __('rotateOut', 'default'),
                    // 'rotateOutDownLeft'                      => __('rotateOutDownLeft', 'default'),
                    // 'rotateOutDownRight'                     => __('rotateOutDownRight', 'default'),
                    // 'rotateOutUpLeft'                        => __('rotateOutUpLeft', 'default'),
                    // 'rotateOutUpRight'                       => __('rotateOutUpRight', 'default'),
                    'hinge'                     => __('hinge', 'homeradar-add-ons'),
                    'jackInTheBox'                      => __('jackInTheBox', 'homeradar-add-ons'),
                    'rollIn'                        => __('rollIn', 'homeradar-add-ons'),
                    //'rollOut'                     => __('rollOut', 'default'),
                    'zoomIn'                        => __('zoomIn', 'homeradar-add-ons'),
                    'zoomInDown'                        => __('zoomInDown', 'homeradar-add-ons'),
                    'zoomInLeft'                        => __('zoomInLeft', 'homeradar-add-ons'),
                    'zoomInRight'                       => __('zoomInRight', 'homeradar-add-ons'),
                    'zoomInUp'                      => __('zoomInUp', 'homeradar-add-ons'),
                    // 'zoomOut'                        => __('zoomOut', 'default'),
                    // 'zoomOutDown'                        => __('zoomOutDown', 'default'),
                    // 'zoomOutLeft'                        => __('zoomOutLeft', 'default'),
                    // 'zoomOutRight'                       => __('zoomOutRight', 'default'),
                    // 'zoomOutUp'                      => __('zoomOutUp', 'default'),
                    'slideInDown'                       => __('slideInDown', 'homeradar-add-ons'),
                    'slideInLeft'                       => __('slideInLeft', 'homeradar-add-ons'),
                    'slideInRight'                      => __('slideInRight', 'homeradar-add-ons'),
                    'slideInUp'                     => __('slideInUp', 'homeradar-add-ons'),
                    // 'slideOutDown'                       => __('slideOutDown', 'default'),
                    // 'slideOutLeft'                       => __('slideOutLeft', 'default'),
                    // 'slideOutRight'                      => __('slideOutRight', 'default'),
                    // 'slideOutUp'                        => __('slideOutUp', 'default'),
                ),
            ),

            array(
                'type'                  => 'text',
                'param_name'            => 'animationdelay',
                'label'                 => __('Animation Delay','homeradar-add-ons'),
                'desc'                  => __("Animation delay in milisecond" ,'homeradar-add-ons'),
                'default'               => '100',
            ),
            
        )
    );

    $elements['AZPRespOptions'] = array(
        'attrs' => array (
            array(
                'type'                  => 'hidden',
                'param_name'            => 'azp_bwid',
                'label'                 => __( 'Base Width', 'homeradar-add-ons' ),
                'desc'                  => "" ,
                'default'               => '100'
            ),
            array (
                'type'                  => 'label',
                'param_name'            => 'respdevice',
                'label'                 => __('Device','homeradar-add-ons'),
                'desc'                  => '',
            ),
            array (
                'type'                  => 'label',
                'param_name'            => 'respoffset',
                'label'                 => __('Offset','homeradar-add-ons'),
                'desc'                  => '',
            ),
            array (
                'type'                  => 'label',
                'param_name'            => 'respwidth',
                'label'                 => __('Width','homeradar-add-ons'),
                'desc'                  => '',
            ),
            array (
                'type'                  => 'label',
                'param_name'            => 'resphideondevice',
                'label'                 => __('Hide on device','homeradar-add-ons'),
                'desc'                  => '',
            ),
            array(
                'type'                  => 'clearfix',
            ),
            array (
                'type'                  => 'label',
                'param_name'            => 'devicedesktop',
                'label'                 => __('<i class="ti-desktop"></i>','homeradar-add-ons'),
                'desc'                  => '',
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'lgoffsetclass',
                'label'                 => __('','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array(   
                    ''                      => __('Inherit from smaller', 'homeradar-add-ons'), 
                    'col-lg-offset-0'                       => __('No offset', 'homeradar-add-ons'), 
                    'col-lg-offset-1'                       => __('1 Column - 1/12', 'homeradar-add-ons'), 
                    'col-lg-offset-2'                       => __('2 Columns - 1/6', 'homeradar-add-ons'),  
                    'col-lg-offset-3'                       => __('3 Columns - 1/4', 'homeradar-add-ons'),    
                    'col-lg-offset-4'                       => __('4 Columns - 1/3', 'homeradar-add-ons'),    
                    'col-lg-offset-5'                       => __('5 Columns - 5/12', 'homeradar-add-ons'),    
                    'col-lg-offset-6'                       => __('6 Columns - 1/2', 'homeradar-add-ons'),    
                    'col-lg-offset-7'                       => __('7 Columns - 7/12', 'homeradar-add-ons'),    
                    'col-lg-offset-8'                       => __('8 Columns - 2/3', 'homeradar-add-ons'),    
                    'col-lg-offset-9'                       => __('9 Columns - 1/4', 'homeradar-add-ons'),    
                    'col-lg-offset-10'                      => __('10 Columns - 5/6', 'homeradar-add-ons'),    
                    'col-lg-offset-11'                      => __('11 Columns - 11/12', 'homeradar-add-ons'),    
                    'col-lg-offset-12'                      => __('12 Columns - 1/1', 'homeradar-add-ons'),     
                ),
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'lgwidthclass',
                'label'                 => __('','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array( 
                    ''                      => __('Inherit from smaller', 'homeradar-add-ons'), 
                    'col-lg-1'                      => __('1 Column - 1/12', 'homeradar-add-ons'), 
                    'col-lg-2'                      => __('2 Columns - 1/6', 'homeradar-add-ons'),  
                    'col-lg-3'                      => __('3 Columns - 1/4', 'homeradar-add-ons'),    
                    'col-lg-4'                      => __('4 Columns - 1/3', 'homeradar-add-ons'),    
                    'col-lg-5'                      => __('5 Columns - 5/12', 'homeradar-add-ons'),    
                    'col-lg-6'                      => __('6 Columns - 1/2', 'homeradar-add-ons'),    
                    'col-lg-7'                      => __('7 Columns - 7/12', 'homeradar-add-ons'),    
                    'col-lg-8'                      => __('8 Columns - 2/3', 'homeradar-add-ons'),    
                    'col-lg-9'                      => __('9 Columns - 1/4', 'homeradar-add-ons'),    
                    'col-lg-10'                     => __('10 Columns - 5/6', 'homeradar-add-ons'),    
                    'col-lg-11'                     => __('11 Columns - 11/12', 'homeradar-add-ons'),    
                    'col-lg-12'                     => __('12 Columns - 1/1', 'homeradar-add-ons'),       

                ),
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'hidden-lg',
                'label'                 => __("Hide on desktop",'homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '0',
                'value'                 => array(
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),
                )
                
            ),

            array(
                'type'                  => 'clearfix',
            ),

            array(
                'type'                  => 'label',
                'param_name'            => 'devicetablethoz',
                'label'                 => __('<i class="ti-tablet"></i>','homeradar-add-ons'),
                'desc'                  => '',
            ),

            array(
                'type'                  => 'select',
                'param_name'            => 'mdoffsetclass',
                'label'                 => __('','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array(   
                    ''                      => __('Inherit from smaller', 'homeradar-add-ons'),
                    'col-md-offset-0'                       => __('No offset', 'homeradar-add-ons'),
                    'col-md-offset-1'                       => __('1 Column - 1/12', 'homeradar-add-ons'),
                    'col-md-offset-2'                       => __('2 Columns - 1/6', 'homeradar-add-ons'),
                    'col-md-offset-3'                       => __('3 Columns - 1/4', 'homeradar-add-ons'),
                    'col-md-offset-4'                       => __('4 Columns - 1/3', 'homeradar-add-ons'),
                    'col-md-offset-5'                       => __('5 Columns - 5/12', 'homeradar-add-ons'),
                    'col-md-offset-6'                       => __('6 Columns - 1/2', 'homeradar-add-ons'),
                    'col-md-offset-7'                       => __('7 Columns - 7/12', 'homeradar-add-ons'),
                    'col-md-offset-8'                       => __('8 Columns - 2/3', 'homeradar-add-ons'),
                    'col-md-offset-9'                       => __('9 Columns - 1/4', 'homeradar-add-ons'),
                    'col-md-offset-10'                      => __('10 Columns - 5/6', 'homeradar-add-ons'),
                    'col-md-offset-11'                      => __('11 Columns - 11/12', 'homeradar-add-ons'),
                    'col-md-offset-12'                      => __('12 Columns - 1/1', 'homeradar-add-ons'),

                ),
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'mdwidthclass',
                'label'                 => __('','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array( 
                    ''                      => __('Inherit from smaller', 'homeradar-add-ons'),
                    'col-md-1'                      => __('1 Column - 1/12', 'homeradar-add-ons'),
                    'col-md-2'                      => __('2 Columns - 1/6', 'homeradar-add-ons'),
                    'col-md-3'                      => __('3 Columns - 1/4', 'homeradar-add-ons'),
                    'col-md-4'                      => __('4 Columns - 1/3', 'homeradar-add-ons'),
                    'col-md-5'                      => __('5 Columns - 5/12', 'homeradar-add-ons'),
                    'col-md-6'                      => __('6 Columns - 1/2', 'homeradar-add-ons'),
                    'col-md-7'                      => __('7 Columns - 7/12', 'homeradar-add-ons'),
                    'col-md-8'                      => __('8 Columns - 2/3', 'homeradar-add-ons'),
                    'col-md-9'                      => __('9 Columns - 1/4', 'homeradar-add-ons'),
                    'col-md-10'                     => __('10 Columns - 5/6', 'homeradar-add-ons'),
                    'col-md-11'                     => __('11 Columns - 11/12', 'homeradar-add-ons'),
                    'col-md-12'                     => __('12 Columns - 1/1', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'hidden-md',
                'label'                 => __("Hide on laptop",'homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '0',
                'value'                 => array(
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),
                )
                
            ),
            array(
                'type'                  => 'clearfix',
            ),

            array(
                'type'                  => 'label',
                'param_name'            => 'devicetablet',
                'label'                 => __('<i class="ti-tablet"></i>','homeradar-add-ons'),
                'desc'                  => '',
            ),

            array(
                'type'                  => 'select',
                'param_name'            => 'smoffsetclass',
                'label'                 => __('','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array(   
                    ''                      => __('Inherit from smaller', 'homeradar-add-ons'),
                    'col-sm-offset-0'                       => __('No offset', 'homeradar-add-ons'),
                    'col-sm-offset-1'                       => __('1 Column - 1/12', 'homeradar-add-ons'),
                    'col-sm-offset-2'                       => __('2 Columns - 1/6', 'homeradar-add-ons'),
                    'col-sm-offset-3'                       => __('3 Columns - 1/4', 'homeradar-add-ons'),
                    'col-sm-offset-4'                       => __('4 Columns - 1/3', 'homeradar-add-ons'),
                    'col-sm-offset-5'                       => __('5 Columns - 5/12', 'homeradar-add-ons'),
                    'col-sm-offset-6'                       => __('6 Columns - 1/2', 'homeradar-add-ons'),
                    'col-sm-offset-7'                       => __('7 Columns - 7/12', 'homeradar-add-ons'),
                    'col-sm-offset-8'                       => __('8 Columns - 2/3', 'homeradar-add-ons'),
                    'col-sm-offset-9'                       => __('9 Columns - 1/4', 'homeradar-add-ons'),
                    'col-sm-offset-10'                      => __('10 Columns - 5/6', 'homeradar-add-ons'),
                    'col-sm-offset-11'                      => __('11 Columns - 11/12', 'homeradar-add-ons'),
                    'col-sm-offset-12'                      => __('12 Columns - 1/1', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'                  => 'select',
                'param_name'            => 'columnwidthclass',
                'label'                 => __('Width','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => 'col-md-12',
                'value'                 => array(   
                    'col-md-1'                      => __('1 Column - 1/12', 'homeradar-add-ons'),
                    'col-md-2'                      => __('2 Columns - 1/6', 'homeradar-add-ons'),
                    'col-md-3'                      => __('3 Columns - 1/4', 'homeradar-add-ons'),
                    'col-md-4'                      => __('4 Columns - 1/3', 'homeradar-add-ons'),
                    'col-md-5'                      => __('5 Columns - 5/12', 'homeradar-add-ons'),
                    'col-md-6'                      => __('6 Columns - 1/2', 'homeradar-add-ons'),
                    'col-md-7'                      => __('7 Columns - 7/12', 'homeradar-add-ons'),
                    'col-md-8'                      => __('8 Columns - 2/3', 'homeradar-add-ons'),
                    'col-md-9'                      => __('9 Columns - 1/4', 'homeradar-add-ons'),
                    'col-md-10'                     => __('10 Columns - 5/6', 'homeradar-add-ons'),
                    'col-md-11'                     => __('11 Columns - 11/12', 'homeradar-add-ons'),
                    'col-md-12'                     => __('12 Columns - 1/1', 'homeradar-add-ons'),
                ),
            ),
            
            array(
                'type'                  => 'switch',
                'param_name'            => 'hidden-sm',
                'label'                 => __("Hide on tablet",'homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '0',
                'value'                 => array(
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),
                )
                
            ),

            array(
                'type'                  => 'clearfix',
            ),

            array(
                'type'                  => 'label',
                'param_name'            => 'devicemobile',
                'label'                 => __('<i class="ti-mobile"></i>','homeradar-add-ons'),
                'desc'                  => '',
            ),


            array(
                'type'                  => 'select',
                'param_name'            => 'xsoffsetclass',
                'label'                 => __('','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array(   
                    ''                      => __('No offset', 'homeradar-add-ons'),
                    'col-xs-offset-1'                       => __('1 Column - 1/12', 'homeradar-add-ons'),
                    'col-xs-offset-2'                       => __('2 Columns - 1/6', 'homeradar-add-ons'),
                    'col-xs-offset-3'                       => __('3 Columns - 1/4', 'homeradar-add-ons'),
                    'col-xs-offset-4'                       => __('4 Columns - 1/3', 'homeradar-add-ons'),
                    'col-xs-offset-5'                       => __('5 Columns - 5/12', 'homeradar-add-ons'),
                    'col-xs-offset-6'                       => __('6 Columns - 1/2', 'homeradar-add-ons'),
                    'col-xs-offset-7'                       => __('7 Columns - 7/12', 'homeradar-add-ons'),
                    'col-xs-offset-8'                       => __('8 Columns - 2/3', 'homeradar-add-ons'),
                    'col-xs-offset-9'                       => __('9 Columns - 1/4', 'homeradar-add-ons'),
                    'col-xs-offset-10'                      => __('10 Columns - 5/6', 'homeradar-add-ons'),
                    'col-xs-offset-11'                      => __('11 Columns - 11/12', 'homeradar-add-ons'),
                    'col-xs-offset-12'                      => __('12 Columns - 1/1', 'homeradar-add-ons'),
                ),
            ),

            
            array(
                'type'                  => 'select',
                'param_name'            => 'xswidthclass',
                'label'                 => __('','homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '',
                'value'                 => array(   
                    ''                      => __('No Select', 'homeradar-add-ons'),
                    'col-xs-1'                      => __('1 Column - 1/12', 'homeradar-add-ons'),
                    'col-xs-2'                      => __('2 Columns - 1/6', 'homeradar-add-ons'),
                    'col-xs-3'                      => __('3 Columns - 1/4', 'homeradar-add-ons'),
                    'col-xs-4'                      => __('4 Columns - 1/3', 'homeradar-add-ons'),
                    'col-xs-5'                      => __('5 Columns - 5/12', 'homeradar-add-ons'),
                    'col-xs-6'                      => __('6 Columns - 1/2', 'homeradar-add-ons'),
                    'col-xs-7'                      => __('7 Columns - 7/12', 'homeradar-add-ons'),
                    'col-xs-8'                      => __('8 Columns - 2/3', 'homeradar-add-ons'),
                    'col-xs-9'                      => __('9 Columns - 1/4', 'homeradar-add-ons'),
                    'col-xs-10'                     => __('10 Columns - 5/6', 'homeradar-add-ons'),
                    'col-xs-11'                     => __('11 Columns - 11/12', 'homeradar-add-ons'),
                    'col-xs-12'                     => __('12 Columns - 1/1', 'homeradar-add-ons'),
                ),
            ),
            array(
                'type'                  => 'switch',
                'param_name'            => 'hidden-xs',
                'label'                 => __("Hide on mobile",'homeradar-add-ons'),
                'desc'                  => '',
                'default'               => '0',
                'value'                 => array(
                    '1'                     => __('Yes', 'homeradar-add-ons'),
                    '0'                     => __('No', 'homeradar-add-ons'),
                )
                
            ),

            array(
                'type'                  => 'clearfix',
            ),

        )
    );


    return $elements;

    // https://regex101.com/r/fTLd7P/1
}

function azp_add_element($name = '', $options = array()){
    AZPElements::addEle($name, $options);
}

class AZPElements{
    public static $elements = array();
    public static function init(){
        self::$elements = homeradar_addons_azp_elements();
        do_action( 'azp_elements_init' );
    }
    public static function getEles(){
        return self::$elements;
    }
    public static function addEle($name = '', $options = array() ){
        if( $name != '' && !isset(self::$elements[$name]))
            self::$elements[$name] = $options;
    }
}
// init after register post type
add_action( 'init', function(){AZPElements::init();}, 15 );
// add_action( 'wp_loaded', function(){AZPElements::init();}, 15 );





add_action('wp_ajax_nopriv_homeradar_addons_azp_fetch_images', 'homeradar_addons_azp_fetch_images_callback');
add_action('wp_ajax_homeradar_addons_azp_fetch_images', 'homeradar_addons_azp_fetch_images_callback');
function homeradar_addons_azp_fetch_images_callback(){
    $json = array(
        'success' => false,
        'data' => array(
            // 'POST'=>$_POST,
        ),
        'images'    => array()
    );
    $images = isset($_POST['images'])? $_POST['images'] : '';
    if(!empty($images)){
        $images = explode(",", $images);
        if( is_array($images) && !empty($images) ){
            foreach( $images as $id ){
                $json['images'][] = array(
                    'id'        => $id,
                    'url'       => wp_get_attachment_url( $id )
                );
            }
        }
    }
    $json['success'] = true;
    wp_send_json($json );
}
