<?php
/* add_ons_php */
/**
 * Disable front-end builder
 */
function homeradar_vc_remove_frontend_links() {
    vc_disable_frontend(); // this will disable frontend editor
}
//add_action( 'vc_after_init', 'homeradar_vc_remove_frontend_links' );

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
add_action( 'vc_before_init', 'homeradar_vcSetAsTheme' );
if(!function_exists('homeradar_vcSetAsTheme')){
    function homeradar_vcSetAsTheme() {
        vc_set_as_theme($disable_updater = true);
    }
}

// Add new Param in Row
function homeradar_add_ons_add_vc_param(){
    if(function_exists('vc_add_param')){
        vc_add_param(
            'vc_row',
            array(
                "type" => "dropdown",
                "heading" => esc_html__('HomeRadar Predefined Section Layout', 'homeradar-add-ons'),
                "param_name" => "cth_layout",
                "value" => array(   
                                esc_html__('Default', 'homeradar-add-ons') => 'default',  
                                esc_html__('HomeRadar Home (Fullheight) Section', 'homeradar-add-ons') => 'homeradar_homefullheight_sec',
                                esc_html__('HomeRadar Page Header Section', 'homeradar-add-ons') => 'homeradar_head_sec',
                                esc_html__('HomeRadar Page Section', 'homeradar-add-ons') => 'homeradar_page_sec',
                                esc_html__('HomeRadar Background Video', 'homeradar-add-ons') => 'homeradar_video_bg_sec',

                ),
                "description" => esc_html__("Select one of the pre made page sections or using default", 'homeradar-add-ons'), 
                "group" => "HomeRadar Theme",
            ) 
        );



        vc_add_param('vc_row',array(
                                
                                "type" => "dropdown",
                                "heading" => esc_html__('Content Width', 'homeradar-add-ons'),
                                "param_name" => "is_fullwidth",
                                "value" => array(   
                                                esc_html__('Fullwidth','homeradar-add-ons' ) => 'yes',  
                                                esc_html__('Wide Boxed','homeradar-add-ons' ) => 'wide',  
                                                esc_html__('Small Boxed','homeradar-add-ons' ) => 'no',   
                                                                                                                                
                                            ),
                                "std" => 'no',
                                

                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value' => array( 'homeradar_homefullheight_sec','homeradar_head_sec','homeradar_page_sec','homeradar_video_bg_sec'),
                                    'not_empty' => false,
                                ),


                                "group" => "HomeRadar Theme",
                            ) 

        );



        vc_add_param('vc_row',array(
                                
                                "type" => "dropdown",
                                "heading" => esc_html__('No Padding', 'homeradar-add-ons'),
                                "param_name" => "no_padding",
                                "value" => array(   
                                                esc_html__('Yes', 'homeradar-add-ons') => 'yes',  
                                                esc_html__('No', 'homeradar-add-ons') => 'no',   
                                                                                                                                
                                            ),
                                "std" => 'no',
                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value' => array( 'homeradar_page_sec','homeradar_head_sec','homeradar_video_bg_sec'),
                                    'not_empty' => false,
                                ),


                                "group" => "HomeRadar Theme",
                            ) 

        );

        vc_add_param('vc_row',array(
                                
                                "type" => "dropdown",
                                "heading" => esc_html__('Background Color', 'homeradar-add-ons'),
                                "param_name" => "homeradar_bg_color",
                                "value" => array(   
                                                esc_html__( 'Theme Color','homeradar-add-ons' ) => 'color-bg',
                                                esc_html__( 'White Color','homeradar-add-ons' ) => 'white-color-bg',
                                                esc_html__( 'Dark Color','homeradar-add-ons' ) => 'dark-bg',
                                                esc_html__( 'Gray Color','homeradar-add-ons' ) => 'gray-bg',
                                                esc_html__( 'Transparent Color','homeradar-add-ons' ) => 'transparent-color-bg',
                                                                                                                                
                                            ),
                                "std" => 'white-color-bg',
                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value' => array( 'homeradar_homefullheight_sec','homeradar_head_sec','homeradar_page_sec','homeradar_video_bg_sec'),
                                    'not_empty' => false,
                                ),
                                "group" => "HomeRadar Theme",  
                            ) 

        );

        vc_add_param('vc_row',array(
                                
                                "type" => "dropdown",
                                "heading" => esc_html__('Background Video Type', 'homeradar-add-ons'),
                                "param_name" => "bg_video_type",
                                "value" => array(   
                                               esc_html__('Youtube Video','homeradar-add-ons' ) => 'youtube',  
                                               esc_html__('Vimeo Video','homeradar-add-ons' ) => 'vimeo',  
                                               esc_html__('Hosted Video','homeradar-add-ons' ) => 'hosted',  
                                                                                                                                
                                            ),
                                "std" => 'hosted',
                                

                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value' => array('homeradar_video_bg_sec'),
                                    'not_empty' => false,
                                ),


                                "group" => "HomeRadar Theme",
                            ) 

        );

        vc_add_param('vc_row',array(
                                "type" => "textfield",
                                "heading" => esc_html__('Video URL', 'homeradar-add-ons'),
                                "param_name" => "bg_video",
                                "value" => "",
                                "description" => esc_html__("Enter your Youtube, Vimeo video ID or URL for hosted video.", 'homeradar-add-ons'),
                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value'     => array('homeradar_video_bg_sec'),
                                    'not_empty' => false,
                                ),
                                "group" => "HomeRadar Theme",
                            ) 

        );

        vc_add_param('vc_row',array(
                                "type"          => "dropdown",
                                "heading"       => esc_html__('Mute', 'homeradar-add-ons'),
                                "param_name"    => "bg_video_mute",
                                "value"         => array(   
                                                    esc_html__('Yes', 'homeradar-add-ons') => '1',  
                                                    esc_html__('No', 'homeradar-add-ons') => '0',                                                                                
                                ),
                                "std"           =>"1",
                                'dependency' => array(
                                    'element' => 'bg_video',
                                    'not_empty' => true,
                                ),


                                "group" => "HomeRadar Theme",  
                            )

        );

        vc_add_param('vc_row',array(
                                    "type"          => "dropdown",
                                    "heading"       => esc_html__('Loop', 'homeradar-add-ons'),
                                    "param_name"    => "bg_video_loop",
                                    "value"         => array(   
                                                        esc_html__('Yes', 'homeradar-add-ons') => '1',  
                                                        esc_html__('No', 'homeradar-add-ons') => '0',                                                                                
                                    ),
                                    "std"           =>"1",
                                    'dependency' => array(
                                        'element' => 'bg_video',
                                        'not_empty' => true,
                                    ),


                                    "group" => "HomeRadar Theme",  
                                )

        );

        vc_add_param('vc_row',array(
                                    "type" => "attach_image",
                                    "heading" => esc_html__('Parallax Background Image', 'homeradar-add-ons'),
                                    "param_name" => "parallax_inner",
                                    'dependency' => array(
                                        'element' => 'cth_layout',
                                        'value' => array('homeradar_homefullheight_sec','homeradar_head_sec', 'homeradar_page_sec','homeradar_video_bg_sec'),
                                        'not_empty' => false,
                                    ),
                                    "group" => "HomeRadar Theme",
                                )

        );


        vc_add_param('vc_row', array(
                        'type' => 'colorpicker',
                        'heading' => esc_html__( 'Overlay Background Color', 'homeradar-add-ons' ),
                        'param_name' => 'overlay_color',
                        'value'=>'rgba(0,0,0,1)',
                        'description' => esc_html__( 'Select custom background color color.', 'homeradar-add-ons' ),
                        'dependency' => array(
                            'element' => 'parallax_inner',
                            'not_empty' => true,
                        ),

                        "group" => "HomeRadar Theme",
            )
        );

        vc_add_param('vc_row',array(
                                "type" => "textfield",
                                "heading" => esc_html__('Background Parallax Value', 'homeradar-add-ons'),
                                "param_name" => "parallax_inner_val",
                                "value" => "",
                                "description" => esc_html__("Parallax CSS style values, separated by comma. Ex: 'translateX': '50px','translateY': '250px' ", 'homeradar-add-ons').'<a href="'.esc_url('https://github.com/iprodev/Scrollax.js/blob/master/docs/Markup.md' ).'" target="_blank">'.esc_html__('Scrollax Documentation','homeradar-add-ons' ).'</a>',
                                'dependency' => array(
                                    'element' => 'parallax_inner',
                                    'not_empty' => true,
                                ),
                                "group" => "HomeRadar Theme",
                            ) 

        );

        

    }
}

add_action('init','homeradar_add_ons_add_vc_param' );