<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
class CTH_Woo_Mem_Plans extends Widget_Base { 

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'woo_mem_plans';
    }

    // public function get_id() {
    //      return 'header-search';
    // }

    public function get_title() {
        return __( 'Membership Plans - Woo', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => __( 'Plans Query', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'ids',
            [
                'label' => __( 'Enter Plan IDs', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter Plan ids to show, separated by a comma. Leave empty to show all.", 'homeradar-add-ons')
                
            ]
        );
        $this->add_control(
            'ids_not',
            [
                'label' => __( 'Or Plan IDs to Exclude', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter plan ids to exclude, separated by a comma (,). Use if the field above is empty.", 'homeradar-add-ons')
                
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => __( 'Order by', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'date' => esc_html__('Date', 'homeradar-add-ons'), 
                    'ID' => esc_html__('ID', 'homeradar-add-ons'), 
                    'author' => esc_html__('Author', 'homeradar-add-ons'), 
                    'title' => esc_html__('Title', 'homeradar-add-ons'), 
                    'modified' => esc_html__('Modified', 'homeradar-add-ons'),
                    'rand' => esc_html__('Random', 'homeradar-add-ons'),
                    'comment_count' => esc_html__('Comment Count', 'homeradar-add-ons'),
                    'menu_order' => esc_html__('Menu Order', 'homeradar-add-ons'),
                    'post__in' => esc_html__('ID order given (post__in)', 'homeradar-add-ons'),
                ],
                'default' => 'date',
                'separator' => 'before',
                'description' => esc_html__("Select how to sort retrieved posts. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Sort Order', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'homeradar-add-ons'), 
                    'DESC' => esc_html__('Descending', 'homeradar-add-ons'), 
                ],
                'default' => 'ASC',
                'separator' => 'before',
                'description' => esc_html__("Select Ascending or Descending order. More at", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Plans to show', 'homeradar-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '4',
                'description' => esc_html__("Number of plans to show (-1 for all).", 'homeradar-add-ons'),
                
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Plans Layout', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'columns_grid',
            [
                'label' => __( 'Columns Grid', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one' => esc_html__('One Column', 'homeradar-add-ons'), 
                    'two' => esc_html__('Two Columns', 'homeradar-add-ons'), 
                    'three' => esc_html__('Three Columns', 'homeradar-add-ons'), 
                    'four' => esc_html__('Four Columns', 'homeradar-add-ons'), 
                    'five' => esc_html__('Five Columns', 'homeradar-add-ons'), 
                    'six' => esc_html__('Six Columns', 'homeradar-add-ons'), 
                    
                ],
                'default' => 'four',
                
                
            ]
        );


        $this->add_control(
            'best_price_item',
            [
                'label' => __( 'Best Price Item', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '2',
                'description' => esc_html__("Best price item number. 1 for first item. Leave empty for none.", 'homeradar-add-ons'),
            ]
        );

        // $this->add_control(
        //     'best_price_icon',
        //     [
        //         'label' => __( 'Best Price Icon', 'homeradar-add-ons' ),
        //         'type' => 'cthicon',
        //         'default' => 'fal fa-check',
        //         'label_block' => true,
        //     ]
        // );
        $this->add_control(
            'best_price_text',
            [
                'label' => __( 'Best Price Recommended Text', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Recommended',
                'label_block' => true,
                
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Simple Pricing For Everyone Users:',
                'description' => '',
                'label_block' => true,
            ]
        );
        // $this->add_control(
        //     'show_pricing_switcher',
        //     [
        //         'label' => __( 'Show Button Switcher Pricing', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => 'no',
        //         'label_on' => __( 'Show', 'homeradar-add-ons' ),
        //         'label_off' => __( 'Hide', 'homeradar-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );



        


        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        
        if(!empty($settings['ids'])){
            $ids = explode(",", $settings['ids']);
            $post_args = array(
                'post_type' => 'lplan',
                
                'posts_per_page'=> $settings['posts_per_page'],
                'post__in' => $ids,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }elseif(!empty($settings['ids_not'])){
            $ids_not = explode(",", $settings['ids_not']);
            $post_args = array(
                'post_type' => 'lplan',
                
                'posts_per_page'=> $settings['posts_per_page'],
                'post__not_in' => $ids_not,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }else{
            $post_args = array(
                'post_type' => 'lplan',
                
                'posts_per_page'=> $settings['posts_per_page'],
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }



        $currency_attrs = homeradar_addons_get_currency_attrs();
        $css_classes = array(
            'membership-plans-wrap cthiso-isotope-wrapper',
            'curr-pos-'.$currency_attrs['sb_pos'],
            $settings['columns_grid'].'-cols',
        );

        $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

        ?>
        <div class="<?php echo esc_attr($css_class );?>">
            <?php if( !empty($settings['title']) ): ?><div class="pricing-switcher-header"><?php echo $settings['title']; ?></div><?php endif; ?>
        <?php 
            // $checkout_page_id = esb_addons_get_wpml_option('checkout_page');

            $posts_query = new \WP_Query($post_args);
            if($posts_query->have_posts()) : ?>
                <div class="cthiso-big-pad cthiso-<?php echo esc_attr($settings['columns_grid']);?>-cols clearfix cthiso-flex">
                <?php 
                $idx = 1;
                $best_price_item = $settings['best_price_item'];
                while($posts_query->have_posts()) : $posts_query->the_post();
                    $_price = get_post_meta( get_the_ID(), '_price', true );
                    $period = get_post_meta( get_the_ID(), ESB_META_PREFIX.'period', true );
                    $interval = get_post_meta( get_the_ID(), ESB_META_PREFIX.'interval', true );

                    $period_text = homeradar_add_ons_get_plan_period_text($interval, $period);
                    
                    $cls = 'pricing-column';
                    $color = get_post_meta( get_the_ID(), ESB_META_PREFIX.'color', true );
                    $headbg = $color .'-gradient-bg';
                    $btncls = $color .'-bg';
                    if($best_price_item == $idx){
                        // $headbg = 'gradient-bg';
                        // $btncls = 'color-bg';
                        $cls .= ' best-price';
                    }
                    $is_free = true;
                    if( (float)$_price > 0 ) $is_free = false;
                    
                 ?>
                 <!-- plan-item -->
                    <div class="pricing-wrap cthiso-item">
                    <div class="<?php echo esc_attr($cls); ?>">
                        <div class="pricing-header <?php echo esc_attr($headbg); ?>">
                            <?php 
                            the_title( '<h3 class="pricing-item-title"><span>'.str_pad($idx, 2, '0', STR_PAD_LEFT).'.</span>', '</h3>', true ); 
                            
                            ?>
                            <div class="price-num price-item fl-wrap">
                                <div class="price-num-item"><span class="mouth-cont"><span class="curen"><?php echo $currency_attrs['symbol']; ?></span><?php echo homeradar_addons_get_price_formated($_price, false); ?></span></div>
                                <div class="price-num-desc"><span class="mouth-cont"><?php echo $period_text; ?></span></div>
                            </div>
                            <?php if( $subtitle = get_post_meta( get_the_ID(), ESB_META_PREFIX.'subtitle', true ) ) echo '<p class="pricing-item-subtitle">'.$subtitle.'</p>';  ?>
                            
                        </div>
                        <?php if($best_price_item == $idx){ ?>
                            <div class="recomm-price color-bg"><?php echo $settings['best_price_text']; ?></div>
                        <?php } ?>
                        <div class="pricing-content">
                        
                            <div class="price-desc">
                                <?php the_content(); ?>
                            </div>

                            <?php if(is_user_logged_in()) : ?>
                            <a href="<?php echo homeradar_addons_get_add_to_cart_url( get_the_ID() );?>" class="price-link <?php echo esc_attr($btncls); ?>"><?php echo sprintf(__( 'Choose %s', 'homeradar-add-ons' ), get_the_title()); ?></a>
                            <?php else : 
                                $logBtnAttrs = homeradar_addons_get_login_button_attrs( 'orderplan', 'current' );
                            ?>
                            <a href="<?php echo esc_url( $logBtnAttrs['url'] );?>" class="price-link <?php echo esc_attr( $logBtnAttrs['class'] );?> <?php echo esc_attr($btncls); ?>" data-message="<?php esc_attr_e( 'You must be logged in to order a membership plan.', 'homeradar-add-ons' ); ?>"><?php echo sprintf(__( 'Choose %s', 'homeradar-add-ons' ), get_the_title()); ?></a>
                            <?php endif; ?>

                        </div>
                    </div>
                    </div>
                    <!-- plan-item end  -->

                <?php 
                $idx++;
                endwhile; ?>
                
            </div><!-- end .pricing-wrap -->
            <?php endif; ?> 

        </div>
        <?php wp_reset_postdata();?>
        <?php

    }

    // protected function _content_template() {}

   
    

}



