<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Wk_Hours extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'wk_hours';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Working Hours', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_images',
            [
                'label' => __( 'Hours', 'homeradar-add-ons' ),
            ]
        );

        

        $this->add_control(
            'values',
            [
                'label' => __( 'Hour Item', 'homeradar-add-ons' ),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'title' => 'Monday - Friday:',
                        'value' => '8am - 6pm',
                    ],
                    [
                        'title' => 'Saturday - Sunday:',
                        'value' => '9am - 3pm',
                    ],
                ],
                'fields' => [
                    [
                        'name' => 'title',
                        'label' => __( 'Title', 'homeradar-add-ons' ),
                        'type' => Controls_Manager::TEXT,
                        'default' => 'Monday - Friday:',
                        'label_block' => true,
                    ],
                    [
                        'name' => 'value',
                        'label' => __( 'Value', 'homeradar-add-ons' ),
                        // 'type' => Controls_Manager::WYSIWYG,
                        'type' => Controls_Manager::TEXT,
                        'default' => '8am - 6pm',
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );


        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
        if(is_array($settings['values']) && !empty($settings['values']) ):

        ?>
        <div class="fw_hours fl-wrap">
            <?php
            foreach ($settings['values'] as $key => $value) {
            ?>
                <span><?php echo esc_html($value['title']); ?><strong><?php echo esc_html($value['value']); ?></strong></span>
            <?php

            }
            ?>
        </div>
        <?php
        endif;
    }

    protected function _content_template() {
        ?>
        <# if(settings.values){ #>
        <div class="fw_hours fl-wrap">
            <# settings.values.forEach(vl=>{ #>
                <span>{{{vl.title}}}<strong>{{{vl.value}}}</strong></span>
            <# }) #>
        </div>
        <# } #>
        <?php
    }

}
