<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Section_Title extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() { 
        return 'section_title';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Section Title', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );

        
        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'st1' => esc_html__('Style 1', 'homeradar-add-ons'), 
                    'st2' => esc_html__('Style 2', 'homeradar-add-ons'), 
                    
                ],
                'default' => 'st1',                
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'BROWSE HOT OFFERS',
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'over_title',
            [
                'label' => __( 'Sub Title', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Latest Properties',
                'label_block' => true,
                // 'separator' => 'before'
                
            ]
        );
        $this->add_control(
            'align',
            [
                'label' => __( 'Alignment', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'left' => esc_html__('Left', 'homeradar-add-ons'), 
                    'center' => esc_html__('Center', 'homeradar-add-ons'), 
                    'right' => esc_html__('Right', 'homeradar-add-ons'), 
                ],
                'default' => 'center',                
            ]
        );

        // $this->add_control(
        //     'show_stars',
        //     [
        //         'label' => __( 'Show Stars', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => 'yes',
        //         'label_on' => __( 'Show', 'homeradar-add-ons' ),
        //         'label_off' => __( 'Hide', 'homeradar-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );
        // $this->add_control(
        //     'show_sep',
        //     [
        //         'label' => __( 'Show Separator', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => 'yes',
        //         'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
        //         'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );
        // $this->add_control(
        //     'separator_color',
        //     [
        //         'label' => __( 'Separator Color', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SELECT,
        //         'options' => [
        //             'theme' => esc_html__('Theme', 'homeradar-add-ons'), 
        //             'yellow' => esc_html__('Yellow', 'homeradar-add-ons'), 
        //             'dk-blue' => esc_html__('Dark Blue', 'homeradar-add-ons'), 
        //         ],
        //         'default' => 'dk-blue',                
        //     ]
        // );
        $this->add_control(
            'sub_title',
            [
                'label' => __( 'Description', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXTAREA, // WYSIWYG,
                'default' => '',
                // 'show_label' => false,
            ]
        );

        

        

        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();
        ?>
        <div class="section-title st-<?php echo $settings['align']; ?> st-<?php echo $settings['style']; ?>">
            
            <?php if(!empty($settings['title'])) echo '<h4 class="sec-subtitle"><span>'.$settings['title'].'</span></h4>'; ?>
            <?php if(!empty($settings['over_title'])) echo '<h2 class="sec-title">'.$settings['over_title'].'</h2>'; ?>
            <div class="st-desc"><?php echo $settings['sub_title'];?> </div>
        </div>
        <?php

    }

    protected function _content_template() {
        ?>
        <div class="section-title st-{{settings.align}} st-{{settings.style}}">
            <# if(settings.title){ #><h4 class="sec-subtitle"><span>{{{settings.title}}}</span></h4><# } #>
            <# if(settings.over_title){ #><h2 class="sec-title">{{{settings.over_title}}}</h2><# } #>
            <div class="st-desc">{{{settings.sub_title}}}</div>
        </div>
        <?php

    }

   
   

}

// Plugin::instance()->widgets_manager->register_widget( 'Elementor\Widget_Header_Search' );

// Plugin::$instance->elements_manager->create_element_instance

