<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Process extends Widget_Base { 

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'process';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Process', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'sty1' => esc_html__('Style 1', 'homeradar-add-ons'), 
                    'sty2' => esc_html__('Style 2', 'homeradar-add-ons'), 
                ],
                'default' => 'sty1',
                
            ]
        );

        
        $this->add_control(
            'step',
            [
                'label' => __( 'Step Number', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '01',
                // 'label_block' => true,
                
            ]
        );

        // $this->add_control(
        //     'icon',
        //     [
        //         'label' => __( 'Icon', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::ICON,
        //         'include' => array_keys( homeradar_addons_extract_awesome_pro_icon_array() ),
        //         'default' => 'fal fa-map-marker-alt',
        //     ]
        // );
        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'homeradar-add-ons' ),
                'type' => 'cthicon',
                // 'include' => array_keys( homeradar_addons_extract_awesome_pro_icon_array() ),
                'default' => 'fal fa-map-marker-alt',
            ]
        );

    
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Find Interesting Place',
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'desc',
            [
                'label' => __( 'Description', 'homeradar-add-ons' ),
                'type' => Controls_Manager::WYSIWYG,
                'default' => '<p>Proin dapibus nisl ornare diam varius tempus. Aenean a quam luctus, finibus tellus ut, convallis eros sollicitudin turpis.</p>',
                'show_label' => false,
                
            ]
        );

        $this->add_control(
            'show_decor',
            [
                'label' => __( 'Show Decoration', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'bot_decor',
            [
                'label' => __( 'Bottom Decoration', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'bot_icon',
            [
                'label' => __( 'Bottom Icon', 'homeradar-add-ons' ),
                'type' => 'cthicon',
                'default' => '',
                'condition' => [
                    'protype' => ['default'],
                ],
            ]
        );

        $this->end_controls_section();

        

    }

    protected function render( ) {
        $settings = $this->get_settings();
        $cls = 'services-item';
        ?>  
        <!--services-box --> 
        <div class="<?php echo esc_attr( $cls ); ?> <?php echo esc_attr( $settings['style'] ); ?>">
            <?php if($settings['icon']!=''): ?>
            <div class="service-icon">
                <i class="<?php echo $settings['icon']; ?>"></i>
            </div>
            <?php endif; ?>
            <div class="service-ithead dis-flex jtf-space-between">
                <?php if($settings['title']!='') echo '<h4 class="service-title">'.$settings['title'].'</h4>'; ?>
                <span><?php echo $settings['step'];?></span>
            </div>
            <?php echo $settings['desc']; ?>
        </div>
        <!-- services-box end  -->      
        <?php
    }

    protected function _content_template() {
        ?>
        <!--services-box --> 
        <div class="services-item {{settings.style}}">
            <# if(settings.icon!=''){ #>
            <div class="service-icon">
                <i class="{{settings.icon}}"></i>
            </div>
            <# } #>
            <div class="service-ithead dis-flex jtf-space-between">
            <# if(settings.title){ #><h4 class="service-title">{{{settings.title}}}</h4><# } #>
            <span>{{{settings.step}}}</span>
            </div>
            {{{settings.desc}}}
        </div>
        <!-- services-box end  -->      
        <?php
    }

}

