<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Pricing_Item extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'pricing_item';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Pricing Item', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Extended',
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __( 'SubTitle', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Lorem ipsum dolor amet, consectetur adipiscing elit.',
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'price',
            [
                'label' => __( 'Price', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '99',
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'currency',
            [
                'label' => __( 'Currency', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '$',
                
            ]
        );

        $this->add_control(
            'period',
            [
                'label' => __( 'Currency', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Per month',
                
            ]
        );

        $this->add_control(
            'features',
            [
                'label' => __( 'Features', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXTAREA, //WYSIWYG,
                'default' => '<ul>
    <li>Ten Listings</li>
    <li>Lifetime Availability</li>
    <li>Featured In Search Results</li>
    <li class="not-included">24/7 Support</li>
</ul>',
                
                'show_label' => false,
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label'         => __( 'Button Text', 'homeradar-add-ons' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => 'Choose Extended',
                'label_block'   => false,
                
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label'         => __( 'Button URL', 'homeradar-add-ons' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => '#',
                'label_block'   => true,
                
            ]
        );


        // $this->add_control(
        //     'is_featured',
        //     [
        //         'label' => __( 'Featured Price', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => 'no',
        //         'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
        //         'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );

        // $this->add_control(
        //     're_icon',
        //     [
        //         'label' => __( 'Recommended Icon', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::ICON,
        //         'default' => 'fa fa-check',
        //         'label_block' => true,
        //     ]
        // );
        $this->add_control(
            're_text',
            [
                'label' => __( 'Recommended Text', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Recommended',
                'label_block' => true,
                
            ]
        );

        // $this->add_control(
        //     'plcolor',
        //     [
        //         'label' => __( 'Color', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SELECT,
        //         'options' => [
        //             'color' => esc_html__('Theme color', 'homeradar-add-ons'),
        //             'purp'  => esc_html__('Purple', 'homeradar-add-ons'),
        //             'green' => esc_html__('Green', 'homeradar-add-ons'),
        //             'blue'  => esc_html__('Blue', 'homeradar-add-ons'),
        //         ],
        //         'default' => 'color',
        //         'separator' => 'before',
                
        //     ]
        // );








        

        

        

        $this->end_controls_section();

        

    }

    protected function render( ) {
        $settings = $this->get_settings();

        ?>
        <div class="pricing-column<?php // if($settings['is_featured'] == 'yes') echo ' best-price';?>">
            <div class="pricing-header">
                <?php if($settings['title'] !='') echo '<h3 class="pricing-item-title">'.$settings['title'].'</h3>'; ?>
                <div class="price-num price-item fl-wrap">
                    <div class="price-num-item"><span class="mouth-cont"><span class="curen"><?php echo $settings['currency']; ?></span><?php echo $settings['price']; ?></span></div>
                    <div class="price-num-desc"><span class="mouth-cont"><?php echo $settings['period']; ?></span></div>
                </div>
                <?php if($settings['sub_title'] !='') echo '<p class="pricing-item-subtitle">'.$settings['sub_title'].'</p>'; ?>
            </div>
            <?php if($settings['re_text'] != ''){ ?>
                <div class="recomm-price color-bg"><?php echo $settings['re_text']; ?></div>
            <?php } ?>
            <div class="pricing-content">
            
                <div class="price-desc">
                    <?php if($settings['features'] !='') echo $settings['features']; ?>
                </div>

                <?php if( $settings['btn_text'] != '' && $settings['btn_link'] != '' ):
                ?>
                <a class="price-link color-bg" href="<?php echo esc_url( $settings['btn_link'] ); ?>"><?php echo esc_html( $settings['btn_text'] ); ?></a>
                <?php
                endif; ?>

            </div>

        </div>
        <?php
    }

    // protected function _content_template() {}

   
    

}



