<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Parallax_Content extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'parallax_content';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Parallax Content', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Our Story Video',
                'label_block' => true,
                
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Get ready to start your exciting journey. <br />Our agency will lead you through the amazing digital world',
                'label_block' => true,
                
            ]
        );

        // $this->add_control(
        //     'show_separator',
        //     [
        //         'label' => __( 'Show Separator', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => 'no',
        //         'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
        //         'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );
        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
        ?>
        <div class="parallax-content">
            <div class="video_section-title fl-wrap">
                <?php 
                    if($settings['title'] !='') echo '<h2>'.$settings['title'].'</h2>';
                    // if($settings['show_separator'] == 'yes'){ echo '<span class="section-separator"></span>'; };
                    
                ?>
                <div class="vid-title-content"><?php echo $settings['sub_title'];?></div>
            </div>
        </div>
        <?php

    }

    protected function _content_template() {
        ?>
        <div class="parallax-content">
            <div class="video_section-title fl-wrap">
                <# if(settings.title){ #><h2>{{{settings.title}}}</h2><# } #>
                <div class="vid-title-content">{{{settings.sub_title}}}</div>
            </div>
        </div>
        <?php
    }



}
