<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Our_Socials extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'our_socials'; 
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Our Socials', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label'         => __( 'Title', 'homeradar-add-ons' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => 'FIND US ON: ',
                'label_block'   => true,
                
            ]
        );
        $this->add_control(
            'socials',
            [
                    'label' => __( 'Socials', 'homeradar-add-ons' ),
                    'type' => Controls_Manager::REPEATER,
                    'default' => [
                            [
                                'name' => 'Facebook',
                                'icon' => 'fab fa-facebook-f',
                                'link' => ['url'=>'https://facebook.com','is_external'=>true],
                            ],
                            [
                                'name' =>'Twitter',
                                'icon' => 'fab fa-twitter',
                                'link' => ['url'=>'https://twitter.com/','is_external'=>true],
                            ],
                            [
                                'name' => 'Instagram',
                                'icon' => 'fab fa-instagram',
                                'link' => ['url'=>'https://www.instagram.com/','is_external'=>true],
                            ],
                            [
                                'name' =>  'VKontakte',
                                'icon' => 'fab fa-vk',
                                'link' => ['url'=>'https://vk.com/','is_external'=>true],
                            ],
                    ],
                    'fields' => [
                            [
                                'name' => 'name',
                                'label' => __( 'Name', 'homeradar-add-ons' ),
                                'type' => Controls_Manager::TEXT,
                                'default' => 'Social Name',
                                'label_block' => true,
                            ],
                            [
                                'name' => 'icon',
                                'label' => __( 'Icon', 'homeradar-add-ons' ),
                                'type' => 'cthicon',
                                'default' => '',
                                'label_block' => true,
                            ],
                            
                            [
                                'name' => 'link',
                                'label' => __( 'Link', 'homeradar-add-ons' ),
                                'type' => Controls_Manager::URL,
                                'default' => [
                                            'url' => '',
                                            'is_external' => '',
                                        ],
                            ]
                    ],
                    'title_field' => '{{{ name }}}',
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'st1' => esc_html__('Style 1', 'homeradar-add-ons'), 
                    'st2' => esc_html__('Style 2', 'homeradar-add-ons'), 
                    
                ],
                'default' => 'st1',                
            ]
        );

        

        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings_for_display();
        $socials = $settings['socials'];
        $title = $settings['title'];

        ?>
        <div class="contact-social flex-items-center socials-<?php echo $settings['style']; ?>">
            <?php if( !empty($title) ): ?><span class="cs-title"><?php echo $title; ?></span><?php endif; ?>
            <?php
            if(!empty($socials)) :
            ?> 
            <ul class="socials-ul">
                <?php 
                foreach ($socials as $key => $social) {
                    $url = $social['link']['url'];
                    $target = $social['link']['is_external'] ? 'target="_blank"' : '';
                    ?>
                    <li><a href="<?php echo esc_attr( $url ); ?>" <?php echo $target;?>><i class="<?php echo esc_attr( $social['icon'] ); ?>"></i></a></li>
                    <?php
                } 
                ?>
            </ul>
            <?php
            endif;
            // end if
            ?>
        </div>
        <?php
    }


}
