<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Members_Grid extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'members_grid';
    }

    // public function get_id() {
    //      return 'header-search';
    // }

    public function get_title() {
        return __( 'Team Members Grid', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => __( 'Members Query', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'ids',
            [
                'label' => __( 'Enter Member IDs', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter Member ids to show, separated by a comma. Leave empty to show all.", 'homeradar-add-ons')
                
            ]
        );
        $this->add_control(
            'ids_not',
            [
                'label' => __( 'Or Member IDs to Exclude', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter member ids to exclude, separated by a comma (,). Use if the field above is empty.", 'homeradar-add-ons')
                
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => __( 'Order by', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'date' => esc_html__('Date', 'homeradar-add-ons'), 
                    'ID' => esc_html__('ID', 'homeradar-add-ons'), 
                    'author' => esc_html__('Author', 'homeradar-add-ons'), 
                    'title' => esc_html__('Title', 'homeradar-add-ons'), 
                    'modified' => esc_html__('Modified', 'homeradar-add-ons'),
                    'rand' => esc_html__('Random', 'homeradar-add-ons'),
                    'comment_count' => esc_html__('Comment Count', 'homeradar-add-ons'),
                    'menu_order' => esc_html__('Menu Order', 'homeradar-add-ons'),
                    'post__in' => esc_html__('ID order given (post__in)', 'homeradar-add-ons'),
                ],
                'default' => 'date',
                'separator' => 'before',
                'description' => esc_html__("Select how to sort retrieved posts. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Sort Order', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'homeradar-add-ons'), 
                    'DESC' => esc_html__('Descending', 'homeradar-add-ons'), 
                ],
                'default' => 'DESC',
                'separator' => 'before',
                'description' => esc_html__("Select Ascending or Descending order. More at", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Members to show', 'homeradar-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '3',
                'description' => esc_html__("Number of members to show (-1 for all).", 'homeradar-add-ons'),
                
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Posts Layout', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'columns_grid',
            [
                'label' => __( 'Columns Grid', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one' => esc_html__('One Column', 'homeradar-add-ons'), 
                    'two' => esc_html__('Two Columns', 'homeradar-add-ons'), 
                    'three' => esc_html__('Three Columns', 'homeradar-add-ons'), 
                    'four' => esc_html__('Four Columns', 'homeradar-add-ons'), 
                    'five' => esc_html__('Five Columns', 'homeradar-add-ons'), 
                    'six' => esc_html__('Six Columns', 'homeradar-add-ons'), 
                    'seven' => esc_html__('Seven Columns', 'homeradar-add-ons'), 
                    'eight' => esc_html__('Eight Columns', 'homeradar-add-ons'), 
                    'nine' => esc_html__('Nine Columns', 'homeradar-add-ons'), 
                    'ten' => esc_html__('Ten Columns', 'homeradar-add-ons'), 
                ],
                'default' => 'three',
                // 'description' => esc_html__("Number of posts to show (-1 for all).", 'homeradar-add-ons'),
                
            ]
        );



        $this->add_control(
            'space',
            [
                'label' => __( 'Space', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'exbig' => esc_html__('Extra Big', 'homeradar-add-ons'), 
                    'mbig' => esc_html__('Bigger', 'homeradar-add-ons'), 
                    'big' => esc_html__('Big', 'homeradar-add-ons'), 
                    'medium' => esc_html__('Medium', 'homeradar-add-ons'), 
                    'small' => esc_html__('Small', 'homeradar-add-ons'), 
                    'extrasmall' => esc_html__('Extra Small', 'homeradar-add-ons'), 
                    'no' => esc_html__('None', 'homeradar-add-ons'), 
                    
                ],
                'default' => 'medium',
                // 'description' => esc_html__("Number of posts to show (-1 for all).", 'homeradar-add-ons'),
                
            ]
        );

        

        $this->add_control(
            'view_all_link',
            [
                'label' => __( 'View All URL', 'homeradar-add-ons' ),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '',
                    'is_external' => '',
                ],
                'show_external' => true, // Show the 'open in new tab' button.
            ]
        );


        $this->add_control(
            'show_pagination',
            [
                'label' => __( 'Show Pagination', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );


        


        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        if(is_front_page()) {
            $paged = (get_query_var('page')) ? get_query_var('page') : 1;
        } else {
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        }

        if(!empty($settings['ids'])){
            $ids = explode(",", $settings['ids']);
            $post_args = array(
                'post_type' => 'member',
                'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__in' => $ids,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }elseif(!empty($settings['ids_not'])){
            $ids_not = explode(",", $settings['ids_not']);
            $post_args = array(
                'post_type' => 'member',
                'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__not_in' => $ids_not,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }else{
            $post_args = array(
                'post_type' => 'member',
                'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }




        $css_classes = array(
            'cthiso-items cthiso-flex team-box2',
            'cthiso-'.$settings['space'].'-pad',
            'cthiso-'.$settings['columns_grid'].'-cols',
        );

        $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

        ?>
        <div class="<?php echo esc_attr($css_class );?>">
        <?php 
            $posts_query = new \WP_Query($post_args);
            if($posts_query->have_posts()) : ?>
                <?php while($posts_query->have_posts()) : $posts_query->the_post(); 
                $job_pos = get_post_meta( get_the_ID(), ESB_META_PREFIX.'job_pos', true );
                $email = get_post_meta( get_the_ID(), ESB_META_PREFIX.'email', true );
                ?>
                    <!-- team-item -->
                    

                    <div id="member-<?php the_ID(); ?>" <?php post_class('cthiso-item'); ?>>
                        <div class="team-item">
                            <?php
                            if(has_post_thumbnail( )){ ?>
                            <div class="team-img">
                            <?php the_post_thumbnail('homeradar-featured-image',array('class'=>'respimg') ); ?>
                            </div>
                            <?php } ?>

                            <div class="team-content">
                                <?php
                                the_title( '<h4 class="mem-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
                                if( !empty($job_pos) ) echo '<h5>'.$job_pos.'</h5>';
                                ?>
                                <?php the_excerpt(); ?>
                                
                            </div>
                            <div class="team-footer flex-items-center jtf-space-between">
                                <?php if( !empty($email) ) : ?><a href="mailto:<?php echo $email;?>" class="tolt tf-btn" data-microtip-position="top-right" data-tooltip="<?php echo esc_attr_x( 'Write Message', 'Member email', 'homeradar-add-ons' );?>"><i class="fal fa-envelope"></i></a><?php endif;?>
                                <?php
                                $socials = get_post_meta( get_the_ID(), ESB_META_PREFIX.'socials' ,true ); 
                                if( !empty($socials) ):
                                ?>
                                <div class="team-social">
                                    <ul class="no-list-style">
                                        <?php 
                                        foreach ((array)$socials as $social) {
                                            $iconcs = 'fab fa-'.$social['name'];
                                            if($social['name'] == 'envelope') $iconcs = 'fal fa-'.$social['name'];
                                            echo '<li><a href="'.esc_url($social['url']).'" target="_blank"><i class="'.esc_attr($iconcs).'"></i></a></li>';
                                        } ?>
                                    </ul>
                                </div>
                                <?php endif; ?> 
                                
                            </div>
                        </div>
                    </div>
                    <!-- team-item end  -->

                <?php endwhile; ?>
            <?php endif; ?> 

        </div>
        <?php
        if($settings['show_pagination'] == 'yes') homeradar_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query) ;
        ?>
        <?php
            $url = $settings['view_all_link']['url'];
            $target = $settings['view_all_link']['is_external'] ? 'target="_blank"' : '';
            if($url != '') echo '<div class="view-all-listings"><a href="' . $url . '" ' . $target .' class="btn  dec_btn  color2-bg">'.__('View All','homeradar-add-ons').'<i class="fal fa-arrow-alt-right"></i></a></div>';
        ?>
        <?php wp_reset_postdata();?>
        <?php

    }

    protected function _content_template() {}

   
    

}



