<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

class CTH_Listings_Slider extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'listings_slider';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Listings Slider', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => __( 'Posts Query', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'cat_ids',
            [
                'label' => __( 'Categories to get listings', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT2,
                'options' => homeradar_addons_get_listing_categories_select2(),
                'multiple' => true,
                'label_block' => true,
                // 'default' => 'date',
                // 'separator' => 'before',
                // 'description' => esc_html__("Select how to sort retrieved posts. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );
        $this->add_control(
            'loc_ids',
            [
                'label'       => __('Locations to get listings', 'homeradar-add-ons'),
                'type'        => Controls_Manager::SELECT2,
                'options'     => homeradar_addons_get_listing_locations_hierarchy_select2(),
                'multiple'    => true,
                'label_block' => true,
                // 'default' => 'date',
                // 'separator' => 'before',
                // 'description' => esc_html__("Select how to sort retrieved posts. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.',
            ]
        );


        $this->add_control(
            'tag_ids',
            [
                'label' => __( 'Listing Tags', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter listing tag's ids to get listings from, separated by a comma.", 'homeradar-add-ons')
                
            ]
        );

        $this->add_control(
            'ids',
            [
                'label' => __( 'Enter Post IDs', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter Post ids to show, separated by a comma. Leave empty to show all.", 'homeradar-add-ons')
                
            ]
        );
        $this->add_control(
            'ids_not',
            [
                'label' => __( 'Or Post IDs to Exclude', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter post ids to exclude, separated by a comma (,). Use if the field above is empty.", 'homeradar-add-ons')
                
            ]
        );

        $this->add_control(
            'ltypes',
            [
                'label' => _x( 'Listing Types', 'Elementor element', 'homeradar-add-ons' ),
                'description' => _x('Comma separated string of listing type post ids to get listings from.', 'Elementor element', 'homeradar-add-ons'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
            ]
        );


        $this->add_control(
            'order_by',
            [
                'label' => __( 'Order by', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'date' => esc_html__('Date', 'homeradar-add-ons'), 
                    'ID' => esc_html__('ID', 'homeradar-add-ons'), 
                    'author' => esc_html__('Author', 'homeradar-add-ons'), 
                    'title' => esc_html__('Title', 'homeradar-add-ons'), 
                    'modified' => esc_html__('Modified', 'homeradar-add-ons'),
                    'rand' => esc_html__('Random', 'homeradar-add-ons'),
                    'comment_count' => esc_html__('Comment Count', 'homeradar-add-ons'),
                    'menu_order' => esc_html__('Menu Order', 'homeradar-add-ons'),
                    'post__in' => esc_html__('ID order given (post__in)', 'homeradar-add-ons'),
                ],
                'default' => 'date',
                'separator' => 'before',
                'description' => esc_html__("Select how to sort retrieved posts. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Sort Order', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'homeradar-add-ons'), 
                    'DESC' => esc_html__('Descending', 'homeradar-add-ons'), 
                ],
                'default' => 'DESC',
                'separator' => 'before',
                'description' => esc_html__("Select Ascending or Descending order. More at", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'featured_only',
            [
                'label' => __( 'Show featured listings only?', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
                
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Posts to show', 'homeradar-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '12',
                'description' => esc_html__("Number of posts to show (-1 for all).", 'homeradar-add-ons'),
                
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Posts Layout', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'airbnb',
            [
                'label' => __( 'Simple Style', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'hide_bookmark',
            [
                'label' => __( 'Hide Bookmark', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'hide_status',
            [
                'label' => __( 'Hide Open/Closed status', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'hide_featured',
            [
                'label' => __( 'Hide Featured', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'hide_author',
            [
                'label' => __( 'Hide Author', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'show_logo',
            [
                'label' => _x( 'Show Logo', 'Elementor Option', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'hide_address',
            [
                'label' => __( 'Hide Address', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'hide_rating',
            [
                'label' => __( 'Hide Rating', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'hide_pricerange',
            [
                'label' => __( 'Hide Price range', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );

        // $this->add_control(
        //     'columns_grid',
        //     [
        //         'label' => __( 'Columns Grid', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SELECT,
        //         'options' => [
        //             'one' => esc_html__('One Column', 'homeradar-add-ons'), 
        //             'two' => esc_html__('Two Columns', 'homeradar-add-ons'), 
        //             'three' => esc_html__('Three Columns', 'homeradar-add-ons'), 
        //             'four' => esc_html__('Four Columns', 'homeradar-add-ons'), 
        //             'five' => esc_html__('Five Columns', 'homeradar-add-ons'), 
        //             'six' => esc_html__('Six Columns', 'homeradar-add-ons'), 
        //         ],
        //         'default' => 'three',
        //         // 'description' => esc_html__("Number of posts to show (-1 for all).", 'homeradar-add-ons'),
                
        //     ]
        // );

        $this->add_control(
            'responsive',
            [
                'label' => __( 'Responsive', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '850:1,1270:2,1650:3,2560:4',
                'label_block' => true,
                'description' => __("The format is: screen-size:number-items-display,larger-screen-size:number-items-display. Ex: 850:1,1270:2,1650:3,2560:4", 'homeradar-add-ons')
                
            ]
        );
        $this->add_control(
            'centered_mode',
            [
                'label' => _x( 'Center Mode', 'Elementor Option', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => _x( 'Autoplay', 'Elementor Option', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'show_pagination',
            [
                'label' => __( 'Show Pagination', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __( 'Show', 'homeradar-add-ons' ),
                'label_off' => __( 'Hide', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );
        $this->add_control(
            'read_all_link',
            [
                'label' => __( 'Read All URL', 'homeradar-add-ons' ),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => '',
                ],
                'show_external' => true, // Show the 'open in new tab' button.
            ]
        );
        


        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        // if(is_front_page()) {
        //     $paged = (get_query_var('page')) ? get_query_var('page') : 1;
        // } else {
        //     $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        // }

        if(!empty($settings['ids'])){
            $ids = explode(",", $settings['ids']);
            $post_args = array(
                'post_type' => 'listing',
                // 'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__in' => $ids,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],
                'post_status' => 'publish'
            );
        }elseif(!empty($settings['ids_not'])){
            $ids_not = explode(",", $settings['ids_not']);
            $post_args = array(
                'post_type' => 'listing',
                // 'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__not_in' => $ids_not,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }else{
            $post_args = array(
                'post_type' => 'listing',
                // 'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }





        $tax_queries = array();

        if(!empty($settings['cat_ids'])){
            $tax_queries[] =    array(
                                    'taxonomy' => 'listing_cat',
                                    'field'    => 'term_id',
                                    'terms'    => $settings['cat_ids'],
                                );

        }
        if (!empty($settings['loc_ids'])) {
            $tax_queries[] = array(
                'taxonomy' => 'listing_location',
                'field'    => 'term_id',
                'terms'    => $settings['loc_ids'],
            );
        }
        
        if(!empty($settings['tag_ids'])){
            $tax_queries[] =    array(
                                    'taxonomy' => 'listing_tag',
                                    'field'    => 'term_id',
                                    'terms'    => explode( ",", $settings['tag_ids'] ),
                                );
        }

        if(!empty($tax_queries)){
            // if( count($tax_queries) > 1 ) $tax_queries['relation'] = 'AND';
            $post_args['tax_query'] = $tax_queries;
        } 
        // listing meta search
        $meta_queries = array();
        // check for membership expired
        // if(homeradar_addons_get_option('membership_package_expired_hide') == 'yes'){
        //     $meta_queries['relation'] = 'OR';
        //     $meta_queries[] = array(
        //         'key'     => ESB_META_PREFIX.'expire_date',
        //         'value'   => current_time('mysql', 1),
        //         'compare' => '>=',
        //         'type'    => 'DATETIME',
        //     );
        //     $meta_queries[] = array(
        //         'key'     => ESB_META_PREFIX.'expire_date',
        //         'value'   => 'NEVER',
        //         'compare' => '=',
        //     );

        // }

        if( !empty($settings['ltypes']) ){
            $meta_queries[] =   array(
                                    'key'           => ESB_META_PREFIX .'listing_type_id',
                                    'value'         => explode(",", $settings['ltypes']),
                                    'type'          => 'NUMERIC',
                                    'compare'       => 'IN',
                                );
        }

        if( $settings['featured_only'] == 'yes'){
            $meta_queries[] =   array(
                                    'key'     => ESB_META_PREFIX .'featured',
                                    'value'   => '1',
                                    'type'      => 'NUMERIC'
                                );
        }

        if(!empty($meta_queries)) $post_args['meta_query'] = $meta_queries;


        $css_classes = array(
            'single-carousel-wrap carousel-wrap hrlisting-carousel-wrap',
            // 'posts-grid-',//.$settings['columns_grid']
        );

        if( $settings['airbnb'] == 'yes' ){
            $css_classes[] = 'airbnb-style';
            
        }

        $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

        ?>
        <!-- carousel -->
        <div class="<?php echo esc_attr( $css_class );?>">
            
            <?php 
            $slider_args = array('simulateTouch'=>false);
            $breakpoints = array();
            $slidesPerView = array();
            $responsive = explode( ",", trim( $settings['responsive'] ) );
            $editor_col = 4;
            if( !empty($responsive) ){
                foreach ($responsive as $breakpoint) {
                    $breakpoint = explode( ":", trim($breakpoint) );
                    if( count($breakpoint) === 2 ){
                        $breakpoints[] = array( 'breakpoint' => intval($breakpoint[0]), 'settings' => array( 'slidesToShow'=>intval($breakpoint[1]) ) );
                        $slidesPerView[] = intval($breakpoint[1]);
                    }
                }
            }
            if( !empty($breakpoints) ){
                usort($breakpoints, function($a, $b) {
                    return $b['breakpoint'] - $a['breakpoint'];
                });
                $slider_args['slidesToShow'] = max($slidesPerView);
                $slider_args['responsive'] = $breakpoints;
                $editor_col = $slider_args['slidesToShow'];
            }
            if( isset($settings['autoplay']) && $settings['autoplay'] == 'yes' ) $slider_args['autoplay'] = true;
            $slider_args['centerMode'] = isset($settings['centered_mode']) && $settings['centered_mode'] == 'yes';
            ?>
            

            <div class="single-carousel carousel listing-slider-editor-col-<?php echo esc_attr( $editor_col ); ?>" data-options='<?php echo json_encode($slider_args); ?>'>

                <?php 
                $ad_posts_ids = array();
                do_action( 'homeradar_addons_elementor_listing_slider_before', $settings );
                if( homeradar_addons_get_option('ads_home_enable') == 'yes'){
                    $ad_args = array(
                        'post_type'             => 'listing', 
                        'orderby'               => homeradar_addons_get_option('ads_home_orderby'),
                        'order'                 => homeradar_addons_get_option('ads_home_order'),
                        'posts_per_page'        => homeradar_addons_get_option('ads_home_count'),
                        // 'post__not_in'          => array(get_the_ID()),
                        'meta_query'            => array(
                            'relation' => 'AND',
                            array(
                                'key'     => ESB_META_PREFIX.'is_ad',
                                'value'   => 'yes',
                            ),
                            // array(
                            //     'key'     => ESB_META_PREFIX.'ad_position',
                            //     'value'   => 'home',
                            // ),
                            array(
                                    'key'     => ESB_META_PREFIX.'ad_position_home',
                                    'value'   => '1',
                                    // 'value'   => array('yes','1'),
                                    // 'compare' => 'IN',
                            ),
                            array(
                                'key'     => ESB_META_PREFIX.'ad_expire',
                                'value'   => current_time('mysql', 1),
                                'compare' => '>=',
                                'type'    => 'DATETIME',
                            ),
                        ),

                    );

                    // The Query
                    $ad_posts_query = new \WP_Query( $ad_args );
                    if($ad_posts_query->have_posts()) :

                        while($ad_posts_query->have_posts()) : $ad_posts_query->the_post();
                            $ad_posts_ids[] = get_the_ID();
                            // homeradar_addons_get_template_part( 'template-parts/listing-slider', false, array( 
                            homeradar_addons_get_template_part( 'template-parts/listing', false, array( 
                                'for_slider'        => true, 
                                'is_ad'             => true, 
                                'hide_status'       => $settings['hide_status'], 
                                'hide_featured'     => $settings['hide_featured'],
                                'hide_author'       => $settings['hide_author'],
                                'hide_bookmark'     => $settings['hide_bookmark'], 
                                'hide_address'      => $settings['hide_address'],
                                'hide_rating'       => $settings['hide_rating'],
                                'hide_pricerange'   => $settings['hide_pricerange'],
                                'show_logo'         => $settings['show_logo'],
                            ) );
                            
                        endwhile;
                        wp_reset_postdata();
                    endif;

                }
                if( !empty($ad_posts_ids) ){
                    if( !empty($post_args['post__not_in']) && is_array($post_args['post__not_in']) ){
                        $post_args['post__not_in'] = array_merge( $post_args['post__not_in'], $ad_posts_ids );
                    }else{
                        $post_args['post__not_in'] = $ad_posts_ids;
                    }
                }


                $posts_query = new \WP_Query($post_args);
                if($posts_query->have_posts()) : ?>
                    <?php 
                    while($posts_query->have_posts()) : $posts_query->the_post(); 
                        // homeradar_addons_get_template_part( 'template-parts/listing-slider', false, array( 
                        homeradar_addons_get_template_part( 'template-parts/listing', false, array( 
                            'for_slider'        => true, 
                            // 'is_ad'             => true, 
                            'hide_status'       => $settings['hide_status'], 
                            'hide_featured'     => $settings['hide_featured'],
                            'hide_author'       => $settings['hide_author'],
                            'hide_bookmark'     => $settings['hide_bookmark'], 
                            'hide_address'      => $settings['hide_address'],
                            'hide_rating'       => $settings['hide_rating'],
                            'hide_pricerange'   => $settings['hide_pricerange'],
                            'show_logo'         => $settings['show_logo'],
                        ) );
                    endwhile; ?>
                <?php endif; ?> 

            </div>
            <div class="crs-button-prev lc-wbtn lc-wbtn_prev"><i class="fal fa-angle-left"></i></div>
            <div class="crs-button-next lc-wbtn lc-wbtn_next"><i class="fal fa-angle-right"></i></div>

        </div>
        <!--  carousel end-->
        <?php 
        wp_reset_postdata();

    }


}
