<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Listing_Locations extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name. 
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'listing_locations'; 
    } 

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Listing Locations', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => __( 'Locations Query', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'cat_ids',
            [
                'label' => __( 'Select Locations to include (Leave empty for ALL)', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT2,
                'options' => homeradar_addons_get_listing_locations_select2(),
                'multiple' => true,
                'label_block' => true,
                // 'default' => 'date',
                // 'separator' => 'before',
                // 'description' => esc_html__("Select how to sort retrieved posts. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'cat_ids_not',
            [
                'label' => __( 'Or Locations to exclude (Leave empty for ALL)', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT2,
                'options' => homeradar_addons_get_listing_locations_select2(),
                'multiple' => true,
                'label_block' => true,
                // 'default' => 'date',
                // 'separator' => 'before',
                // 'description' => esc_html__("Select how to sort retrieved posts. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __( 'Order by', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'name' => esc_html__('Name', 'homeradar-add-ons'), 
                    'slug' => esc_html__('Slug', 'homeradar-add-ons'), 
                    'term_group' => esc_html__('Term Group', 'homeradar-add-ons'), 
                    'term_id' => esc_html__('Term ID', 'homeradar-add-ons'), 
                    'description' => esc_html__('Description', 'homeradar-add-ons'),
                    'parent' => esc_html__('Parent', 'homeradar-add-ons'),
                    'count' => esc_html__('Term Count', 'homeradar-add-ons'),
                    'include' => esc_html__('For Include above', 'homeradar-add-ons'),
                ],
                'default' => 'name',
                'separator' => 'before',
                'description' => esc_html__("Select how to sort retrieved categories. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Sort Order', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'homeradar-add-ons'), 
                    'DESC' => esc_html__('Descending', 'homeradar-add-ons'), 
                ],
                'default' => 'DESC',
                'separator' => 'before',
                'description' => esc_html__("Select Ascending or Descending order. More at", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'hide_empty',
            [
                'label' => __( 'Hide Empty', 'homeradar-add-ons' ),
                'description' => esc_html__('Whether to hide categories not assigned to any listings', 'homeradar-add-ons'),
                'type' => Controls_Manager::SWITCHER,
                'default' => '1',
                'label_on' => __( 'Yes', 'homeradar-add-ons' ),
                'label_off' => __( 'No', 'homeradar-add-ons' ),
                'return_value' => '1',
            ]
        );


        $this->add_control(
            'number',
            [
                'label' => __( 'Number of Locations to show', 'homeradar-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '6',
                'description' => esc_html__("Number of Locations to show (0 for all).", 'homeradar-add-ons'),
                'min'     => 0,
                'step'     => 1,
                
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Locations Layout', 'homeradar-add-ons' ),
            ]
        );

        // $this->add_control(
        //     'columns_grid',
        //     [
        //         'label' => __( 'Columns Grid', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SELECT,
        //         'options' => [
        //             'one' => esc_html__('One Column', 'homeradar-add-ons'), 
        //             'two' => esc_html__('Two Columns', 'homeradar-add-ons'), 
        //             'three' => esc_html__('Three Columns', 'homeradar-add-ons'), 
        //             'four' => esc_html__('Four Columns', 'homeradar-add-ons'), 
        //             'five' => esc_html__('Five Columns', 'homeradar-add-ons'), 
        //             'six' => esc_html__('Six Columns', 'homeradar-add-ons'), 
        //             'seven' => esc_html__('Seven Columns', 'homeradar-add-ons'), 
        //             'eight' => esc_html__('Eight Columns', 'homeradar-add-ons'), 
        //             'nine' => esc_html__('Nine Columns', 'homeradar-add-ons'), 
        //             'ten' => esc_html__('Ten Columns', 'homeradar-add-ons'), 
        //         ],
        //         'default' => 'three',
        //         // 'description' => esc_html__("Number of posts to show (-1 for all).", 'homeradar-add-ons'),
                
        //     ]
        // );

        // $this->add_control(
        //     'items_width',
        //     [
        //         'label' => __( 'Locations Items Width', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::TEXT,

        //         'label_block' => true,
        //         // 'default' => 'date',
        //         // 'separator' => 'before',
        //         'description' => esc_html__('Defined location width. Available values are x1(default),x2(x2 width),x3(x3 width), and separated by comma. Ex: x1,x1,x2,x1,x1,x1', 'homeradar-add-ons')
        //     ]
        // );

        // $this->add_control(
        //     'space',
        //     [
        //         'label' => __( 'Space', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SELECT,
        //         'options' => [
        //             'big' => esc_html__('Big', 'homeradar-add-ons'), 
        //             'medium' => esc_html__('Medium', 'homeradar-add-ons'), 
        //             'small' => esc_html__('Small', 'homeradar-add-ons'), 
        //             'extrasmall' => esc_html__('Extra Small', 'homeradar-add-ons'), 
        //             'no' => esc_html__('None', 'homeradar-add-ons'), 
                    
        //         ],
        //         'default' => 'big',
        //         // 'description' => esc_html__("Number of posts to show (-1 for all).", 'homeradar-add-ons'),
                
        //     ]
        // );

        $this->add_control(
            'responsive',
            [
                'label' => __( 'Responsive', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '1650:3,1224:2,564:1',
                'label_block' => true,
                'description' => __("The format is: screen-size:number-items-display,smaller-screen-size:number-items-display. Ex: 1650:3,1224:2,564:1", 'homeradar-add-ons')
                
            ]
        );
        // $this->add_control(
        //     'centered_mode',
        //     [
        //         'label' => _x( 'Center Mode', 'Elementor Option', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => 'yes',
        //         'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
        //         'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );
        $this->add_control(
            'autoplay',
            [
                'label' => _x( 'Autoplay', 'Elementor Option', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'view_all_link',
            [
                'label' => __( 'View All Link', 'homeradar-add-ons' ),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '',
                    'is_external' => '',
                ],
                'description' => __( 'Listing archive page: ', 'homeradar-add-ons' ). get_post_type_archive_link( 'listing' ),
                'show_external' => true, // Show the 'open in new tab' button.
            ]
        );

        $this->add_control(
            'view_all_text',
            [
                'label' => __( 'View all Text', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,

                'label_block' => true,
                'default' => 'View All Cities',
                // 'separator' => 'before',
                'description' =>''
            ]
        );

       
        $this->add_control(
            'count_child',
            [
                'label' => __( 'Count listings from child locations', 'homeradar-add-ons' ),
                'description' => '',
                'type' => Controls_Manager::SWITCHER,
                'default' => '0',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => '1',
            ]
        );


        


        


        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
        $term_args = array(
            'taxonomy' => 'listing_location',
            'hide_empty' => (bool)$settings['hide_empty'],
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
            'number' => $settings['number'],
        );

        if(!empty($settings['cat_ids'])) $term_args['include']  = $settings['cat_ids'];
        elseif(!empty($settings['cat_ids_not'])) $term_args['exclude']  = $settings['cat_ids_not'];
        
        $listing_terms = get_terms( $term_args );

        

        if ( ! empty( $listing_terms ) && ! is_wp_error( $listing_terms ) ){

            $slider_args = array(
                'slidesToShow'      => 3,
                // 'responsive'        => false,
                'adaptiveHeight'    => false,
                'variableWidth'     => false,
                'centerMode'        => false,
                'arrows'            => false,
                'dots'              => true,
                'infinite'          => true,
            );
            $breakpoints = array();
            $slidesPerView = array();
            $responsive = explode( ",", trim( $settings['responsive'] ) );
            $editor_col = 3;
            if( !empty($responsive) ){
                foreach ($responsive as $breakpoint) {
                    $breakpoint = explode( ":", trim($breakpoint) );
                    if( count($breakpoint) === 2 ){
                        $breakpoints[] = array( 'breakpoint' => intval($breakpoint[0]), 'settings' => array( 'slidesToShow'=>intval($breakpoint[1]) ) );
                        $slidesPerView[] = intval($breakpoint[1]);
                    }
                }
            }
            if( !empty($breakpoints) ){
                usort($breakpoints, function($a, $b) {
                    return $b['breakpoint'] - $a['breakpoint'];
                });
                $slider_args['slidesToShow'] = max($slidesPerView);
                $slider_args['responsive'] = $breakpoints;
                $editor_col = $slider_args['slidesToShow'];
            }
            if( isset($settings['autoplay']) && $settings['autoplay'] == 'yes' ) $slider_args['autoplay'] = true;
            // $slider_args['centerMode'] = isset($settings['centered_mode']) && $settings['centered_mode'] == 'yes';
            ?>
            <div class="half-carousel-wrapper listing-slider-editor-col-<?php echo $editor_col; ?>">
                <!-- carousel -->
                <div class="single-carousel-wrap carousel-wrap half-carousel full-heights">
                    <div class="single-carousel carousel" data-options='<?php echo json_encode($slider_args); ?>'>
                        <?php 
                        
                        $key = 0;

                        $dfthumb = '';
                        $default_thumbnail = homeradar_addons_get_option('default_thumbnail');
                        if( $default_thumbnail && !empty($default_thumbnail['id']) ){
                            $dfthumb = $default_thumbnail['id'];
                        }
                    
                        foreach ($listing_terms as $term) { 

                            $lcount = $term->count;
                            // https://wordpress.stackexchange.com/questions/207923/count-posts-in-category-including-child-categories
                            if( (bool)$settings['count_child'] ){
                                $termPosts = new \WP_Query( array(
                                    'post_type'         => 'listing',
                                    'post_status'       => 'publish',
                                    'posts_per_page'    => 1,
                                    'fields'            => 'ids',
                                    'tax_query'         => array(
                                        array(
                                            'taxonomy' => 'listing_location',
                                            'terms'    => array( $term->term_id ),
                                        )
                                    ),
                                        
                                ) );

                                $lcount = $termPosts->found_posts;

                                wp_reset_postdata();
                            }
                            
                            $imgid = '';
                            $term_meta = get_term_meta( $term->term_id, ESB_META_PREFIX.'term_meta', true );
                            if( isset($term_meta['featured_img']) && !empty($term_meta['featured_img']) ){
                               $imgid = $term_meta['featured_img']['id'];
                            }
                            if( empty($imgid) ) $imgid = $dfthumb;
                            // $tnsize = 'homeradar-lcat-one';
                            ?>
                            <div class="slick-item">
                                <div class="half-carousel-item fl-wrap">
                                    <div class="bg-wrap bg-parallax-wrap-gradien">
                                        <div class="bg"  data-bg="<?php echo esc_url( homeradar_addons_get_attachment_thumb_link( $imgid, 'full' ) ); ?>"></div>
                                    </div>
                                    <div class="half-carousel-content">
                                        <div class="hc-counter color-bg"><?php echo sprintf( _n( '<span>%s </span> Property', '<span>%s </span> Properties', $lcount, 'homeradar-add-ons' ), $lcount ); ?></div>
                                        <h3><a href="<?php echo homeradar_addons_get_term_link( $term->term_id, 'listing_location' ); ?>"><?php echo esc_html($term->name); ?></a></h3>
                                        <?php echo term_description( $term->term_id, 'listing_location' ); ?>
                                    </div>
                                </div>
                            </div>
                        <?php
                            $key++;
                        }
                        // end foreach

                        ?>
                            
                    </div>

                </div>
                <!--  carousel end-->
            </div>
            <?php
                $url = $settings['view_all_link']['url'];
                $target = $settings['view_all_link']['is_external'] ? 'target="_blank"' : '';
                if($url != '') echo '<div class="view-all-taxs"><a href="' . $url . '" ' . $target .' class="btn dec_btn   color2-bg">'. $settings['view_all_text'].'<i class="fal fa-arrow-alt-right"></i></a></div>';
            ?>
            
        <?php
        }
        // end if  ! empty( $listing_terms ) && ! is_wp_error( $listing_terms )


        

    }

    protected function _content_template() {}

   
    

}

