<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Image_Quote extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {  
        return 'image_quote';
    }

    // public function get_id() {
    //      return 'header-search';
    // }

    public function get_title() {
        return __( 'Image with Quote', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_images',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'homeradar-add-ons' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => '',
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'image',
            [
                'label'       => __( 'Image', 'homeradar-add-ons' ),
                'type'        => Controls_Manager::MEDIA,
                'default' => [
                    'id'  => 0,
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'quote',
            [   
                'label'         => __( 'Quote', 'homeradar-add-ons' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => '<p>Your website is fully responsive so visitors can view your content from their choice of device.</p>
<h5>Mark Antony</h5>
<h6>Homeradar CEO</h6>',
            ]
        );

        
        $this->add_control(
            'mwidth',
            [
                'label'       => __( 'Width (pixel)', 'homeradar-add-ons' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '600',
                'label_block' => false,
                
            ]
        );


        

        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
          
        ?>
        <div class="about-img fl-wrap">
            <?php if( !empty($settings['image']) ) : ?><?php echo wp_get_attachment_image( $settings['image']['id'],  'full', false, array('class'=>'respimg') ); ?><?php endif; ?>
            <?php if( !empty($settings['quote']) ): ?>
            <div class="about-img-hotifer color-bg">
                <?php echo $settings['quote'];?>
            </div>
            <?php endif; ?>
        </div>
        <?php
        
    }

}
