<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Hero_Slider extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'hero_slider';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Hero Slider', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_images',
            [
                'label' => __( 'Slides', 'homeradar-add-ons' ),
            ]
        );

        

        $this->add_control(
            'slides',
            [
                'label' => __( 'Slide Items', 'homeradar-add-ons' ),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'title' => 'Slide 1',
                        'image' => array(
                            'id' => '6453',
                            'url' => 'http://localhost:8888/homeradar/wp-content/uploads/2019/08/37.jpg'
                        ),
                        'content' => '<div class="row">
    <div class="col-md-6">
        <div class="hero-title ht-column fl-wrap">
            <h4>Real Estate Searching Platform</h4>
            <h2>Find The House of Your Dream  <br>
                Using Our Platform
            </h2>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas in pulvinar neque. Nulla finibus lobortis pulvinar.</p>
        </div>
    </div>
    <div class="col-md-2"></div>
    <div class="col-md-4">
        <div class="msiw-column_title">Use Quick Search</div>
        [hero_search ltype="5058"]
        <div class="hero-notifer fl-wrap">Need more search options? <a href="'.get_post_type_archive_link('listing').'">Advanced Search</a></div>
    </div>
</div>',
                        'scroll_text'           => 'Scroll Down To Discover',
                    ],
                    [
                        'title' => 'Slide 2',
                        'image' => array(
                            'id' => '6819',
                            'url' => 'http://localhost:8888/homeradar/wp-content/uploads/2019/09/7.jpg'
                        ),
                        'content' => '[lslider_card post_id="7439"]',
                        'scroll_text'           => '',
                    ],
                ],
                'fields' => [
                    [
                        'name' => 'title',
                        'label' => __( 'Title (for editing only)', 'homeradar-add-ons' ),
                        'type' => Controls_Manager::TEXT,
                        'default' => 'Slide Title',
                        'label_block' => true,
                    ],
                    [
                        'name' => 'image',
                        'label' => __( 'Image', 'homeradar-add-ons' ),
                        'type' => Controls_Manager::MEDIA,
                        'default' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'content',
                        'label' => __( 'Content', 'homeradar-add-ons' ),
                        'type' => Controls_Manager::TEXTAREA, // WYSIWYG,
                        'default' => '<div class="row">
    <div class="col-md-6">
        <div class="hero-title ht-column fl-wrap">
            <h4>Real Estate Searching Platform</h4>
            <h2>Find The House of Your Dream  <br>
                Using Our Platform
            </h2>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas in pulvinar neque. Nulla finibus lobortis pulvinar.</p>
        </div>
    </div>
    <div class="col-md-2"></div>
    <div class="col-md-4">
        <div class="msiw-column_title">Use Quick Search</div>
        [hero_search ltype="5058"]
        <div class="hero-notifer fl-wrap">Need more search options? <a href="'.get_post_type_archive_link('listing').'">Advanced Search</a></div>
    </div>
</div>',
                        'label_block' => true,
                    ],

                    [
                        'name' => 'scroll_text',
                        'label' => __( 'Scroll Text', 'homeradar-add-ons' ),
                        'type' => Controls_Manager::TEXT, // WYSIWYG,
                        'default' => 'Scroll Down To Discover',
                        'label_block' => true,
                    ],


                    
                ],
                'title_field' => '{{{ title }}}',
            ]
        );


        // $this->add_control(
        //     'active',
        //     [
        //         'label'   => __( 'Active Item - 0 for first item', 'homeradar-add-ons' ),
        //         'type'    => Controls_Manager::NUMBER,
        //         'default' => 0,
        //         'min'     => 0,
        //         'max'     => 100,
        //         'step'    => 1,
        //         'label_block' => true,
        //     ]
        // );
        

        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
        if(is_array($settings['slides']) && !empty($settings['slides']) ):
        ?>
        <div class="hero-slider-wrap carousel-wrap fl-wrap">
            <div class="hero-slider carousel" >
                <?php
                foreach ($settings['slides'] as $key => $slide) {
                    // var_dump($slide);
                ?>
                <!-- hero-slider-item -->
                <div class="hero-slider-item fl-wrap">
                    <div class="bg" data-bg="<?php echo esc_url( homeradar_addons_get_attachment_thumb_link($slide['image']['id'], 'full') ); ?>"></div>
                    <div class="overlay"></div>
                    <div class="hero-slide-inner idx-5 flex-items-center full-height pos-relative">
                        <div class="container">
                            <?php echo do_shortcode( $slide['content'] );?>

                            <?php 
                            if(!empty($slide['scroll_text'])): ?>
                            <div class="pos-relative">
                                <div class="scroll-down-wrap">
                                    <div class="mousey">
                                        <div class="scroller"></div>
                                    </div>
                                    <span><?php echo $slide['scroll_text']; ?></span>
                                </div>
                            </div>
                            <?php 
                            endif;?>

                        </div>
                    </div>
                </div>
                <!--  hero-slider-item end  -->
                <?php
                }
                ?>             
            </div>
            <div class="hs-btn hs-btn_prev color-bg swiper-button-prev"><i class="far fa-angle-left"></i></div>
            <div class="hs-btn hs-btn_next color-bg swiper-button-next"><i class="far fa-angle-right"></i></div>
        </div>

        <?php
        endif;
    }

    // protected function _content_template() {}
    // end _content_template



}
