<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

class CTH_Hero_Section extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'hero_section';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Hero Section', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXTAREA, // WYSIWYG,
                'default' => '<h4>Real Estate Searching Platform</h4>
<h1>Real Estate Searching Platform</h1>
<h2>Find The House of Your Dream  <br>
    Using Our Platform
</h2>',
                'show_label' => false,
            ]
        );

        $this->add_control(
            'ltypes',
            [
                'label' => __( 'Listing Types', 'homeradar-add-ons' ),
                'description' => __('Comma separated string of listing type post ids to get hero filter form from.', 'homeradar-add-ons'),
                'type' => Controls_Manager::TEXT,
                'default' => '6379',
                'label_block' => true,
            ]
        );


        // $this->add_control(
        //     'show_cats',
        //     [
        //         'label' => __( 'Show Categories', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => 'yes',
        //         'label_on' => __( 'Show', 'homeradar-add-ons' ),
        //         'label_off' => __( 'Hide', 'homeradar-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );


        $this->add_control(
            'content_after',
            [
                'label' => __( 'Content After Search', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXTAREA, // WYSIWYG,
                'default' => '<div class="hero-notifer fl-wrap">Need more search options? <a href="'.get_post_type_archive_link('listing').'">Advanced Search</a></div>',
                'show_label' => false,
            ]
        );

        $this->add_control(
            'scroll_text',
            [
                'label' => __( 'Scroll Text', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Scroll Down To Discover',
                
            ]
        );

        $this->add_control(
            'ctalign',
            [
                'label'       => __('Alignment', 'homeradar-add-ons'),
                'type'        => Controls_Manager::SELECT,
                'options'     => [
                    'al-left'        => esc_html__('Align Left', 'homeradar-add-ons'),
                    'al-center'        => esc_html__('Align Center', 'homeradar-add-ons'),
                    'al-right'        => esc_html__('Align Right', 'homeradar-add-ons'),
                ],
                'default'     => 'slug',
                'separator'   => 'before',
                'description' => '',
            ]
        );

        $this->add_control(
            'boxshadow',
            [
                'label'        => __('Show border around search form', 'homeradar-add-ons'),
                'type'         => Controls_Manager::SWITCHER,
                'default'      => 'no',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'filter_sec',
            [
                'label' => __('Categories List', 'homeradar-add-ons'),
            ]
        );

        $this->add_control(
            'show_filter',
            [
                'label'        => __('Show Categories List', 'homeradar-add-ons'),
                'type'         => Controls_Manager::SWITCHER,
                'default'      => 'yes',
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'cats_text',
            [
                'label' => __( 'Categories Description', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXTAREA, // WYSIWYG,
                'default' => 'Just looking around ? Use quick search by category :',
                'show_label' => false,
            ]
        );

        

        $this->add_control(
            'finclude',
            [
                'label'       => __('Cats Include', 'homeradar-add-ons'),
                'type'        => Controls_Manager::TEXT,

                'label_block' => true,
                'default'     => '',
                // 'separator' => 'before',
                'description' => __('Comma/space-separated string of term ids to include. Leave empty to use default.', 'homeradar-add-ons'),
            ]
        );

        $this->add_control(
            'fnumber',
            [
                'label'       => __('No of Cats', 'homeradar-add-ons'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '5',
                'min'         => -1,
                'description' => '',

            ]
        );
        $this->add_control(
            'forderby',
            [
                'label'       => __('Order by', 'homeradar-add-ons'),
                'type'        => Controls_Manager::SELECT,
                'options'     => [
                    'name'        => esc_html__('Name', 'homeradar-add-ons'),
                    'slug'        => esc_html__('Slug', 'homeradar-add-ons'),
                    'term_group'  => esc_html__('Term Group', 'homeradar-add-ons'),
                    'term_id'     => esc_html__('Term ID', 'homeradar-add-ons'),
                    'id'          => esc_html__('ID', 'homeradar-add-ons'),
                    'description' => esc_html__('Description', 'homeradar-add-ons'),
                    'parent'      => esc_html__('Parent', 'homeradar-add-ons'),
                    'count'       => esc_html__('Count', 'homeradar-add-ons'),
                    'include'     => esc_html__('Include', 'homeradar-add-ons'),

                ],
                'default'     => 'slug',
                'separator'   => 'before',
                'description' => '',
            ]
        );

        $this->add_control(
            'forder',
            [
                'label'       => __('Sort Order', 'homeradar-add-ons'),
                'type'        => Controls_Manager::SELECT,
                'options'     => [
                    'ASC'  => esc_html__('Ascending', 'homeradar-add-ons'),
                    'DESC' => esc_html__('Descending', 'homeradar-add-ons'),
                ],
                'default'     => 'ASC',
                'separator'   => 'before',
                'description' => '',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_background',
            [
                'label' => __( 'Background', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'bg_type',
            [
                'label' => __( 'Background Type', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'image' => esc_html__('Parallax Image', 'homeradar-add-ons'), 
                    'slideshow' => esc_html__('Slideshow Images', 'homeradar-add-ons'), 
                    'yt_video' => esc_html__('Youtube Video', 'homeradar-add-ons'), 
                    'vm_video' => esc_html__('Vimeo Video', 'homeradar-add-ons'), 
                    'ht_video' => esc_html__('Hosted Video', 'homeradar-add-ons'), 
                ],
                'default' => 'image',
                'separator' => 'before',
                // 'description' => esc_html__("Select how to sort retrieved posts. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'slideshow_imgs',
            [
                'label' => __( 'Slideshow Images', 'homeradar-add-ons' ),
                'type' => Controls_Manager::GALLERY,
                'condition' => [
                    'bg_type' => 'slideshow',
                ],
            ]
        );

        $this->add_control(
            'video_id',
            [
                'label' => __( 'Youtube or Vimeo Video ID', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'bg_type' => ['yt_video','vm_video'],
                ],
                'label_block' => true,
                'description' => __( 'Your Youtube or Vimeo video ID: Hg5iNVSp2z8', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'video_url',
            [
                'label' => __( 'Hosted Video URL', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'bg_type' => ['ht_video'],
                ],
                'label_block' => true,
                'description' => __( 'Your hosted video URL (should be in.mp4 format)', 'homeradar-add-ons' ),
            ]
        );


        $this->add_control(
            'bgimage',
            [
                'label' => __( 'Background Image', 'homeradar-add-ons' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'bg_type' => ['yt_video','vm_video','image','ht_video'],
                ],
                'description' => __( 'Background Image', 'homeradar-add-ons' ),
            ]
        );
        $this->add_control(
            'overlay_opa',
            [
                'label' => __( 'Overlay Opacity', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                // 'default' => [
                //     'url' => Utils::get_placeholder_image_src(),
                // ],
                'description' => __( 'Overlay Opacity value 0.0 - 1. Default 0.5', 'homeradar-add-ons' ),
                'condition' => [
                    'bg_type' => ['yt_video','vm_video','image','ht_video'],
                ],
            ]
        );

        $this->add_control(
            'overlay_color',
            [
                'label' => __( 'Overlay Color', 'homeradar-add-ons' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .overlay' => 'background-color: {{VALUE}};',
                ],
                // Set a value from the active color scheme as the default value returned by the control.
                // 'scheme' => [
                //     'type' => Scheme_Color::get_type(),
                //     'value' => Scheme_Color::COLOR_7,
                // ],
                'condition' => [
                    'bg_type' => ['yt_video','vm_video','image','ht_video'],
                ],
            ]
        );

        $this->end_controls_section();


    }

    protected function render( ) {

        $settings = $this->get_settings();

        // get our input from the widget settings.

        // $custom_text = ! empty( $instance['some_text'] ) ? $instance['some_text'] : ' (no text was entered ) ';
        // $post_count = ! empty( $instance['posts_per_page'] ) ? (int)$instance['posts_per_page'] : 5;

        $bgimage = homeradar_addons_get_attachment_thumb_link($settings['bgimage']['id'], 'bg-image');

        ?>
        <section class="hero-section hero-section_dec elementor-hero-section hero-<?php echo $settings['bg_type']; ?>" data-scrollax-parent="true">
            <?php 
            if($settings['bg_type'] == 'image' && $bgimage != ''){ ?>
                <div class="bg-wrap"><div class="bg" style="background-image:url(<?php echo esc_url( $bgimage );?>);" data-bg="<?php echo esc_url( $bgimage );?>" data-scrollax="properties: { translateY: '30%' }"></div></div>
            <?php }elseif($settings['bg_type'] == 'slideshow'){ ?>
                <div class="bg-wrap">
                    <div class="half-hero-bg-media full-height">
                        <div class="slider-progress-bar">
                            <span>
                                <svg class="circ" width="30" height="30">
                                    <circle class="circ2" cx="15" cy="15" r="13" stroke="rgba(255,255,255,0.4)" stroke-width="1" fill="none"/>
                                    <circle class="circ1" cx="15" cy="15" r="13" stroke="#fff" stroke-width="2" fill="none"/>
                                </svg>
                            </span>
                        </div>
                        <div class="slideshow-container" >
                            <?php 
                            foreach ( $settings['slideshow_imgs'] as $image ) {
                                ?>
                                <!-- slideshow-item -->
                                <div class="slideshow-item">
                                    <div class="bg" data-bg="<?php echo esc_url( homeradar_addons_get_attachment_thumb_link($image['id'], 'full') ); ?>"></div>
                                </div>
                                <!--  slideshow-item end  -->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            <?php }else{ ?>
            <!-- <div class="media-container-wrap hero-bg-absolute"> -->
                <div class="media-container bg-parallax-wrap-gradien">
                    <div class="bg mob-bg idx-auto" data-bg="<?php echo esc_url( $bgimage );?>"></div>
                <?php 
                    if($settings['bg_type'] == 'yt_video') : 
                        $vidOpts = array(
                            'videoURL'          => $settings['video_id'],
                            'mute'              => true,
                            'containment'       => 'self',
                            'quality'           => 'highres', // 'default','small','medium','large','hd720','hd1080' - deprecated
                            'autoPlay'          => true,
                            'loop'              => true,
                            'showControls'      => false,
                            // 'ratio'             => 'auto',
                            'optimizeDisplay'   => false,
                        );
                        // Hg5iNVSp2z8
                    ?> 
                    <div  class="background-youtube-wrapper" data-property='<?php echo json_encode($vidOpts); ?>'></div>
                <?php 
                    elseif($settings['bg_type'] == 'vm_video') : 
                        $dataArr = array();
                        $dataArr['video'] = $settings['video_id'];
                        $dataArr['quality'] = '1080p'; // '4K','2K','1080p','720p','540p','360p'
                        $dataArr['mute'] = '1';
                        $dataArr['loop'] = '1';
                        // 97871257
                        ?>
                    <div class="video-holder">
                        <div  class="background-vimeo" data-opts='<?php echo json_encode( $dataArr );?>'></div>
                    </div>
                <?php else : 
                    $video_attrs = ' autoplay';
                    $video_attrs .=' muted';
                    $video_attrs .=' loop';

                    // http://localhost:8888/homeradar/wp-content/uploads/2018/03/3.mp4
                ?>
                    <div class="video-container">
                        <video<?php echo esc_attr( $video_attrs );?> class="bgvid">
                            <source src="<?php echo esc_url( $settings['video_url'] );?>" type="video/mp4">
                        </video>
                    </div>
                <?php endif; ?>
                </div>
            <!-- </div> -->
            <?php } ?>
            <?php if( $settings['bg_type'] !== 'slideshow' ): ?><div class="overlay"<?php if(!empty($settings['overlay_opa'])) echo ' style="opacity:'.$settings['overlay_opa'].';"';?>></div><?php endif; ?>
            <div class="container idx-5">
                <div class="hrsec-inner pos-relative <?php echo $settings['ctalign']; ?> bsform-<?php echo $settings['boxshadow']; ?>">
                    <?php 
                    if(!empty($settings['content'])): ?>
                    <div class="hero-title hero-title_small">
                        <?php echo do_shortcode( $settings['content'] );?>
                    </div>
                    <?php 
                    endif;?>
                    <?php if( !empty($settings['ltypes']) ) homeradar_addons_get_template_part('template-parts/hero_search_form', '', array( 'ltypes'=> explode(",", $settings['ltypes']) ) ); ?>
                    <?php // if($settings['show_search'] == 'yes') homeradar_addons_get_template_part('template-parts/hero_search_form' ); ?>
                    
                    <?php if($settings['show_filter'] == 'yes') homeradar_addons_get_template_part('template-parts/hero_cats' , false , array('settings'=>$settings) ); ?>
                    
                        
                    
                    <?php 
                    if(!empty($settings['content_after'])): ?>
                    <div class="intro-item-after fl-wrap">
                        <?php echo do_shortcode( $settings['content_after'] );?>
                    </div>
                    <?php 
                    endif;?>
                    <?php 
                    if(!empty($settings['scroll_text'])): ?>
                        <div class="scroll-down-wrap">
                            <div class="mousey">
                                <div class="scroller"></div>
                            </div>
                            <span><?php echo $settings['scroll_text']; ?></span>
                        </div>
                    <?php 
                    endif;?>
                </div><!-- end hrsec-inner -->
            </div>
            
        </section>
        <?php



    }

    

}


