<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Footer_Nav extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'footer_nav';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Footer Navigation', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_images',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );

        

        $this->add_control(
            'mn_id',
            [
                'label' => __( 'Menu', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => homeradar_addons_elementor_get_menus(),
                'default' => '',
                
            ]
        );

        $this->add_control(
            'mnstyle',
            [
                'label' => __( 'Style', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'footer-list' => esc_html__('Normal', 'homeradar-add-ons'), 
                    'footer-list-inline' => esc_html__('Inline', 'homeradar-add-ons'), 
                    
                ],
                'default' => 'footer-list',
                'separator' => 'before',
                
            ]
        );
        

        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
        if( empty($settings['mn_id']) ) return;
        ?>
        <div class="footer_nav-ele">
            <?php
            wp_nav_menu(
                array(
                    'fallback_cb'       => '',
                    'menu'              => $settings['mn_id'],

                    'menu_id'           => '',
                    'menu_class'           => $settings['mnstyle'].' no-list-style',
                    'container'         => '',
                    // 'container_class'   => 'footer-menu-nav',
                    // 'container_id'      => '',
                )
            );
            ?>
        </div>
        <?php
    }

    // protected function _content_template() {}
    // end _content_template



}
