<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Feature_Box extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'feature_box';
    }

    // public function get_id() {
    //      return 'header-search';
    // }

    public function get_title() {
        return __( 'Feature Box', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label'         => __( 'Content', 'homeradar-add-ons' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label'         => __( 'Title', 'homeradar-add-ons' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => '24 Hours Support',
                'label_block'   => true,
                
            ]
        );
        $this->add_control(
            'content',
            [   
                'label'         => __( 'Content', 'homeradar-add-ons' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas in pulvinar neque. Nulla finibus lobortis pulvinar.</p>',
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'homeradar-add-ons' ),
                'type' => 'cthicon',
                'default' => '',
                'label_block'   => true,
            ]
        );
        $this->add_control(
            'number',
            [
                'label'         => __( 'Service Step', 'homeradar-add-ons' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => '01',
                'label_block'   => false,
                
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'sty1' => esc_html__('Style 1', 'homeradar-add-ons'), 
                    'sty2' => esc_html__('Style 2', 'homeradar-add-ons'), 
                ],
                'default' => 'sty1',
                
            ]
        );

        // $this->add_control(
        //     'featured',
        //     [
        //         'label' => __( 'Is Featured', 'homeradar-add-ons' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => 'no',
        //         'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
        //         'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );


        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
        $cls = 'services-item';
        ?>  
        <!--services-box --> 
        <div class="<?php echo esc_attr( $cls ); ?> <?php echo esc_attr( $settings['style'] ); ?>">
            <?php if($settings['icon']!=''): ?>
            <div class="service-icon">
                <i class="<?php echo $settings['icon']; ?>"></i>
            </div>
            <?php endif; ?>
            <div class="service-ithead dis-flex jtf-space-between">
                <?php if($settings['title']!='') echo '<h4 class="service-title">'.$settings['title'].'</h4>'; ?>
                <span><?php echo $settings['number'];?></span>
            </div>
            <?php echo $settings['content']; ?>
        </div>
        <!-- services-box end  -->      
        <?php
    }

    protected function _content_template() {
        ?>
        <!--services-box --> 
        <div class="services-item {{settings.style}}">
            <# if(settings.icon!=''){ #>
            <div class="service-icon">
                <i class="{{settings.icon}}"></i>
            </div>
            <# } #>
            <div class="service-ithead dis-flex jtf-space-between">
            <# if(settings.title){ #><h4 class="service-title">{{{settings.title}}}</h4><# } #>
            <span>{{{settings.number}}}</span>
            </div>
            {{{settings.content}}}
        </div>
        <!-- services-box end  -->      
        <?php
    }

   
   

}

// Plugin::instance()->widgets_manager->register_widget( 'Elementor\Widget_Header_Search' );

// Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance/ Plugin::$instance->elements_manager->create_element_instance