<?php
/* add_ons_php */

namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

class CTH_Faqs extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve alert widget name.
     *
     * 
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'cth_faqs';
    }

    // public function get_id() {
    //        return 'header-search';
    // }

    public function get_title()
    {
        return __('FAQs', 'homeradar-add-ons');
    }

    public function get_icon()
    {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the widget categories.
     *
     * 
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['homeradar-elements'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'faqs_content',
            [
                'label' => __('Content', 'homeradar-add-ons'),
            ]
        );

        $this->add_control(
            'sb_title',
            [
                'label' => __( 'Sidebar Title', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'FAQ Navigation',
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'categories',
            [
                'label'       => __('Categories', 'homeradar-add-ons'),
                'type'        => Controls_Manager::REPEATER,
                'default'     => [
                    [
                        'title' => 'Payments',
                        'icon'  => '',
                    ],
                    [
                        'title' => 'Suggestions',
                        'icon'  => '',
                    ],
                    [
                        'title' => 'Reccomendations',
                        'icon'  => '',
                    ],
                    [
                        'title' => 'Booking',
                        'icon'  => '',
                    ],
                    [
                        'title' => 'Listing',
                        'icon'  => '',
                    ],
                ],
                'fields'      => [
                    [
                        'name'        => 'title',
                        'label'       => __('Category Title', 'homeradar-add-ons'),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => 'Payments',
                        'label_block' => true,
                    ],
                    [
                        'name'    => 'icon',
                        'label'   => __('Icon', 'homeradar-add-ons'),
                        'type'    => 'cthicon',
                        'default' => '',
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_control(
            'questions',
            [
                'label'       => __('Question List', 'homeradar-add-ons'),
                'type'        => Controls_Manager::REPEATER,
                'default'     => [
                    [
                        'question' => 'How long does the sending process take?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Payments',
                    ],
                    [
                        'question' => 'Can I use more than one payment method to pay for a reservation?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Payments',
                    ],
                    [
                        'question' => 'How do I edit or remove a payment method?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Payments',
                    ],
                    // Getting Started
                    [
                        'question' => 'Can I pay my own taxes and insurance?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Suggestions',
                    ],
                    [
                        'question' => 'How long does the loan process take?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Suggestions',
                    ],
                    // Suggestions
                    [
                        'question' => 'How long does the sending process take?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Reccomendations',
                    ],
                    [
                        'question' => 'Can I use more than one payment method to pay for a reservation?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Reccomendations',
                    ],
                    [
                        'question' => 'How do I edit or remove a payment method?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Reccomendations',
                    ],
                    // Reccomendations
                    [
                        'question' => 'How long does the sending process take?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Booking',
                    ],
                    [
                        'question' => 'Can I use more than one payment method to pay for a reservation?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Booking',
                    ],
                    [
                        'question' => 'How do I edit or remove a payment method?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Booking',
                    ],
                    
                    // Booking
                    [
                        'question' => 'How long does the sending process take?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Listing',
                    ],
                    [
                        'question' => 'Can I use more than one payment method to pay for a reservation?',
                        'answer'   => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'category' => 'Listing',
                    ],
                    
                    // Listing
                ],
                'fields'      => [
                    [
                        'name'        => 'question',
                        'label'       => __('Question', 'homeradar-add-ons'),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => 'How long does the sending process take?',
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'category',
                        'label'       => __('Category Name', 'homeradar-add-ons'),
                        'description' => __('This value should match <strong>Category Title</strong> above', 'homeradar-add-ons'),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => 'Payments',
                        'label_block' => true,
                    ],
                    [
                        'name'       => 'answer',
                        'label'      => __('Answer', 'homeradar-add-ons'),
                        'type'       => Controls_Manager::WYSIWYG,
                        'default'    => '<p> Nulla finibus lobortis pulvinar. Donec a consectetur nulla. Nulla posuere sapien vitae lectus suscipit, et pulvinar nisi tincidunt. Aliquam erat volutpat. Curabitur convallis fringilla diam sed aliquam. Sed tempor iaculis massa faucibus feugiat. In fermentum facilisis massa, a consequat .</p>',
                        'show_label' => false,
                    ],

                ],
                'title_field' => '{{{ question }}}',
            ]
        );

        $this->end_controls_section();

        // $this->start_controls_section(
        //     'needhelp_sec',
        //     [
        //         'label' => __('Contact Infos', 'homeradar-add-ons'),
        //     ]
        // );

        // $this->add_control(
        //     'needhelp',
        //     [
        //         'label'        => __('Show Contact Infos?', 'homeradar-add-ons'),
        //         'type'         => Controls_Manager::SWITCHER,
        //         'default'      => 'yes',
        //         'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
        //         'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );

        // $this->add_control(
        //     'nhtitle',
        //     [
        //         'label'       => __('Title', 'homeradar-add-ons'),
        //         'type'        => Controls_Manager::TEXT,
        //         'default'     => 'Still Need Help ?',
        //         'label_block' => true,

        //     ]
        // );

        // $this->add_control(
        //     'nhphone',
        //     [
        //         'label'       => __('Left Side Content', 'homeradar-add-ons'),
        //         'type'        => Controls_Manager::TEXTAREA,
        //         'default'     => '<strong>Call us</strong> <br>+7(111)123456789',
        //         'label_block' => true,

        //     ]
        // );

        // $this->add_control(
        //     'leftimage',
        //     [
        //         'label'   => __('Left Side Image', 'homeradar-add-ons'),
        //         'type'    => Controls_Manager::MEDIA,
        //         'default' => [
        //             'url' => Utils::get_placeholder_image_src(),
        //         ],
        //     ]
        // );

        // $this->add_control(
        //     'lefturl',
        //     [
        //         'label'       => __('Left Side URL', 'homeradar-add-ons'),
        //         'type'        => Controls_Manager::TEXT,
        //         'default'     => '#',
        //         'label_block' => true,

        //     ]
        // );

        // $this->add_control(
        //     'nhemail',
        //     [
        //         'label'       => __('Right Side Content', 'homeradar-add-ons'),
        //         'type'        => Controls_Manager::TEXTAREA,
        //         'default'     => '<strong>Write to us</strong><br>yourmail@domain.com',
        //         'label_block' => true,

        //     ]
        // );

        // $this->add_control(
        //     'rightimage',
        //     [
        //         'label'   => __('Right Side Image', 'homeradar-add-ons'),
        //         'type'    => Controls_Manager::MEDIA,
        //         'default' => [
        //             'url' => Utils::get_placeholder_image_src(),
        //         ],
        //     ]
        // );

        // $this->add_control(
        //     'righturl',
        //     [
        //         'label'       => __('Right Side URL', 'homeradar-add-ons'),
        //         'type'        => Controls_Manager::TEXT,
        //         'default'     => '#',
        //         'label_block' => true,

        //     ]
        // );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings    = $this->get_settings();
        $css_classes = array(
            'faqs-ele-wrap',
        );

        $css_class = preg_replace('/\s+/', ' ', implode(' ', array_filter($css_classes)));

        ?>
        <div class="<?php echo $css_class; ?>">
            <div class="row faqs-row">
            <?php
            $categories = $settings['categories'];
            if (!empty($categories)):
            ?>
                <!-- faqs cats -->
                <div class="col-md-4">
                    <div class="box-widget fixed-column_menu-init float-box">
                        <div class="box-widget-content">
                            <div class="box-widget-title"><?php echo $settings['sb_title']; ?></div>
                            <div class="faq-nav scroll-init help-bar">
                                <ul class="no-list-style">
                                    <?php 
                                    foreach ($categories as $cat) {
                                        $slug = sanitize_title_with_dashes($cat['title']);
                                    ?>
                                    <li>
                                        <a href="#faqcat-<?php echo $slug; ?>">
                                        <?php if($cat['icon'] != ''): ?><i class="<?php echo esc_attr($cat['icon']); ?>"></i><?php endif; ?>
                                        <span><?php echo $cat['title']; ?></span>
                                        </a>
                                    </li>
                                    <?php }?>
                                </ul>
                            </div>
                            <!-- <div class="search-widget fns">
                                <form action="#" class="custom-form pos-relative">
                                    <input name="se" id="se" type="text" class="search" placeholder="Keywords" value="" />
                                    <button class="search-submit" id="submit_btn"><i class="far fa-search"></i></button>
                                </form>
                            </div> -->
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <!-- faqs cats end-->
                <!-- faqs questions -->
                <div class="col-md-8">
                    <div class="list-single-main-container faqs-inner">
            <?php else: ?>
                <!-- faqs questions -->
                <div class="col-md-12">
                    <div class="list-single-main-container faqs-inner">
            <?php endif; //end categories ?>
                    <?php

                    $questions      = $settings['questions'];
                    $questions_cats = array();
                    if (!empty($questions)):
                        foreach ($questions as $key => $question) {
                            $slug = sanitize_title_with_dashes($question['category']);
                            if (!isset($questions_cats[$slug])) {
                                $questions_cats[$slug] = array(
                                    'title'     => '<div class="lsingle-block-title big-lsmt' . ($key === 0 ? ' faq-title_first fl-wrap' : ' fl-wrap') . '"><h3>' . $question['category'] . '</h3></div>',
                                    'questions' => '<div class="accordion-lite-container fl-wrap"><div class="accordion-lite-header' . ($key === 0 ? ' act-accordion' : '') . '">' . $question['question'] . '<i class="fas fa-plus"></i></div><div class="accordion-lite_content' . ($key === 0 ? ' visible' : '') . '">' . $question['answer'] . '</div></div><!--   accordion-lite end -->',

                                );
                            } else {
                                $questions_cats[$slug]['questions'] .= '<div class="accordion-lite-container fl-wrap"><div class="accordion-lite-header fl-wrap">' . $question['question'] . '<i class="fas fa-plus"></i></div><div class="accordion-lite_content fl-wrap">' . $question['answer'] . '</div></div><!--   accordion-lite end -->';
                            }
                        }
                    endif;
                    //end !empty($questions) ?>
                
                    <?php
                    foreach ($questions_cats as $slug => $questions_cat) {
                    ?>
                        <!-- faq-section -->
                        
                        <div class="lsingle-block-box fl-wrap" id="faqcat-<?php echo $slug; ?>">
                            <?php echo $questions_cat['title']; ?>

                            <?php
                            echo $questions_cat['questions'];
                            ?>
                        </div>
                        <!-- faq-section end -->
                    <?php
                    }?>

                    <?php if ( 1 == 2 && $settings['needhelp'] == 'yes'): ?>
                    <div class="faq-links fl-wrap">
                        <?php if ($settings['nhtitle'] != ''): ?><h3 class="faq-links-title"><?php echo $settings['nhtitle']; ?></h3><?php endif;?>
                        <span class="section-separator"></span>
                        <!-- post nav -->
                        <div class="post-nav-wrap fl-wrap">
                            <?php if ($settings['nhphone'] != ''): ?>
                                <a class="post-nav post-nav-prev<?php if( $settings['leftimage'] != '' ) echo ' post-nav-has-thumb'; ?>" href="<?php echo esc_url( $settings['lefturl'] ); ?>">
                                    <?php if ($settings['leftimage'] != ''): ?><span class="post-nav-img"><?php echo wp_get_attachment_image($settings['leftimage']['id'], 'thumbnail'); ?></span><?php endif;?>
                                    <span class="post-nav-text"><?php echo $settings['nhphone']; ?></span>
                                </a>
                            <?php endif;?>
                            <?php if ($settings['nhemail'] != ''): ?>
                                <a class="post-nav post-nav-next<?php if( $settings['rightimage'] != '' ) echo ' post-nav-has-thumb'; ?>" href="<?php echo esc_url( $settings['righturl'] ); ?>">
                                    <?php if ($settings['rightimage'] != ''): ?><span class="post-nav-img"><?php echo wp_get_attachment_image($settings['rightimage']['id'], 'thumbnail'); ?></span><?php endif;?>
                                    <span class="post-nav-text"><?php echo $settings['nhemail']; ?></span>
                                </a>
                            <?php endif;?>
                        </div>
                        <!-- post nav end -->
                    </div>
                    <?php endif;?>
                    </div><!-- list-single-main-container end -->
                </div>
                <!-- faqs questions end -->

            </div><!-- faqs-row end -->
        </div><!-- faqs-ele-wrap end -->
        <div class="limit-box"></div>
        <div class="clearfix"></div>
        <?php
}

}