<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Contact_Modal extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'contact_modal';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Contact Form 7 - Modal', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );


        $this->add_control(
            'f_id',
            [
                'label'       => __( 'Select a form', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'default' => '100',
                'options' => homeradar_addons_get_contact_form7_forms(),
                
            ]
        );

        $this->add_control(
            'f_title',
            [
                'label'       => __( 'Form Title', 'homeradar-add-ons' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => '',
                'description' => __( '(Optional) Title to search if no ID selected or cannot find by ID.', 'homeradar-add-ons' ),
                'label_block' => true
            ]
        );

        $this->add_control(
            'button',
            [
                'label'       => __( 'Open Modal Button', 'homeradar-add-ons' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => 'Write Message',
                'description' => '',
                'label_block' => true
            ]
        );
        $this->add_control(
            'md_title',
            [
                'label'       => __( 'Modal Title', 'homeradar-add-ons' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => 'Get In Touch',
                'description' => '',
                'label_block' => true
            ]
        );

        $this->end_controls_section();

        

    }

    protected function render( ) {
        $settings = $this->get_settings();
        $attrs = '';
        if($settings['f_id']) $attrs .= ' id="'.$settings['f_id'].'"';
        elseif($settings['f_title']) $attrs .= ' title="'.$settings['f_title'].'"';

        $shortcode = do_shortcode( '[contact-form-7'.$attrs.']' ) ;
        ?>
        <a href="#" class="btn small-btn color-bg cf_btn"><?php echo $settings['button'];?></a>
        <!--contact-form-wrap -->   
        <div class="contact-form-wrap">
            <div class="contact-form-container">
                <div class="contact-form-main fl-wrap">
                    <div class="contact-form-header">
                        <h4><?php echo $settings['md_title'];?></h4>
                        <span class="close-contact-form"><i class="fal fa-times"></i></span>
                    </div>
                    <div class="contact-form7"><?php echo $shortcode;?></div>                 
                </div>
            </div>
            <div class="contact-form-overlay"></div>
        </div>
        <!--contact-form-wrap end-->    

        <?php
    }

    // protected function _content_template() {}

   
    

}

