<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Contact_Infos extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'contact_infos';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Contact Infos', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_images',
            [
                'label' => __( 'Infos', 'homeradar-add-ons' ),
            ]
        );

        

        $this->add_control(
            'values',
            [
                'label' => __( 'Hour Item', 'homeradar-add-ons' ),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'title' => 'Mail :',
                        'value' => 'yourmail@domain.com',
                        'icon'  => 'fal fa-envelope',
                        'link'  => [
                            'url'           => '#',
                            'is_external'   => false,
                        ],
                    ],
                    [
                        'title' => 'Adress :',
                        'value' => 'USA 27TH Brooklyn NY',
                        'icon'  => 'fal fa-map-marker',
                        'link'  => [
                            'url'           => '#',
                            'is_external'   => false,
                        ],
                    ],
                    [
                        'title' => 'Phone :',
                        'value' => '+7(111)123456789',
                        'icon'  => 'fal fa-phone',
                        'link'  => [
                            'url'           => '#',
                            'is_external'   => false,
                        ],
                    ],
                ],
                'fields' => [
                    [
                        'name' => 'title',
                        'label' => __( 'Title', 'homeradar-add-ons' ),
                        'type' => Controls_Manager::TEXT,
                        'default' => 'Mail :',
                        'label_block' => true,
                    ],
                    [
                        'name' => 'value',
                        'label' => __( 'Value', 'homeradar-add-ons' ),
                        // 'type' => Controls_Manager::WYSIWYG,
                        'type' => Controls_Manager::TEXT,
                        'default' => 'yourmail@domain.com',
                        'label_block' => true,
                    ],
                    [
                        'name' => 'icon',
                        'label' => __( 'Icon', 'homeradar-add-ons' ),
                        'type' => 'cthicon',
                        'default' => '',
                        'label_block' => true,
                    ],
                    [
                        'name' => 'link',
                        'label' => __( 'Link', 'homeradar-add-ons' ),
                        'type' => Controls_Manager::URL,
                        'default' => [
                                    'url' => '',
                                    'is_external' => '',
                                ],
                    ]
                ],
                'title_field' => '{{{ title }}}',
            ]
        );


        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
        if(is_array($settings['values']) && !empty($settings['values']) ):
        ?>
        <ul class="footer-contacts fl-wrap no-list-style">
            <?php
            foreach ($settings['values'] as $key => $value) {
                $url = $value['link']['url'];
                $target = $value['link']['is_external'] ? ' target="_blank"' : '';
            ?> 
            <li><span><?php if( !empty($value['icon']) ): ?><i class="<?php echo esc_attr($value['icon']); ?>"></i><?php endif; ?><?php echo esc_html($value['title']); ?></span><a href="<?php echo esc_attr( $url ); ?>"<?php echo $target;?>><?php echo esc_html($value['value']); ?></a></li>
            <?php
            }
            ?>
        </ul>
        <?php
        endif;
    }

    protected function _content_template() {
        ?>
        <# if(settings.values){ #>
        <ul class="footer-contacts fl-wrap no-list-style">
            <# settings.values.forEach(vl=>{ 
                var url = vl.link.url,
                    target = vl.link.is_external ? ' target="_blank"' : '';
            #>
                <li><span><# if( vl.icon ){ #><i class="fal fa-envelope"></i><# } #>{{{vl.title}}}</span><a href="{{url}}"{{target}}>{{{vl.value}}}</a></li>
            <# }) #>
        </div>
        <# } #>
        <?php
    }


}
