<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Button extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'cthbutton';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Button', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_images',
            [
                'label' => __( 'Content', 'homeradar-add-ons' ),
            ]
        );
        $this->add_control(
            'name_bt',
            [
                'label'         => __( 'Name Button', 'homeradar-add-ons' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => 'Our Vimeo Chanel',
                'label_block'   => true,
                
            ]
        );
        $this->add_control(
            'btntype',
            [
                'label' => __( 'Click Action', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'external_link' => esc_html__('External link', 'homeradar-add-ons'), 
                    'custom-scroll-link' => esc_html__('On page scrolling', 'homeradar-add-ons'), 
                    'image-popup' => esc_html__('Popup Link', 'homeradar-add-ons'), 
                ],
                'default' => 'external_link',
                'separator' => 'before',
                
            ]
        );
        $this->add_control(
            'links',
            [
                'label' => __( 'Button Links', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXTAREA, // WYSIWYG,
                'default' => '#',
                'description' => __( 'Enter links for each partner (Note: divide links with linebreaks (Enter) or | and no spaces).', 'homeradar-add-ons' ) 
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'homeradar-add-ons' ),
                'type' => 'cthicon',
                'default' => '',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'iconpos',
            [
                'label' => __( 'Icon Position', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'icon-left' => esc_html__('Left', 'homeradar-add-ons'), 
                    'icon-right' => esc_html__('Right', 'homeradar-add-ons'), 
                    'icon-hide' => esc_html__('Hide', 'homeradar-add-ons'), 
                ],
                'default' => 'icon-right',
                'separator' => 'before',
                
            ]
        );

        $this->add_control(
            'btnstyle',
            [
                'label' => __( 'Button Style', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'btn' => esc_html__('Default', 'homeradar-add-ons'), 
                    'promo-link' => esc_html__('Rounded', 'homeradar-add-ons'), 
                ],
                'default' => 'btn',
                'separator' => 'before',
                
            ]
        );

        $this->add_control(
            'btncolor',
            [
                'label' => __( 'Button Color', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'color-bg' => esc_html__('Primary color', 'homeradar-add-ons'), 
                    // 'color2-bg' => esc_html__('Secondary color', 'homeradar-add-ons'), 
                    'white-bg' => esc_html__('White color', 'homeradar-add-ons'), 
                ],
                'default' => 'color-bg',
                'separator' => 'before',
                
            ]
        );

        $this->add_control(
            'btnsize',
            [
                'label' => __( 'Button Size', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normal-btn' => esc_html__('Normal', 'homeradar-add-ons'),  
                    'small-btn' => esc_html__('Small', 'homeradar-add-ons'), 
                ],
                'default' => 'normal-btn',
                'separator' => 'before',
                
            ]
        );
        $this->add_control(
            'btnwidth',
            [
                'label' => __( 'Button Width', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'normalw-btn' => esc_html__('Normal', 'homeradar-add-ons'),  
                    'fullw-btn' => esc_html__('Block', 'homeradar-add-ons'), 
                ],
                'default' => 'normalw-btn',
                'separator' => 'before',
                
            ]
        );

        $this->add_control(
            'class_css',
            [
                'label' => __( 'Extra class name', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'description' => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'homeradar-add-ons'),
            ]
        );
        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();
        $css_classes = array(
            $settings['btnstyle'],
            $settings['btncolor'],
            $settings['btnsize'],
            $settings['class_css'],
            $settings['btntype'],
            $settings['btnwidth'],
            $settings['iconpos'],
            'btn-no-text-'. ( empty( $settings['name_bt'] ) ? 'yes' : 'no' ),
        );
        
        $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
        ?> 
            <a href="<?php echo $settings['links']; ?>" class="cthbtn <?php echo esc_attr($css_class );?>"<?php echo $settings['btntype'] == 'external_link'? ' target="_blank"':'';?>><?php if( !empty($settings['icon']) && $settings['iconpos'] == 'icon-left' ) : ?><i class="<?php echo $settings['icon'];?>"></i><?php endif; ?><?php echo $settings['name_bt']; ?><?php if( !empty($settings['icon']) && $settings['iconpos'] == 'icon-right' ) : ?><i class="<?php echo $settings['icon'];?>"></i><?php endif; ?></a>
        <?php

    }
    

}
