<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Breadcrumbs extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'cthbreadcrumbs';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Breadcrumbs', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_images',
            [
                'label' => __( 'Layout', 'homeradar-add-ons' ),
            ]
        );
        $this->add_control(
            'showShare',
            [
                'label' => __( 'Show Share', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => _x( 'Yes', 'On/Off', 'homeradar-add-ons' ),
                'label_off' => _x( 'No', 'On/Off', 'homeradar-add-ons' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings_for_display();
        ?> 
            <!-- breadcrumbs-->
            <div class="breadcrumbs-wrapper inline-breadcrumbs fw-breadcrumbs sp-brd fl-wrap">
                <div class="container">
                    <div class="inline-breadcrumbs-wrap flex-items-center jtf-space-between flw-wrap">
                        <?php if( function_exists('homeradar_get_template_part') ) homeradar_get_template_part( 'template-parts/breadcrumbs', '', array( 'is_top'=>false) ); ?>
                        <?php 
                        if($settings['showShare'] == 'yes' ): ?>
                        <div class="inline-breadcrumbs-right flex-items-center">
                            <?php homeradar_addons_echo_socials_share(); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- breadcrumbs end -->
        <?php

    }
    

}
