<?php
/* add_ons_php */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

class CTH_Agents extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * 
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'agents';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Agents Slider', 'homeradar-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'cth-elementor-icon';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * 
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'homeradar-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => __( 'Posts Query', 'homeradar-add-ons' ),
            ]
        );

        $this->add_control(
            'ids',
            [
                'label' => __( 'Enter Post IDs', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter Post ids to show, separated by a comma. Leave empty to show all.", 'homeradar-add-ons')
                
            ]
        );
        $this->add_control(
            'ids_not',
            [
                'label' => __( 'Or Post IDs to Exclude', 'homeradar-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter post ids to exclude, separated by a comma (,). Use if the field above is empty.", 'homeradar-add-ons')
                
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => __( 'Order by', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'date' => esc_html__('Date', 'homeradar-add-ons'), 
                    'ID' => esc_html__('ID', 'homeradar-add-ons'), 
                    'author' => esc_html__('Author', 'homeradar-add-ons'), 
                    'title' => esc_html__('Title', 'homeradar-add-ons'), 
                    'modified' => esc_html__('Modified', 'homeradar-add-ons'),
                    'rand' => esc_html__('Random', 'homeradar-add-ons'),
                    'comment_count' => esc_html__('Comment Count', 'homeradar-add-ons'),
                    'menu_order' => esc_html__('Menu Order', 'homeradar-add-ons'),
                    'post__in' => esc_html__('ID order given (post__in)', 'homeradar-add-ons'),
                ],
                'default' => 'date',
                'separator' => 'before',
                'description' => esc_html__("Select how to sort retrieved posts. More at ", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Sort Order', 'homeradar-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'homeradar-add-ons'), 
                    'DESC' => esc_html__('Descending', 'homeradar-add-ons'), 
                ],
                'default' => 'DESC',
                'separator' => 'before',
                'description' => esc_html__("Select Ascending or Descending order. More at", 'homeradar-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Posts to show', 'homeradar-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '5',
                'description' => esc_html__("Number of posts to show (-1 for all).", 'homeradar-add-ons'),
                
            ]
        );

        

        $this->end_controls_section();

        

    }

    protected function render( ) {

        $settings = $this->get_settings();

        if(is_front_page()) {
            $paged = (get_query_var('page')) ? get_query_var('page') : 1;
        } else {
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        }

        if(!empty($settings['ids'])){
            $ids = explode(",", $settings['ids']);
            $post_args = array(
                'post_type' => 'lagent',
                'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__in' => $ids,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],
                'post_status' => 'publish'
            );
        }elseif(!empty($settings['ids_not'])){
            $ids_not = explode(",", $settings['ids_not']);
            $post_args = array(
                'post_type' => 'lagent',
                'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__not_in' => $ids_not,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }else{
            $post_args = array(
                'post_type' => 'lagent',
                'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }

        $css_classes = array(
            'single-carousel-wrap carousel-wrap agents-carousel-wrap',
            // 'posts-grid-',//.$settings['columns_grid']
        );

        $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );
        ?>
        <!-- carousel -->
        <div class="<?php echo esc_attr( $css_class );?>">
            <?php 
            $slider_args = array(
                'slidesToShow'      => 3,
                // 'responsive'        => false,
                'adaptiveHeight'    => true,
                'variableWidth'     => false,
                'centerMode'        => true,
                'arrows'            => false,
                'dots'              => true,
                'infinite'          => true,
            );
            ?>
            <?php
            $posts_query = new \WP_Query($post_args);
            if($posts_query->have_posts()) : ?>

            <div class="single-carousel carousel listing-slider-editor-col-3" data-options='<?php echo json_encode($slider_args); ?>'>
                <?php 
                // $rating_base = (int)homeradar_addons_get_option('rating_base');
                while($posts_query->have_posts()) : $posts_query->the_post(); ?>
                    <!-- slick-slide-item -->
                    <div class="slick-slide-item slick-item">
                        <?php homeradar_addons_get_template_part( 'template-parts/agent', false ); ?>
                    </div>
                    <!-- slick-slide-item end-->

                <?php
                endwhile; ?>
                    
            </div>
            <div class="crs-button-prev lc-wbtn lc-wbtn_prev color-bg"><i class="fal fa-angle-left"></i></div>
            <div class="crs-button-next lc-wbtn lc-wbtn_next color-bg"><i class="fal fa-angle-right"></i></div>

        </div>
        <!--  carousel end-->
        <?php endif; ?>      
        <?php 
        wp_reset_postdata();

    }


}
